/*
 * Decompiled with CFR 0.152.
 */
package jehep.utils.downloadman;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jehep.ui.SetEnv;
import jehep.ui.UJar;
import jehep.utils.Util;
import jehep.utils.downloadman.Download;
import jehep.utils.downloadman.DownloadsTableModel;
import jehep.utils.downloadman.ProgressRenderer;

public class DownloadManager
extends JDialog
implements Observer {
    private static final long serialVersionUID = 1L;
    private DownloadsTableModel tableModel;
    private JTable table;
    private JButton pauseButton;
    private JButton resumeButton;
    private JButton cancelButton;
    private JButton clearButton;
    private Download selectedDownload;
    private boolean clearing;
    private ArrayList<UJar> jars;
    private String dirpath;
    private String wwwpath;

    public DownloadManager(JFrame win, ArrayList<UJar> jars, String wwwpath, String dirpath) {
        this.jars = jars;
        this.dirpath = dirpath;
        this.wwwpath = wwwpath;
        this.setModal(true);
        this.setResizable(true);
        this.setTitle("Update Manager");
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min(400, res.width), Math.min(500, res.height));
        this.setSize(size);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DownloadManager.this.actionExit();
            }
        });
        JPanel addPanel = new JPanel();
        this.tableModel = new DownloadsTableModel();
        this.table = new JTable(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DownloadManager.this.tableSelectionChanged();
            }
        });
        this.table.setSelectionMode(0);
        ProgressRenderer renderer = new ProgressRenderer(0, 100);
        renderer.setStringPainted(true);
        this.table.setDefaultRenderer(JProgressBar.class, renderer);
        this.table.setRowHeight((int)renderer.getPreferredSize().getHeight());
        JPanel downloadsPanel = new JPanel();
        downloadsPanel.setBorder(BorderFactory.createTitledBorder("Downloads"));
        downloadsPanel.setLayout(new BorderLayout());
        downloadsPanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel buttonsPanel = new JPanel();
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadManager.this.actionPause();
            }
        });
        this.pauseButton.setEnabled(false);
        buttonsPanel.add(this.pauseButton);
        this.resumeButton = new JButton("Resume");
        this.resumeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadManager.this.actionResume();
            }
        });
        this.resumeButton.setEnabled(false);
        buttonsPanel.add(this.resumeButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadManager.this.actionCancel();
            }
        });
        this.cancelButton.setEnabled(false);
        buttonsPanel.add(this.cancelButton);
        this.clearButton = new JButton("Close");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadManager.this.clearing = true;
                DownloadManager.this.selectedDownload = null;
                DownloadManager.this.actionExit();
            }
        });
        this.clearButton.setEnabled(true);
        buttonsPanel.add(this.clearButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)addPanel, "North");
        this.getContentPane().add((Component)downloadsPanel, "Center");
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.addJars();
        Util.centreWithin(win, this);
        this.setVisible(true);
    }

    private void actionExit() {
        this.setVisible(false);
        this.dispose();
    }

    private void addJars() {
        int totaljars = this.jars.size();
        for (int j = 0; j < totaljars; ++j) {
            UJar ujar = this.jars.get(j);
            String sname = ujar.getName();
            String www = this.wwwpath + sname;
            sname = sname.replace("/", SetEnv.fSep);
            String filepath = this.dirpath + SetEnv.fSep + sname;
            URL verifiedUrl = this.verifyUrl(www);
            if (verifiedUrl != null) {
                this.tableModel.addDownload(new Download(verifiedUrl, filepath, totaljars, j));
                continue;
            }
            JOptionPane.showMessageDialog(this, "Invalid Download URL", "Error", 0);
        }
    }

    private URL verifyUrl(String url) {
        if (!url.toLowerCase().startsWith("http://")) {
            return null;
        }
        URL verifiedUrl = null;
        try {
            verifiedUrl = new URL(url);
        }
        catch (Exception e) {
            return null;
        }
        if (verifiedUrl.getFile().length() < 2) {
            return null;
        }
        return verifiedUrl;
    }

    private void tableSelectionChanged() {
        if (this.selectedDownload != null) {
            this.selectedDownload.deleteObserver(this);
        }
        if (!this.clearing) {
            this.selectedDownload = this.tableModel.getDownload(this.table.getSelectedRow());
            this.selectedDownload.addObserver(this);
            this.updateButtons();
        }
    }

    private void actionPause() {
        this.selectedDownload.pause();
        this.updateButtons();
    }

    private void actionResume() {
        this.selectedDownload.resume();
        this.updateButtons();
    }

    private void actionCancel() {
        this.selectedDownload.cancel();
        this.updateButtons();
    }

    private void actionClear() {
        this.clearing = true;
        this.tableModel.clearDownload(this.table.getSelectedRow());
        this.clearing = false;
        this.selectedDownload = null;
        this.updateButtons();
        this.setVisible(false);
        this.dispose();
    }

    private void updateButtons() {
        if (this.selectedDownload != null) {
            int status = this.selectedDownload.getStatus();
            switch (status) {
                case 0: {
                    this.pauseButton.setEnabled(true);
                    this.resumeButton.setEnabled(false);
                    this.cancelButton.setEnabled(true);
                    this.clearButton.setEnabled(false);
                    break;
                }
                case 1: {
                    this.pauseButton.setEnabled(false);
                    this.resumeButton.setEnabled(true);
                    this.cancelButton.setEnabled(true);
                    this.clearButton.setEnabled(false);
                    break;
                }
                case 4: {
                    this.pauseButton.setEnabled(false);
                    this.resumeButton.setEnabled(true);
                    this.cancelButton.setEnabled(false);
                    this.clearButton.setEnabled(true);
                    break;
                }
                default: {
                    this.pauseButton.setEnabled(false);
                    this.resumeButton.setEnabled(false);
                    this.cancelButton.setEnabled(false);
                    this.clearButton.setEnabled(true);
                    break;
                }
            }
        } else {
            this.pauseButton.setEnabled(false);
            this.resumeButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.clearButton.setEnabled(false);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.selectedDownload != null && this.selectedDownload.equals(o)) {
            this.updateButtons();
        }
    }

    public static void main(String[] args) {
    }
}

