/*
 * Decompiled with CFR 0.152.
 */
package jehep.utils;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class VasJython2HTML
extends Applet {
    Label lState;
    TextArea taContents;
    Button bGo;
    Component[] compo;
    boolean isApplet = true;
    String lineSep = new String(System.getProperty("line.separator"));
    String[] classes = new String[]{"VasOnglets", "VasTabs", "AbstractMethodError", "Applet", "AppletContext", "AppletStub", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "AudioClip", "AWTError", "AWTException", "BitSet", "Boolean", "BorderLayout", "BufferedInputStream", "BufferedOutputStream", "Button", "ByteArrayInputStream", "ByteArrayOutputStream", "Canvas", "CardLayout", "Character", "Checkbox", "CheckboxGroup", "CheckboxMenuItem", "Choice", "Class", "ClassCastException", "ClassCircularityError", "ClassFormatError", "ClassLoader", "ClassNotFoundException", "Cloneable", "CloneNotSupportedException", "Color", "ColorModel", "Compiler", "Component", "Container", "ContentHandler", "ContentHandlerFactory", "CropImageFilter", "DatagramPacket", "DatagramSocket", "DataInput", "DataInputStream", "DataOutput", "DataOutputStream", "Date", "Dialog", "Dictionary", "Dimension", "DirectColorModel", "Double", "EmptyStackException", "Enumeration", "EOFException", "Error", "Event", "Exception", "File", "FileDescriptor", "FileDialog", "FileInputStream", "FilenameFilter", "FileNotFoundException", "FileOutputStream", "FilteredImageSource", "FilterInputStream", "FilterOutputStream", "Float", "FlowLayout", "Font", "FontMetrics", "Frame", "Graphics", "GridBagConstraints", "GridBagLayout", "GridLayout", "Hashtable", "IllegalAccessError", "IllegalAccessException", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalThreadStateException", "Image", "ImageConsumer", "ImageFilter", "ImageObserver", "ImageProducer", "IncompatibleClassChangeError", "IndexColorModel", "IndexOutOfBoundsException", "InetAddress", "InputStream", "Insets", "InstantiationError", "InstantiationException", "Integer", "InternalError", "InterruptedException", "InterruptedIOException", "IOException", "Label", "LayoutManager", "LineNumberInputStream", "LinkageError", "List", "Long", "MalformedURLException", "Math", "MediaTracker", "MemoryImageSource", "Menu", "MenuBar", "MenuComponent", "MenuContainer", "MenuItem", "NegativeArraySizeException", "NoClassDefFoundError", "NoSuchElementException", "NoSuchFieldError", "NoSuchMethodError", "NoSuchMethodException", "NullPointerException", "Number", "NumberFormatException", "Object", "Observable", "Observer", "OutOfMemoryError", "OutputStream", "Panel", "PipedInputStream", "PipedOutputStream", "PixelGrabber", "PlainSocketImpl", "Point", "Polygon", "PrintStream", "Process", "Properties", "ProtocolException", "PushbackInputStream", "Random", "RandomAccessFile", "Rectangle", "RGBImageFilter", "Runnable", "Runtime", "RuntimeException", "Scrollbar", "SecurityException", "SecurityManager", "SequenceInputStream", "ServerSocket", "Socket", "SocketException", "SocketImpl", "SocketImplFactory", "SocketInputStream", "SocketOutputStream", "Stack", "StackOverflowError", "StreamTokenizer", "String", "StringBuffer", "StringBufferInputStream", "StringIndexOutOfBoundsException", "StringTokenizer", "System", "TextArea", "TextComponent", "TextField", "Thread", "ThreadDeath", "ThreadGroup", "Throwable", "Toolkit", "UnknownError", "UnknownHostException", "UnknownServiceException", "UnsatisfiedLinkError", "URL", "URLConnection", "URLEncoder", "URLStreamHandler", "URLStreamHandlerFactory", "UTFDataFormatException", "Vector", "VerifyError", "VirtualMachineError", "Window"};
    String[] keywords = new String[]{"range", "boolean", "break", "byte", "in", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "threadsafe", "throw", "transient", "true", "try", "void", "while"};
    String[] types = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    Hashtable privateVariables = new Hashtable();
    Hashtable publicVariables = new Hashtable();
    Vector allTokens = new Vector();
    Vector tokenType = new Vector();
    int isWord = 0;
    int isSpace = 1;
    int isString = 2;
    int isComment1 = 3;
    int isComment2 = 4;
    int isChar = 5;
    int isKeyword = 6;
    int isKeywordPublic = 7;
    int isKeywordThis = 8;
    int isKeywordTypeOfData = 9;
    int isKnownJavaClass = 10;
    int isPrivateVariable = 11;
    int isPublicVariable = 12;
    int isInteger = 13;
    int isHexadecimal = 14;
    int isLong = 15;
    int isOctal = 16;
    int isDouble = 17;
    int isFloat = 18;
    int isUnknown = 19;
    String[] strFont = new String[]{"", "", "<FONT COLOR=\"red\">", "<FONT COLOR=\"green\">", "<FONT COLOR=\"green\">", "<FONT COLOR=\"#00FFFF\">", "<FONT COLOR=\"blue\">", "<FONT COLOR=\"blue\">", "<FONT COLOR=\"blue\">", "<FONT COLOR=\"blue\">", "<FONT COLOR=\"orange\">", "", "", "<B>", "<FONT COLOR=\"#0000BF\">", "<FONT COLOR=\"#CAFEBA\">", "<FONT COLOR=\"#BB00BB\">", "<FONT COLOR=\"white\">", "<FONT COLOR=\"white\">", ""};
    String[] strEndFont = new String[]{"", "", "</FONT>", "</FONT>", "</FONT>", "</FONT>", "</FONT>", "</FONT>", "</FONT>", "</FONT>", "</FONT>", "", "", "</B>", "</FONT>", "</FONT>", "</FONT>", "</FONT>", "</FONT>", ""};
    char[] separators = new char[]{' ', '\r', '\n', '\t', ';', ',', '(', ')', '{', '}', '=', '<', '>', '-', '+', '*', '/', '%', '^', '!', '?', '|', '&', ':', '~', '[', ']', '\''};
    char[] figures = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'x', '.', 'l'};
    char[] special = new char[]{'\"', '&', '<', '>'};
    String[] strSpecial = new String[]{"&quot;", "&amp;", "&lt;", "&gt;"};

    @Override
    public String getAppletInfo() {
        return new String("VasJava2HTML v2.0 February 10th, 1999, (C) 1997, 1998, 1999, 2000, 2001 Vasile Calmatui");
    }

    public static void main(String[] args) {
        VasJython2HTML myClass = new VasJython2HTML(false);
        boolean toForce = false;
        if (args.length == 0) {
            System.out.println("usage: VasJava2HTML [-f] file1 file2 ..\n-f option overrides the existing files.");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-f")) {
                toForce = true;
                continue;
            }
            try {
                String newFile = new String(args[i] + ".html");
                RandomAccessFile file2 = new RandomAccessFile(args[i], "r");
                byte[] fileC = new byte[(int)file2.length()];
                file2.readFully(fileC);
                file2.close();
                String fileContent = new String(fileC, 0);
                File newOne = new File(newFile);
                if (newOne.exists()) {
                    if (toForce) {
                        newOne.delete();
                    } else {
                        System.out.println("File " + newFile + " already exists.\nYou can use -f option to override it.");
                        System.exit(-1);
                    }
                }
                file2 = new RandomAccessFile(newFile, "rw");
                file2.writeBytes(myClass.transform(fileContent));
                file2.close();
                continue;
            }
            catch (Exception e) {
                System.out.println("File problem");
                e.printStackTrace(System.out);
                System.exit(-1);
            }
        }
    }

    public VasJython2HTML(boolean isApplet) {
        this.isApplet = isApplet;
    }

    public VasJython2HTML() {
        this.setLayout(null);
        this.setFont(new Font("Courier", 0, 12));
        this.setBackground(Color.white);
        this.lState = new Label("Paste in TextArea your Java code and make Go!");
        this.lState.reshape(10, 10, 360, 25);
        this.add(this.lState);
        this.bGo = new Button("Go!");
        this.bGo.reshape(385, 10, 70, 30);
        this.add(this.bGo);
        this.taContents = new TextArea();
        this.taContents.reshape(20, 45, 435, 210);
        this.add(this.taContents);
        this.taContents.appendText("/* (C), vasile@wook.com */" + this.lineSep + "import java.awt.*;" + this.lineSep + this.lineSep + "public class VasTest {" + this.lineSep + "  int hex=0x32;//C++ comment" + this.lineSep + "  char c='\\\\';//a character" + this.lineSep + "  int integ=32;//it works:-)" + this.lineSep + "  int OCTAL=077;" + this.lineSep + "  float floatN=.13f;" + this.lineSep + "  String string=\"String\";" + this.lineSep + "}//end VasTest");
        this.resize(470, 340);
    }

    @Override
    public void init() {
        this.compo = new Component[2];
        this.compo[0] = this.taContents;
        this.compo[1] = this.bGo;
        this.compo[0].requestFocus();
        if (this.compo[0] instanceof TextComponent) {
            ((TextComponent)this.compo[0]).selectAll();
        }
    }

    public String transform(String toTransform) {
        int i;
        Date dBegin = new Date();
        if (this.allTokens.size() > 0) {
            this.privateVariables = new Hashtable();
            this.publicVariables = new Hashtable();
            this.allTokens = new Vector();
            this.tokenType = new Vector();
        }
        int iBegWord = 0;
        int thisWordType = this.isWord;
        boolean bEndWord = false;
        if (this.isSeparator(toTransform.charAt(0))) {
            thisWordType = this.isSpace;
            bEndWord = true;
        }
        int strLength = toTransform.length();
        block5: for (i = 0; i < strLength; ++i) {
            if (this.isApplet && i % 100 == 0) {
                this.lState.setText("Analyzing character " + i + "/" + strLength);
            }
            char cCurr = toTransform.charAt(i);
            switch (cCurr) {
                case '\"': {
                    this.allTokens.addElement(toTransform.substring(iBegWord, i));
                    this.tokenType.addElement(new Integer(thisWordType));
                    int oldI = i;
                    i = this.getEndOfType(toTransform, i + 1, "\"");
                    this.allTokens.addElement(toTransform.substring(oldI, i));
                    this.tokenType.addElement(new Integer(this.isString));
                    iBegWord = i;
                    continue block5;
                }
                case '\'': {
                    this.allTokens.addElement(toTransform.substring(iBegWord, i));
                    this.tokenType.addElement(new Integer(thisWordType));
                    int oldI = i;
                    i = this.getEndOfType(toTransform, i + 1, "'");
                    this.allTokens.addElement(toTransform.substring(oldI, i));
                    this.tokenType.addElement(new Integer(this.isChar));
                    iBegWord = i;
                    continue block5;
                }
                case '#': {
                    int oldI;
                    if (i != 0) {
                        this.allTokens.addElement(toTransform.substring(iBegWord, i - 1));
                        this.tokenType.addElement(new Integer(thisWordType));
                        oldI = i - 1;
                        i = this.getEndOfType(toTransform, i, "\n");
                        this.allTokens.addElement(toTransform.substring(oldI, i));
                        this.tokenType.addElement(new Integer(this.isComment2));
                        iBegWord = i;
                        continue block5;
                    }
                }
                default: {
                    boolean sep = this.isSeparator(cCurr);
                    if (bEndWord != sep) {
                        this.allTokens.addElement(toTransform.substring(iBegWord, i));
                        this.tokenType.addElement(new Integer(thisWordType));
                        iBegWord = i;
                        boolean bl = bEndWord = !bEndWord;
                    }
                    if (sep) {
                        thisWordType = this.isSpace;
                        continue block5;
                    }
                    thisWordType = this.isWord;
                    continue block5;
                }
            }
        }
        this.allTokens.addElement(toTransform.substring(iBegWord));
        this.tokenType.addElement(new Integer(thisWordType));
        for (i = 0; i < this.allTokens.size(); ++i) {
            if ((Integer)this.tokenType.elementAt(i) != this.isWord) continue;
            this.tokenType.setElementAt(new Integer(this.analyzeToken(i)), i);
        }
        StringBuffer result = new StringBuffer("<HTML>" + this.lineSep + "<HEAD>" + this.lineSep + "<TITLE>Vasile's VasJava2HTML Output</TITLE>" + this.lineSep + "<META NAME=\"GENERATOR\" CONTENT=\"VasJava2HTML\">" + this.lineSep + "</HEAD>" + this.lineSep + "<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\">" + this.lineSep + "<PRE>" + this.lineSep);
        int tkSize = this.allTokens.size();
        for (int i2 = 0; i2 < tkSize; ++i2) {
            int type = (Integer)this.tokenType.elementAt(i2);
            result.append(this.strFont[type]);
            result.append(this.escapeHTML((String)this.allTokens.elementAt(i2)));
            result.append(this.strEndFont[type]);
        }
        if (this.isApplet) {
            this.lState.setText("Completed in " + (new Date().getTime() - dBegin.getTime()) + " millisec. " + result.length() + " characters.");
        }
        return result.toString();
    }

    int analyzeToken(int pos) {
        int i;
        String thisWord = (String)this.allTokens.elementAt(pos);
        if (thisWord.length() < 1) {
            return this.isSpace;
        }
        for (i = 0; i < this.keywords.length; ++i) {
            if (!thisWord.equals(this.keywords[i])) continue;
            if (this.keywords[i].equals("public")) {
                return this.isKeywordPublic;
            }
            if (this.keywords[i].equals("this")) {
                return this.isKeywordThis;
            }
            for (int k = 0; k < this.types.length; ++k) {
                if (!this.keywords[i].equals(this.types[k])) continue;
                return this.isKeywordTypeOfData;
            }
            return this.isKeyword;
        }
        for (i = 0; i < this.classes.length; ++i) {
            if (!thisWord.equals(this.classes[i])) continue;
            return this.isKnownJavaClass;
        }
        if (this.privateVariables.containsKey(thisWord)) {
            if (pos - 2 > 0 && ((String)this.allTokens.elementAt(pos - 1)).equals(".") && !((String)this.allTokens.elementAt(pos - 2)).equals("this")) {
                return this.isUnknown;
            }
            this.allTokens.setElementAt((String)this.privateVariables.get(thisWord), pos);
            return this.isPrivateVariable;
        }
        if (this.publicVariables.containsKey(thisWord)) {
            return this.isPublicVariable;
        }
        boolean isFunction = this.spaceHasParens(pos);
        if (this.isPublic(pos) && !isFunction) {
            this.publicVariables.put(thisWord, thisWord);
            return this.isPublicVariable;
        }
        if (this.previousWordWasDataType(pos) && !isFunction) {
            this.privateVariables.put(thisWord, thisWord);
            return this.isPrivateVariable;
        }
        return this.isUnknown;
    }

    boolean previousWordWasDataType(int pos) {
        while (--pos > 0) {
            int type = (Integer)this.tokenType.elementAt(pos);
            if (type == this.isComment1 || type == this.isComment2) continue;
            if (type == this.isKnownJavaClass || type == this.isKeywordTypeOfData || type == this.isPrivateVariable) {
                return true;
            }
            if (type == this.isSpace) {
                String myWord = (String)this.allTokens.elementAt(pos);
                int strLength = myWord.length();
                for (int i = 0; i < strLength; ++i) {
                    char c = myWord.charAt(i);
                    if (c == ' ' || c == ',' || c == '\t' || c == '[' || c == ']') continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return false;
    }

    boolean spaceHasParens(int pos) {
        while (++pos < this.tokenType.size()) {
            int type = (Integer)this.tokenType.elementAt(pos);
            if (type == this.isComment1 || type == this.isComment2) continue;
            if (type == this.isSpace) {
                String myWord = (String)this.allTokens.elementAt(pos);
                int strLength = myWord.length();
                for (int i = 0; i < strLength; ++i) {
                    char c = myWord.charAt(i);
                    if (c == ' ' || c == '\t') continue;
                    return c == '(';
                }
            }
            return false;
        }
        return false;
    }

    boolean isPublic(int pos) {
        while (--pos > 0) {
            int type = (Integer)this.tokenType.elementAt(pos);
            if (type == this.isComment1 || type == this.isComment2) continue;
            if (type == this.isPublicVariable || type == this.isKeywordPublic) {
                return true;
            }
            if (type == this.isKeyword || type == this.isKnownJavaClass || type == this.isKeywordTypeOfData) continue;
            if (type == this.isSpace) {
                String myWord = (String)this.allTokens.elementAt(pos);
                int strLength = myWord.length();
                for (int i = 0; i < strLength; ++i) {
                    char c = myWord.charAt(i);
                    if (c == ' ' || c == ',' || c == '\t' || c == '[' || c == ']') continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return false;
    }

    boolean isNotEscaped(String myString, int charPosition) {
        int i = 1;
        while (charPosition - i >= 0 && myString.charAt(charPosition - i) == '\\') {
            ++i;
        }
        return i % 2 != 0;
    }

    boolean isSeparator(char car) {
        for (int i = 0; i < this.separators.length; ++i) {
            if (car != this.separators[i]) continue;
            return true;
        }
        return false;
    }

    int getEndOfType(String myString, int where, String whatStops) {
        int strLength = myString.length();
        int whatLength = whatStops.length();
        while (where < strLength - whatLength) {
            int j;
            for (j = 0; j < whatLength && myString.charAt(where + j) == whatStops.charAt(j); ++j) {
            }
            if (j == whatLength && this.isNotEscaped(myString, where)) {
                where += whatLength;
                break;
            }
            ++where;
        }
        if (where == strLength - whatLength) {
            where += whatLength;
        }
        return where;
    }

    StringBuffer escapeHTML(String toEscape) {
        StringBuffer out = new StringBuffer(toEscape);
        for (int j = 0; j < out.length(); ++j) {
            for (int i = 0; i < this.special.length; ++i) {
                if (out.charAt(j) != this.special[i]) continue;
                out.setCharAt(j, this.strSpecial[i].charAt(0));
                if (this.strSpecial[i].length() <= 1) continue;
                out.insert(j + 1, this.strSpecial[i].substring(1));
                j += this.strSpecial[i].length() - 1;
            }
        }
        return out;
    }

    int putNumberType(String toAnalyze) {
        char[] number = toAnalyze.toCharArray();
        int type = this.isInteger;
        int j = 0;
        int figLength = this.figures.length;
        int wordLength = number.length;
        do {
            number[j] = Character.toLowerCase(number[j]);
            int i = 0;
            do {
                if (number[j] != this.figures[i]) continue;
                if (number[j] != '.' && number[j] != 'e') break;
                type = this.isDouble;
                break;
            } while (++i < figLength);
            if (i != figLength) continue;
            return this.isWord;
        } while (++j < wordLength);
        if (number[0] == '0' && number.length > 1) {
            type = number[1] == 'x' ? this.isHexadecimal : this.isOctal;
        }
        switch (number[number.length - 1]) {
            case 'd': {
                type = this.isDouble;
                break;
            }
            case 'f': {
                type = this.isFloat;
                break;
            }
            case 'l': {
                type = this.isLong;
            }
        }
        return type;
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.id == 401 && e.key == 9) {
            for (int i = 0; i < this.compo.length; ++i) {
                if (e.target != this.compo[i]) continue;
                if (this.compo[i] instanceof TextComponent) {
                    ((TextComponent)this.compo[i]).select(0, 0);
                }
                while (!this.compo[i = (i + (e.shiftDown() ? this.compo.length - 1 : 1)) % this.compo.length].isEnabled()) {
                }
                this.compo[i].requestFocus();
                if (this.compo[i] instanceof TextComponent) {
                    ((TextComponent)this.compo[i]).selectAll();
                }
                return true;
            }
            return false;
        }
        if (e.target == this.bGo && (e.arg == this.bGo.getLabel() || e.id == 402 && e.key == 10)) {
            this.taContents.setText(this.transform(this.taContents.getText()));
            return true;
        }
        return false;
    }
}

