/*
 * Decompiled with CFR 0.152.
 */
package jehep.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.util.Date;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import jehep.syntax.SyntaxStyle;
import jehep.syntax.SyntaxUtilities;
import jehep.syntax.TokenMarker;
import jehep.ui.JehepTextArea;
import jehep.ui.mainGUI;

public class PrintSyntax {
    private Segment seg = new Segment();

    public void print(mainGUI parent, JehepTextArea textArea) {
        PrintJob job = parent.getToolkit().getPrintJob(parent, "Jehep:" + textArea.getName(), null);
        if (job == null) {
            return;
        }
        int ppi = job.getPageResolution();
        int topMargin = (int)(0.5 * (double)ppi);
        int leftMargin = (int)(0.5 * (double)ppi);
        int bottomMargin = (int)(0.5 * (double)ppi);
        int rightMargin = (int)(0.5 * (double)ppi);
        boolean printHeader = true;
        boolean printFooter = true;
        boolean printLineNumbers = true;
        String header = textArea.getName();
        String footer = new Date().toString();
        int lineCount = textArea.getDocument().getDefaultRootElement().getElementCount();
        PrintTabExpander expander = null;
        Graphics gfx = null;
        String fontFamily = parent.getFont().getFamily();
        int fontSize = parent.getFont().getSize();
        int fontStyle = parent.getFont().getStyle();
        SyntaxStyle[] styles = textArea.getPainter().getStyles();
        Font font = new Font(fontFamily, fontStyle, fontSize);
        FontMetrics fm = null;
        Dimension pageDimension = job.getPageDimension();
        int pageWidth = pageDimension.width;
        int pageHeight = pageDimension.height;
        int y = 0;
        int tabSize = 0;
        int lineHeight = 0;
        int page = 0;
        int lineNumberDigits = (int)Math.ceil(Math.log(lineCount) / Math.log(10.0));
        int lineNumberWidth = 0;
        for (int i = 0; i < lineCount; ++i) {
            if (gfx == null) {
                ++page;
                gfx = job.getGraphics();
                gfx.setFont(font);
                fm = gfx.getFontMetrics();
                lineNumberWidth = printLineNumbers ? fm.charWidth('0') * lineNumberDigits : 0;
                lineHeight = fm.getHeight();
                tabSize = textArea.getTabSize() * fm.charWidth(' ');
                expander = new PrintTabExpander(leftMargin + lineNumberWidth, tabSize);
                y = topMargin + lineHeight - fm.getDescent() - fm.getLeading();
                if (printHeader) {
                    gfx.setColor(Color.lightGray);
                    gfx.fillRect(leftMargin, topMargin, pageWidth - leftMargin - rightMargin, lineHeight);
                    gfx.setColor(Color.black);
                    gfx.drawString(header, leftMargin, y);
                    y += lineHeight;
                }
            }
            y += lineHeight;
            gfx.setColor(Color.black);
            gfx.setFont(font);
            int x = leftMargin;
            if (printLineNumbers) {
                String lineNumber = String.valueOf(i + 1);
                gfx.drawString(lineNumber, leftMargin + lineNumberWidth - fm.stringWidth(lineNumber), y);
                x += lineNumberWidth + fm.charWidth('0');
            }
            this.paintSyntaxLine(textArea, gfx, expander, textArea.getTokenMarker(), styles, fm, i, font, Color.black, x, y);
            int bottomOfPage = pageHeight - bottomMargin - lineHeight;
            if (printFooter) {
                bottomOfPage -= lineHeight * 2;
            }
            if (y < bottomOfPage && i != lineCount - 1) continue;
            if (printFooter) {
                y = pageHeight - bottomMargin;
                gfx.setColor(Color.lightGray);
                gfx.setFont(font);
                gfx.fillRect(leftMargin, y - lineHeight, pageWidth - leftMargin - rightMargin, lineHeight);
                gfx.setColor(Color.black);
                gfx.drawString(footer, leftMargin, y -= lineHeight - fm.getAscent());
                String pageStr = parent.getFileName();
                int width = fm.stringWidth(pageStr);
                gfx.drawString(pageStr, pageWidth - rightMargin - width, y);
            }
            gfx.dispose();
            gfx = null;
        }
        job.end();
    }

    protected int paintSyntaxLine(JehepTextArea textArea, Graphics gfx, TabExpander expander, TokenMarker tokenMarker, SyntaxStyle[] styles, FontMetrics fm, int line, Font defaultFont, Color defaultColor, int x, int y) {
        gfx.setFont(defaultFont);
        gfx.setColor(defaultColor);
        textArea.getLineText(line, this.seg);
        x = SyntaxUtilities.paintSyntaxLine(this.seg, tokenMarker.markTokens(this.seg, line), styles, expander, gfx, x, y);
        return x;
    }

    static class PrintTabExpander
    implements TabExpander {
        private int leftMargin;
        private int tabSize;

        public PrintTabExpander(int leftMargin, int tabSize) {
            this.leftMargin = leftMargin;
            this.tabSize = tabSize;
        }

        @Override
        public float nextTabStop(float x, int tabOffset) {
            int ntabs = ((int)x - this.leftMargin) / this.tabSize;
            return (ntabs + 1) * this.tabSize + this.leftMargin;
        }
    }
}

