/*
 * Decompiled with CFR 0.152.
 */
package jehep.utils;

import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import jehep.ui.Constants;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;

public class MenuFactory
implements Constants {
    public static JMenu createMenu(String label, int key, int mnemonic, Icon icon, mainGUI win) {
        JMenu menu = new JMenu(label);
        if (icon != null) {
            menu.setIcon(icon);
        }
        if (mnemonic != 0) {
            menu.setMnemonic(mnemonic);
        }
        menu.setFont(SetEnv.guiFont);
        return menu;
    }

    public static JMenuItem createMenuItem(String label, String tooltip, Icon icon, int key, int mnemonic, mainGUI win) {
        JMenuItem menuitem = new JMenuItem(label);
        menuitem.addActionListener(win);
        if (icon != null) {
            menuitem.setIcon(icon);
        }
        if (tooltip != null) {
            menuitem.setToolTipText(tooltip);
        }
        if (key != 0) {
            if (key == 99) {
                menuitem.setAccelerator(KeyStroke.getKeyStroke(67, 10));
            } else if (key == 120) {
                menuitem.setAccelerator(KeyStroke.getKeyStroke(88, 10));
            }
            if (key == 97) {
                menuitem.setAccelerator(KeyStroke.getKeyStroke(65, 3));
            } else if (key == 100) {
                menuitem.setAccelerator(KeyStroke.getKeyStroke(68, 3));
            } else if (key == 124) {
                menuitem.setAccelerator(KeyStroke.getKeyStroke(74, 10));
            } else {
                menuitem.setAccelerator(KeyStroke.getKeyStroke(key, 2));
            }
        }
        if (mnemonic != 0) {
            menuitem.setMnemonic(mnemonic);
        }
        menuitem.setFont(SetEnv.guiFont);
        return menuitem;
    }
}

