/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jehep.ui.Constants;
import jehep.ui.Editor;
import jehep.ui.SetEnv;
import jehep.ui.Thread1;
import jehep.ui.mainGUI;

public class PanelStructure
extends JPanel
implements Constants {
    private mainGUI win;
    private JScrollPane scroll;
    private static final long serialVersionUID = 1L;
    public JTree stree;

    public PanelStructure(mainGUI win) {
        this.win = win;
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        this.stree = new JTree(Editor.Struc[Editor.Selected].model);
        this.scroll = new JScrollPane(this.stree);
        this.scroll.setWheelScrollingEnabled(true);
        this.add(this.scroll);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(leafIcon);
        renderer.setClosedIcon(leafIcon);
        renderer.setLeafIcon(sectionIcon);
        this.stree.setCellRenderer(renderer);
        this.stree.setFont(SetEnv.guiFont);
        this.stree.setShowsRootHandles(false);
        this.stree.putClientProperty("JTree.lineStyle", "Angled");
        this.stree.setRootVisible(true);
        this.stree.getSelectionModel().setSelectionMode(1);
        this.stree.setBackground(new Color(255, 255, 255));
        this.stree.setForeground(Color.blue);
        this.stree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JTree jtree = (JTree)e.getSource();
                    int clickedrow = jtree.getRowForLocation(e.getX(), e.getY());
                    int isize = Editor.Struc[Editor.Selected].getSize();
                    if (clickedrow > 0 && clickedrow < isize) {
                        int iline = Editor.Struc[Editor.Selected].getLine(clickedrow - 1);
                        Editor.ScrollToLine(iline);
                    }
                }
            }
        });
    }

    public void Refresh() {
        Thread1 t = new Thread1("RunAnalyser thread");
        if (!t.Alive()) {
            t.Start();
        }
        if (t.Joint()) {
            this.stree.setModel(Editor.Struc[Editor.Selected].model);
            Editor.Struc[Editor.Selected].model.reload();
            this.stree.expandRow(0);
            this.scroll.revalidate();
            this.scroll.repaint();
            this.repaint();
        }
    }

    public void Repaint() {
        this.stree.setModel(Editor.Struc[Editor.Selected].model);
        Editor.Struc[Editor.Selected].model.reload();
        this.stree.expandRow(0);
        this.scroll.revalidate();
        this.scroll.repaint();
        this.repaint();
    }

    public void Clear() {
        Editor.Struc[Editor.Selected].remove();
        this.stree.setModel(Editor.Struc[Editor.Selected].model);
        Editor.Struc[Editor.Selected].model.reload();
        this.repaint();
    }
}

