/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jehep.ui.Constants;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;
import jehep.utils.Util;

class EditorRun
extends JDialog
implements Constants {
    private static final long serialVersionUID = 1L;
    private JButton jB1;
    private JButton jB2;
    private JButton jB3;
    private JScrollPane jScrollPane1;
    public static String keepstring;
    public JTextArea jDescription;
    private JPopupMenu menu;
    private mainGUI win;

    public EditorRun(mainGUI win) {
        this.win = win;
        this.setModal(true);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setTitle("Editor for custom command");
        this.setSize(400, 200);
        JPanel topPanel = new JPanel();
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(300, 35));
        this.jDescription = new JTextArea(40, 40);
        this.jDescription.setText(SetEnv.RunCommText);
        this.jDescription.setCaretPosition(0);
        this.jDescription.setFont(SetEnv.guiFont);
        this.jDescription.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jDescription.setEditable(true);
        this.jB1 = new JButton();
        this.jB1.setText("Save");
        this.jB1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOptionPane dialog1 = new JOptionPane();
                int ask = JOptionPane.showConfirmDialog(dialog1, "Save Settings?", "Question", 0, 3, null);
                if (ask == 0) {
                    try {
                        SetEnv.RunCommText = EditorRun.this.jDescription.getText();
                        SetEnv.writeComm();
                        SetEnv.buildComm();
                    }
                    catch (Exception e) {
                        System.out.println("Error when saving file..");
                        JOptionPane dialog = new JOptionPane();
                        JOptionPane.showMessageDialog(dialog, "Cannot save!", "Error", 0);
                    }
                }
            }
        });
        this.jB2 = new JButton();
        this.jB2.setText("Exit");
        this.jB2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOptionPane dialog1 = new JOptionPane();
                int ask = JOptionPane.showConfirmDialog(dialog1, "Exit Editor?", "Question", 0, 3, null);
                if (ask == 0) {
                    EditorRun.this.setVisible(false);
                    EditorRun.this.dispose();
                }
            }
        });
        this.jB3 = new JButton();
        this.jB3.setText("Set to Default");
        this.jB3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetEnv.RunCommText = SetEnv.RunCommTextDefault;
                EditorRun.this.jDescription.setText(SetEnv.RunCommTextDefault);
                EditorRun.this.jDescription.setCaretPosition(0);
            }
        });
        lowerPanel.add((Component)this.jB1, null);
        lowerPanel.add((Component)this.jB2, null);
        lowerPanel.add((Component)this.jB3, null);
        topPanel.setLayout(new BorderLayout());
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setWheelScrollingEnabled(true);
        this.jScrollPane1.getViewport().add(this.jDescription);
        topPanel.add((Component)this.jScrollPane1, "Center");
        this.jDescription.setLineWrap(true);
        this.jDescription.setWrapStyleWord(true);
        this.jDescription.setCaretColor(Color.red);
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        this.menu = new JPopupMenu();
        JMenuItem icut = new JMenuItem("Cut");
        JMenuItem icopy = new JMenuItem("Copy");
        JMenuItem ipaste = new JMenuItem("Paste");
        this.menu.add(icut);
        this.menu.add(icopy);
        this.menu.add(ipaste);
        this.jDescription.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    EditorRun.this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    EditorRun.this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        icut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorRun.this.jDescription.replaceSelection("");
                EditorRun.this.jScrollPane1.revalidate();
                EditorRun.this.jScrollPane1.repaint();
            }
        });
        icopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                keepstring = EditorRun.this.jDescription.getSelectedText();
                int nn = EditorRun.this.jDescription.getSelectionStart();
                EditorRun.this.jDescription.select(nn, nn);
            }
        });
        ipaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int pos = EditorRun.this.jDescription.getCaretPosition();
                if (pos <= EditorRun.this.jDescription.getDocument().getLength()) {
                    EditorRun.this.jDescription.insert(keepstring, pos);
                    keepstring = "";
                }
            }
        });
        this.Show();
    }

    public void Show() {
        Dimension dim = this.win.getSize();
        int w = dim.width;
        int h = dim.height;
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Util.rightWithin(this.win, this);
        Util.centreWithin(this.win, this);
        this.setVisible(true);
        this.pack();
    }
}

