/*
 * Decompiled with CFR 0.152.
 */
package jehep.textparse;

import java.util.ArrayList;
import java.util.List;
import jehep.textparse.OidNode;
import jehep.ui.Editor;

public class PythonParse {
    private List<OidNode> data = new ArrayList<OidNode>();
    private int[] id_keywords;
    private String[][] keywords = new String[][]{{"def ", ""}};

    public PythonParse() {
        this.id_keywords = new int[this.keywords.length];
    }

    public List<OidNode> Load() {
        this.clear();
        String snode = "";
        for (int i = 0; i < Editor.getLineCount(); ++i) {
            String scomment;
            int ii;
            String text = Editor.getLineText(i);
            text = text.trim();
            for (ii = 0; ii < this.keywords.length; ++ii) {
                this.id_keywords[ii] = -1;
            }
            for (ii = 0; ii < this.keywords.length; ++ii) {
                if (!text.startsWith(this.keywords[ii][0])) continue;
                this.id_keywords[ii] = 1;
            }
            int jtake = -1;
            String jwhat = "";
            int jjtake = 0;
            for (int ii2 = 0; ii2 < this.keywords.length; ++ii2) {
                if (this.id_keywords[ii2] <= -1) continue;
                jtake = this.id_keywords[ii2];
                jwhat = this.keywords[ii2][1];
                jjtake = ii2;
            }
            if (jtake <= -1 || (scomment = text.substring(0, jtake)).indexOf("#") > -1) continue;
            int i1 = text.indexOf("(");
            int i2 = text.indexOf(")");
            int i3 = text.indexOf(":");
            if (i1 <= -1 || i2 <= -1 || i3 <= -1 || i1 >= i2 || i2 >= i3) continue;
            snode = text.substring(0, i1);
            this.data.add(new OidNode(i, snode));
        }
        return this.data;
    }

    public void clear() {
        this.data.clear();
    }

    public int getSize() {
        return this.data.size();
    }
}

