/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class VerilogTokenMarker
extends TokenMarker {
    static final int NORMAL = 0;
    static final int SIMPLE_QUOTE = 1;
    static final int BACK_ACCENT = 2;
    static final int DOLLAR = 3;
    int env;
    private static KeywordMap vKeywords;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public VerilogTokenMarker() {
        this(VerilogTokenMarker.getKeywords());
    }

    public VerilogTokenMarker(KeywordMap keywords) {
        this.keywords = keywords;
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        boolean keyChar = false;
        this.env = 0;
        block24: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(1, (byte)6);
                            this.lastOffset = this.lastKeyword = i + 1;
                            break;
                        }
                        case '@': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            keyChar = true;
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '$': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.env = 3;
                            this.addToken(i - this.lastOffset, token);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '`': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.env = 2;
                            this.addToken(i - this.lastOffset, token);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.env = 1;
                            this.addToken(i - this.lastOffset, token);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                backslash = false;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block24;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block24;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (length - i > 2 && array[i + 2] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    token = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(length - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block24;
                                }
                            }
                            continue block24;
                        }
                        default: {
                            backslash = false;
                            if (keyChar) {
                                keyChar = false;
                                this.doKeyword(line, i, c);
                                this.addToken(i1 - this.lastOffset, token);
                                token = 0;
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (Character.isLetterOrDigit(c) || c == '_') continue block24;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block24;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block24;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block24;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block24;
                    }
                    if (c != '\"') continue block24;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.env = 0;
                    continue block24;
                }
                case 4: {
                    if (Character.isLetterOrDigit(c) || c == '_') continue block24;
                    this.addToken(i1 - this.lastOffset, (byte)4);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.env = 0;
                    continue block24;
                }
                case 7: {
                    if (Character.isLetterOrDigit(c) || c == '_') continue block24;
                    this.addToken(i1 - this.lastOffset, (byte)7);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.env = 0;
                    continue block24;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 4: 
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (backslash) break;
                token = 0;
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (vKeywords == null) {
            vKeywords = new KeywordMap(false);
            vKeywords.add("reg", (byte)8);
            vKeywords.add("wire", (byte)8);
            vKeywords.add("wand", (byte)8);
            vKeywords.add("wor", (byte)8);
            vKeywords.add("integer", (byte)8);
            vKeywords.add("parameter", (byte)8);
            vKeywords.add("integer", (byte)8);
            vKeywords.add("real", (byte)8);
            vKeywords.add("time", (byte)8);
            vKeywords.add("realtime", (byte)8);
            vKeywords.add("event", (byte)8);
            vKeywords.add("input", (byte)6);
            vKeywords.add("output", (byte)6);
            vKeywords.add("inout", (byte)6);
            vKeywords.add("module", (byte)6);
            vKeywords.add("endmodule", (byte)6);
            vKeywords.add("assign", (byte)6);
            vKeywords.add("always", (byte)6);
            vKeywords.add("posedge", (byte)6);
            vKeywords.add("negedge", (byte)6);
            vKeywords.add("initial", (byte)6);
            vKeywords.add("forever", (byte)6);
            vKeywords.add("while", (byte)6);
            vKeywords.add("for", (byte)6);
            vKeywords.add("if", (byte)6);
            vKeywords.add("else", (byte)6);
            vKeywords.add("case", (byte)6);
            vKeywords.add("casex", (byte)6);
            vKeywords.add("casez", (byte)6);
            vKeywords.add("default", (byte)6);
            vKeywords.add("endcase", (byte)6);
            vKeywords.add("or", (byte)6);
            vKeywords.add("#", (byte)6);
            vKeywords.add("@", (byte)6);
            vKeywords.add("begin", (byte)6);
            vKeywords.add("end", (byte)6);
            vKeywords.add("fork", (byte)6);
            vKeywords.add("join", (byte)6);
            vKeywords.add("wait", (byte)6);
            vKeywords.add("function", (byte)6);
            vKeywords.add("endfunction", (byte)6);
            vKeywords.add("task", (byte)6);
            vKeywords.add("endtask", (byte)6);
            vKeywords.add("$display", (byte)7);
            vKeywords.add("$write", (byte)7);
            vKeywords.add("$time", (byte)7);
            vKeywords.add("$monitor", (byte)7);
            vKeywords.add("$finish", (byte)7);
            vKeywords.add("$readmemb", (byte)7);
            vKeywords.add("$readmemh", (byte)7);
            vKeywords.add("$stop", (byte)7);
            vKeywords.add("$define_group_waves", (byte)7);
            vKeywords.add("$gr_waves_memsize", (byte)7);
            vKeywords.add("$gr_waves", (byte)7);
            vKeywords.add("`include", (byte)7);
            vKeywords.add("`define", (byte)7);
            vKeywords.add("`ifdef", (byte)7);
            vKeywords.add("`define", (byte)7);
        }
        return vKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        switch (this.env) {
            case 2: {
                if (id != 0) break;
                id = 4;
                break;
            }
            case 1: {
                id = 4;
                this.lastKeyword += 2;
                len -= 2;
            }
        }
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        this.env = 0;
        return false;
    }
}

