/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class VHDLTokenMarker
extends TokenMarker {
    public static final int AS_IS = 0;
    public static final int LOWER_CASE = 1;
    public static final int UPPER_CASE = 2;
    private static KeywordMap vhdlKeywords;
    private KeywordMap keywords = VHDLTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;
    private int keywordCase = 0;
    private boolean allLowerCase = false;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block20: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (!backslash) continue block20;
                            backslash = false;
                            break;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                backslash = false;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block20;
                            break;
                        }
                        case '-': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block20;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.lastOffset = this.lastKeyword = i;
                                    token = 1;
                                    break;
                                }
                                case '-': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(length - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block20;
                                }
                            }
                            continue block20;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block20;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block20;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block20;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block20;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block20;
                    }
                    if (c != '\"') continue block20;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block20;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block20;
                    }
                    if (c != '\'') continue block20;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block20;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (vhdlKeywords == null) {
            vhdlKeywords = new KeywordMap(true);
            vhdlKeywords.add("char", (byte)8);
            vhdlKeywords.add("double", (byte)8);
            vhdlKeywords.add("enum", (byte)8);
            vhdlKeywords.add("real", (byte)8);
            vhdlKeywords.add("integer", (byte)8);
            vhdlKeywords.add("natural", (byte)8);
            vhdlKeywords.add("text", (byte)8);
            vhdlKeywords.add("boolean", (byte)8);
            vhdlKeywords.add("line", (byte)8);
            vhdlKeywords.add("string", (byte)8);
            vhdlKeywords.add("bit", (byte)8);
            vhdlKeywords.add("bit_vector", (byte)8);
            vhdlKeywords.add("std_logic", (byte)8);
            vhdlKeywords.add("std_logic_vector", (byte)8);
            vhdlKeywords.add("if", (byte)6);
            vhdlKeywords.add("then", (byte)6);
            vhdlKeywords.add("elsif", (byte)6);
            vhdlKeywords.add("else", (byte)6);
            vhdlKeywords.add("begin", (byte)6);
            vhdlKeywords.add("end", (byte)6);
            vhdlKeywords.add("for", (byte)6);
            vhdlKeywords.add("while", (byte)6);
            vhdlKeywords.add("loop", (byte)6);
            vhdlKeywords.add("when", (byte)6);
            vhdlKeywords.add("after", (byte)6);
            vhdlKeywords.add("wait", (byte)6);
            vhdlKeywords.add("function", (byte)6);
            vhdlKeywords.add("procedure", (byte)6);
            vhdlKeywords.add("case", (byte)6);
            vhdlKeywords.add("default", (byte)6);
            vhdlKeywords.add("transport", (byte)6);
            vhdlKeywords.add("and", (byte)6);
            vhdlKeywords.add("or", (byte)6);
            vhdlKeywords.add("not", (byte)6);
            vhdlKeywords.add("xor", (byte)6);
            vhdlKeywords.add("entity", (byte)6);
            vhdlKeywords.add("architecture", (byte)6);
            vhdlKeywords.add("port", (byte)6);
            vhdlKeywords.add("in", (byte)6);
            vhdlKeywords.add("out", (byte)6);
            vhdlKeywords.add("inout", (byte)6);
            vhdlKeywords.add("map", (byte)6);
            vhdlKeywords.add("component", (byte)6);
            vhdlKeywords.add("of", (byte)6);
            vhdlKeywords.add("on", (byte)6);
            vhdlKeywords.add("is", (byte)6);
            vhdlKeywords.add("process", (byte)6);
            vhdlKeywords.add("return", (byte)6);
            vhdlKeywords.add("to", (byte)6);
            vhdlKeywords.add("downto", (byte)6);
            vhdlKeywords.add("alias", (byte)6);
            vhdlKeywords.add("variable", (byte)6);
            vhdlKeywords.add("signal", (byte)6);
            vhdlKeywords.add("constant", (byte)6);
            vhdlKeywords.add("generic", (byte)6);
            vhdlKeywords.add("range", (byte)6);
            vhdlKeywords.add("event", (byte)6);
            vhdlKeywords.add("file", (byte)6);
            vhdlKeywords.add("time", (byte)6);
            vhdlKeywords.add("all", (byte)6);
            vhdlKeywords.add("package", (byte)6);
            vhdlKeywords.add("use", (byte)6);
            vhdlKeywords.add("library", (byte)6);
            vhdlKeywords.add("true", (byte)4);
            vhdlKeywords.add("false", (byte)4);
            vhdlKeywords.add("NULL", (byte)4);
        }
        return vhdlKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        int txtOffset = this.lastKeyword;
        int n = i;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
            if (this.keywordCase == 1 || this.allLowerCase) {
                char[] txt = line.array;
                for (int j = txtOffset; j < n; ++j) {
                    txt[j] = Character.toLowerCase(txt[j]);
                }
            } else if (this.keywordCase == 2) {
                char[] txt = line.array;
                for (int j = txtOffset; j < n; ++j) {
                    txt[j] = Character.toUpperCase(txt[j]);
                }
            }
        }
        this.lastKeyword = i1;
        return false;
    }

    public void setKeywordCase(int c) {
        this.keywordCase = c;
    }

    public int getKeywordCase() {
        return this.keywordCase;
    }

    public void setAllLowerCase(boolean b) {
        this.allLowerCase = b;
    }

    public boolean getAllLowerCase() {
        return this.allLowerCase;
    }
}

