/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;
import jehep.ui.SetEnv;

public class RubyTokenMarker
extends TokenMarker {
    private static KeywordMap rubyKeywords;
    private KeywordMap keywords = RubyTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;
    private int lastWhitespace;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        this.lastWhitespace = offset - 1;
        int length = line.count + offset;
        boolean backslash = false;
        block15: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '(': {
                            if (backslash) {
                                this.doKeyword(line, i, c);
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(this.lastWhitespace - this.lastOffset + 1, token);
                            this.addToken(i - this.lastWhitespace - 1, (byte)11);
                            this.addToken(1, (byte)0);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i1;
                            this.lastWhitespace = i;
                            break;
                        }
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            this.lastOffset = this.lastKeyword = length;
                            break block15;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (!Character.isLetterOrDigit(c) && c != '_') {
                                this.doKeyword(line, i, c);
                            }
                            if (" \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?@".indexOf(c) == -1) continue block15;
                            this.lastWhitespace = i;
                            break;
                        }
                    }
                    continue block15;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block15;
                    }
                    if (c != '\"') continue block15;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block15;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block15;
                    }
                    if (c != '\'') continue block15;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block15;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 0: {
                this.doKeyword(line, length, '\u0000');
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (rubyKeywords == null) {
            rubyKeywords = new KeywordMap(false);
            rubyKeywords.add("__FILE__", (byte)5);
            rubyKeywords.add("and", (byte)7);
            rubyKeywords.add("def", (byte)6);
            rubyKeywords.add("end", (byte)6);
            rubyKeywords.add("in", (byte)6);
            rubyKeywords.add("or", (byte)7);
            rubyKeywords.add("self", (byte)4);
            rubyKeywords.add("unless", (byte)6);
            rubyKeywords.add("__LINE__", (byte)5);
            rubyKeywords.add("begin", (byte)6);
            rubyKeywords.add("defined?", (byte)6);
            rubyKeywords.add("ensure", (byte)6);
            rubyKeywords.add("module", (byte)8);
            rubyKeywords.add("require", (byte)7);
            rubyKeywords.add("include", (byte)7);
            rubyKeywords.add("java_import", (byte)7);
            rubyKeywords.add("load", (byte)7);
            rubyKeywords.add("redo", (byte)6);
            rubyKeywords.add("super", (byte)4);
            rubyKeywords.add("until", (byte)6);
            rubyKeywords.add("BEGIN", (byte)5);
            rubyKeywords.add("break", (byte)6);
            rubyKeywords.add("do", (byte)6);
            rubyKeywords.add("false", (byte)4);
            rubyKeywords.add("next", (byte)6);
            rubyKeywords.add("rescue", (byte)6);
            rubyKeywords.add("then", (byte)6);
            rubyKeywords.add("when", (byte)6);
            rubyKeywords.add("END", (byte)5);
            rubyKeywords.add("case", (byte)6);
            rubyKeywords.add("else", (byte)6);
            rubyKeywords.add("for", (byte)6);
            rubyKeywords.add("nil", (byte)4);
            rubyKeywords.add("retry", (byte)6);
            rubyKeywords.add("true", (byte)4);
            rubyKeywords.add("while", (byte)6);
            rubyKeywords.add("alias", (byte)8);
            rubyKeywords.add("class", (byte)8);
            rubyKeywords.add("elsif", (byte)6);
            rubyKeywords.add("if", (byte)6);
            rubyKeywords.add("not", (byte)7);
            rubyKeywords.add("return", (byte)6);
            rubyKeywords.add("undef", (byte)6);
            rubyKeywords.add("yield", (byte)6);
            rubyKeywords.add("gets", (byte)6);
            rubyKeywords.add("puts", (byte)6);
            rubyKeywords.add("print", (byte)6);
            RubyTokenMarker.ReadSyntax();
        }
        return rubyKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
            this.lastWhitespace = i1;
            this.lastKeyword = i1;
            return true;
        }
        this.lastKeyword = i1;
        return false;
    }

    private static void ReadSyntax() {
        String sd1 = SetEnv.DirPath + File.separator + "syntax" + File.separator + "jhplot" + File.separator + "classes.d";
        try {
            String thisLine;
            BufferedReader in = new BufferedReader(new FileReader(sd1));
            while ((thisLine = in.readLine()) != null) {
                if (thisLine.length() <= 1) continue;
                rubyKeywords.add(thisLine, (byte)8);
            }
        }
        catch (Exception e) {
            System.out.println("Error in reading : " + sd1);
        }
    }
}

