/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.SyntaxUtilities;
import jehep.syntax.TokenMarker;
import jehep.ui.SetEnv;

public class PythonRootTokenMarker
extends TokenMarker {
    private static final byte TRIPLEQUOTE1 = 100;
    private static final byte TRIPLEQUOTE2 = 126;
    private static KeywordMap pyKeywords;
    private KeywordMap keywords = PythonRootTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;
    private int lastWhitespace;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        this.lastWhitespace = offset - 1;
        int length = line.count + offset;
        boolean backslash = false;
        block18: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '(': {
                            if (backslash) {
                                this.doKeyword(line, i, c);
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(this.lastWhitespace - this.lastOffset + 1, token);
                            this.addToken(i - this.lastWhitespace - 1, (byte)11);
                            this.addToken(1, (byte)0);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i1;
                            this.lastWhitespace = i;
                            break;
                        }
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            this.lastOffset = this.lastKeyword = length;
                            break block18;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            if (SyntaxUtilities.regionMatches(false, line, i1, "\"\"")) {
                                this.lastOffset = this.lastKeyword = i;
                                i += 3;
                                token = (byte)100;
                                break;
                            }
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            if (SyntaxUtilities.regionMatches(false, line, i1, "''")) {
                                this.lastOffset = this.lastKeyword = i;
                                i += 3;
                                token = (byte)126;
                                break;
                            }
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (!Character.isLetterOrDigit(c) && c != '_') {
                                this.doKeyword(line, i, c);
                            }
                            if (" \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?@".indexOf(c) == -1) continue block18;
                            this.lastWhitespace = i;
                            break;
                        }
                    }
                    continue block18;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block18;
                    }
                    if (c != '\"') continue block18;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block18;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block18;
                    }
                    if (c != '\'') continue block18;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block18;
                }
                case 100: {
                    if (!SyntaxUtilities.regionMatches(false, line, i, "\"\"\"")) continue block18;
                    this.addToken((i += 3) - this.lastOffset, (byte)4);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i;
                    continue block18;
                }
                case 126: {
                    if (!SyntaxUtilities.regionMatches(false, line, i, "'''")) continue block18;
                    this.addToken((i += 3) - this.lastOffset, (byte)4);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i;
                    continue block18;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 100: 
            case 126: {
                this.addToken(length - this.lastOffset, (byte)4);
                break;
            }
            case 0: {
                this.doKeyword(line, length, '\u0000');
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (pyKeywords == null) {
            pyKeywords = new KeywordMap(false);
            pyKeywords.add("and", (byte)7);
            pyKeywords.add("not", (byte)7);
            pyKeywords.add("or", (byte)7);
            pyKeywords.add("if", (byte)6);
            pyKeywords.add("yield", (byte)6);
            pyKeywords.add("for", (byte)6);
            pyKeywords.add("assert", (byte)6);
            pyKeywords.add("break", (byte)6);
            pyKeywords.add("continue", (byte)6);
            pyKeywords.add("elif", (byte)6);
            pyKeywords.add("else", (byte)6);
            pyKeywords.add("except", (byte)6);
            pyKeywords.add("exec", (byte)6);
            pyKeywords.add("finally", (byte)6);
            pyKeywords.add("raise", (byte)6);
            pyKeywords.add("return", (byte)6);
            pyKeywords.add("try", (byte)6);
            pyKeywords.add("while", (byte)6);
            pyKeywords.add("def", (byte)8);
            pyKeywords.add("class", (byte)8);
            pyKeywords.add("lambda", (byte)8);
            pyKeywords.add("del", (byte)7);
            pyKeywords.add("from", (byte)7);
            pyKeywords.add("global", (byte)7);
            pyKeywords.add("import", (byte)7);
            pyKeywords.add("in", (byte)7);
            pyKeywords.add("is", (byte)7);
            pyKeywords.add("pass", (byte)7);
            pyKeywords.add("print", (byte)7);
            pyKeywords.add("self", (byte)4);
            pyKeywords.add("__dict__", (byte)5);
            pyKeywords.add("__methods__", (byte)5);
            pyKeywords.add("__members__", (byte)5);
            pyKeywords.add("__class__", (byte)5);
            pyKeywords.add("__bases__", (byte)5);
            pyKeywords.add("__name__", (byte)5);
            pyKeywords.add("Exception", (byte)8);
            pyKeywords.add("StandardError", (byte)8);
            pyKeywords.add("ArithmeticError", (byte)8);
            pyKeywords.add("LookupError", (byte)8);
            pyKeywords.add("EnvironmentError", (byte)8);
            pyKeywords.add("AssertionError", (byte)8);
            pyKeywords.add("AttributeError", (byte)8);
            pyKeywords.add("EOFError", (byte)8);
            pyKeywords.add("FloatingPointError", (byte)8);
            pyKeywords.add("IOError", (byte)8);
            pyKeywords.add("ImportError", (byte)8);
            pyKeywords.add("IndexError", (byte)8);
            pyKeywords.add("KeyError", (byte)8);
            pyKeywords.add("KeyboardInterrupt", (byte)8);
            pyKeywords.add("MemoryError", (byte)8);
            pyKeywords.add("NameError", (byte)8);
            pyKeywords.add("OSError", (byte)8);
            pyKeywords.add("NotImplementedError", (byte)8);
            pyKeywords.add("OverflowError", (byte)8);
            pyKeywords.add("RuntimeError", (byte)8);
            pyKeywords.add("SyntaxError", (byte)8);
            pyKeywords.add("SystemError", (byte)8);
            pyKeywords.add("SystemExit", (byte)8);
            pyKeywords.add("TypeError", (byte)8);
            pyKeywords.add("ValueError", (byte)8);
            pyKeywords.add("ZeroDivisionError", (byte)8);
            pyKeywords.add("Double_t", (byte)8);
            pyKeywords.add("Float_t", (byte)8);
            pyKeywords.add("Int_t", (byte)8);
            pyKeywords.add("UInt_t", (byte)8);
            pyKeywords.add("Char_t", (byte)8);
            pyKeywords.add("Bool_t", (byte)8);
            pyKeywords.add("Short_t", (byte)8);
            pyKeywords.add("Long64_t", (byte)8);
            pyKeywords.add("ULong64_t", (byte)8);
            pyKeywords.add("Double32_t", (byte)8);
            pyKeywords.add("gROOT", (byte)6);
            pyKeywords.add("gStyle", (byte)6);
            pyKeywords.add("gPad", (byte)6);
            pyKeywords.add("gSystem", (byte)6);
            pyKeywords.add("gRandom", (byte)6);
            pyKeywords.add("gBenchmark", (byte)6);
            pyKeywords.add("gMinuit", (byte)6);
            pyKeywords.add("gEnv", (byte)6);
            pyKeywords.add("gDirectory", (byte)6);
            pyKeywords.add("gFile", (byte)6);
            pyKeywords.add("gHTML", (byte)6);
            PythonRootTokenMarker.ReadRoot();
        }
        return pyKeywords;
    }

    private static void ReadRoot() {
        String thisLine;
        BufferedReader in;
        String sd1 = SetEnv.DirPath + File.separator + "syntax" + File.separator + "root" + File.separator + "classes.d";
        try {
            in = new BufferedReader(new FileReader(sd1));
            while ((thisLine = in.readLine()) != null) {
                if (thisLine.length() <= 1) continue;
                pyKeywords.add(thisLine, (byte)6);
            }
        }
        catch (Exception e) {
            System.out.println("Error in reading : " + sd1);
        }
        sd1 = SetEnv.DirPath + File.separator + "syntax" + File.separator + "root" + File.separator + "methods.d";
        try {
            in = new BufferedReader(new FileReader(sd1));
            while ((thisLine = in.readLine()) != null) {
                if (thisLine.length() <= 1) continue;
                pyKeywords.add(thisLine, (byte)7);
            }
        }
        catch (Exception e) {
            System.out.println("Error in reading: " + sd1);
        }
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
            this.lastWhitespace = i1;
            this.lastKeyword = i1;
            return true;
        }
        this.lastKeyword = i1;
        return false;
    }
}

