/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class ProgressTokenMarker
extends TokenMarker {
    private static KeywordMap progKeywords;
    private boolean cpp;
    private boolean javadoc;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public ProgressTokenMarker() {
        this(true, false, ProgressTokenMarker.getKeywords());
        this.cpp = false;
        this.javadoc = false;
    }

    public ProgressTokenMarker(boolean cpp, boolean javadoc, KeywordMap keywords) {
        this.cpp = cpp;
        this.javadoc = javadoc;
        this.keywords = keywords;
        cpp = false;
        javadoc = false;
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block21: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (!this.cpp) continue block21;
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)7);
                            this.lastOffset = this.lastKeyword = length;
                            break block21;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                backslash = false;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block21;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block21;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (this.javadoc && length - i > 2 && array[i + 2] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    token = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(length - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block21;
                                }
                            }
                            continue block21;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '{' || c == '}' || c == '&' || c == '<' || c == '>' || c == '@' || c == '+' || c == '=' || c == '[' || c == ']' || c == '?' || c == '^' || c == '~') continue block21;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block21;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block21;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block21;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\"') continue block21;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\'') continue block21;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (progKeywords == null) {
            progKeywords = new KeywordMap(true);
            progKeywords.add("comment1", (byte)1);
            progKeywords.add("comment2", (byte)2);
            progKeywords.add("key1", (byte)6);
            progKeywords.add("key2", (byte)7);
            progKeywords.add("key3", (byte)8);
            progKeywords.add("lit1", (byte)3);
            progKeywords.add("lit2", (byte)4);
            progKeywords.add("label", (byte)5);
            progKeywords.add("operator", (byte)9);
            progKeywords.add("invalid", (byte)10);
            progKeywords.add("ABORT", (byte)6);
            progKeywords.add("ABSOLUTE", (byte)6);
            progKeywords.add("ACCELERATOR", (byte)6);
            progKeywords.add("ACCUMULATE", (byte)6);
            progKeywords.add("ACROSS", (byte)6);
            progKeywords.add("ACTIVE-WINDOW", (byte)6);
            progKeywords.add("ADD", (byte)6);
            progKeywords.add("ADD-BUFFER", (byte)6);
            progKeywords.add("ADD-CALC-COLUMN", (byte)6);
            progKeywords.add("ADD-COLUMNS-FROM", (byte)6);
            progKeywords.add("ADD-EVENTS-PROCEDURE", (byte)6);
            progKeywords.add("ADD-FIELDS-FROM", (byte)6);
            progKeywords.add("ADD-FIRST", (byte)6);
            progKeywords.add("ADD-INDEX-FIELD", (byte)6);
            progKeywords.add("ADD-LAST", (byte)6);
            progKeywords.add("ADD-LIKE-COLUMN", (byte)6);
            progKeywords.add("ADD-LIKE-FIELD", (byte)6);
            progKeywords.add("ADD-LIKE-INDEX", (byte)6);
            progKeywords.add("ADD-NEW-FIELD", (byte)6);
            progKeywords.add("ADD-NEW-INDEX", (byte)6);
            progKeywords.add("ADD-SUPER-PROCEDURE", (byte)6);
            progKeywords.add("ADM-DATA", (byte)6);
            progKeywords.add("ADVISE", (byte)6);
            progKeywords.add("ALERT-BOX", (byte)6);
            progKeywords.add("ALIAS", (byte)6);
            progKeywords.add("ALL", (byte)6);
            progKeywords.add("ALLOW-COLUMN-SEARCHING", (byte)6);
            progKeywords.add("ALLOW-REPLICATION", (byte)6);
            progKeywords.add("ALTER", (byte)6);
            progKeywords.add("ALTERNATE-KEY", (byte)6);
            progKeywords.add("ALWAYS-ON-TOP", (byte)6);
            progKeywords.add("AMBIGUOUS", (byte)6);
            progKeywords.add("AND", (byte)6);
            progKeywords.add("ANSI-ONLY", (byte)6);
            progKeywords.add("ANY", (byte)6);
            progKeywords.add("ANY-KEY", (byte)6);
            progKeywords.add("ANY-PRINTABLE", (byte)6);
            progKeywords.add("ANYWHERE", (byte)6);
            progKeywords.add("APPEND", (byte)6);
            progKeywords.add("APPEND-CHILD", (byte)6);
            progKeywords.add("APPEND-LINE", (byte)6);
            progKeywords.add("APPL-ALERT-BOXES", (byte)6);
            progKeywords.add("APPLICATION", (byte)6);
            progKeywords.add("APPLY", (byte)6);
            progKeywords.add("APPSERVER-INFO", (byte)6);
            progKeywords.add("APPSERVER-PASSWORD", (byte)6);
            progKeywords.add("APPSERVER-USERID", (byte)6);
            progKeywords.add("ARRAY-MESSAGE", (byte)6);
            progKeywords.add("AS", (byte)6);
            progKeywords.add("AS-CURSOR", (byte)6);
            progKeywords.add("ASCENDING", (byte)6);
            progKeywords.add("ASK-OVERWRITE", (byte)6);
            progKeywords.add("ASSIGN", (byte)6);
            progKeywords.add("ASYNC-REQUEST-COUNT", (byte)6);
            progKeywords.add("ASYNCHRONOUS", (byte)6);
            progKeywords.add("AT", (byte)6);
            progKeywords.add("ATTACHMENT", (byte)6);
            progKeywords.add("ATTR-SPACE", (byte)6);
            progKeywords.add("ATTRIBUTE-NAMES", (byte)6);
            progKeywords.add("ATTRIBUTE-TYPE", (byte)6);
            progKeywords.add("AUTHORIZATION", (byte)6);
            progKeywords.add("AUTO-COMPLETION", (byte)6);
            progKeywords.add("AUTO-DELETE-XML", (byte)6);
            progKeywords.add("AUTO-END-KEY", (byte)6);
            progKeywords.add("AUTO-ENDKEY", (byte)6);
            progKeywords.add("AUTO-GO", (byte)6);
            progKeywords.add("AUTO-INDENT", (byte)6);
            progKeywords.add("AUTO-RESIZE", (byte)6);
            progKeywords.add("AUTO-RETURN", (byte)6);
            progKeywords.add("AUTO-VALIDATE", (byte)6);
            progKeywords.add("AUTO-ZAP", (byte)6);
            progKeywords.add("AUTOMATIC", (byte)6);
            progKeywords.add("AVAILABLE", (byte)6);
            progKeywords.add("AVAILABLE-FORMATS", (byte)6);
            progKeywords.add("AVERAGE", (byte)6);
            progKeywords.add("AVG", (byte)6);
            progKeywords.add("BACKGROUND", (byte)6);
            progKeywords.add("BACK-TAB", (byte)6);
            progKeywords.add("BACKSPACE", (byte)6);
            progKeywords.add("BACKWARDS", (byte)6);
            progKeywords.add("BASE-KEY", (byte)6);
            progKeywords.add("BATCH-MODE", (byte)6);
            progKeywords.add("BEFORE-HIDE", (byte)6);
            progKeywords.add("BEGINS", (byte)6);
            progKeywords.add("BELL", (byte)6);
            progKeywords.add("BETWEEN", (byte)6);
            progKeywords.add("BGCOLOR", (byte)6);
            progKeywords.add("BIG-ENDIAN", (byte)6);
            progKeywords.add("BINARY", (byte)6);
            progKeywords.add("BIND-WHERE", (byte)6);
            progKeywords.add("BLANK", (byte)6);
            progKeywords.add("BLOCK", (byte)6);
            progKeywords.add("BLOCK-ITERATION-DISPLAY", (byte)6);
            progKeywords.add("BORDER-BOTTOM", (byte)6);
            progKeywords.add("BORDER-BOTTOM-CHARS", (byte)6);
            progKeywords.add("BORDER-BOTTOM-PIXELS", (byte)6);
            progKeywords.add("BORDER-LEFT", (byte)6);
            progKeywords.add("BORDER-LEFT-CHARS", (byte)6);
            progKeywords.add("BORDER-LEFT-PIXELS", (byte)6);
            progKeywords.add("BORDER-RIGHT", (byte)6);
            progKeywords.add("BORDER-RIGHT-CHARS", (byte)6);
            progKeywords.add("BORDER-RIGHT-PIXELS", (byte)6);
            progKeywords.add("BORDER-TOP", (byte)6);
            progKeywords.add("BORDER-TOP-CHARS", (byte)6);
            progKeywords.add("BORDER-TOP-PIXELS", (byte)6);
            progKeywords.add("BOTH", (byte)6);
            progKeywords.add("BOTTOM", (byte)6);
            progKeywords.add("BOTTOM-COLUMN", (byte)6);
            progKeywords.add("BOX", (byte)6);
            progKeywords.add("BOX-SELECTABLE", (byte)6);
            progKeywords.add("BREAK", (byte)6);
            progKeywords.add("BREAK-LINE", (byte)6);
            progKeywords.add("BROWSE", (byte)6);
            progKeywords.add("BROWSE-COLUMN-DATA-TYPES", (byte)6);
            progKeywords.add("BROWSE-COLUMN-FORMATS", (byte)6);
            progKeywords.add("BROWSE-COLUMN-LABELS", (byte)6);
            progKeywords.add("BROWSE-HEADER", (byte)6);
            progKeywords.add("BTOS", (byte)6);
            progKeywords.add("BUFFER", (byte)6);
            progKeywords.add("BUFFER-CHARS", (byte)6);
            progKeywords.add("BUFFER-COMPARE", (byte)6);
            progKeywords.add("BUFFER-COPY", (byte)6);
            progKeywords.add("BUFFER-CREATE", (byte)6);
            progKeywords.add("BUFFER-DELETE", (byte)6);
            progKeywords.add("BUFFER-FIELD", (byte)6);
            progKeywords.add("BUFFER-HANDLE", (byte)6);
            progKeywords.add("BUFFER-LINES", (byte)6);
            progKeywords.add("BUFFER-NAME", (byte)6);
            progKeywords.add("BUFFER-RELEASE", (byte)6);
            progKeywords.add("BUFFER-VALUE", (byte)6);
            progKeywords.add("BUTTONS", (byte)6);
            progKeywords.add("BY", (byte)6);
            progKeywords.add("BY-POINTER", (byte)6);
            progKeywords.add("BY-VARIANT-POINTER", (byte)6);
            progKeywords.add("BYTE", (byte)6);
            progKeywords.add("BYTES-READ", (byte)6);
            progKeywords.add("BYTES-WRITTEN", (byte)6);
            progKeywords.add("CACHE", (byte)6);
            progKeywords.add("CACHE-SIZE", (byte)6);
            progKeywords.add("CALL", (byte)6);
            progKeywords.add("CAN-CREATE", (byte)6);
            progKeywords.add("CAN-DELETE", (byte)6);
            progKeywords.add("CAN-DO", (byte)6);
            progKeywords.add("CAN-FIND", (byte)6);
            progKeywords.add("CAN-QUERY", (byte)6);
            progKeywords.add("CAN-READ", (byte)6);
            progKeywords.add("CAN-SET", (byte)6);
            progKeywords.add("CAN-WRITE", (byte)6);
            progKeywords.add("CANCEL-BREAK", (byte)6);
            progKeywords.add("CANCEL-BUTTON", (byte)6);
            progKeywords.add("CANCEL-PICK", (byte)6);
            progKeywords.add("CANCEL-REQUESTS", (byte)6);
            progKeywords.add("CANCELLED", (byte)6);
            progKeywords.add("CAPS", (byte)6);
            progKeywords.add("CAREFUL-PAINT", (byte)6);
            progKeywords.add("CASE", (byte)6);
            progKeywords.add("CASE-SENSITIVE", (byte)6);
            progKeywords.add("CDECL", (byte)6);
            progKeywords.add("CENTERED", (byte)6);
            progKeywords.add("CHAINED", (byte)6);
            progKeywords.add("CHARACTER", (byte)6);
            progKeywords.add("CHARACTER_LENGTH", (byte)6);
            progKeywords.add("CHARSET", (byte)6);
            progKeywords.add("CHECK", (byte)6);
            progKeywords.add("CHECKED", (byte)6);
            progKeywords.add("CHILD-NUM", (byte)6);
            progKeywords.add("CHOICES", (byte)6);
            progKeywords.add("CHOOSE", (byte)6);
            progKeywords.add("CHR", (byte)6);
            progKeywords.add("CLEAR", (byte)6);
            progKeywords.add("CLEAR-SELECTION", (byte)6);
            progKeywords.add("CLIENT-CONNECTION-ID", (byte)6);
            progKeywords.add("CLIENT-TYPE", (byte)6);
            progKeywords.add("CLIPBOARD", (byte)6);
            progKeywords.add("CLONE-NODE", (byte)6);
            progKeywords.add("CLOSE", (byte)6);
            progKeywords.add("CODE", (byte)6);
            progKeywords.add("CODEBASE-LOCATOR", (byte)6);
            progKeywords.add("CODEPAGE", (byte)6);
            progKeywords.add("CODEPAGE-CONVERT", (byte)6);
            progKeywords.add("COL", (byte)6);
            progKeywords.add("COL-OF", (byte)6);
            progKeywords.add("COLLATE", (byte)6);
            progKeywords.add("COLON", (byte)6);
            progKeywords.add("COLON-ALIGNED", (byte)6);
            progKeywords.add("COLOR", (byte)6);
            progKeywords.add("COLOR-TABLE", (byte)6);
            progKeywords.add("COLUMNS", (byte)6);
            progKeywords.add("COLUMN-BGCOLOR", (byte)6);
            progKeywords.add("COLUMN-DCOLOR", (byte)6);
            progKeywords.add("COLUMN-FGCOLOR", (byte)6);
            progKeywords.add("COLUMN-FONT", (byte)6);
            progKeywords.add("COLUMN-LABEL", (byte)6);
            progKeywords.add("COLUMN-LABEL-BGCOLOR", (byte)6);
            progKeywords.add("COLUMN-LABEL-DCOLOR", (byte)6);
            progKeywords.add("COLUMN-LABEL-FGCOLOR", (byte)6);
            progKeywords.add("COLUMN-LABEL-FONT", (byte)6);
            progKeywords.add("COLUMN-LABEL-HEIGHT-CHARS", (byte)6);
            progKeywords.add("COLUMN-LABEL-HEIGHT-PIXELS", (byte)6);
            progKeywords.add("COLUMN-MOVABLE", (byte)6);
            progKeywords.add("COLUMN-OF", (byte)6);
            progKeywords.add("COLUMN-PFCOLOR", (byte)6);
            progKeywords.add("COLUMN-READ-ONLY", (byte)6);
            progKeywords.add("COLUMN-RESIZABLE", (byte)6);
            progKeywords.add("COLUMN-SCROLLING", (byte)6);
            progKeywords.add("COM-HANDLE", (byte)6);
            progKeywords.add("COM-SELF", (byte)6);
            progKeywords.add("COMBO-BOX", (byte)6);
            progKeywords.add("COMMAND", (byte)6);
            progKeywords.add("COMPARES", (byte)6);
            progKeywords.add("COMPILE", (byte)6);
            progKeywords.add("COMPILER", (byte)6);
            progKeywords.add("COMPLETE", (byte)6);
            progKeywords.add("COMPONENT-HANDLE", (byte)6);
            progKeywords.add("COMPONENT-SELF", (byte)6);
            progKeywords.add("CONFIG-NAME", (byte)6);
            progKeywords.add("CONNECT", (byte)6);
            progKeywords.add("CONNECTED", (byte)6);
            progKeywords.add("CONSTRAINED", (byte)6);
            progKeywords.add("CONTAINER-EVENT", (byte)6);
            progKeywords.add("CONTAINS", (byte)6);
            progKeywords.add("CONTENTS", (byte)6);
            progKeywords.add("CONTEXT", (byte)6);
            progKeywords.add("CONTEXT-HELP", (byte)6);
            progKeywords.add("CONTEXT-HELP-FILE", (byte)6);
            progKeywords.add("CONTEXT-HELP-ID", (byte)6);
            progKeywords.add("CONTEXT-POPUP", (byte)6);
            progKeywords.add("CONTROL", (byte)6);
            progKeywords.add("CONTROL-BOX", (byte)6);
            progKeywords.add("CONTROL-CONTAINER", (byte)6);
            progKeywords.add("CONTROL-FRAME", (byte)6);
            progKeywords.add("CONVERT", (byte)6);
            progKeywords.add("CONVERT-3D-COLORS", (byte)6);
            progKeywords.add("CONVERT-TO-OFFSET", (byte)6);
            progKeywords.add("COPY", (byte)6);
            progKeywords.add("COUNT", (byte)6);
            progKeywords.add("COUNT-OF", (byte)6);
            progKeywords.add("COVERAGE", (byte)6);
            progKeywords.add("CPCASE", (byte)6);
            progKeywords.add("CPCOLL", (byte)6);
            progKeywords.add("CPINTERNAL", (byte)6);
            progKeywords.add("CPLOG", (byte)6);
            progKeywords.add("CPPRINT", (byte)6);
            progKeywords.add("CPRCODEIN", (byte)6);
            progKeywords.add("CPRCODEOUT", (byte)6);
            progKeywords.add("CPSTREAM", (byte)6);
            progKeywords.add("CPTERM", (byte)6);
            progKeywords.add("CRC-VALUE", (byte)6);
            progKeywords.add("CREATE", (byte)6);
            progKeywords.add("CREATE-LIKE", (byte)6);
            progKeywords.add("CREATE-NODE", (byte)6);
            progKeywords.add("CREATE-NODE-NAMESPACE", (byte)6);
            progKeywords.add("CREATE-ON-ADD", (byte)6);
            progKeywords.add("CREATE-RESULT-LIST-ENTRY", (byte)6);
            progKeywords.add("CREATE-TEST-FILE", (byte)6);
            progKeywords.add("CTOS", (byte)6);
            progKeywords.add("CURRENT", (byte)6);
            progKeywords.add("CURRENT-CHANGED", (byte)6);
            progKeywords.add("CURRENT-COLUMN", (byte)6);
            progKeywords.add("CURRENT-ENVIRONMENT", (byte)6);
            progKeywords.add("CURRENT-ITERATION", (byte)6);
            progKeywords.add("CURRENT-LANGUAGE", (byte)6);
            progKeywords.add("CURRENT-RESULT-ROW", (byte)6);
            progKeywords.add("CURRENT-ROW-MODIFIED", (byte)6);
            progKeywords.add("CURRENT-VALUE", (byte)6);
            progKeywords.add("CURRENT-WINDOW", (byte)6);
            progKeywords.add("CURRENT_DATE", (byte)6);
            progKeywords.add("CURSOR", (byte)6);
            progKeywords.add("CURSOR-CHAR", (byte)6);
            progKeywords.add("CURSOR-DOWN", (byte)6);
            progKeywords.add("CURSOR-LEFT", (byte)6);
            progKeywords.add("CURSOR-LINE", (byte)6);
            progKeywords.add("CURSOR-OFFSET", (byte)6);
            progKeywords.add("CURSOR-RIGHT", (byte)6);
            progKeywords.add("CURSOR-UP", (byte)6);
            progKeywords.add("CUT", (byte)6);
            progKeywords.add("DATA-BIND", (byte)6);
            progKeywords.add("DATA-ENTRY-RETURN", (byte)6);
            progKeywords.add("DATA-REFRESH-LINE", (byte)6);
            progKeywords.add("DATA-REFRESH-PAGE", (byte)6);
            progKeywords.add("DATA-TYPE", (byte)6);
            progKeywords.add("DATABASE", (byte)6);
            progKeywords.add("DATASERVERS", (byte)6);
            progKeywords.add("DATE", (byte)6);
            progKeywords.add("DATE-FORMAT", (byte)6);
            progKeywords.add("DAY", (byte)6);
            progKeywords.add("DB-REFERENCES", (byte)6);
            progKeywords.add("DBCODEPAGE", (byte)6);
            progKeywords.add("DBCOLLATION", (byte)6);
            progKeywords.add("DBNAME", (byte)6);
            progKeywords.add("DBPARAM", (byte)6);
            progKeywords.add("DBRESTRICTIONS", (byte)6);
            progKeywords.add("DBTASKID", (byte)6);
            progKeywords.add("DBTYPE", (byte)6);
            progKeywords.add("DBVERSION", (byte)6);
            progKeywords.add("DCOLOR", (byte)6);
            progKeywords.add("DDE", (byte)6);
            progKeywords.add("DDE-ERROR", (byte)6);
            progKeywords.add("DDE-ID", (byte)6);
            progKeywords.add("DDE-ITEM", (byte)6);
            progKeywords.add("DDE-NAME", (byte)6);
            progKeywords.add("DDE-NOTIFY", (byte)6);
            progKeywords.add("DDE-TOPIC", (byte)6);
            progKeywords.add("DEBLANK", (byte)6);
            progKeywords.add("DEBUG", (byte)6);
            progKeywords.add("DEBUG-ALERT", (byte)6);
            progKeywords.add("DEBUG-LIST", (byte)6);
            progKeywords.add("DEBUGGER", (byte)6);
            progKeywords.add("DECIMAL", (byte)6);
            progKeywords.add("DECIMALS", (byte)6);
            progKeywords.add("DECLARE", (byte)6);
            progKeywords.add("DEFINE", (byte)6);
            progKeywords.add("DEFAULT", (byte)6);
            progKeywords.add("DEFAULT-ACTION", (byte)6);
            progKeywords.add("DEFAULT-BUFFER-HANDLE", (byte)6);
            progKeywords.add("DEFAULT-BUTTON", (byte)6);
            progKeywords.add("DEFAULT-COMMIT", (byte)6);
            progKeywords.add("DEFAULT-EXTENSION", (byte)6);
            progKeywords.add("DEFAULT-NOXLATE", (byte)6);
            progKeywords.add("DEFAULT-POP-UP", (byte)6);
            progKeywords.add("DEFAULT-WINDOW", (byte)6);
            progKeywords.add("DEFER-LOB-FETCH", (byte)6);
            progKeywords.add("DEFINED", (byte)6);
            progKeywords.add("DEL", (byte)6);
            progKeywords.add("DELETE", (byte)6);
            progKeywords.add("DELETE-CHAR", (byte)6);
            progKeywords.add("DELETE-CHARACTER", (byte)6);
            progKeywords.add("DELETE-COLUMN", (byte)6);
            progKeywords.add("DELETE-CURRENT-ROW", (byte)6);
            progKeywords.add("DELETE-END-LINE", (byte)6);
            progKeywords.add("DELETE-FIELD", (byte)6);
            progKeywords.add("DELETE-LINE", (byte)6);
            progKeywords.add("DELETE-NODE", (byte)6);
            progKeywords.add("DELETE-RESULT-LIST-ENTRY", (byte)6);
            progKeywords.add("DELETE-SELECTED-ROW", (byte)6);
            progKeywords.add("DELETE-SELECTED-ROWS", (byte)6);
            progKeywords.add("DELETE-WORD", (byte)6);
            progKeywords.add("DELIMITER", (byte)6);
            progKeywords.add("DESCENDING", (byte)6);
            progKeywords.add("DESCRIPTION", (byte)6);
            progKeywords.add("DESELECT", (byte)6);
            progKeywords.add("DESELECT-EXTEND", (byte)6);
            progKeywords.add("DESELECT-FOCUSED-ROW", (byte)6);
            progKeywords.add("DESELECT-ROWS", (byte)6);
            progKeywords.add("DESELECT-SELECTED-ROW", (byte)6);
            progKeywords.add("DESELECTION", (byte)6);
            progKeywords.add("DESELECTION-EXTEND", (byte)6);
            progKeywords.add("DETACH", (byte)6);
            progKeywords.add("DIALOG-BOX", (byte)6);
            progKeywords.add("DIALOG-HELP", (byte)6);
            progKeywords.add("DICTIONARY", (byte)6);
            progKeywords.add("DIR", (byte)6);
            progKeywords.add("DIRECTORY", (byte)6);
            progKeywords.add("DISABLE", (byte)6);
            progKeywords.add("DISABLE-AUTO-ZAP", (byte)6);
            progKeywords.add("DISABLE-CONNECTIONS", (byte)6);
            progKeywords.add("DISABLE-DUMP-TRIGGERS", (byte)6);
            progKeywords.add("DISABLE-LOAD-TRIGGERS", (byte)6);
            progKeywords.add("DISABLED", (byte)6);
            progKeywords.add("DISCONNECT", (byte)6);
            progKeywords.add("DISMISS-MENU", (byte)6);
            progKeywords.add("DISPLAY", (byte)6);
            progKeywords.add("DISPLAY-MESSAGE", (byte)6);
            progKeywords.add("DISPLAY-TYPE", (byte)6);
            progKeywords.add("DISTINCT", (byte)6);
            progKeywords.add("DO", (byte)6);
            progKeywords.add("DOS", (byte)6);
            progKeywords.add("DOS-END", (byte)6);
            progKeywords.add("DOUBLE", (byte)6);
            progKeywords.add("DOWN", (byte)6);
            progKeywords.add("DRAG-ENABLED", (byte)6);
            progKeywords.add("DROP", (byte)6);
            progKeywords.add("DROP-DOWN", (byte)6);
            progKeywords.add("DROP-DOWN-LIST", (byte)6);
            progKeywords.add("DROP-FILE-NOTIFY", (byte)6);
            progKeywords.add("DROP-TARGET", (byte)6);
            progKeywords.add("DUMP", (byte)6);
            progKeywords.add("DYNAMIC", (byte)6);
            progKeywords.add("DYNAMIC-FUNCTION", (byte)6);
            progKeywords.add("EACH", (byte)6);
            progKeywords.add("ECHO", (byte)6);
            progKeywords.add("EDGE", (byte)6);
            progKeywords.add("EDGE-CHARS", (byte)6);
            progKeywords.add("EDGE-PIXELS", (byte)6);
            progKeywords.add("EDIT-CAN-PASTE", (byte)6);
            progKeywords.add("EDIT-CAN-UNDO", (byte)6);
            progKeywords.add("EDIT-CLEAR", (byte)6);
            progKeywords.add("EDIT-COPY", (byte)6);
            progKeywords.add("EDIT-CUT", (byte)6);
            progKeywords.add("EDIT-PASTE", (byte)6);
            progKeywords.add("EDIT-UNDO", (byte)6);
            progKeywords.add("EDITING", (byte)6);
            progKeywords.add("EDITOR", (byte)6);
            progKeywords.add("EDITOR-BACKTAB", (byte)6);
            progKeywords.add("EDITOR-TAB", (byte)6);
            progKeywords.add("ELSE", (byte)6);
            progKeywords.add("EMPTY", (byte)6);
            progKeywords.add("EMPTY-SELECTION", (byte)6);
            progKeywords.add("EMPTY-TEMP-TABLE", (byte)6);
            progKeywords.add("ENABLE", (byte)6);
            progKeywords.add("ENABLE-CONNECTIONS", (byte)6);
            progKeywords.add("ENABLED", (byte)6);
            progKeywords.add("ENCODE", (byte)6);
            progKeywords.add("ENCODING", (byte)6);
            progKeywords.add("END", (byte)6);
            progKeywords.add("END-BOX-SELECTION", (byte)6);
            progKeywords.add("END-ERROR", (byte)6);
            progKeywords.add("END-FILE-DROP", (byte)6);
            progKeywords.add("END-KEY", (byte)6);
            progKeywords.add("END-MOVE", (byte)6);
            progKeywords.add("END-RESIZE", (byte)6);
            progKeywords.add("END-ROW-RESIZE", (byte)6);
            progKeywords.add("END-SEARCH", (byte)6);
            progKeywords.add("END-USER-PROMPT", (byte)6);
            progKeywords.add("ENDKEY", (byte)6);
            progKeywords.add("ENTER-MENUBAR", (byte)6);
            progKeywords.add("ENTERED", (byte)6);
            progKeywords.add("ENTRY", (byte)6);
            progKeywords.add("EQ", (byte)6);
            progKeywords.add("ERROR", (byte)6);
            progKeywords.add("ERROR-COLUMN", (byte)6);
            progKeywords.add("ERROR-ROW", (byte)6);
            progKeywords.add("ERROR-STATUS", (byte)6);
            progKeywords.add("ESCAPE", (byte)6);
            progKeywords.add("ETIME", (byte)6);
            progKeywords.add("EVENT-PROCEDURE", (byte)6);
            progKeywords.add("EVENT-PROCEDURE-CONTEXT", (byte)6);
            progKeywords.add("EVENT-TYPE", (byte)6);
            progKeywords.add("EVENTS", (byte)6);
            progKeywords.add("EXCEPT", (byte)6);
            progKeywords.add("EXCLUSIVE", (byte)6);
            progKeywords.add("EXCLUSIVE-ID", (byte)6);
            progKeywords.add("EXCLUSIVE-LOCK", (byte)6);
            progKeywords.add("EXCLUSIVE-WEB-USER", (byte)6);
            progKeywords.add("EXECUTE", (byte)6);
            progKeywords.add("EXECUTION-LOG", (byte)6);
            progKeywords.add("EXISTS", (byte)6);
            progKeywords.add("EXIT", (byte)6);
            progKeywords.add("EXP", (byte)6);
            progKeywords.add("EXPAND", (byte)6);
            progKeywords.add("EXPANDABLE", (byte)6);
            progKeywords.add("EXPLICIT", (byte)6);
            progKeywords.add("EXPORT", (byte)6);
            progKeywords.add("EXTENDED", (byte)6);
            progKeywords.add("EXTENT", (byte)6);
            progKeywords.add("EXTERNAL", (byte)6);
            progKeywords.add("EXTRACT", (byte)6);
            progKeywords.add("FALSE", (byte)4);
            progKeywords.add("FETCH", (byte)6);
            progKeywords.add("FETCH-SELECTED-ROW", (byte)6);
            progKeywords.add("FGCOLOR", (byte)6);
            progKeywords.add("FIELDS", (byte)6);
            progKeywords.add("FILE", (byte)6);
            progKeywords.add("FILE-ACCESS-DATE", (byte)6);
            progKeywords.add("FILE-ACCESS-TIME", (byte)6);
            progKeywords.add("FILE-CREATE-DATE", (byte)6);
            progKeywords.add("FILE-CREATE-TIME", (byte)6);
            progKeywords.add("FILE-INFORMATION", (byte)6);
            progKeywords.add("FILE-MOD-DATE", (byte)6);
            progKeywords.add("FILE-MOD-TIME", (byte)6);
            progKeywords.add("FILE-NAME", (byte)6);
            progKeywords.add("FILE-OFFSET", (byte)6);
            progKeywords.add("FILE-SIZE", (byte)6);
            progKeywords.add("FILE-TYPE", (byte)6);
            progKeywords.add("FILENAME", (byte)6);
            progKeywords.add("FILL", (byte)6);
            progKeywords.add("FILL-IN", (byte)6);
            progKeywords.add("FILLED", (byte)6);
            progKeywords.add("FILTERS", (byte)6);
            progKeywords.add("FIND", (byte)6);
            progKeywords.add("FIND-BY-ROWID", (byte)6);
            progKeywords.add("FIND-CASE-SENSITIVE", (byte)6);
            progKeywords.add("FIND-GLOBAL", (byte)6);
            progKeywords.add("FIND-NEXT", (byte)6);
            progKeywords.add("FIND-NEXT-OCCURRENCE", (byte)6);
            progKeywords.add("FIND-PREV-OCCURRENCE", (byte)6);
            progKeywords.add("FIND-PREVIOUS", (byte)6);
            progKeywords.add("FIND-SELECT", (byte)6);
            progKeywords.add("FIND-WRAP-AROUND", (byte)6);
            progKeywords.add("FINDER", (byte)6);
            progKeywords.add("FIRST", (byte)6);
            progKeywords.add("FIRST-ASYNC-REQUEST", (byte)6);
            progKeywords.add("FIRST-BUFFER", (byte)6);
            progKeywords.add("FIRST-CHILD", (byte)6);
            progKeywords.add("FIRST-COLUMN", (byte)6);
            progKeywords.add("FIRST-OF", (byte)6);
            progKeywords.add("FIRST-PROCEDURE", (byte)6);
            progKeywords.add("FIRST-SERVER", (byte)6);
            progKeywords.add("FIRST-SERVER-SOCKET", (byte)6);
            progKeywords.add("FIRST-SOCKET", (byte)6);
            progKeywords.add("FIRST-TAB-ITEM", (byte)6);
            progKeywords.add("FIXED-ONLY", (byte)6);
            progKeywords.add("FLAT-BUTTON", (byte)6);
            progKeywords.add("FLOAT", (byte)6);
            progKeywords.add("FOCUS", (byte)6);
            progKeywords.add("FOCUS-IN", (byte)6);
            progKeywords.add("FOCUSED-ROW", (byte)6);
            progKeywords.add("FOCUSED-ROW-SELECTED", (byte)6);
            progKeywords.add("FONT", (byte)6);
            progKeywords.add("FONT-TABLE", (byte)6);
            progKeywords.add("FOR", (byte)6);
            progKeywords.add("FORCE-FILE", (byte)6);
            progKeywords.add("FOREGROUND", (byte)6);
            progKeywords.add("FORMAT", (byte)6);
            progKeywords.add("FORM-INPUT", (byte)6);
            progKeywords.add("FORWARDS", (byte)6);
            progKeywords.add("FRAME", (byte)6);
            progKeywords.add("FRAME-COL", (byte)6);
            progKeywords.add("FRAME-DB", (byte)6);
            progKeywords.add("FRAME-DOWN", (byte)6);
            progKeywords.add("FRAME-FIELD", (byte)6);
            progKeywords.add("FRAME-FILE", (byte)6);
            progKeywords.add("FRAME-INDEX", (byte)6);
            progKeywords.add("FRAME-LINE", (byte)6);
            progKeywords.add("FRAME-NAME", (byte)6);
            progKeywords.add("FRAME-ROW", (byte)6);
            progKeywords.add("FRAME-SPACING", (byte)6);
            progKeywords.add("FRAME-VALUE", (byte)6);
            progKeywords.add("FRAME-X", (byte)6);
            progKeywords.add("FRAME-Y", (byte)6);
            progKeywords.add("FREQUENCY", (byte)6);
            progKeywords.add("FROM", (byte)6);
            progKeywords.add("FROM-CHARS", (byte)6);
            progKeywords.add("FROM-CURRENT", (byte)6);
            progKeywords.add("FROM-PIXELS", (byte)6);
            progKeywords.add("FROMNOREORDER", (byte)6);
            progKeywords.add("FULL-HEIGHT", (byte)6);
            progKeywords.add("FULL-HEIGHT-CHARS", (byte)6);
            progKeywords.add("FULL-HEIGHT-PIXELS", (byte)6);
            progKeywords.add("FULL-PATHNAME", (byte)6);
            progKeywords.add("FULL-WIDTH-CHARS", (byte)6);
            progKeywords.add("FULL-WIDTH-PIXELS", (byte)6);
            progKeywords.add("FUNCTION", (byte)6);
            progKeywords.add("GATEWAYS", (byte)6);
            progKeywords.add("GE", (byte)6);
            progKeywords.add("GENERATE-MD5", (byte)6);
            progKeywords.add("GET", (byte)7);
            progKeywords.add("GET-ATTRIBUTE", (byte)7);
            progKeywords.add("GET-ATTRIBUTE-NODE", (byte)7);
            progKeywords.add("GET-BITS", (byte)7);
            progKeywords.add("GET-BLUE-VALUE", (byte)7);
            progKeywords.add("GET-BROWSE-COLUMN", (byte)7);
            progKeywords.add("GET-BUFFER-HANDLE", (byte)7);
            progKeywords.add("GET-BYTE", (byte)7);
            progKeywords.add("GET-BYTE-ORDER", (byte)7);
            progKeywords.add("GET-BYTES", (byte)7);
            progKeywords.add("GET-BYTES-AVAILABLE", (byte)7);
            progKeywords.add("GET-CGI-LIST", (byte)7);
            progKeywords.add("GET-CGI-VALUE", (byte)7);
            progKeywords.add("GET-CHILD", (byte)7);
            progKeywords.add("GET-CODEPAGES", (byte)7);
            progKeywords.add("GET-COLLATIONS", (byte)7);
            progKeywords.add("GET-CONFIG-VALUE", (byte)7);
            progKeywords.add("GET-CURRENT", (byte)7);
            progKeywords.add("GET-DOCUMENT-ELEMENT", (byte)7);
            progKeywords.add("GET-DOUBLE", (byte)7);
            progKeywords.add("GET-DROPPED-FILE", (byte)7);
            progKeywords.add("GET-DYNAMIC", (byte)7);
            progKeywords.add("GET-FILE", (byte)7);
            progKeywords.add("GET-FIRST", (byte)7);
            progKeywords.add("GET-FLOAT", (byte)7);
            progKeywords.add("GET-GREEN-VALUE", (byte)7);
            progKeywords.add("GET-ITERATION", (byte)7);
            progKeywords.add("GET-KEY-VALUE", (byte)7);
            progKeywords.add("GET-LAST", (byte)7);
            progKeywords.add("GET-LONG", (byte)7);
            progKeywords.add("GET-MESSAGE", (byte)7);
            progKeywords.add("GET-NEXT", (byte)7);
            progKeywords.add("GET-NUMBER", (byte)7);
            progKeywords.add("GET-PARENT", (byte)7);
            progKeywords.add("GET-POINTER-VALUE", (byte)7);
            progKeywords.add("GET-PREV", (byte)7);
            progKeywords.add("GET-PRINTERS", (byte)7);
            progKeywords.add("GET-RED-VALUE", (byte)7);
            progKeywords.add("GET-REPOSITIONED-ROW", (byte)7);
            progKeywords.add("GET-RGB-VALUE", (byte)7);
            progKeywords.add("GET-SELECTED-WIDGET", (byte)7);
            progKeywords.add("GET-SHORT", (byte)7);
            progKeywords.add("GET-SIGNATURE", (byte)7);
            progKeywords.add("GET-SIZE", (byte)7);
            progKeywords.add("GET-SOCKET-OPTION", (byte)7);
            progKeywords.add("GET-STRING", (byte)7);
            progKeywords.add("GET-TAB-ITEM", (byte)7);
            progKeywords.add("GET-TEXT-HEIGHT", (byte)7);
            progKeywords.add("GET-TEXT-HEIGHT-CHARS", (byte)7);
            progKeywords.add("GET-TEXT-HEIGHT-PIXELS", (byte)7);
            progKeywords.add("GET-TEXT-WIDTH", (byte)7);
            progKeywords.add("GET-TEXT-WIDTH-CHARS", (byte)7);
            progKeywords.add("GET-TEXT-WIDTH-PIXELS", (byte)7);
            progKeywords.add("GET-UNSIGNED-SHORT", (byte)7);
            progKeywords.add("GET-WAIT-STATE", (byte)7);
            progKeywords.add("GETBYTE", (byte)7);
            progKeywords.add("GLOBAL", (byte)6);
            progKeywords.add("GO", (byte)6);
            progKeywords.add("GO-ON", (byte)6);
            progKeywords.add("GO-PENDING", (byte)6);
            progKeywords.add("GOTO", (byte)6);
            progKeywords.add("GRANT", (byte)6);
            progKeywords.add("GRAPHIC-EDGE", (byte)6);
            progKeywords.add("GRAYED", (byte)6);
            progKeywords.add("GRID-FACTOR-HORIZONTAL", (byte)6);
            progKeywords.add("GRID-FACTOR-VERTICAL", (byte)6);
            progKeywords.add("GRID-SET", (byte)6);
            progKeywords.add("GRID-SNAP", (byte)6);
            progKeywords.add("GRID-UNIT-HEIGHT", (byte)6);
            progKeywords.add("GRID-UNIT-HEIGHT-CHARS", (byte)6);
            progKeywords.add("GRID-UNIT-HEIGHT-PIXELS", (byte)6);
            progKeywords.add("GRID-UNIT-WIDTH", (byte)6);
            progKeywords.add("GRID-UNIT-WIDTH-CHARS", (byte)6);
            progKeywords.add("GRID-UNIT-WIDTH-PIXELS", (byte)6);
            progKeywords.add("GRID-VISIBLE", (byte)6);
            progKeywords.add("GROUP", (byte)6);
            progKeywords.add("GT", (byte)6);
            progKeywords.add("HANDLE", (byte)6);
            progKeywords.add("HAS-RECORDS", (byte)6);
            progKeywords.add("HAVING", (byte)6);
            progKeywords.add("HEADER", (byte)6);
            progKeywords.add("HEIGHT", (byte)6);
            progKeywords.add("HEIGHT-CHARS", (byte)6);
            progKeywords.add("HEIGHT-PIXELS", (byte)6);
            progKeywords.add("HELP", (byte)6);
            progKeywords.add("HELP-CONTEXT", (byte)6);
            progKeywords.add("HELP-TOPIC", (byte)6);
            progKeywords.add("HELPFILE-NAME", (byte)6);
            progKeywords.add("HIDDEN", (byte)6);
            progKeywords.add("HIDE", (byte)6);
            progKeywords.add("HINT", (byte)6);
            progKeywords.add("HOME", (byte)6);
            progKeywords.add("HORIZONTAL", (byte)6);
            progKeywords.add("HORIZ-END", (byte)6);
            progKeywords.add("HORIZ-HOME", (byte)6);
            progKeywords.add("HORIZ-SCROLL-DRAG", (byte)6);
            progKeywords.add("HOST-BYTE-ORDER", (byte)6);
            progKeywords.add("HTML-END-OF-LINE", (byte)6);
            progKeywords.add("HTML-END-OF-PAGE", (byte)6);
            progKeywords.add("HTML-FRAME-BEGIN", (byte)6);
            progKeywords.add("HTML-FRAME-END", (byte)6);
            progKeywords.add("HTML-HEADER-BEGIN", (byte)6);
            progKeywords.add("HTML-HEADER-END", (byte)6);
            progKeywords.add("HTML-TITLE-BEGIN", (byte)6);
            progKeywords.add("HTML-TITLE-END", (byte)6);
            progKeywords.add("HWND", (byte)6);
            progKeywords.add("ICFPARAMETER", (byte)6);
            progKeywords.add("ICON", (byte)6);
            progKeywords.add("IF", (byte)6);
            progKeywords.add("IMAGE", (byte)6);
            progKeywords.add("IMAGE-DOWN", (byte)6);
            progKeywords.add("IMAGE-INSENSITIVE", (byte)6);
            progKeywords.add("IMAGE-SIZE", (byte)6);
            progKeywords.add("IMAGE-SIZE-CHARS", (byte)6);
            progKeywords.add("IMAGE-SIZE-PIXELS", (byte)6);
            progKeywords.add("IMAGE-UP", (byte)6);
            progKeywords.add("IMMEDIATE-DISPLAY", (byte)6);
            progKeywords.add("IMPORT", (byte)6);
            progKeywords.add("IMPORT-NODE", (byte)6);
            progKeywords.add("IN", (byte)6);
            progKeywords.add("INCREMENT-EXCLUSIVE-ID", (byte)6);
            progKeywords.add("INDEX", (byte)6);
            progKeywords.add("INDEX-HINT", (byte)6);
            progKeywords.add("INDEX-INFORMATION", (byte)6);
            progKeywords.add("INDEXED-REPOSITION", (byte)6);
            progKeywords.add("INDICATOR", (byte)6);
            progKeywords.add("INFORMATION", (byte)6);
            progKeywords.add("INIT", (byte)6);
            progKeywords.add("INITIAL", (byte)6);
            progKeywords.add("INITIAL-DIR", (byte)6);
            progKeywords.add("INITIAL-FILTER", (byte)6);
            progKeywords.add("INITIALIZE-DOCUMENT-TYPE", (byte)6);
            progKeywords.add("INITIATE", (byte)6);
            progKeywords.add("INNER", (byte)6);
            progKeywords.add("INNER-CHARS", (byte)6);
            progKeywords.add("INNER-LINES", (byte)6);
            progKeywords.add("INPUT", (byte)6);
            progKeywords.add("INPUT-OUTPUT", (byte)6);
            progKeywords.add("INPUT-VALUE", (byte)6);
            progKeywords.add("INSERT", (byte)6);
            progKeywords.add("INSERT-BACKTAB", (byte)6);
            progKeywords.add("INSERT-BEFORE", (byte)6);
            progKeywords.add("INSERT-COLUMN", (byte)6);
            progKeywords.add("INSERT-FIELD", (byte)6);
            progKeywords.add("INSERT-FIELD-DATA", (byte)6);
            progKeywords.add("INSERT-FIELD-LABEL", (byte)6);
            progKeywords.add("INSERT-FILE", (byte)6);
            progKeywords.add("INSERT-MODE", (byte)6);
            progKeywords.add("INSERT-ROW", (byte)6);
            progKeywords.add("INSERT-STRING", (byte)6);
            progKeywords.add("INSERT-TAB", (byte)6);
            progKeywords.add("INTEGER", (byte)6);
            progKeywords.add("INTERNAL-ENTRIES", (byte)6);
            progKeywords.add("INTO", (byte)6);
            progKeywords.add("IS", (byte)6);
            progKeywords.add("IS-ATTR-SPACE", (byte)6);
            progKeywords.add("IS-LEAD-BYTE", (byte)6);
            progKeywords.add("IS-OPEN", (byte)6);
            progKeywords.add("IS-ROW-SELECTED", (byte)6);
            progKeywords.add("IS-SELECTED", (byte)6);
            progKeywords.add("IS-XML", (byte)6);
            progKeywords.add("ITEM", (byte)6);
            progKeywords.add("ITEMS-PER-ROW", (byte)6);
            progKeywords.add("ITERATION-CHANGED", (byte)6);
            progKeywords.add("JOIN", (byte)6);
            progKeywords.add("JOIN-BY-SQLDB", (byte)6);
            progKeywords.add("KBLABEL", (byte)6);
            progKeywords.add("KEEP-CONNECTION-OPEN", (byte)6);
            progKeywords.add("KEEP-FRAME-Z-ORDER", (byte)6);
            progKeywords.add("KEEP-MESSAGES", (byte)6);
            progKeywords.add("KEEP-SECURITY-CACHE", (byte)6);
            progKeywords.add("KEEP-TAB-ORDER", (byte)6);
            progKeywords.add("KEY", (byte)6);
            progKeywords.add("KEY-CODE", (byte)6);
            progKeywords.add("KEY-FUNCTION", (byte)6);
            progKeywords.add("KEY-LABEL", (byte)6);
            progKeywords.add("KEYCODE", (byte)6);
            progKeywords.add("KEYFUNCTION", (byte)6);
            progKeywords.add("KEYLABEL", (byte)6);
            progKeywords.add("KEYS", (byte)6);
            progKeywords.add("KEYWORD", (byte)6);
            progKeywords.add("KEYWORD-ALL", (byte)6);
            progKeywords.add("LABEL", (byte)6);
            progKeywords.add("LABEL-BGCOLOR", (byte)6);
            progKeywords.add("LABEL-DCOLOR", (byte)6);
            progKeywords.add("LABEL-FGCOLOR", (byte)6);
            progKeywords.add("LABEL-FONT", (byte)6);
            progKeywords.add("LABEL-PFCOLOR", (byte)6);
            progKeywords.add("LABELS", (byte)6);
            progKeywords.add("LANDSCAPE", (byte)6);
            progKeywords.add("LANGUAGES", (byte)6);
            progKeywords.add("LARGE", (byte)6);
            progKeywords.add("LARGE-TO-SMALL", (byte)6);
            progKeywords.add("LAST", (byte)6);
            progKeywords.add("LAST-ASYNC-REQUEST", (byte)6);
            progKeywords.add("LAST-CHILD", (byte)6);
            progKeywords.add("LAST-EVENT", (byte)6);
            progKeywords.add("LAST-KEY", (byte)6);
            progKeywords.add("LAST-OF", (byte)6);
            progKeywords.add("LAST-PROCEDURE", (byte)6);
            progKeywords.add("LAST-SERVER", (byte)6);
            progKeywords.add("LAST-SERVER-SOCKET", (byte)6);
            progKeywords.add("LAST-SOCKET", (byte)6);
            progKeywords.add("LAST-TAB-ITEM", (byte)6);
            progKeywords.add("LASTKEY", (byte)6);
            progKeywords.add("LC", (byte)6);
            progKeywords.add("LDBNAME", (byte)6);
            progKeywords.add("LE", (byte)6);
            progKeywords.add("LEADING", (byte)6);
            progKeywords.add("LEAVE", (byte)6);
            progKeywords.add("LEFT", (byte)6);
            progKeywords.add("LEFT-ALIGNED", (byte)6);
            progKeywords.add("LEFT-END", (byte)6);
            progKeywords.add("LEFT-TRIM", (byte)6);
            progKeywords.add("LENGTH", (byte)6);
            progKeywords.add("LIBRARY", (byte)6);
            progKeywords.add("LIKE", (byte)6);
            progKeywords.add("LINE", (byte)6);
            progKeywords.add("LINE-COUNTER", (byte)6);
            progKeywords.add("LINE-DOWN", (byte)6);
            progKeywords.add("LINE-LEFT", (byte)6);
            progKeywords.add("LINE-RIGHT", (byte)6);
            progKeywords.add("LINE-UP", (byte)6);
            progKeywords.add("LIST-EVENTS", (byte)6);
            progKeywords.add("LIST-ITEM-PAIRS", (byte)6);
            progKeywords.add("LIST-ITEMS", (byte)6);
            progKeywords.add("LIST-QUERY-ATTRS", (byte)6);
            progKeywords.add("LIST-SET-ATTRS", (byte)6);
            progKeywords.add("LIST-WIDGETS", (byte)6);
            progKeywords.add("LISTING", (byte)6);
            progKeywords.add("LISTINGS", (byte)6);
            progKeywords.add("LITTLE-ENDIAN", (byte)6);
            progKeywords.add("LOAD", (byte)6);
            progKeywords.add("LOAD-FROM", (byte)6);
            progKeywords.add("LOAD-ICON", (byte)6);
            progKeywords.add("LOAD-IMAGE", (byte)6);
            progKeywords.add("LOAD-IMAGE-DOWN", (byte)6);
            progKeywords.add("LOAD-IMAGE-INSENSITIVE", (byte)6);
            progKeywords.add("LOAD-IMAGE-UP", (byte)6);
            progKeywords.add("LOAD-MOUSE-POINTER", (byte)6);
            progKeywords.add("LOAD-PICTURE", (byte)6);
            progKeywords.add("LOAD-SMALL-ICON", (byte)6);
            progKeywords.add("LOCAL-HOST", (byte)6);
            progKeywords.add("LOCAL-NAME", (byte)6);
            progKeywords.add("LOCAL-PORT", (byte)6);
            progKeywords.add("LOCATOR-TYPE", (byte)6);
            progKeywords.add("LOCKED", (byte)6);
            progKeywords.add("LOG", (byte)6);
            progKeywords.add("LOG-ID", (byte)6);
            progKeywords.add("LOGICAL", (byte)6);
            progKeywords.add("LONG", (byte)6);
            progKeywords.add("LOOKAHEAD", (byte)6);
            progKeywords.add("LOOKUP", (byte)6);
            progKeywords.add("LOWER", (byte)6);
            progKeywords.add("LT", (byte)6);
            progKeywords.add("MACHINE-CLASS", (byte)6);
            progKeywords.add("MAIN-MENU", (byte)6);
            progKeywords.add("MANDATORY", (byte)6);
            progKeywords.add("MANUAL-HIGHLIGHT", (byte)6);
            progKeywords.add("MAP", (byte)6);
            progKeywords.add("MARGIN-EXTRA", (byte)6);
            progKeywords.add("MARGIN-HEIGHT", (byte)6);
            progKeywords.add("MARGIN-HEIGHT-CHARS", (byte)6);
            progKeywords.add("MARGIN-HEIGHT-PIXELS", (byte)6);
            progKeywords.add("MARGIN-WIDTH", (byte)6);
            progKeywords.add("MARGIN-WIDTH-CHARS", (byte)6);
            progKeywords.add("MARGIN-WIDTH-PIXELS", (byte)6);
            progKeywords.add("MATCHES", (byte)6);
            progKeywords.add("MAX", (byte)6);
            progKeywords.add("MAX-BUTTON", (byte)6);
            progKeywords.add("MAX-CHARS", (byte)6);
            progKeywords.add("MAX-DATA-GUESS", (byte)6);
            progKeywords.add("MAX-HEIGHT", (byte)6);
            progKeywords.add("MAX-HEIGHT-CHARS", (byte)6);
            progKeywords.add("MAX-HEIGHT-PIXELS", (byte)6);
            progKeywords.add("MAX-ROWS", (byte)6);
            progKeywords.add("MAX-SIZE", (byte)6);
            progKeywords.add("MAX-VALUE", (byte)6);
            progKeywords.add("MAX-WIDTH", (byte)6);
            progKeywords.add("MAX-WIDTH-CHARS", (byte)6);
            progKeywords.add("MAX-WIDTH-PIXELS", (byte)6);
            progKeywords.add("MAXIMIZE", (byte)6);
            progKeywords.add("MAXIMUM", (byte)6);
            progKeywords.add("MEMBER", (byte)6);
            progKeywords.add("MEMPTR", (byte)6);
            progKeywords.add("MENU", (byte)6);
            progKeywords.add("MENU-BAR", (byte)6);
            progKeywords.add("MENU-DROP", (byte)6);
            progKeywords.add("MENU-ITEM", (byte)6);
            progKeywords.add("MENU-KEY", (byte)6);
            progKeywords.add("MENU-MOUSE", (byte)6);
            progKeywords.add("MENUBAR", (byte)6);
            progKeywords.add("MESSAGE", (byte)6);
            progKeywords.add("MESSAGE-AREA", (byte)6);
            progKeywords.add("MESSAGE-AREA-FONT", (byte)6);
            progKeywords.add("MESSAGE-LINE", (byte)6);
            progKeywords.add("MESSAGE-LINES", (byte)6);
            progKeywords.add("MINIMUM", (byte)6);
            progKeywords.add("MIN-BUTTON", (byte)6);
            progKeywords.add("MIN-HEIGHT", (byte)6);
            progKeywords.add("MIN-HEIGHT-CHARS", (byte)6);
            progKeywords.add("MIN-HEIGHT-PIXELS", (byte)6);
            progKeywords.add("MIN-ROW-HEIGHT", (byte)6);
            progKeywords.add("MIN-ROW-HEIGHT-CHARS", (byte)6);
            progKeywords.add("MIN-ROW-HEIGHT-PIXELS", (byte)6);
            progKeywords.add("MIN-SIZE", (byte)6);
            progKeywords.add("MIN-VALUE", (byte)6);
            progKeywords.add("MIN-WIDTH", (byte)6);
            progKeywords.add("MIN-WIDTH-CHARS", (byte)6);
            progKeywords.add("MIN-WIDTH-PIXELS", (byte)6);
            progKeywords.add("MOD", (byte)6);
            progKeywords.add("MODIFIED", (byte)6);
            progKeywords.add("MODULO", (byte)6);
            progKeywords.add("MONTH", (byte)6);
            progKeywords.add("MOUSE", (byte)6);
            progKeywords.add("MOUSE-POINTER", (byte)6);
            progKeywords.add("MOVABLE", (byte)6);
            progKeywords.add("MOVE", (byte)6);
            progKeywords.add("MOVE-AFTER-TAB-ITEM", (byte)6);
            progKeywords.add("MOVE-BEFORE-TAB-ITEM", (byte)6);
            progKeywords.add("MOVE-COLUMN", (byte)6);
            progKeywords.add("MOVE-TO-BOTTOM", (byte)6);
            progKeywords.add("MOVE-TO-EOF", (byte)6);
            progKeywords.add("MOVE-TO-TOP", (byte)6);
            progKeywords.add("MPE", (byte)6);
            progKeywords.add("MULTIPLE", (byte)6);
            progKeywords.add("MULTIPLE-KEY", (byte)6);
            progKeywords.add("MULTITASKING-INTERVAL", (byte)6);
            progKeywords.add("MUST-EXIST", (byte)6);
            progKeywords.add("mysearchablewidget", (byte)6);
            progKeywords.add("NAME", (byte)6);
            progKeywords.add("NAMESPACE-PREFIX", (byte)6);
            progKeywords.add("NAMESPACE-URI", (byte)6);
            progKeywords.add("NATIVE", (byte)6);
            progKeywords.add("NE", (byte)6);
            progKeywords.add("NEEDS-APPSERVER-PROMPT", (byte)6);
            progKeywords.add("NEEDS-PROMPT", (byte)6);
            progKeywords.add("NEW", (byte)6);
            progKeywords.add("NEW-LINE", (byte)6);
            progKeywords.add("NEW-ROW", (byte)6);
            progKeywords.add("NEXT", (byte)6);
            progKeywords.add("NEXT-COLUMN", (byte)6);
            progKeywords.add("NEXT-ERROR", (byte)6);
            progKeywords.add("NEXT-FRAME", (byte)6);
            progKeywords.add("NEXT-PROMPT", (byte)6);
            progKeywords.add("NEXT-SIBLING", (byte)6);
            progKeywords.add("NEXT-TAB-ITEM", (byte)6);
            progKeywords.add("NEXT-VALUE", (byte)6);
            progKeywords.add("NEXT-WORD", (byte)6);
            progKeywords.add("NO", (byte)6);
            progKeywords.add("NO-APPLY", (byte)6);
            progKeywords.add("NO-ARRAY-MESSAGE", (byte)6);
            progKeywords.add("NO-ASSIGN", (byte)6);
            progKeywords.add("NO-ATTR", (byte)6);
            progKeywords.add("NO-ATTR-LIST", (byte)6);
            progKeywords.add("NO-ATTR-SPACE", (byte)6);
            progKeywords.add("NO-AUTO-VALIDATE", (byte)6);
            progKeywords.add("NO-BIND-WHERE", (byte)6);
            progKeywords.add("NO-BOX", (byte)6);
            progKeywords.add("NO-COLUMN-SCROLLING", (byte)6);
            progKeywords.add("NO-CONSOLE", (byte)6);
            progKeywords.add("NO-CONVERT", (byte)6);
            progKeywords.add("NO-CONVERT-3D-COLORS", (byte)6);
            progKeywords.add("NO-CURRENT-VALUE", (byte)6);
            progKeywords.add("NO-DEBUG", (byte)6);
            progKeywords.add("NO-DRAG", (byte)6);
            progKeywords.add("NO-ECHO", (byte)6);
            progKeywords.add("NO-ERROR", (byte)6);
            progKeywords.add("NO-FILL", (byte)6);
            progKeywords.add("NO-FOCUS", (byte)6);
            progKeywords.add("NO-HELP", (byte)6);
            progKeywords.add("NO-HIDE", (byte)6);
            progKeywords.add("NO-INDEX-HINT", (byte)6);
            progKeywords.add("NO-JOIN-BY-SQLDB", (byte)6);
            progKeywords.add("NO-LABELS", (byte)6);
            progKeywords.add("NO-LOCK", (byte)6);
            progKeywords.add("NO-LOOKAHEAD", (byte)6);
            progKeywords.add("NO-MAP", (byte)6);
            progKeywords.add("NO-MESSAGE", (byte)6);
            progKeywords.add("NO-PAUSE", (byte)6);
            progKeywords.add("NO-PREFETCH", (byte)6);
            progKeywords.add("NO-RETURN-VALUE", (byte)6);
            progKeywords.add("NO-ROW-MARKERS", (byte)6);
            progKeywords.add("NO-SCROLLBAR-VERTICAL", (byte)6);
            progKeywords.add("NO-SCROLLING", (byte)6);
            progKeywords.add("NO-SEPARATE-CONNECTION", (byte)6);
            progKeywords.add("NO-SEPARATORS", (byte)6);
            progKeywords.add("NO-TAB-STOP", (byte)6);
            progKeywords.add("NO-UNDERLINE", (byte)6);
            progKeywords.add("NO-UNDO", (byte)6);
            progKeywords.add("NO-VALIDATE", (byte)6);
            progKeywords.add("NO-WAIT", (byte)6);
            progKeywords.add("NO-WORD-WRAP", (byte)6);
            progKeywords.add("NODE-TYPE", (byte)6);
            progKeywords.add("NODE-VALUE", (byte)6);
            progKeywords.add("NONE", (byte)6);
            progKeywords.add("NORMALIZE", (byte)6);
            progKeywords.add("NOT", (byte)6);
            progKeywords.add("NULL", (byte)6);
            progKeywords.add("NUM-ALIASES", (byte)6);
            progKeywords.add("NUM-BUFFERS", (byte)6);
            progKeywords.add("NUM-BUTTONS", (byte)6);
            progKeywords.add("NUM-CHILDREN", (byte)6);
            progKeywords.add("NUM-COLUMNS", (byte)6);
            progKeywords.add("NUM-COPIES", (byte)6);
            progKeywords.add("NUM-DBS", (byte)6);
            progKeywords.add("NUM-DROPPED-FILES", (byte)6);
            progKeywords.add("NUM-ENTRIES", (byte)6);
            progKeywords.add("NUM-FIELDS", (byte)6);
            progKeywords.add("NUM-FORMATS", (byte)6);
            progKeywords.add("NUM-ITEMS", (byte)6);
            progKeywords.add("NUM-ITERATIONS", (byte)6);
            progKeywords.add("NUM-LINES", (byte)6);
            progKeywords.add("NUM-LOCKED-COLUMNS", (byte)6);
            progKeywords.add("NUM-MESSAGES", (byte)6);
            progKeywords.add("NUM-REPLACED", (byte)6);
            progKeywords.add("NUM-RESULTS", (byte)6);
            progKeywords.add("NUM-SELECTED", (byte)6);
            progKeywords.add("NUM-SELECTED-ROWS", (byte)6);
            progKeywords.add("NUM-SELECTED-WIDGETS", (byte)6);
            progKeywords.add("NUM-TABS", (byte)6);
            progKeywords.add("NUM-TO-RETAIN", (byte)6);
            progKeywords.add("NUM-VISIBLE-COLUMNS", (byte)6);
            progKeywords.add("NUMERIC", (byte)6);
            progKeywords.add("NUMERIC-DECIMAL-POINT", (byte)6);
            progKeywords.add("NUMERIC-FORMAT", (byte)6);
            progKeywords.add("NUMERIC-SEPARATOR", (byte)6);
            progKeywords.add("OBJECT", (byte)6);
            progKeywords.add("OCTET_LENGTH", (byte)6);
            progKeywords.add("OF", (byte)6);
            progKeywords.add("OFF", (byte)6);
            progKeywords.add("OFF-END", (byte)6);
            progKeywords.add("OFF-HOME", (byte)6);
            progKeywords.add("OK", (byte)6);
            progKeywords.add("OK-CANCEL", (byte)6);
            progKeywords.add("OLD", (byte)6);
            progKeywords.add("OLE-INVOKE-LOCALE", (byte)6);
            progKeywords.add("OLE-NAMES-LOCALE", (byte)6);
            progKeywords.add("ON", (byte)6);
            progKeywords.add("ON-FRAME-BORDER", (byte)6);
            progKeywords.add("OPEN", (byte)6);
            progKeywords.add("OPEN-LINE-ABOVE", (byte)6);
            progKeywords.add("OPSYS", (byte)6);
            progKeywords.add("OPTION", (byte)6);
            progKeywords.add("OPTIONS", (byte)6);
            progKeywords.add("OR", (byte)6);
            progKeywords.add("ORDERED-JOIN", (byte)6);
            progKeywords.add("ORDINAL", (byte)6);
            progKeywords.add("ORIENTATION", (byte)6);
            progKeywords.add("OS-APPEND", (byte)6);
            progKeywords.add("OS-COMMAND", (byte)6);
            progKeywords.add("OS-COPY", (byte)6);
            progKeywords.add("OS-CREATE-DIR", (byte)6);
            progKeywords.add("OS-DELETE", (byte)6);
            progKeywords.add("OS-DIR", (byte)6);
            progKeywords.add("OS-DRIVES", (byte)6);
            progKeywords.add("OS-ERROR", (byte)6);
            progKeywords.add("OS-GETENV", (byte)6);
            progKeywords.add("OS-RENAME", (byte)6);
            progKeywords.add("OS2", (byte)6);
            progKeywords.add("OS400", (byte)6);
            progKeywords.add("OTHERWISE", (byte)6);
            progKeywords.add("OUT-OF-DATA", (byte)6);
            progKeywords.add("OUTER", (byte)6);
            progKeywords.add("OUTER-JOIN", (byte)6);
            progKeywords.add("OUTPUT", (byte)6);
            progKeywords.add("OVERLAY", (byte)6);
            progKeywords.add("OVERRIDE", (byte)6);
            progKeywords.add("OWNER", (byte)6);
            progKeywords.add("OWNER-DOCUMENT", (byte)6);
            progKeywords.add("PAGE", (byte)6);
            progKeywords.add("PAGE-BOTTOM", (byte)6);
            progKeywords.add("PAGE-DOWN", (byte)6);
            progKeywords.add("PAGE-LEFT", (byte)6);
            progKeywords.add("PAGE-NUMBER", (byte)6);
            progKeywords.add("PAGE-RIGHT", (byte)6);
            progKeywords.add("PAGE-RIGHT-TEXT", (byte)6);
            progKeywords.add("PAGE-SIZE", (byte)6);
            progKeywords.add("PAGE-TOP", (byte)6);
            progKeywords.add("PAGE-UP", (byte)6);
            progKeywords.add("PAGE-WIDTH", (byte)6);
            progKeywords.add("PAGED", (byte)6);
            progKeywords.add("PARAMETER", (byte)6);
            progKeywords.add("PARENT", (byte)6);
            progKeywords.add("PARENT-WINDOW-CLOSE", (byte)6);
            progKeywords.add("PARTIAL-KEY", (byte)6);
            progKeywords.add("PASCAL", (byte)6);
            progKeywords.add("PASTE", (byte)6);
            progKeywords.add("PATHNAME", (byte)6);
            progKeywords.add("PAUSE", (byte)6);
            progKeywords.add("PDBNAME", (byte)6);
            progKeywords.add("PERFORMANCE", (byte)6);
            progKeywords.add("PERSISTENT", (byte)6);
            progKeywords.add("PERSISTENT-CACHE-DISABLED", (byte)6);
            progKeywords.add("PERSISTENT-PROCEDURE", (byte)6);
            progKeywords.add("PFCOLOR", (byte)6);
            progKeywords.add("PICK", (byte)6);
            progKeywords.add("PICK-AREA", (byte)6);
            progKeywords.add("PICK-BOTH", (byte)6);
            progKeywords.add("PIXELS", (byte)6);
            progKeywords.add("PIXELS-PER-COLUMN", (byte)6);
            progKeywords.add("PIXELS-PER-ROW", (byte)6);
            progKeywords.add("POPUP-MENU", (byte)6);
            progKeywords.add("POPUP-ONLY", (byte)6);
            progKeywords.add("PORTRAIT", (byte)6);
            progKeywords.add("POSITION", (byte)6);
            progKeywords.add("PRECISION", (byte)6);
            progKeywords.add("PREPARE-STRING", (byte)6);
            progKeywords.add("PREPARED", (byte)6);
            progKeywords.add("PREPROCESS", (byte)6);
            progKeywords.add("PRESELECT", (byte)6);
            progKeywords.add("PREV", (byte)6);
            progKeywords.add("PREV-COLUMN", (byte)6);
            progKeywords.add("PREV-FRAME", (byte)6);
            progKeywords.add("PREV-SIBLING", (byte)6);
            progKeywords.add("PREV-TAB-ITEM", (byte)6);
            progKeywords.add("PREV-WORD", (byte)6);
            progKeywords.add("PRIMARY", (byte)6);
            progKeywords.add("PRINTER", (byte)6);
            progKeywords.add("PRINTER-CONTROL-HANDLE", (byte)6);
            progKeywords.add("PRINTER-HDC", (byte)6);
            progKeywords.add("PRINTER-NAME", (byte)6);
            progKeywords.add("PRINTER-PORT", (byte)6);
            progKeywords.add("PRINTER-SETUP", (byte)6);
            progKeywords.add("PRIVATE", (byte)6);
            progKeywords.add("PRIVATE-DATA", (byte)6);
            progKeywords.add("PRIVILEGES", (byte)6);
            progKeywords.add("PROC-HANDLE", (byte)6);
            progKeywords.add("PROC-STATUS", (byte)6);
            progKeywords.add("PROCEDURE", (byte)6);
            progKeywords.add("PROCEDURE-COMPLETE", (byte)6);
            progKeywords.add("PROCEDURE-NAME", (byte)6);
            progKeywords.add("PROCESS", (byte)6);
            progKeywords.add("PROFILE-FILE", (byte)6);
            progKeywords.add("PROFILER", (byte)6);
            progKeywords.add("PROFILING", (byte)6);
            progKeywords.add("PROGRAM-NAME", (byte)6);
            progKeywords.add("PROGRESS", (byte)6);
            progKeywords.add("PROGRESS-SOURCE", (byte)6);
            progKeywords.add("PROMPT", (byte)6);
            progKeywords.add("PROMPT-FOR", (byte)6);
            progKeywords.add("PROMSGS", (byte)6);
            progKeywords.add("PROPATH", (byte)6);
            progKeywords.add("PROVERSION", (byte)6);
            progKeywords.add("PROXY", (byte)6);
            progKeywords.add("PUBLIC-ID", (byte)6);
            progKeywords.add("PUBLISH", (byte)6);
            progKeywords.add("PUBLISHED-EVENTS", (byte)6);
            progKeywords.add("PUT", (byte)6);
            progKeywords.add("PUT-BITS", (byte)6);
            progKeywords.add("PUT-BYTE", (byte)6);
            progKeywords.add("PUT-BYTES", (byte)6);
            progKeywords.add("PUT-DOUBLE", (byte)6);
            progKeywords.add("PUT-FLOAT", (byte)6);
            progKeywords.add("PUT-KEY-VALUE", (byte)6);
            progKeywords.add("PUT-LONG", (byte)6);
            progKeywords.add("PUT-SHORT", (byte)6);
            progKeywords.add("PUT-STRING", (byte)6);
            progKeywords.add("PUT-UNSIGNED-SHORT", (byte)6);
            progKeywords.add("PUTBYTE", (byte)6);
            progKeywords.add("QUERY", (byte)6);
            progKeywords.add("QUERY-CLOSE", (byte)6);
            progKeywords.add("QUERY-OFF-END", (byte)6);
            progKeywords.add("QUERY-OPEN", (byte)6);
            progKeywords.add("QUERY-PREPARE", (byte)6);
            progKeywords.add("QUERY-TUNING", (byte)6);
            progKeywords.add("QUESTION", (byte)6);
            progKeywords.add("QUIT", (byte)6);
            progKeywords.add("R-INDEX", (byte)6);
            progKeywords.add("RADIO-BUTTONS", (byte)6);
            progKeywords.add("RADIO-SET", (byte)6);
            progKeywords.add("RANDOM", (byte)6);
            progKeywords.add("RAW", (byte)6);
            progKeywords.add("RAW-TRANSFER", (byte)6);
            progKeywords.add("RCODE-INFORMATION", (byte)6);
            progKeywords.add("READ", (byte)6);
            progKeywords.add("READ-AVAILABLE", (byte)6);
            progKeywords.add("READ-EXACT-NUM", (byte)6);
            progKeywords.add("READ-FILE", (byte)6);
            progKeywords.add("READ-ONLY", (byte)6);
            progKeywords.add("READ-RESPONSE", (byte)6);
            progKeywords.add("READKEY", (byte)6);
            progKeywords.add("REAL", (byte)6);
            progKeywords.add("RECALL", (byte)6);
            progKeywords.add("RECID", (byte)6);
            progKeywords.add("RECORD-LENGTH", (byte)6);
            progKeywords.add("RECTANGLE", (byte)6);
            progKeywords.add("RECURSIVE", (byte)6);
            progKeywords.add("REFRESH", (byte)6);
            progKeywords.add("REFRESHABLE", (byte)6);
            progKeywords.add("RELEASE", (byte)6);
            progKeywords.add("REMOTE", (byte)6);
            progKeywords.add("REMOTE-HOST", (byte)6);
            progKeywords.add("REMOTE-PORT", (byte)6);
            progKeywords.add("REMOVE-ATTRIBUTE", (byte)6);
            progKeywords.add("REMOVE-CHILD", (byte)6);
            progKeywords.add("REMOVE-EVENTS-PROCEDURE", (byte)6);
            progKeywords.add("REMOVE-SUPER-PROCEDURE", (byte)6);
            progKeywords.add("REPEAT", (byte)6);
            progKeywords.add("REPLACE", (byte)6);
            progKeywords.add("REPLACE-CHILD", (byte)6);
            progKeywords.add("REPLACE-SELECTION-TEXT", (byte)6);
            progKeywords.add("REPLICATION-CREATE", (byte)6);
            progKeywords.add("REPLICATION-DELETE", (byte)6);
            progKeywords.add("REPLICATION-WRITE", (byte)6);
            progKeywords.add("REPORTS", (byte)6);
            progKeywords.add("REPOSITION", (byte)6);
            progKeywords.add("REPOSITION-BACKWARDS", (byte)6);
            progKeywords.add("REPOSITION-FORWARDS", (byte)6);
            progKeywords.add("REPOSITION-TO-ROW", (byte)6);
            progKeywords.add("REPOSITION-TO-ROWID", (byte)6);
            progKeywords.add("REQUEST", (byte)6);
            progKeywords.add("RESIZABLE", (byte)6);
            progKeywords.add("RESIZE", (byte)6);
            progKeywords.add("RESULT", (byte)6);
            progKeywords.add("RESUME-DISPLAY", (byte)6);
            progKeywords.add("RETAIN", (byte)6);
            progKeywords.add("RETAIN-SHAPE", (byte)6);
            progKeywords.add("RETRY", (byte)6);
            progKeywords.add("RETRY-CANCEL", (byte)6);
            progKeywords.add("RETURN", (byte)6);
            progKeywords.add("RETURN-INSERTED", (byte)6);
            progKeywords.add("RETURN-TO-START-DIR", (byte)6);
            progKeywords.add("RETURN-VALUE", (byte)6);
            progKeywords.add("RETURNS", (byte)6);
            progKeywords.add("REVERSE-FROM", (byte)6);
            progKeywords.add("REVERT", (byte)6);
            progKeywords.add("REVOKE", (byte)6);
            progKeywords.add("RGB-VALUE", (byte)6);
            progKeywords.add("RIGHT", (byte)6);
            progKeywords.add("RIGHT-ALIGNED", (byte)6);
            progKeywords.add("RIGHT-END", (byte)6);
            progKeywords.add("RIGHT-TRIM", (byte)6);
            progKeywords.add("ROUND", (byte)6);
            progKeywords.add("ROW", (byte)6);
            progKeywords.add("ROW-DISPLAY", (byte)6);
            progKeywords.add("ROW-ENTRY", (byte)6);
            progKeywords.add("ROW-HEIGHT", (byte)6);
            progKeywords.add("ROW-HEIGHT-CHARS", (byte)6);
            progKeywords.add("ROW-HEIGHT-PIXELS", (byte)6);
            progKeywords.add("ROW-LEAVE", (byte)6);
            progKeywords.add("ROW-MARKERS", (byte)6);
            progKeywords.add("ROW-OF", (byte)6);
            progKeywords.add("ROW-RESIZABLE", (byte)6);
            progKeywords.add("ROWID", (byte)6);
            progKeywords.add("RULE", (byte)6);
            progKeywords.add("RULE-ROW", (byte)6);
            progKeywords.add("RULE-Y", (byte)6);
            progKeywords.add("RUN", (byte)6);
            progKeywords.add("RUN-PROCEDURE", (byte)6);
            progKeywords.add("SAVE", (byte)6);
            progKeywords.add("SAVE-AS", (byte)6);
            progKeywords.add("SAVE-FILE", (byte)6);
            progKeywords.add("SAX-XML", (byte)6);
            progKeywords.add("SCHEMA", (byte)6);
            progKeywords.add("SCREEN", (byte)6);
            progKeywords.add("SCREEN-IO", (byte)6);
            progKeywords.add("SCREEN-LINES", (byte)6);
            progKeywords.add("SCREEN-VALUE", (byte)6);
            progKeywords.add("SCROLL", (byte)6);
            progKeywords.add("SCROLL-BARS", (byte)6);
            progKeywords.add("SCROLL-LEFT", (byte)6);
            progKeywords.add("SCROLL-MODE", (byte)6);
            progKeywords.add("SCROLL-NOTIFY", (byte)6);
            progKeywords.add("SCROLL-RIGHT", (byte)6);
            progKeywords.add("SCROLL-TO-CURRENT-ROW", (byte)6);
            progKeywords.add("SCROLL-TO-ITEM", (byte)6);
            progKeywords.add("SCROLL-TO-SELECTED-ROW", (byte)6);
            progKeywords.add("SCROLLABLE", (byte)6);
            progKeywords.add("SCROLLBAR-DRAG", (byte)6);
            progKeywords.add("SCROLLBAR-HORIZONTAL", (byte)6);
            progKeywords.add("SCROLLBAR-VERTICAL", (byte)6);
            progKeywords.add("SCROLLED-ROW-POSITION", (byte)6);
            progKeywords.add("SCROLLING", (byte)6);
            progKeywords.add("SDBNAME", (byte)6);
            progKeywords.add("SEARCH", (byte)6);
            progKeywords.add("SEARCH-SELF", (byte)6);
            progKeywords.add("SEARCH-TARGET", (byte)6);
            progKeywords.add("SECTION", (byte)6);
            progKeywords.add("SEEK", (byte)6);
            progKeywords.add("SELECT", (byte)6);
            progKeywords.add("SELECT-ALL", (byte)6);
            progKeywords.add("SELECT-EXTEND", (byte)6);
            progKeywords.add("SELECT-FOCUSED-ROW", (byte)6);
            progKeywords.add("SELECT-NEXT-ROW", (byte)6);
            progKeywords.add("SELECT-PREV-ROW", (byte)6);
            progKeywords.add("SELECT-REPOSITIONED-ROW", (byte)6);
            progKeywords.add("SELECT-ROW", (byte)6);
            progKeywords.add("SELECTABLE", (byte)6);
            progKeywords.add("SELECTED", (byte)6);
            progKeywords.add("SELECTED-ITEMS", (byte)6);
            progKeywords.add("SELECTION", (byte)6);
            progKeywords.add("SELECTION-END", (byte)6);
            progKeywords.add("SELECTION-EXTEND", (byte)6);
            progKeywords.add("SELECTION-LIST", (byte)6);
            progKeywords.add("SELECTION-START", (byte)6);
            progKeywords.add("SELECTION-TEXT", (byte)6);
            progKeywords.add("SELF", (byte)6);
            progKeywords.add("SEND", (byte)6);
            progKeywords.add("SENSITIVE", (byte)6);
            progKeywords.add("SEPARATE-CONNECTION", (byte)6);
            progKeywords.add("SEPARATOR-FGCOLOR", (byte)6);
            progKeywords.add("SEPARATORS", (byte)6);
            progKeywords.add("SERVER", (byte)6);
            progKeywords.add("SERVER-CONNECTION-BOUND", (byte)6);
            progKeywords.add("SERVER-CONNECTION-BOUND-REQUEST", (byte)6);
            progKeywords.add("SERVER-CONNECTION-CONTEXT", (byte)6);
            progKeywords.add("SERVER-CONNECTION-ID", (byte)6);
            progKeywords.add("SERVER-OPERATING-MODE", (byte)6);
            progKeywords.add("SERVER-SOCKET", (byte)6);
            progKeywords.add("SESSION", (byte)6);
            progKeywords.add("SESSION-END", (byte)6);
            progKeywords.add("SET", (byte)7);
            progKeywords.add("SET-ATTRIBUTE", (byte)7);
            progKeywords.add("SET-ATTRIBUTE-NODE", (byte)7);
            progKeywords.add("SET-BLUE-VALUE", (byte)7);
            progKeywords.add("SET-BREAK", (byte)7);
            progKeywords.add("SET-BUFFERS", (byte)7);
            progKeywords.add("SET-BYTE-ORDER", (byte)7);
            progKeywords.add("SET-CELL-FOCUS", (byte)7);
            progKeywords.add("SET-COMMIT", (byte)7);
            progKeywords.add("SET-CONNECT-PROCEDURE", (byte)7);
            progKeywords.add("SET-CONTENTS", (byte)7);
            progKeywords.add("SET-DYNAMIC", (byte)7);
            progKeywords.add("SET-GREEN-VALUE", (byte)7);
            progKeywords.add("SET-NUMERIC-FORMAT", (byte)7);
            progKeywords.add("SET-POINTER-VALUE", (byte)7);
            progKeywords.add("SET-READ-RESPONSE-PROCEDURE", (byte)7);
            progKeywords.add("SET-RED-VALUE", (byte)7);
            progKeywords.add("SET-REPOSITIONED-ROW", (byte)7);
            progKeywords.add("SET-RGB-VALUE", (byte)7);
            progKeywords.add("SET-ROLLBACK", (byte)7);
            progKeywords.add("SET-SELECTION", (byte)7);
            progKeywords.add("SET-SIZE", (byte)7);
            progKeywords.add("SET-SOCKET-OPTION", (byte)7);
            progKeywords.add("SET-WAIT-STATE", (byte)7);
            progKeywords.add("SETTINGS", (byte)6);
            progKeywords.add("SETUSERID", (byte)6);
            progKeywords.add("SHARE-LOCK", (byte)6);
            progKeywords.add("SHARED", (byte)6);
            progKeywords.add("SHORT", (byte)6);
            progKeywords.add("SHOW-IN-TASKBAR", (byte)6);
            progKeywords.add("SHOW-STATS", (byte)6);
            progKeywords.add("SIDE-LABEL", (byte)6);
            progKeywords.add("SIDE-LABEL-HANDLE", (byte)6);
            progKeywords.add("SIDE-LABELS", (byte)6);
            progKeywords.add("SILENT", (byte)6);
            progKeywords.add("SIMPLE", (byte)6);
            progKeywords.add("SINGLE", (byte)6);
            progKeywords.add("SIZE", (byte)6);
            progKeywords.add("SIZE-CHARS", (byte)6);
            progKeywords.add("SIZE-PIXELS", (byte)6);
            progKeywords.add("SKIP", (byte)6);
            progKeywords.add("SKIP-DELETED-RECORD", (byte)6);
            progKeywords.add("SKIP-SCHEMA-CHECK", (byte)6);
            progKeywords.add("SLIDER", (byte)6);
            progKeywords.add("SMALL-ICON", (byte)6);
            progKeywords.add("SMALL-TITLE", (byte)6);
            progKeywords.add("SMALLINT", (byte)6);
            progKeywords.add("SOCKET", (byte)6);
            progKeywords.add("SOME", (byte)6);
            progKeywords.add("SORT", (byte)6);
            progKeywords.add("SOURCE", (byte)6);
            progKeywords.add("SOURCE-PROCEDURE", (byte)6);
            progKeywords.add("SPACE", (byte)6);
            progKeywords.add("SQL", (byte)6);
            progKeywords.add("SQRT", (byte)6);
            progKeywords.add("START", (byte)6);
            progKeywords.add("START-BOX-SELECTION", (byte)6);
            progKeywords.add("START-EXTEND-BOX-SELECTION", (byte)6);
            progKeywords.add("START-MOVE", (byte)6);
            progKeywords.add("START-RESIZE", (byte)6);
            progKeywords.add("START-ROW-RESIZE", (byte)6);
            progKeywords.add("START-SEARCH", (byte)6);
            progKeywords.add("STATUS", (byte)6);
            progKeywords.add("STATUS-AREA", (byte)6);
            progKeywords.add("STATUS-AREA-FONT", (byte)6);
            progKeywords.add("STDCALL", (byte)6);
            progKeywords.add("STOP", (byte)6);
            progKeywords.add("STOP-DISPLAY", (byte)6);
            progKeywords.add("STOPPED", (byte)6);
            progKeywords.add("STORED-PROCEDURE", (byte)6);
            progKeywords.add("STREAM", (byte)6);
            progKeywords.add("STREAM-IO", (byte)6);
            progKeywords.add("STRETCH-TO-FIT", (byte)6);
            progKeywords.add("STRING", (byte)6);
            progKeywords.add("STRING-VALUE", (byte)6);
            progKeywords.add("STRING-XREF", (byte)6);
            progKeywords.add("SUB-AVERAGE", (byte)6);
            progKeywords.add("SUB-COUNT", (byte)6);
            progKeywords.add("SUB-MAXIMUM", (byte)6);
            progKeywords.add("SUB-MENU", (byte)6);
            progKeywords.add("SUB-MENU-HELP", (byte)6);
            progKeywords.add("SUB-MINIMUM", (byte)6);
            progKeywords.add("SUB-TOTAL", (byte)6);
            progKeywords.add("SUBSCRIBE", (byte)6);
            progKeywords.add("SUBSTITUTE", (byte)6);
            progKeywords.add("SUBSTRING", (byte)6);
            progKeywords.add("SUBTYPE", (byte)6);
            progKeywords.add("SUM", (byte)6);
            progKeywords.add("SUMMARY", (byte)6);
            progKeywords.add("SUPER", (byte)6);
            progKeywords.add("SUPER-PROCEDURES", (byte)6);
            progKeywords.add("SUPPRESS-WARNINGS", (byte)6);
            progKeywords.add("SYSTEM-ALERT-BOXES", (byte)6);
            progKeywords.add("SYSTEM-DIALOG", (byte)6);
            progKeywords.add("SYSTEM-HELP", (byte)6);
            progKeywords.add("SYSTEM-ID", (byte)6);
            progKeywords.add("TAB", (byte)6);
            progKeywords.add("TAB-POSITION", (byte)6);
            progKeywords.add("TAB-STOP", (byte)6);
            progKeywords.add("TABLE", (byte)6);
            progKeywords.add("TABLE-HANDLE", (byte)6);
            progKeywords.add("TABLE-NUMBER", (byte)6);
            progKeywords.add("TARGET", (byte)6);
            progKeywords.add("TARGET-PROCEDURE", (byte)6);
            progKeywords.add("TEMP-DIRECTORY", (byte)6);
            progKeywords.add("TEMP-TABLE", (byte)6);
            progKeywords.add("TEMP-TABLE-PREPARE", (byte)6);
            progKeywords.add("TERM", (byte)6);
            progKeywords.add("TERMINAL", (byte)6);
            progKeywords.add("TERMINATE", (byte)6);
            progKeywords.add("TEXT", (byte)6);
            progKeywords.add("TEXT-CURSOR", (byte)6);
            progKeywords.add("TEXT-SEG-GROWTH", (byte)6);
            progKeywords.add("TEXT-SELECTED", (byte)6);
            progKeywords.add("THEN", (byte)6);
            progKeywords.add("THIS-PROCEDURE", (byte)6);
            progKeywords.add("THREE-D", (byte)6);
            progKeywords.add("THROUGH", (byte)6);
            progKeywords.add("THRU", (byte)6);
            progKeywords.add("TIC-MARKS", (byte)6);
            progKeywords.add("TIME", (byte)6);
            progKeywords.add("TIME-SOURCE", (byte)6);
            progKeywords.add("TITLE", (byte)6);
            progKeywords.add("TITLE-BGCOLOR", (byte)6);
            progKeywords.add("TITLE-DCOLOR", (byte)6);
            progKeywords.add("TITLE-FGCOLOR", (byte)6);
            progKeywords.add("TITLE-FONT", (byte)6);
            progKeywords.add("TO", (byte)6);
            progKeywords.add("TO-ROWID", (byte)6);
            progKeywords.add("TODAY", (byte)6);
            progKeywords.add("TOGGLE-BOX", (byte)6);
            progKeywords.add("TOOLTIP", (byte)6);
            progKeywords.add("TOOLTIPS", (byte)6);
            progKeywords.add("TOP", (byte)6);
            progKeywords.add("TOP-COLUMN", (byte)6);
            progKeywords.add("TOP-ONLY", (byte)6);
            progKeywords.add("TOPIC", (byte)6);
            progKeywords.add("TOTAL", (byte)6);
            progKeywords.add("TRACE-FILTER", (byte)6);
            progKeywords.add("TRACING", (byte)6);
            progKeywords.add("TRAILING", (byte)6);
            progKeywords.add("TRANS", (byte)6);
            progKeywords.add("TRANS-INIT-PROCEDURE", (byte)6);
            progKeywords.add("TRANSACTION", (byte)6);
            progKeywords.add("TRANSACTION-MODE", (byte)6);
            progKeywords.add("TRANSPARENT", (byte)6);
            progKeywords.add("TRIGGER", (byte)6);
            progKeywords.add("TRIGGERS", (byte)6);
            progKeywords.add("TRIM", (byte)6);
            progKeywords.add("TRUE", (byte)4);
            progKeywords.add("TRUNCATE", (byte)6);
            progKeywords.add("TYPE", (byte)6);
            progKeywords.add("UNBUFFERED", (byte)6);
            progKeywords.add("UNDERLINE", (byte)6);
            progKeywords.add("UNDO", (byte)6);
            progKeywords.add("UNFORMATTED", (byte)6);
            progKeywords.add("UNION", (byte)6);
            progKeywords.add("UNIQUE", (byte)6);
            progKeywords.add("UNIQUE-ID", (byte)6);
            progKeywords.add("UNIQUE-MATCH", (byte)6);
            progKeywords.add("UNIX", (byte)6);
            progKeywords.add("UNIX-END", (byte)6);
            progKeywords.add("UNLESS-HIDDEN", (byte)6);
            progKeywords.add("UNLOAD", (byte)6);
            progKeywords.add("UNSIGNED-SHORT", (byte)6);
            progKeywords.add("UNSUBSCRIBE", (byte)6);
            progKeywords.add("UP", (byte)6);
            progKeywords.add("UPDATE", (byte)6);
            progKeywords.add("UPPER", (byte)6);
            progKeywords.add("URL", (byte)6);
            progKeywords.add("URL-DECODE", (byte)6);
            progKeywords.add("URL-ENCODE", (byte)6);
            progKeywords.add("URL-PASSWORD", (byte)6);
            progKeywords.add("URL-USERID", (byte)6);
            progKeywords.add("USE", (byte)6);
            progKeywords.add("USE-DICT-EXPS", (byte)6);
            progKeywords.add("USE-FILENAME", (byte)6);
            progKeywords.add("USE-INDEX", (byte)6);
            progKeywords.add("USE-REVVIDEO", (byte)6);
            progKeywords.add("USE-TEXT", (byte)6);
            progKeywords.add("USE-UNDERLINE", (byte)6);
            progKeywords.add("USER", (byte)6);
            progKeywords.add("USER-DATA", (byte)6);
            progKeywords.add("USERID", (byte)6);
            progKeywords.add("USING", (byte)6);
            progKeywords.add("UTC-OFFSET", (byte)6);
            progKeywords.add("V6DISPLAY", (byte)6);
            progKeywords.add("V6FRAME", (byte)6);
            progKeywords.add("VALID-EVENT", (byte)6);
            progKeywords.add("VALID-HANDLE", (byte)6);
            progKeywords.add("VALIDATE", (byte)6);
            progKeywords.add("VALIDATE-EXPRESSION", (byte)6);
            progKeywords.add("VALIDATE-MESSAGE", (byte)6);
            progKeywords.add("VALIDATE-XML", (byte)6);
            progKeywords.add("VALUE", (byte)6);
            progKeywords.add("VALUE-CHANGED", (byte)6);
            progKeywords.add("VALUES", (byte)6);
            progKeywords.add("VARIABLE", (byte)6);
            progKeywords.add("VERBOSE", (byte)6);
            progKeywords.add("VERTICAL", (byte)6);
            progKeywords.add("VIEW", (byte)6);
            progKeywords.add("VIEW-AS", (byte)6);
            progKeywords.add("VIRTUAL-HEIGHT", (byte)6);
            progKeywords.add("VIRTUAL-HEIGHT-CHARS", (byte)6);
            progKeywords.add("VIRTUAL-HEIGHT-PIXELS", (byte)6);
            progKeywords.add("VIRTUAL-WIDTH", (byte)6);
            progKeywords.add("VIRTUAL-WIDTH-CHARS", (byte)6);
            progKeywords.add("VIRTUAL-WIDTH-PIXELS", (byte)6);
            progKeywords.add("VISIBLE", (byte)6);
            progKeywords.add("VMS", (byte)6);
            progKeywords.add("WAIT", (byte)6);
            progKeywords.add("WAIT-FOR", (byte)6);
            progKeywords.add("WARNING", (byte)6);
            progKeywords.add("WEB-CONTEXT", (byte)6);
            progKeywords.add("WEB-NOTIFY", (byte)6);
            progKeywords.add("WEEKDAY", (byte)6);
            progKeywords.add("WHEN", (byte)6);
            progKeywords.add("WHERE", (byte)6);
            progKeywords.add("WHILE", (byte)6);
            progKeywords.add("WIDGET", (byte)6);
            progKeywords.add("WIDGET-ENTER", (byte)6);
            progKeywords.add("WIDGET-HANDLE", (byte)6);
            progKeywords.add("WIDGET-LEAVE", (byte)6);
            progKeywords.add("WIDGET-POOL", (byte)6);
            progKeywords.add("WIDTH", (byte)6);
            progKeywords.add("WIDTH-CHARS", (byte)6);
            progKeywords.add("WIDTH-PIXELS", (byte)6);
            progKeywords.add("WINDOW", (byte)6);
            progKeywords.add("WINDOW-CLOSE", (byte)6);
            progKeywords.add("WINDOW-DELAYED-MINIMIZE", (byte)6);
            progKeywords.add("WINDOW-MAXIMIZED", (byte)6);
            progKeywords.add("WINDOW-MAXIMIZED", (byte)6);
            progKeywords.add("WINDOW-MINIMIZED", (byte)6);
            progKeywords.add("WINDOW-MINIMIZED", (byte)6);
            progKeywords.add("WINDOW-NAME", (byte)6);
            progKeywords.add("WINDOW-NORMAL", (byte)6);
            progKeywords.add("WINDOW-RESIZED", (byte)6);
            progKeywords.add("WINDOW-RESTORED", (byte)6);
            progKeywords.add("WINDOW-STATE", (byte)6);
            progKeywords.add("WINDOW-SYSTEM", (byte)6);
            progKeywords.add("WITH", (byte)6);
            progKeywords.add("WORD-INDEX", (byte)6);
            progKeywords.add("WORD-WRAP", (byte)6);
            progKeywords.add("WORK-AREA-HEIGHT-PIXELS", (byte)6);
            progKeywords.add("WORK-AREA-WIDTH-PIXELS", (byte)6);
            progKeywords.add("WORK-AREA-X", (byte)6);
            progKeywords.add("WORK-AREA-Y", (byte)6);
            progKeywords.add("WORK-TABLE", (byte)6);
            progKeywords.add("WORKFILE", (byte)6);
            progKeywords.add("WRITE", (byte)6);
            progKeywords.add("WRITE-DATA", (byte)6);
            progKeywords.add("X", (byte)6);
            progKeywords.add("X-DOCUMENT", (byte)6);
            progKeywords.add("X-NODEREF", (byte)6);
            progKeywords.add("X-OF", (byte)6);
            progKeywords.add("XCODE", (byte)6);
            progKeywords.add("XREF", (byte)6);
            progKeywords.add("Y", (byte)6);
            progKeywords.add("Y-OF", (byte)6);
            progKeywords.add("YEAR", (byte)6);
            progKeywords.add("YEAR-OFFSET", (byte)6);
            progKeywords.add("YES", (byte)6);
            progKeywords.add("YES-NO", (byte)6);
            progKeywords.add("YES-NO-CANCEL", (byte)6);
            progKeywords.add("&ANALYZE-RESUME", (byte)7);
            progKeywords.add("&ANALYZE-SUSPEND", (byte)7);
            progKeywords.add("&ELSE", (byte)7);
            progKeywords.add("&ELSEIF", (byte)7);
            progKeywords.add("&ENDIF", (byte)7);
            progKeywords.add("&FILE-NAME", (byte)7);
            progKeywords.add("pp&GLOBAL", (byte)7);
            progKeywords.add("&GLOBAL-DEFINE", (byte)7);
            progKeywords.add("&IF", (byte)7);
            progKeywords.add("&MESSAGE", (byte)7);
            progKeywords.add("&OPSYS", (byte)7);
            progKeywords.add("&SCOPED", (byte)7);
            progKeywords.add("&SCOPED-DEFINE", (byte)7);
            progKeywords.add("pp&THEN", (byte)7);
            progKeywords.add("&UNDEFINE", (byte)7);
            progKeywords.add("{&BATCH-MODE}", (byte)7);
            progKeywords.add("{&FILE-NAME}", (byte)7);
            progKeywords.add("{&LINE-NUMBER}", (byte)7);
            progKeywords.add("{&OPSYS}", (byte)7);
            progKeywords.add("{&SEQUENCE}", (byte)7);
            progKeywords.add("{&WINDOW-SYSTEM}", (byte)7);
            progKeywords.add("&", (byte)8);
            progKeywords.add("(", (byte)8);
            progKeywords.add(") ", (byte)8);
            progKeywords.add("* ", (byte)8);
            progKeywords.add("+ ", (byte)8);
            progKeywords.add(", ", (byte)8);
            progKeywords.add("- ", (byte)8);
            progKeywords.add(". ", (byte)8);
            progKeywords.add("/ ", (byte)8);
            progKeywords.add(": ", (byte)8);
            progKeywords.add("; ", (byte)8);
            progKeywords.add("< ", (byte)8);
            progKeywords.add("<=", (byte)8);
            progKeywords.add("<>", (byte)8);
            progKeywords.add("= ", (byte)8);
            progKeywords.add(">", (byte)8);
            progKeywords.add(">=", (byte)8);
            progKeywords.add("?", (byte)8);
            progKeywords.add("@", (byte)8);
            progKeywords.add("[", (byte)8);
            progKeywords.add("]", (byte)8);
            progKeywords.add("^", (byte)8);
            progKeywords.add("{", (byte)8);
            progKeywords.add("{get ", (byte)8);
            progKeywords.add("{set ", (byte)8);
            progKeywords.add("} ", (byte)8);
            progKeywords.add("~", (byte)8);
        }
        return progKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

