/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.SyntaxUtilities;
import jehep.syntax.TokenMarker;

public class PHPTokenMarker
extends TokenMarker {
    public static final byte SCRIPT = 101;
    public static final byte HTML_LITERAL_QUOTE = 102;
    public static final byte HTML_LITERAL_NO_QUOTE = 103;
    public static final byte INSIDE_TAG = 104;
    public static final byte PHP_VARIABLE = 105;
    private static KeywordMap keywords = new KeywordMap(false);
    private int lastOffset;
    private int lastKeyword;
    private int lastWhitespace;
    private boolean script = false;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        this.lastWhitespace = offset - 1;
        int length = line.count + offset;
        boolean backslash = false;
        block41: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    backslash = false;
                    switch (c) {
                        case '<': {
                            this.addToken(i - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i++;
                            if (SyntaxUtilities.regionMatches(false, line, i1, "!--")) {
                                i += 3;
                                token = 1;
                                break;
                            }
                            if (SyntaxUtilities.regionMatches(true, line, i1, "?php")) {
                                this.addToken(1, (byte)6, true);
                                this.addToken(4, (byte)5, true);
                                this.lastOffset = this.lastKeyword = (i += 4) + 1;
                                this.lastWhitespace = this.lastOffset - 1;
                                token = (byte)101;
                                break;
                            }
                            if (SyntaxUtilities.regionMatches(true, line, i1, "?")) {
                                this.addToken(1, (byte)6, true);
                                this.addToken(1, (byte)5, true);
                                this.lastOffset = this.lastKeyword = i + 1;
                                this.lastWhitespace = this.lastOffset - 1;
                                token = (byte)101;
                                break;
                            }
                            if (SyntaxUtilities.regionMatches(true, line, i1, "script")) {
                                this.addToken(1, (byte)6);
                                this.lastOffset = this.lastKeyword = i1;
                                token = (byte)11;
                                this.script = true;
                                break;
                            }
                            this.addToken(1, (byte)6);
                            this.lastOffset = this.lastKeyword = i1;
                            token = (byte)11;
                            break;
                        }
                        case '&': {
                            this.addToken(i - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)7;
                        }
                    }
                    continue block41;
                }
                case 9: {
                    backslash = false;
                    if (c == '<') continue block41;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = 0;
                    continue block41;
                }
                case 11: {
                    backslash = false;
                    if (c == '>') {
                        this.addToken(i - this.lastOffset, token);
                        this.addToken(1, (byte)6);
                        this.lastOffset = this.lastKeyword = i1;
                        if (!this.script) {
                            token = 0;
                            continue block41;
                        }
                        this.script = false;
                        this.lastWhitespace = i;
                        token = (byte)101;
                        continue block41;
                    }
                    if (c == ':') {
                        this.addToken(i1 - this.lastOffset, (byte)4);
                        this.lastOffset = this.lastKeyword = i1;
                        continue block41;
                    }
                    if (c != ' ' && c != '\t') continue block41;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)104;
                    continue block41;
                }
                case 104: {
                    if (c == '>') {
                        this.addToken(i - this.lastOffset, (byte)11);
                        this.addToken(1, (byte)6);
                        this.lastOffset = this.lastKeyword = i1;
                        if (!this.script) {
                            token = 0;
                            continue block41;
                        }
                        this.script = false;
                        this.lastWhitespace = i;
                        token = (byte)101;
                        continue block41;
                    }
                    if (c == '/' || c == '?') {
                        this.addToken(1, (byte)11);
                        this.lastOffset = this.lastKeyword = i1;
                        token = (byte)11;
                        continue block41;
                    }
                    this.addToken(i - this.lastOffset, (byte)0);
                    this.lastOffset = this.lastKeyword = i;
                    token = (byte)8;
                    continue block41;
                }
                case 7: {
                    backslash = false;
                    if (c != ';') continue block41;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = 0;
                    continue block41;
                }
                case 8: {
                    if (c == '/' || c == '?') {
                        this.addToken(i - this.lastOffset, token);
                        this.addToken(1, (byte)11);
                        this.lastOffset = this.lastKeyword = i1;
                        continue block41;
                    }
                    if (c == '=') {
                        this.addToken(i - this.lastOffset, token);
                        this.addToken(1, (byte)5);
                        this.lastOffset = this.lastKeyword = i1;
                        if (i1 < array.length && array[i1] == '\"') {
                            token = (byte)102;
                            ++i;
                            continue block41;
                        }
                        token = (byte)103;
                        continue block41;
                    }
                    if (c == '>') {
                        this.addToken(i - this.lastOffset, token);
                        this.addToken(1, (byte)6);
                        this.lastOffset = this.lastKeyword = i1;
                        token = 0;
                        continue block41;
                    }
                    if (c != ' ' && c != '\t') continue block41;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)104;
                    continue block41;
                }
                case 102: {
                    if (c != '\"') continue block41;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)104;
                    continue block41;
                }
                case 103: {
                    if (c == ' ' || c == '\t') {
                        this.addToken(i1 - this.lastOffset, (byte)3);
                        this.lastOffset = this.lastKeyword = i1;
                        token = (byte)104;
                        continue block41;
                    }
                    if (c != '>') continue block41;
                    this.addToken(i - this.lastOffset, (byte)3);
                    this.addToken(1, (byte)6);
                    this.lastOffset = this.lastKeyword = i1;
                    token = 0;
                    continue block41;
                }
                case 1: {
                    backslash = false;
                    if (!SyntaxUtilities.regionMatches(false, line, i, "-->")) continue block41;
                    this.addToken(i + 3 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i + 3;
                    token = 0;
                    continue block41;
                }
                case 101: {
                    switch (c) {
                        case '<': {
                            backslash = false;
                            if (!this.doKeyword(line, i, c)) {
                                this.addToken(i - this.lastOffset, token, true);
                            }
                            if (SyntaxUtilities.regionMatches(true, line, i1, "/script>")) {
                                this.addToken(1, (byte)6);
                                this.addToken(7, (byte)11);
                                this.addToken(1, (byte)6);
                                this.lastOffset = this.lastKeyword = (i += 8) + 1;
                                token = 0;
                                break;
                            }
                            if (SyntaxUtilities.regionMatches(true, line, i1, "<<HERE")) {
                                this.addToken(7, (byte)2);
                                this.lastOffset = this.lastKeyword = (i += 6) + 1;
                                break;
                            }
                            this.addToken(1, (byte)9, true);
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                        case '?': {
                            backslash = false;
                            if (!this.doKeyword(line, i, c)) {
                                this.addToken(i - this.lastOffset, token, true);
                            }
                            if (SyntaxUtilities.regionMatches(true, line, i1, ">")) {
                                this.addToken(1, (byte)5, true);
                                this.addToken(1, (byte)6, true);
                                this.lastOffset = this.lastKeyword = ++i + 1;
                                this.lastWhitespace = this.lastOffset - 1;
                                token = 0;
                                break;
                            }
                            this.addToken(1, (byte)9, true);
                            this.lastOffset = this.lastKeyword = i1;
                            this.lastWhitespace = i;
                            break;
                        }
                        case '(': {
                            if (backslash) {
                                this.doKeyword(line, i, c);
                                backslash = false;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) {
                                this.addToken(this.lastWhitespace - this.lastOffset + 1, token, true);
                                this.addToken(i - this.lastWhitespace - 1, (byte)11, true);
                            }
                            this.addToken(1, (byte)9, true);
                            token = (byte)101;
                            this.lastOffset = this.lastKeyword = i1;
                            this.lastWhitespace = i;
                            break;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token, true);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)3;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token, true);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)4;
                            break;
                        }
                        case '#': {
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, token, true);
                            this.addToken(length - i, (byte)2, true);
                            this.lastOffset = this.lastKeyword = length;
                            break block41;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i > 1) {
                                if (array[i1] == '/') {
                                    this.addToken(i - this.lastOffset, token, true);
                                    this.addToken(length - i, (byte)1, true);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block41;
                                }
                                if (array[i1] == '*') {
                                    this.addToken(i - this.lastOffset, token, true);
                                    this.lastOffset = this.lastKeyword = i;
                                    token = (byte)2;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token, true);
                                this.addToken(1, (byte)9, true);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(1, (byte)9, true);
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                        case '$': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token, true);
                            token = (byte)105;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block41;
                            this.doKeyword(line, i, c);
                            if (" \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?@".indexOf(c) != -1) {
                                this.lastWhitespace = i;
                            }
                            if (c == ' ') continue block41;
                            this.addToken(i - this.lastOffset, token, true);
                            this.addToken(1, (byte)9, true);
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                    }
                    continue block41;
                }
                case 105: {
                    if (Character.isLetterOrDigit(c) || c == '_') continue block41;
                    this.addToken(i - this.lastOffset, (byte)4, true);
                    this.addToken(1, (byte)9, true);
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    token = (byte)101;
                    continue block41;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block41;
                    }
                    if (c != '\"') continue block41;
                    this.addToken(i1 - this.lastOffset, (byte)3, true);
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    token = (byte)101;
                    continue block41;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block41;
                    }
                    if (c != '\'') continue block41;
                    this.addToken(i1 - this.lastOffset, (byte)4, true);
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    token = (byte)101;
                    continue block41;
                }
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block41;
                    this.addToken(i + 2 - this.lastOffset, (byte)2, true);
                    this.lastOffset = this.lastKeyword = ++i + 1;
                    this.lastWhitespace = i;
                    token = (byte)101;
                    continue block41;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        switch (token) {
            case 3: {
                this.addToken(length - this.lastOffset, (byte)3);
                break;
            }
            case 4: {
                this.addToken(length - this.lastOffset, (byte)4);
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 101: {
                this.doKeyword(line, length, '\u0000');
                this.addToken(length - this.lastOffset, (byte)0, true);
                break;
            }
            case 2: {
                this.addToken(length - this.lastOffset, (byte)1);
                break;
            }
            case 104: {
                break;
            }
            case 102: 
            case 103: {
                this.addToken(length - this.lastOffset, (byte)3);
                break;
            }
            case 105: {
                this.addToken(length - this.lastOffset, (byte)8, true);
                token = (byte)101;
                break;
            }
            case 9: 
            case 11: {
                this.addToken(length - this.lastOffset, token, true);
                token = (byte)101;
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    @Override
    protected void addToken(int i, byte id) {
        this.addToken(i, id, false);
    }

    @Override
    protected void addToken(int i, byte id, boolean highlighBackground) {
        if (id == 101) {
            id = 0;
        }
        super.addToken(i, id, highlighBackground);
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0, true);
            }
            this.addToken(len, id, true);
            this.lastOffset = i;
            this.lastKeyword = i1;
            this.lastWhitespace = i;
            return true;
        }
        this.lastKeyword = i1;
        return false;
    }

    static {
        keywords.add("function", (byte)7);
        keywords.add("class", (byte)7);
        keywords.add("var", (byte)7);
        keywords.add("global", (byte)7);
        keywords.add("require", (byte)7);
        keywords.add("require_once", (byte)7);
        keywords.add("include", (byte)7);
        keywords.add("include_once", (byte)7);
        keywords.add("and", (byte)6);
        keywords.add("or", (byte)6);
        keywords.add("else", (byte)6);
        keywords.add("elseif", (byte)6);
        keywords.add("do", (byte)6);
        keywords.add("as", (byte)6);
        keywords.add("for", (byte)6);
        keywords.add("foreach", (byte)6);
        keywords.add("if", (byte)6);
        keywords.add("endif", (byte)6);
        keywords.add("in", (byte)6);
        keywords.add("new", (byte)6);
        keywords.add("return", (byte)6);
        keywords.add("while", (byte)6);
        keywords.add("endwhile", (byte)6);
        keywords.add("with", (byte)6);
        keywords.add("break", (byte)6);
        keywords.add("switch", (byte)6);
        keywords.add("case", (byte)6);
        keywords.add("continue", (byte)6);
        keywords.add("default", (byte)6);
        keywords.add("echo", (byte)6);
        keywords.add("false", (byte)6);
        keywords.add("this", (byte)6);
        keywords.add("true", (byte)6);
        keywords.add("array", (byte)6);
        keywords.add("extends", (byte)6);
    }
}

