/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.text.Segment;
import jehep.syntax.CTokenMarker;
import jehep.syntax.KeywordMap;
import jehep.ui.SetEnv;

public class GroovyTokenMarker
extends CTokenMarker {
    public static final byte META_DATA = 101;
    private static KeywordMap groovyKeywords;

    public GroovyTokenMarker() {
        super(false, true, GroovyTokenMarker.getKeywords());
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        this.lastWhitespace = offset - 1;
        int length = line.count + offset;
        boolean backslash = false;
        block24: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '(': {
                            if (backslash) {
                                this.doKeyword(line, i, c);
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(this.lastWhitespace - this.lastOffset + 1, token);
                            this.addToken(i - this.lastWhitespace - 1, (byte)11);
                            this.addToken(1, (byte)0);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i1;
                            this.lastWhitespace = i;
                            break;
                        }
                        case '@': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)101;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                if (i1 < array.length && array[i1] == ':') {
                                    this.addToken(i1 - this.lastOffset, (byte)0);
                                } else {
                                    this.addToken(i1 - this.lastOffset, (byte)5);
                                }
                                this.lastOffset = this.lastKeyword = i1;
                                this.lastWhitespace = i1;
                                backslash = false;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block24;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block24;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (this.javadoc && length - i > 2 && array[i + 2] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    token = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(length - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block24;
                                }
                            }
                            continue block24;
                        }
                        default: {
                            backslash = false;
                            if (!Character.isLetterOrDigit(c) && c != '_') {
                                this.doKeyword(line, i, c);
                            }
                            if (" \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?@".indexOf(c) == -1) continue block24;
                            this.lastWhitespace = i;
                            break;
                        }
                    }
                    continue block24;
                }
                case 101: {
                    if (Character.isLetterOrDigit(c) || c == '_') continue block24;
                    this.addToken(i - this.lastOffset, (byte)5);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i;
                    this.lastWhitespace = i;
                    continue block24;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block24;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    this.lastWhitespace = i;
                    continue block24;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block24;
                    }
                    if (c != '\"') continue block24;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    continue block24;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block24;
                    }
                    if (c != '\'') continue block24;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    continue block24;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 101: {
                this.addToken(length - this.lastOffset, (byte)5);
                token = 0;
                break;
            }
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (groovyKeywords == null) {
            groovyKeywords = new KeywordMap(false);
            groovyKeywords.add("println", (byte)6);
            groovyKeywords.add("def", (byte)6);
            groovyKeywords.add("const", (byte)10);
            groovyKeywords.add("package", (byte)7);
            groovyKeywords.add("import", (byte)7);
            groovyKeywords.add("byte", (byte)8);
            groovyKeywords.add("char", (byte)8);
            groovyKeywords.add("short", (byte)8);
            groovyKeywords.add("int", (byte)8);
            groovyKeywords.add("long", (byte)8);
            groovyKeywords.add("float", (byte)8);
            groovyKeywords.add("double", (byte)8);
            groovyKeywords.add("boolean", (byte)8);
            groovyKeywords.add("void", (byte)8);
            groovyKeywords.add("enum", (byte)8);
            groovyKeywords.add("class", (byte)8);
            groovyKeywords.add("interface", (byte)8);
            groovyKeywords.add("abstract", (byte)6);
            groovyKeywords.add("assert", (byte)6);
            groovyKeywords.add("final", (byte)6);
            groovyKeywords.add("private", (byte)6);
            groovyKeywords.add("protected", (byte)6);
            groovyKeywords.add("public", (byte)6);
            groovyKeywords.add("static", (byte)6);
            groovyKeywords.add("synchronized", (byte)6);
            groovyKeywords.add("native", (byte)6);
            groovyKeywords.add("volatile", (byte)6);
            groovyKeywords.add("transient", (byte)6);
            groovyKeywords.add("break", (byte)6);
            groovyKeywords.add("case", (byte)6);
            groovyKeywords.add("continue", (byte)6);
            groovyKeywords.add("default", (byte)6);
            groovyKeywords.add("do", (byte)6);
            groovyKeywords.add("else", (byte)6);
            groovyKeywords.add("for", (byte)6);
            groovyKeywords.add("if", (byte)6);
            groovyKeywords.add("instanceof", (byte)6);
            groovyKeywords.add("new", (byte)6);
            groovyKeywords.add("return", (byte)6);
            groovyKeywords.add("switch", (byte)6);
            groovyKeywords.add("while", (byte)6);
            groovyKeywords.add("throw", (byte)6);
            groovyKeywords.add("try", (byte)6);
            groovyKeywords.add("catch", (byte)6);
            groovyKeywords.add("extends", (byte)6);
            groovyKeywords.add("finally", (byte)6);
            groovyKeywords.add("implements", (byte)6);
            groovyKeywords.add("throws", (byte)6);
            groovyKeywords.add("this", (byte)4);
            groovyKeywords.add("null", (byte)4);
            groovyKeywords.add("super", (byte)4);
            groovyKeywords.add("true", (byte)4);
            groovyKeywords.add("false", (byte)4);
            GroovyTokenMarker.ReadSyntax();
        }
        return groovyKeywords;
    }

    private static void ReadSyntax() {
        String sd1 = SetEnv.DirPath + File.separator + "syntax" + File.separator + "jhplot" + File.separator + "classes.d";
        try {
            String thisLine;
            BufferedReader in = new BufferedReader(new FileReader(sd1));
            while ((thisLine = in.readLine()) != null) {
                if (thisLine.length() <= 1) continue;
                groovyKeywords.add(thisLine, (byte)8);
            }
        }
        catch (Exception e) {
            System.out.println("Error in reading : " + sd1);
        }
    }
}

