/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class ASMTokenMarker
extends TokenMarker {
    private static KeywordMap asmKeywords;
    private KeywordMap keywords = ASMTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        block14: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            switch (token) {
                case 0: {
                    switch (c) {
                        case ';': {
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            token = 0;
                            this.lastOffset = this.lastKeyword = length;
                            break block14;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ' ': {
                            this.doKeyword(line, i, c);
                        }
                    }
                    continue block14;
                }
                case 3: {
                    if (c != '\"') continue block14;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block14;
                }
                case 4: {
                    if (c != '\'') continue block14;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block14;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (asmKeywords == null) {
            asmKeywords = new KeywordMap(true);
            asmKeywords.add(".186", (byte)6);
            asmKeywords.add(".286", (byte)6);
            asmKeywords.add(".286P", (byte)6);
            asmKeywords.add(".287", (byte)6);
            asmKeywords.add(".386", (byte)6);
            asmKeywords.add(".386P", (byte)6);
            asmKeywords.add(".387", (byte)6);
            asmKeywords.add(".486", (byte)6);
            asmKeywords.add(".486P", (byte)6);
            asmKeywords.add(".586", (byte)6);
            asmKeywords.add(".586P", (byte)6);
            asmKeywords.add(".686", (byte)6);
            asmKeywords.add(".686P", (byte)6);
            asmKeywords.add(".8086", (byte)6);
            asmKeywords.add(".8087", (byte)6);
            asmKeywords.add(".ALPHA", (byte)6);
            asmKeywords.add(".BREAK", (byte)6);
            asmKeywords.add(".BSS", (byte)6);
            asmKeywords.add(".CODE", (byte)6);
            asmKeywords.add(".CONST", (byte)6);
            asmKeywords.add(".CONTINUE", (byte)6);
            asmKeywords.add(".CREF", (byte)6);
            asmKeywords.add(".DATA", (byte)6);
            asmKeywords.add(".DATA?", (byte)6);
            asmKeywords.add(".DOSSEG", (byte)6);
            asmKeywords.add(".ELSE", (byte)6);
            asmKeywords.add(".ELSEIF", (byte)6);
            asmKeywords.add(".ENDIF", (byte)6);
            asmKeywords.add(".ENDW", (byte)6);
            asmKeywords.add(".ERR", (byte)6);
            asmKeywords.add(".ERR1", (byte)6);
            asmKeywords.add(".ERR2", (byte)6);
            asmKeywords.add(".ERRB", (byte)6);
            asmKeywords.add(".ERRDEF", (byte)6);
            asmKeywords.add(".ERRDIF", (byte)6);
            asmKeywords.add(".ERRDIFI", (byte)6);
            asmKeywords.add(".ERRE", (byte)6);
            asmKeywords.add(".ERRIDN", (byte)6);
            asmKeywords.add(".ERRIDNI", (byte)6);
            asmKeywords.add(".ERRNB", (byte)6);
            asmKeywords.add(".ERRNDEF", (byte)6);
            asmKeywords.add(".ERRNZ", (byte)6);
            asmKeywords.add(".EXIT", (byte)6);
            asmKeywords.add(".FARDATA", (byte)6);
            asmKeywords.add(".FARDATA?", (byte)6);
            asmKeywords.add(".IF", (byte)6);
            asmKeywords.add(".K3D", (byte)6);
            asmKeywords.add(".LALL", (byte)6);
            asmKeywords.add(".LFCOND", (byte)6);
            asmKeywords.add(".LIST", (byte)6);
            asmKeywords.add(".LISTALL", (byte)6);
            asmKeywords.add(".LISTIF", (byte)6);
            asmKeywords.add(".LISTMACRO", (byte)6);
            asmKeywords.add(".LISTMACROALL", (byte)6);
            asmKeywords.add(".MMX", (byte)6);
            asmKeywords.add(".MODEL", (byte)6);
            asmKeywords.add(".MSFLOAT", (byte)6);
            asmKeywords.add(".NO87", (byte)6);
            asmKeywords.add(".NOCREF", (byte)6);
            asmKeywords.add(".NOLIST", (byte)6);
            asmKeywords.add(".NOLISTIF", (byte)6);
            asmKeywords.add(".NOLISTMACRO", (byte)6);
            asmKeywords.add(".RADIX", (byte)6);
            asmKeywords.add(".REPEAT", (byte)6);
            asmKeywords.add(".SALL", (byte)6);
            asmKeywords.add(".SEQ", (byte)6);
            asmKeywords.add(".SFCOND", (byte)6);
            asmKeywords.add(".STACK", (byte)6);
            asmKeywords.add(".STARTUP", (byte)6);
            asmKeywords.add(".TEXT", (byte)6);
            asmKeywords.add(".TFCOND", (byte)6);
            asmKeywords.add(".UNTIL", (byte)6);
            asmKeywords.add(".UNTILCXZ", (byte)6);
            asmKeywords.add(".WHILE", (byte)6);
            asmKeywords.add(".XALL", (byte)6);
            asmKeywords.add(".XCREF", (byte)6);
            asmKeywords.add(".XLIST", (byte)6);
            asmKeywords.add(".XMM", (byte)6);
            asmKeywords.add("__FILE__", (byte)6);
            asmKeywords.add("__LINE__", (byte)6);
            asmKeywords.add("A16", (byte)6);
            asmKeywords.add("A32", (byte)6);
            asmKeywords.add("ADDR", (byte)6);
            asmKeywords.add("ALIGN", (byte)6);
            asmKeywords.add("ALIGNB", (byte)6);
            asmKeywords.add("ASSUME", (byte)6);
            asmKeywords.add("BITS", (byte)6);
            asmKeywords.add("CARRY?", (byte)6);
            asmKeywords.add("CATSTR", (byte)6);
            asmKeywords.add("CODESEG", (byte)6);
            asmKeywords.add("COMM", (byte)6);
            asmKeywords.add("COMMENT", (byte)6);
            asmKeywords.add("COMMON", (byte)6);
            asmKeywords.add("DATASEG", (byte)6);
            asmKeywords.add("DOSSEG", (byte)6);
            asmKeywords.add("ECHO", (byte)6);
            asmKeywords.add("ELSE", (byte)6);
            asmKeywords.add("ELSEIF", (byte)6);
            asmKeywords.add("ELSEIF1", (byte)6);
            asmKeywords.add("ELSEIF2", (byte)6);
            asmKeywords.add("ELSEIFB", (byte)6);
            asmKeywords.add("ELSEIFDEF", (byte)6);
            asmKeywords.add("ELSEIFE", (byte)6);
            asmKeywords.add("ELSEIFIDN", (byte)6);
            asmKeywords.add("ELSEIFNB", (byte)6);
            asmKeywords.add("ELSEIFNDEF", (byte)6);
            asmKeywords.add("END", (byte)6);
            asmKeywords.add("ENDIF", (byte)6);
            asmKeywords.add("ENDM", (byte)6);
            asmKeywords.add("ENDP", (byte)6);
            asmKeywords.add("ENDS", (byte)6);
            asmKeywords.add("ENDSTRUC", (byte)6);
            asmKeywords.add("EVEN", (byte)6);
            asmKeywords.add("EXITM", (byte)6);
            asmKeywords.add("EXPORT", (byte)6);
            asmKeywords.add("EXTERN", (byte)6);
            asmKeywords.add("EXTERNDEF", (byte)6);
            asmKeywords.add("EXTRN", (byte)6);
            asmKeywords.add("FAR", (byte)6);
            asmKeywords.add("FOR", (byte)6);
            asmKeywords.add("FORC", (byte)6);
            asmKeywords.add("GLOBAL", (byte)6);
            asmKeywords.add("GOTO", (byte)6);
            asmKeywords.add("GROUP", (byte)6);
            asmKeywords.add("HIGH", (byte)6);
            asmKeywords.add("HIGHWORD", (byte)6);
            asmKeywords.add("IEND", (byte)6);
            asmKeywords.add("IF", (byte)6);
            asmKeywords.add("IF1", (byte)6);
            asmKeywords.add("IF2", (byte)6);
            asmKeywords.add("IFB", (byte)6);
            asmKeywords.add("IFDEF", (byte)6);
            asmKeywords.add("IFDIF", (byte)6);
            asmKeywords.add("IFDIFI", (byte)6);
            asmKeywords.add("IFE", (byte)6);
            asmKeywords.add("IFIDN", (byte)6);
            asmKeywords.add("IFIDNI", (byte)6);
            asmKeywords.add("IFNB", (byte)6);
            asmKeywords.add("IFNDEF", (byte)6);
            asmKeywords.add("IMPORT", (byte)6);
            asmKeywords.add("INCBIN", (byte)6);
            asmKeywords.add("INCLUDE", (byte)6);
            asmKeywords.add("INCLUDELIB", (byte)6);
            asmKeywords.add("INSTR", (byte)6);
            asmKeywords.add("INVOKE", (byte)6);
            asmKeywords.add("IRP", (byte)6);
            asmKeywords.add("IRPC", (byte)6);
            asmKeywords.add("ISTRUC", (byte)6);
            asmKeywords.add("LABEL", (byte)6);
            asmKeywords.add("LENGTH", (byte)6);
            asmKeywords.add("LENGTHOF", (byte)6);
            asmKeywords.add("LOCAL", (byte)6);
            asmKeywords.add("LOW", (byte)6);
            asmKeywords.add("LOWWORD", (byte)6);
            asmKeywords.add("LROFFSET", (byte)6);
            asmKeywords.add("MACRO", (byte)6);
            asmKeywords.add("NAME", (byte)6);
            asmKeywords.add("NEAR", (byte)6);
            asmKeywords.add("NOSPLIT", (byte)6);
            asmKeywords.add("O16", (byte)6);
            asmKeywords.add("O32", (byte)6);
            asmKeywords.add("OFFSET", (byte)6);
            asmKeywords.add("OPATTR", (byte)6);
            asmKeywords.add("OPTION", (byte)6);
            asmKeywords.add("ORG", (byte)6);
            asmKeywords.add("OVERFLOW?", (byte)6);
            asmKeywords.add("PAGE", (byte)6);
            asmKeywords.add("PARITY?", (byte)6);
            asmKeywords.add("POPCONTEXT", (byte)6);
            asmKeywords.add("PRIVATE", (byte)6);
            asmKeywords.add("PROC", (byte)6);
            asmKeywords.add("PROTO", (byte)6);
            asmKeywords.add("PTR", (byte)6);
            asmKeywords.add("PUBLIC", (byte)6);
            asmKeywords.add("PURGE", (byte)6);
            asmKeywords.add("PUSHCONTEXT", (byte)6);
            asmKeywords.add("RECORD", (byte)6);
            asmKeywords.add("REPEAT", (byte)6);
            asmKeywords.add("REPT", (byte)6);
            asmKeywords.add("SECTION", (byte)6);
            asmKeywords.add("SEG", (byte)6);
            asmKeywords.add("SEGMENT", (byte)6);
            asmKeywords.add("SHORT", (byte)6);
            asmKeywords.add("SIGN?", (byte)6);
            asmKeywords.add("SIZE", (byte)6);
            asmKeywords.add("SIZEOF", (byte)6);
            asmKeywords.add("SIZESTR", (byte)6);
            asmKeywords.add("STACK", (byte)6);
            asmKeywords.add("STRUC", (byte)6);
            asmKeywords.add("STRUCT", (byte)6);
            asmKeywords.add("SUBSTR", (byte)6);
            asmKeywords.add("SUBTITLE", (byte)6);
            asmKeywords.add("SUBTTL", (byte)6);
            asmKeywords.add("THIS", (byte)6);
            asmKeywords.add("TITLE", (byte)6);
            asmKeywords.add("TYPE", (byte)6);
            asmKeywords.add("TYPEDEF", (byte)6);
            asmKeywords.add("UNION", (byte)6);
            asmKeywords.add("USE16", (byte)6);
            asmKeywords.add("USE32", (byte)6);
            asmKeywords.add("USES", (byte)6);
            asmKeywords.add("WHILE", (byte)6);
            asmKeywords.add("WRT", (byte)6);
            asmKeywords.add("ZERO?", (byte)6);
            asmKeywords.add("DB", (byte)7);
            asmKeywords.add("DW", (byte)7);
            asmKeywords.add("DD", (byte)7);
            asmKeywords.add("DF", (byte)7);
            asmKeywords.add("DQ", (byte)7);
            asmKeywords.add("DT", (byte)7);
            asmKeywords.add("RESB", (byte)7);
            asmKeywords.add("RESW", (byte)7);
            asmKeywords.add("RESD", (byte)7);
            asmKeywords.add("RESQ", (byte)7);
            asmKeywords.add("REST", (byte)7);
            asmKeywords.add("EQU", (byte)7);
            asmKeywords.add("TEXTEQU", (byte)7);
            asmKeywords.add("TIMES", (byte)7);
            asmKeywords.add("DUP", (byte)7);
            asmKeywords.add("BYTE", (byte)7);
            asmKeywords.add("WORD", (byte)7);
            asmKeywords.add("DWORD", (byte)7);
            asmKeywords.add("FWORD", (byte)7);
            asmKeywords.add("QWORD", (byte)7);
            asmKeywords.add("TBYTE", (byte)7);
            asmKeywords.add("SBYTE", (byte)7);
            asmKeywords.add("TWORD", (byte)7);
            asmKeywords.add("SWORD", (byte)7);
            asmKeywords.add("SDWORD", (byte)7);
            asmKeywords.add("REAL4", (byte)7);
            asmKeywords.add("REAL8", (byte)7);
            asmKeywords.add("REAL10", (byte)7);
            asmKeywords.add("AL", (byte)8);
            asmKeywords.add("BL", (byte)8);
            asmKeywords.add("CL", (byte)8);
            asmKeywords.add("DL", (byte)8);
            asmKeywords.add("AH", (byte)8);
            asmKeywords.add("BH", (byte)8);
            asmKeywords.add("CH", (byte)8);
            asmKeywords.add("DH", (byte)8);
            asmKeywords.add("AX", (byte)8);
            asmKeywords.add("BX", (byte)8);
            asmKeywords.add("CX", (byte)8);
            asmKeywords.add("DX", (byte)8);
            asmKeywords.add("SI", (byte)8);
            asmKeywords.add("DI", (byte)8);
            asmKeywords.add("SP", (byte)8);
            asmKeywords.add("BP", (byte)8);
            asmKeywords.add("EAX", (byte)8);
            asmKeywords.add("EBX", (byte)8);
            asmKeywords.add("ECX", (byte)8);
            asmKeywords.add("EDX", (byte)8);
            asmKeywords.add("ESI", (byte)8);
            asmKeywords.add("EDI", (byte)8);
            asmKeywords.add("ESP", (byte)8);
            asmKeywords.add("EBP", (byte)8);
            asmKeywords.add("CS", (byte)8);
            asmKeywords.add("DS", (byte)8);
            asmKeywords.add("SS", (byte)8);
            asmKeywords.add("ES", (byte)8);
            asmKeywords.add("FS", (byte)8);
            asmKeywords.add("GS", (byte)8);
            asmKeywords.add("ST", (byte)8);
            asmKeywords.add("ST0", (byte)8);
            asmKeywords.add("ST1", (byte)8);
            asmKeywords.add("ST2", (byte)8);
            asmKeywords.add("ST3", (byte)8);
            asmKeywords.add("ST4", (byte)8);
            asmKeywords.add("ST5", (byte)8);
            asmKeywords.add("ST6", (byte)8);
            asmKeywords.add("ST7", (byte)8);
            asmKeywords.add("MM0", (byte)8);
            asmKeywords.add("MM1", (byte)8);
            asmKeywords.add("MM2", (byte)8);
            asmKeywords.add("MM3", (byte)8);
            asmKeywords.add("MM4", (byte)8);
            asmKeywords.add("MM5", (byte)8);
            asmKeywords.add("MM6", (byte)8);
            asmKeywords.add("MM7", (byte)8);
            asmKeywords.add("XMM0", (byte)8);
            asmKeywords.add("XMM1", (byte)8);
            asmKeywords.add("XMM2", (byte)8);
            asmKeywords.add("XMM3", (byte)8);
            asmKeywords.add("XMM4", (byte)8);
            asmKeywords.add("XMM5", (byte)8);
            asmKeywords.add("XMM6", (byte)8);
            asmKeywords.add("XMM7", (byte)8);
            asmKeywords.add("CR0", (byte)8);
            asmKeywords.add("CR2", (byte)8);
            asmKeywords.add("CR3", (byte)8);
            asmKeywords.add("CR4", (byte)8);
            asmKeywords.add("DR0", (byte)8);
            asmKeywords.add("DR1", (byte)8);
            asmKeywords.add("DR2", (byte)8);
            asmKeywords.add("DR3", (byte)8);
            asmKeywords.add("DR4", (byte)8);
            asmKeywords.add("DR5", (byte)8);
            asmKeywords.add("DR6", (byte)8);
            asmKeywords.add("DR7", (byte)8);
            asmKeywords.add("TR3", (byte)8);
            asmKeywords.add("TR4", (byte)8);
            asmKeywords.add("TR5", (byte)8);
            asmKeywords.add("TR6", (byte)8);
            asmKeywords.add("TR7", (byte)8);
            asmKeywords.add("AAA", (byte)4);
            asmKeywords.add("AAD", (byte)4);
            asmKeywords.add("AAM", (byte)4);
            asmKeywords.add("AAS", (byte)4);
            asmKeywords.add("ADC", (byte)4);
            asmKeywords.add("ADD", (byte)4);
            asmKeywords.add("ADDPS", (byte)4);
            asmKeywords.add("ADDSS", (byte)4);
            asmKeywords.add("AND", (byte)4);
            asmKeywords.add("ANDNPS", (byte)4);
            asmKeywords.add("ANDPS", (byte)4);
            asmKeywords.add("ARPL", (byte)4);
            asmKeywords.add("BOUND", (byte)4);
            asmKeywords.add("BSF", (byte)4);
            asmKeywords.add("BSR", (byte)4);
            asmKeywords.add("BSWAP", (byte)4);
            asmKeywords.add("BT", (byte)4);
            asmKeywords.add("BTC", (byte)4);
            asmKeywords.add("BTR", (byte)4);
            asmKeywords.add("BTS", (byte)4);
            asmKeywords.add("CALL", (byte)4);
            asmKeywords.add("CBW", (byte)4);
            asmKeywords.add("CDQ", (byte)4);
            asmKeywords.add("CLC", (byte)4);
            asmKeywords.add("CLD", (byte)4);
            asmKeywords.add("CLI", (byte)4);
            asmKeywords.add("CLTS", (byte)4);
            asmKeywords.add("CMC", (byte)4);
            asmKeywords.add("CMOVA", (byte)4);
            asmKeywords.add("CMOVAE", (byte)4);
            asmKeywords.add("CMOVB", (byte)4);
            asmKeywords.add("CMOVBE", (byte)4);
            asmKeywords.add("CMOVC", (byte)4);
            asmKeywords.add("CMOVE", (byte)4);
            asmKeywords.add("CMOVG", (byte)4);
            asmKeywords.add("CMOVGE", (byte)4);
            asmKeywords.add("CMOVL", (byte)4);
            asmKeywords.add("CMOVLE", (byte)4);
            asmKeywords.add("CMOVNA", (byte)4);
            asmKeywords.add("CMOVNAE", (byte)4);
            asmKeywords.add("CMOVNB", (byte)4);
            asmKeywords.add("CMOVNBE", (byte)4);
            asmKeywords.add("CMOVNC", (byte)4);
            asmKeywords.add("CMOVNE", (byte)4);
            asmKeywords.add("CMOVNG", (byte)4);
            asmKeywords.add("CMOVNGE", (byte)4);
            asmKeywords.add("CMOVNL", (byte)4);
            asmKeywords.add("CMOVNLE", (byte)4);
            asmKeywords.add("CMOVNO", (byte)4);
            asmKeywords.add("CMOVNP", (byte)4);
            asmKeywords.add("CMOVNS", (byte)4);
            asmKeywords.add("CMOVNZ", (byte)4);
            asmKeywords.add("CMOVO", (byte)4);
            asmKeywords.add("CMOVP", (byte)4);
            asmKeywords.add("CMOVPE", (byte)4);
            asmKeywords.add("CMOVPO", (byte)4);
            asmKeywords.add("CMOVS", (byte)4);
            asmKeywords.add("CMOVZ", (byte)4);
            asmKeywords.add("CMP", (byte)4);
            asmKeywords.add("CMPPS", (byte)4);
            asmKeywords.add("CMPS", (byte)4);
            asmKeywords.add("CMPSB", (byte)4);
            asmKeywords.add("CMPSD", (byte)4);
            asmKeywords.add("CMPSS", (byte)4);
            asmKeywords.add("CMPSW", (byte)4);
            asmKeywords.add("CMPXCHG", (byte)4);
            asmKeywords.add("CMPXCHGB", (byte)4);
            asmKeywords.add("COMISS", (byte)4);
            asmKeywords.add("CPUID", (byte)4);
            asmKeywords.add("CWD", (byte)4);
            asmKeywords.add("CWDE", (byte)4);
            asmKeywords.add("CVTPI2PS", (byte)4);
            asmKeywords.add("CVTPS2PI", (byte)4);
            asmKeywords.add("CVTSI2SS", (byte)4);
            asmKeywords.add("CVTSS2SI", (byte)4);
            asmKeywords.add("CVTTPS2PI", (byte)4);
            asmKeywords.add("CVTTSS2SI", (byte)4);
            asmKeywords.add("DAA", (byte)4);
            asmKeywords.add("DAS", (byte)4);
            asmKeywords.add("DEC", (byte)4);
            asmKeywords.add("DIV", (byte)4);
            asmKeywords.add("DIVPS", (byte)4);
            asmKeywords.add("DIVSS", (byte)4);
            asmKeywords.add("EMMS", (byte)4);
            asmKeywords.add("ENTER", (byte)4);
            asmKeywords.add("F2XM1", (byte)4);
            asmKeywords.add("FABS", (byte)4);
            asmKeywords.add("FADD", (byte)4);
            asmKeywords.add("FADDP", (byte)4);
            asmKeywords.add("FBLD", (byte)4);
            asmKeywords.add("FBSTP", (byte)4);
            asmKeywords.add("FCHS", (byte)4);
            asmKeywords.add("FCLEX", (byte)4);
            asmKeywords.add("FCMOVB", (byte)4);
            asmKeywords.add("FCMOVBE", (byte)4);
            asmKeywords.add("FCMOVE", (byte)4);
            asmKeywords.add("FCMOVNB", (byte)4);
            asmKeywords.add("FCMOVNBE", (byte)4);
            asmKeywords.add("FCMOVNE", (byte)4);
            asmKeywords.add("FCMOVNU", (byte)4);
            asmKeywords.add("FCMOVU", (byte)4);
            asmKeywords.add("FCOM", (byte)4);
            asmKeywords.add("FCOMI", (byte)4);
            asmKeywords.add("FCOMIP", (byte)4);
            asmKeywords.add("FCOMP", (byte)4);
            asmKeywords.add("FCOMPP", (byte)4);
            asmKeywords.add("FCOS", (byte)4);
            asmKeywords.add("FDECSTP", (byte)4);
            asmKeywords.add("FDIV", (byte)4);
            asmKeywords.add("FDIVP", (byte)4);
            asmKeywords.add("FDIVR", (byte)4);
            asmKeywords.add("FDIVRP", (byte)4);
            asmKeywords.add("FFREE", (byte)4);
            asmKeywords.add("FIADD", (byte)4);
            asmKeywords.add("FICOM", (byte)4);
            asmKeywords.add("FICOMP", (byte)4);
            asmKeywords.add("FIDIV", (byte)4);
            asmKeywords.add("FIDIVR", (byte)4);
            asmKeywords.add("FILD", (byte)4);
            asmKeywords.add("FIMUL", (byte)4);
            asmKeywords.add("FINCSTP", (byte)4);
            asmKeywords.add("FINIT", (byte)4);
            asmKeywords.add("FIST", (byte)4);
            asmKeywords.add("FISTP", (byte)4);
            asmKeywords.add("FISUB", (byte)4);
            asmKeywords.add("FISUBR", (byte)4);
            asmKeywords.add("FLD1", (byte)4);
            asmKeywords.add("FLDCW", (byte)4);
            asmKeywords.add("FLDENV", (byte)4);
            asmKeywords.add("FLDL2E", (byte)4);
            asmKeywords.add("FLDL2T", (byte)4);
            asmKeywords.add("FLDLG2", (byte)4);
            asmKeywords.add("FLDLN2", (byte)4);
            asmKeywords.add("FLDPI", (byte)4);
            asmKeywords.add("FLDZ", (byte)4);
            asmKeywords.add("FMUL", (byte)4);
            asmKeywords.add("FMULP", (byte)4);
            asmKeywords.add("FNCLEX", (byte)4);
            asmKeywords.add("FNINIT", (byte)4);
            asmKeywords.add("FNOP", (byte)4);
            asmKeywords.add("FNSAVE", (byte)4);
            asmKeywords.add("FNSTCW", (byte)4);
            asmKeywords.add("FNSTENV", (byte)4);
            asmKeywords.add("FNSTSW", (byte)4);
            asmKeywords.add("FPATAN", (byte)4);
            asmKeywords.add("FPREM", (byte)4);
            asmKeywords.add("FPREMI", (byte)4);
            asmKeywords.add("FPTAN", (byte)4);
            asmKeywords.add("FRNDINT", (byte)4);
            asmKeywords.add("FRSTOR", (byte)4);
            asmKeywords.add("FSAVE", (byte)4);
            asmKeywords.add("FSCALE", (byte)4);
            asmKeywords.add("FSIN", (byte)4);
            asmKeywords.add("FSINCOS", (byte)4);
            asmKeywords.add("FSQRT", (byte)4);
            asmKeywords.add("FST", (byte)4);
            asmKeywords.add("FSTCW", (byte)4);
            asmKeywords.add("FSTENV", (byte)4);
            asmKeywords.add("FSTP", (byte)4);
            asmKeywords.add("FSTSW", (byte)4);
            asmKeywords.add("FSUB", (byte)4);
            asmKeywords.add("FSUBP", (byte)4);
            asmKeywords.add("FSUBR", (byte)4);
            asmKeywords.add("FSUBRP", (byte)4);
            asmKeywords.add("FTST", (byte)4);
            asmKeywords.add("FUCOM", (byte)4);
            asmKeywords.add("FUCOMI", (byte)4);
            asmKeywords.add("FUCOMIP", (byte)4);
            asmKeywords.add("FUCOMP", (byte)4);
            asmKeywords.add("FUCOMPP", (byte)4);
            asmKeywords.add("FWAIT", (byte)4);
            asmKeywords.add("FXAM", (byte)4);
            asmKeywords.add("FXCH", (byte)4);
            asmKeywords.add("FXRSTOR", (byte)4);
            asmKeywords.add("FXSAVE", (byte)4);
            asmKeywords.add("FXTRACT", (byte)4);
            asmKeywords.add("FYL2X", (byte)4);
            asmKeywords.add("FYL2XP1", (byte)4);
            asmKeywords.add("HLT", (byte)4);
            asmKeywords.add("IDIV", (byte)4);
            asmKeywords.add("IMUL", (byte)4);
            asmKeywords.add("IN", (byte)4);
            asmKeywords.add("INC", (byte)4);
            asmKeywords.add("INS", (byte)4);
            asmKeywords.add("INSB", (byte)4);
            asmKeywords.add("INSD", (byte)4);
            asmKeywords.add("INSW", (byte)4);
            asmKeywords.add("INT", (byte)4);
            asmKeywords.add("INTO", (byte)4);
            asmKeywords.add("INVD", (byte)4);
            asmKeywords.add("INVLPG", (byte)4);
            asmKeywords.add("IRET", (byte)4);
            asmKeywords.add("JA", (byte)4);
            asmKeywords.add("JAE", (byte)4);
            asmKeywords.add("JB", (byte)4);
            asmKeywords.add("JBE", (byte)4);
            asmKeywords.add("JC", (byte)4);
            asmKeywords.add("JCXZ", (byte)4);
            asmKeywords.add("JE", (byte)4);
            asmKeywords.add("JECXZ", (byte)4);
            asmKeywords.add("JG", (byte)4);
            asmKeywords.add("JGE", (byte)4);
            asmKeywords.add("JL", (byte)4);
            asmKeywords.add("JLE", (byte)4);
            asmKeywords.add("JMP", (byte)4);
            asmKeywords.add("JNA", (byte)4);
            asmKeywords.add("JNAE", (byte)4);
            asmKeywords.add("JNB", (byte)4);
            asmKeywords.add("JNBE", (byte)4);
            asmKeywords.add("JNC", (byte)4);
            asmKeywords.add("JNE", (byte)4);
            asmKeywords.add("JNG", (byte)4);
            asmKeywords.add("JNGE", (byte)4);
            asmKeywords.add("JNL", (byte)4);
            asmKeywords.add("JNLE", (byte)4);
            asmKeywords.add("JNO", (byte)4);
            asmKeywords.add("JNP", (byte)4);
            asmKeywords.add("JNS", (byte)4);
            asmKeywords.add("JNZ", (byte)4);
            asmKeywords.add("JO", (byte)4);
            asmKeywords.add("JP", (byte)4);
            asmKeywords.add("JPE", (byte)4);
            asmKeywords.add("JPO", (byte)4);
            asmKeywords.add("JS", (byte)4);
            asmKeywords.add("JZ", (byte)4);
            asmKeywords.add("LAHF", (byte)4);
            asmKeywords.add("LAR", (byte)4);
            asmKeywords.add("LDMXCSR", (byte)4);
            asmKeywords.add("LDS", (byte)4);
            asmKeywords.add("LEA", (byte)4);
            asmKeywords.add("LEAVE", (byte)4);
            asmKeywords.add("LES", (byte)4);
            asmKeywords.add("LFS", (byte)4);
            asmKeywords.add("LGDT", (byte)4);
            asmKeywords.add("LGS", (byte)4);
            asmKeywords.add("LIDT", (byte)4);
            asmKeywords.add("LLDT", (byte)4);
            asmKeywords.add("LMSW", (byte)4);
            asmKeywords.add("LOCK", (byte)4);
            asmKeywords.add("LODS", (byte)4);
            asmKeywords.add("LODSB", (byte)4);
            asmKeywords.add("LODSD", (byte)4);
            asmKeywords.add("LODSW", (byte)4);
            asmKeywords.add("LOOP", (byte)4);
            asmKeywords.add("LOOPE", (byte)4);
            asmKeywords.add("LOOPNE", (byte)4);
            asmKeywords.add("LOOPNZ", (byte)4);
            asmKeywords.add("LOOPZ", (byte)4);
            asmKeywords.add("LSL", (byte)4);
            asmKeywords.add("LSS", (byte)4);
            asmKeywords.add("LTR", (byte)4);
            asmKeywords.add("MASKMOVQ", (byte)4);
            asmKeywords.add("MAXPS", (byte)4);
            asmKeywords.add("MAXSS", (byte)4);
            asmKeywords.add("MINPS", (byte)4);
            asmKeywords.add("MINSS", (byte)4);
            asmKeywords.add("MOV", (byte)4);
            asmKeywords.add("MOVAPS", (byte)4);
            asmKeywords.add("MOVD", (byte)4);
            asmKeywords.add("MOVHLPS", (byte)4);
            asmKeywords.add("MOVHPS", (byte)4);
            asmKeywords.add("MOVLHPS", (byte)4);
            asmKeywords.add("MOVLPS", (byte)4);
            asmKeywords.add("MOVMSKPS", (byte)4);
            asmKeywords.add("MOVNTPS", (byte)4);
            asmKeywords.add("MOVNTQ", (byte)4);
            asmKeywords.add("MOVQ", (byte)4);
            asmKeywords.add("MOVS", (byte)4);
            asmKeywords.add("MOVSB", (byte)4);
            asmKeywords.add("MOVSD", (byte)4);
            asmKeywords.add("MOVSS", (byte)4);
            asmKeywords.add("MOVSW", (byte)4);
            asmKeywords.add("MOVSX", (byte)4);
            asmKeywords.add("MOVUPS", (byte)4);
            asmKeywords.add("MOVZX", (byte)4);
            asmKeywords.add("MUL", (byte)4);
            asmKeywords.add("MULPS", (byte)4);
            asmKeywords.add("MULSS", (byte)4);
            asmKeywords.add("NEG", (byte)4);
            asmKeywords.add("NOP", (byte)4);
            asmKeywords.add("NOT", (byte)4);
            asmKeywords.add("OR", (byte)4);
            asmKeywords.add("ORPS", (byte)4);
            asmKeywords.add("OUT", (byte)4);
            asmKeywords.add("OUTS", (byte)4);
            asmKeywords.add("OUTSB", (byte)4);
            asmKeywords.add("OUTSD", (byte)4);
            asmKeywords.add("OUTSW", (byte)4);
            asmKeywords.add("PACKSSDW", (byte)4);
            asmKeywords.add("PACKSSWB", (byte)4);
            asmKeywords.add("PACKUSWB", (byte)4);
            asmKeywords.add("PADDB", (byte)4);
            asmKeywords.add("PADDD", (byte)4);
            asmKeywords.add("PADDSB", (byte)4);
            asmKeywords.add("PADDSW", (byte)4);
            asmKeywords.add("PADDUSB", (byte)4);
            asmKeywords.add("PADDUSW", (byte)4);
            asmKeywords.add("PADDW", (byte)4);
            asmKeywords.add("PAND", (byte)4);
            asmKeywords.add("PANDN", (byte)4);
            asmKeywords.add("PAVGB", (byte)4);
            asmKeywords.add("PAVGW", (byte)4);
            asmKeywords.add("PCMPEQB", (byte)4);
            asmKeywords.add("PCMPEQD", (byte)4);
            asmKeywords.add("PCMPEQW", (byte)4);
            asmKeywords.add("PCMPGTB", (byte)4);
            asmKeywords.add("PCMPGTD", (byte)4);
            asmKeywords.add("PCMPGTW", (byte)4);
            asmKeywords.add("PEXTRW", (byte)4);
            asmKeywords.add("PINSRW", (byte)4);
            asmKeywords.add("PMADDWD", (byte)4);
            asmKeywords.add("PMAXSW", (byte)4);
            asmKeywords.add("PMAXUB", (byte)4);
            asmKeywords.add("PMINSW", (byte)4);
            asmKeywords.add("PMINUB", (byte)4);
            asmKeywords.add("PMOVMSKB", (byte)4);
            asmKeywords.add("PMULHUW", (byte)4);
            asmKeywords.add("PMULHW", (byte)4);
            asmKeywords.add("PMULLW", (byte)4);
            asmKeywords.add("POP", (byte)4);
            asmKeywords.add("POPA", (byte)4);
            asmKeywords.add("POPAD", (byte)4);
            asmKeywords.add("POPAW", (byte)4);
            asmKeywords.add("POPF", (byte)4);
            asmKeywords.add("POPFD", (byte)4);
            asmKeywords.add("POPFW", (byte)4);
            asmKeywords.add("POR", (byte)4);
            asmKeywords.add("PREFETCH", (byte)4);
            asmKeywords.add("PSADBW", (byte)4);
            asmKeywords.add("PSHUFW", (byte)4);
            asmKeywords.add("PSLLD", (byte)4);
            asmKeywords.add("PSLLQ", (byte)4);
            asmKeywords.add("PSLLW", (byte)4);
            asmKeywords.add("PSRAD", (byte)4);
            asmKeywords.add("PSRAW", (byte)4);
            asmKeywords.add("PSRLD", (byte)4);
            asmKeywords.add("PSRLQ", (byte)4);
            asmKeywords.add("PSRLW", (byte)4);
            asmKeywords.add("PSUBB", (byte)4);
            asmKeywords.add("PSUBD", (byte)4);
            asmKeywords.add("PSUBSB", (byte)4);
            asmKeywords.add("PSUBSW", (byte)4);
            asmKeywords.add("PSUBUSB", (byte)4);
            asmKeywords.add("PSUBUSW", (byte)4);
            asmKeywords.add("PSUBW", (byte)4);
            asmKeywords.add("PUNPCKHBW", (byte)4);
            asmKeywords.add("PUNPCKHDQ", (byte)4);
            asmKeywords.add("PUNPCKHWD", (byte)4);
            asmKeywords.add("PUNPCKLBW", (byte)4);
            asmKeywords.add("PUNPCKLDQ", (byte)4);
            asmKeywords.add("PUNPCKLWD", (byte)4);
            asmKeywords.add("PUSH", (byte)4);
            asmKeywords.add("PUSHA", (byte)4);
            asmKeywords.add("PUSHAD", (byte)4);
            asmKeywords.add("PUSHAW", (byte)4);
            asmKeywords.add("PUSHF", (byte)4);
            asmKeywords.add("PUSHFD", (byte)4);
            asmKeywords.add("PUSHFW", (byte)4);
            asmKeywords.add("PXOR", (byte)4);
            asmKeywords.add("RCL", (byte)4);
            asmKeywords.add("RCR", (byte)4);
            asmKeywords.add("RDMSR", (byte)4);
            asmKeywords.add("RDPMC", (byte)4);
            asmKeywords.add("RDTSC", (byte)4);
            asmKeywords.add("REP", (byte)4);
            asmKeywords.add("REPE", (byte)4);
            asmKeywords.add("REPNE", (byte)4);
            asmKeywords.add("REPNZ", (byte)4);
            asmKeywords.add("REPZ", (byte)4);
            asmKeywords.add("RET", (byte)4);
            asmKeywords.add("RETF", (byte)4);
            asmKeywords.add("RETN", (byte)4);
            asmKeywords.add("ROL", (byte)4);
            asmKeywords.add("ROR", (byte)4);
            asmKeywords.add("RSM", (byte)4);
            asmKeywords.add("SAHF", (byte)4);
            asmKeywords.add("SAL", (byte)4);
            asmKeywords.add("SAR", (byte)4);
            asmKeywords.add("SBB", (byte)4);
            asmKeywords.add("SCAS", (byte)4);
            asmKeywords.add("SCASB", (byte)4);
            asmKeywords.add("SCASD", (byte)4);
            asmKeywords.add("SCASW", (byte)4);
            asmKeywords.add("SETA", (byte)4);
            asmKeywords.add("SETAE", (byte)4);
            asmKeywords.add("SETB", (byte)4);
            asmKeywords.add("SETBE", (byte)4);
            asmKeywords.add("SETC", (byte)4);
            asmKeywords.add("SETE", (byte)4);
            asmKeywords.add("SETG", (byte)4);
            asmKeywords.add("SETGE", (byte)4);
            asmKeywords.add("SETL", (byte)4);
            asmKeywords.add("SETLE", (byte)4);
            asmKeywords.add("SETNA", (byte)4);
            asmKeywords.add("SETNAE", (byte)4);
            asmKeywords.add("SETNB", (byte)4);
            asmKeywords.add("SETNBE", (byte)4);
            asmKeywords.add("SETNC", (byte)4);
            asmKeywords.add("SETNE", (byte)4);
            asmKeywords.add("SETNG", (byte)4);
            asmKeywords.add("SETNGE", (byte)4);
            asmKeywords.add("SETNL", (byte)4);
            asmKeywords.add("SETNLE", (byte)4);
            asmKeywords.add("SETNO", (byte)4);
            asmKeywords.add("SETNP", (byte)4);
            asmKeywords.add("SETNS", (byte)4);
            asmKeywords.add("SETNZ", (byte)4);
            asmKeywords.add("SETO", (byte)4);
            asmKeywords.add("SETP", (byte)4);
            asmKeywords.add("SETPE", (byte)4);
            asmKeywords.add("SETPO", (byte)4);
            asmKeywords.add("SETS", (byte)4);
            asmKeywords.add("SETZ", (byte)4);
            asmKeywords.add("SFENCE", (byte)4);
            asmKeywords.add("SGDT", (byte)4);
            asmKeywords.add("SHL", (byte)4);
            asmKeywords.add("SHLD", (byte)4);
            asmKeywords.add("SHR", (byte)4);
            asmKeywords.add("SHRD", (byte)4);
            asmKeywords.add("SHUFPS", (byte)4);
            asmKeywords.add("SIDT", (byte)4);
            asmKeywords.add("SLDT", (byte)4);
            asmKeywords.add("SMSW", (byte)4);
            asmKeywords.add("SQRTPS", (byte)4);
            asmKeywords.add("SQRTSS", (byte)4);
            asmKeywords.add("STC", (byte)4);
            asmKeywords.add("STD", (byte)4);
            asmKeywords.add("STI", (byte)4);
            asmKeywords.add("STMXCSR", (byte)4);
            asmKeywords.add("STOS", (byte)4);
            asmKeywords.add("STOSB", (byte)4);
            asmKeywords.add("STOSD", (byte)4);
            asmKeywords.add("STOSW", (byte)4);
            asmKeywords.add("STR", (byte)4);
            asmKeywords.add("SUB", (byte)4);
            asmKeywords.add("SUBPS", (byte)4);
            asmKeywords.add("SUBSS", (byte)4);
            asmKeywords.add("SYSENTER", (byte)4);
            asmKeywords.add("SYSEXIT", (byte)4);
            asmKeywords.add("TEST", (byte)4);
            asmKeywords.add("UB2", (byte)4);
            asmKeywords.add("UCOMISS", (byte)4);
            asmKeywords.add("UNPCKHPS", (byte)4);
            asmKeywords.add("UNPCKLPS", (byte)4);
            asmKeywords.add("WAIT", (byte)4);
            asmKeywords.add("WBINVD", (byte)4);
            asmKeywords.add("VERR", (byte)4);
            asmKeywords.add("VERW", (byte)4);
            asmKeywords.add("WRMSR", (byte)4);
            asmKeywords.add("XADD", (byte)4);
            asmKeywords.add("XCHG", (byte)4);
            asmKeywords.add("XLAT", (byte)4);
            asmKeywords.add("XLATB", (byte)4);
            asmKeywords.add("XOR", (byte)4);
            asmKeywords.add("XORPS", (byte)4);
            asmKeywords.add("FEMMS", (byte)4);
            asmKeywords.add("PAVGUSB", (byte)4);
            asmKeywords.add("PF2ID", (byte)4);
            asmKeywords.add("PFACC", (byte)4);
            asmKeywords.add("PFADD", (byte)4);
            asmKeywords.add("PFCMPEQ", (byte)4);
            asmKeywords.add("PFCMPGE", (byte)4);
            asmKeywords.add("PFCMPGT", (byte)4);
            asmKeywords.add("PFMAX", (byte)4);
            asmKeywords.add("PFMIN", (byte)4);
            asmKeywords.add("PFMUL", (byte)4);
            asmKeywords.add("PFRCP", (byte)4);
            asmKeywords.add("PFRCPIT1", (byte)4);
            asmKeywords.add("PFRCPIT2", (byte)4);
            asmKeywords.add("PFRSQIT1", (byte)4);
            asmKeywords.add("PFRSQRT", (byte)4);
            asmKeywords.add("PFSUB", (byte)4);
            asmKeywords.add("PFSUBR", (byte)4);
            asmKeywords.add("PI2FD", (byte)4);
            asmKeywords.add("PMULHRW", (byte)4);
            asmKeywords.add("PREFETCHW", (byte)4);
            asmKeywords.add("PF2IW", (byte)4);
            asmKeywords.add("PFNACC", (byte)4);
            asmKeywords.add("PFPNACC", (byte)4);
            asmKeywords.add("PI2FW", (byte)4);
            asmKeywords.add("PSWAPD", (byte)4);
            asmKeywords.add("PREFETCHNTA", (byte)4);
            asmKeywords.add("PREFETCHT0", (byte)4);
            asmKeywords.add("PREFETCHT1", (byte)4);
            asmKeywords.add("PREFETCHT2", (byte)4);
        }
        return asmKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

