/*
 * Decompiled with CFR 0.152.
 */
package jehep.spell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;
import jehep.utils.Util;

public class SpellDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton closeButton;
    private static JComboBox combo;
    public final String nonspell = "no spelling";

    public SpellDialog(mainGUI win) {
        this.setDefaultCloseOperation(2);
        this.setTitle("Dictionary");
        this.setModal(true);
        this.setResizable(true);
        JPanel topPanel = new JPanel();
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(300, 35));
        this.closeButton = new JButton();
        this.closeButton.setText("Exit");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetEnv.jbtRunSpell.setEnabled(false);
                if (SetEnv.SelectedDic > 0) {
                    SetEnv.jbtRunSpell.setEnabled(true);
                }
                SpellDialog.this.setVisible(false);
                SpellDialog.this.dispose();
            }
        });
        lowerPanel.add((Component)this.closeButton, null);
        topPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        combo = new JComboBox();
        combo.addItem("no spelling");
        combo.setFocusable(true);
        combo.setPreferredSize(new Dimension(200, 50));
        combo.setBorder(new TitledBorder(null, "Select dictionary:", 0, 0, new Font("Dialog", 0, 12)));
        JPanel main = new JPanel();
        main.add(combo);
        topPanel.add((Component)main, "Center");
        Util.centreWithin(win, this);
        File f1 = new File(SetEnv.DicDir);
        int nn = 0;
        Vector<String> dbbases = new Vector<String>();
        dbbases.addElement("no spelling");
        if (f1.isDirectory()) {
            String[] s = f1.list();
            for (int i = 0; i < s.length; ++i) {
                File f = new File(SetEnv.DicDir + File.separator + s[i]);
                if (f.isDirectory() || !s[i].endsWith(".zip") || s[i].length() <= 4) continue;
                String ss = s[i].replace(".zip", "");
                combo.addItem(ss);
                dbbases.addElement(ss);
                ++nn;
            }
        }
        if (nn < SetEnv.SelectedDic) {
            combo.setSelectedIndex(SetEnv.SelectedDic);
        }
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JComboBox cb = (JComboBox)evt.getSource();
                SetEnv.SelectedDic = cb.getSelectedIndex();
                SetEnv.SelectedDicName = "no spelling";
                if (SetEnv.SelectedDic == 0) {
                    SetEnv.removeDic();
                }
                if (SetEnv.SelectedDic > 0) {
                    String newDictName = (String)cb.getSelectedItem();
                    SetEnv.removeDic();
                    SetEnv.loadDic(SetEnv.DicDir + File.separator + newDictName + ".zip");
                    SetEnv.SelectedDicName = newDictName;
                }
            }
        });
        if (SetEnv.SelectedDic < nn) {
            combo.setSelectedIndex(SetEnv.SelectedDic);
        }
        this.pack();
        this.setVisible(true);
    }
}

