/*
 * Decompiled with CFR 0.152.
 */
package jehep.shellbsh;

import java.util.StringTokenizer;
import jehep.shellbsh.Alias;
import jehep.ui.Constants;
import jehep.ui.Editor;
import jehep.ui.SetEnv;

public class Replacement
implements Constants {
    public static String make(String s) {
        boolean suc;
        String ss;
        if ((s = s.trim()).endsWith(".bsh")) {
            s = "source(\"" + s + "\");";
            return s;
        }
        StringTokenizer st = new StringTokenizer(s);
        int ncount = st.countTokens();
        String[] sword = new String[ncount];
        int m = 0;
        while (st.hasMoreTokens()) {
            String tmp;
            sword[m] = tmp = st.nextToken();
            ++m;
        }
        if (s.equals("pwd")) {
            s = "pwd();";
            return s;
        }
        if (s.equals("ls")) {
            s = "dir();";
            return s;
        }
        if (ncount > 0) {
            if (sword[0].equals("cp")) {
                if (ncount != 3) {
                    s = "error(\" wrong command. cp takes 2 arguments!\");";
                    return s;
                }
                s = "cp(\"" + sword[1] + "\",\"" + sword[2] + "\");";
                return s;
            }
            if (sword[0].equals("mv")) {
                if (ncount != 3) {
                    s = "error(\" wrong command. mv takes 2 arguments!\");";
                    return s;
                }
                s = "mv(\"" + sword[1] + "\",\"" + sword[2] + "\");";
                return s;
            }
            if (sword[0].equals("cd")) {
                if (ncount != 2) {
                    s = "error(\" wrong command. cd takes 1 path (String)!\");";
                    return s;
                }
                s = "cd(\"" + sword[1] + "\");";
                return s;
            }
            if (sword[0].equals("cat")) {
                if (ncount != 2) {
                    s = "error(\" wrong command. cat takes 1 argument (String)!\");";
                    return s;
                }
                s = "cat(\"" + sword[1] + "\");";
                return s;
            }
            if (sword[0].equals("rm")) {
                if (ncount != 2) {
                    s = "error(\" wrong command. rm takes 1 argument (String)!\");";
                    return s;
                }
                s = "rm(\"" + sword[1] + "\");";
                return s;
            }
        }
        s = Alias.makeReplacement(s);
        if (ncount > 1) {
            if (sword[0].equals("print")) {
                if (ncount < 2) {
                    s = "error(\" wrong command. print takes at least 1 argument (String)!\");";
                    return s;
                }
                ss = s.substring(6, s.length());
                s = "print(\"" + ss + "\");";
                return s;
            }
            if (sword[0].equals("echo")) {
                if (ncount < 2) {
                    s = "error(\" wrong command. echo takes at least 1 argument (String)!\");";
                    return s;
                }
                ss = s.substring(5, s.length());
                s = "print(\"" + ss + "\");";
                return s;
            }
        }
        if (s.equals("run") && !Editor.DocName.equals("none")) {
            s = "source(\"" + Editor.DocName + "\");";
        }
        if (s.equals("obrowser")) {
            ss = "macros" + SetEnv.fSep + "system" + SetEnv.fSep + "obrowser.bsh";
            if (SetEnv.DirPath.length() > 0) {
                ss = SetEnv.DirPath + SetEnv.fSep + ss;
            }
            s = "source(\"" + ss + "\");";
        }
        if (s.startsWith("source") && (suc = Alias.aliasMacro(s))) {
            s = "source(\"tmp.bsh\");";
        }
        if (s.startsWith("!")) {
            s = s.substring(1, s.length());
            s = "exec(\"" + s + "\");";
        }
        if (!s.endsWith(";")) {
            s = s + ";";
        }
        return s;
    }
}

