/*
 * Decompiled with CFR 0.152.
 */
package jehep.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jehep.ui.Constants;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;
import jehep.utils.Utils;

public class ReplaceDialog
extends JDialog
implements ActionListener,
ItemListener,
Constants {
    private static final long serialVersionUID = 1L;
    private mainGUI window;
    private JButton jbtFind;
    private JButton jbtReplace;
    private JButton jbtNext;
    private JButton jbtAll;
    private JButton Cancel;
    private JTextField jtf;
    private JTextField jtf2;
    private String tempstr;
    private String tempstr2;
    private String findstr;
    private String findstr2;
    private JCheckBox jcheck;
    private JCheckBox jcheck2;
    private JCheckBox jcheck3;
    private boolean ignoreCase;
    private boolean wholeWord;
    private boolean wrap;
    private boolean runFind;
    private boolean replaceAll;
    private boolean replace;
    private boolean replaceFinished = false;
    private int pos = 0;
    private int counter = 0;
    private int marker;
    private int lastpos = 0;
    private Utils Utils;
    private JComboBox jcb;
    private JComboBox jcb2;

    public ReplaceDialog(mainGUI window) {
        super(window, "Search and Replace", false);
        this.window = window;
        this.setResizable(false);
        this.Utils = new Utils(window);
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min(350, res.width), Math.min(200, res.height));
        this.setSize(size);
        this.jcheck = new JCheckBox("Ignor case");
        this.jcheck.addItemListener(this);
        this.jcheck.setFont(SetEnv.guiFont);
        this.jcheck2 = new JCheckBox("Whole word");
        this.jcheck2.addItemListener(this);
        this.jcheck2.setFont(SetEnv.guiFont);
        this.jcheck3 = new JCheckBox("Wrap");
        this.jcheck3.addItemListener(this);
        this.jcheck3.setFont(SetEnv.guiFont);
        JPanel topbutPanel = new JPanel();
        topbutPanel.setLayout(new FlowLayout(1));
        this.jbtNext = this.createButton("Find Next");
        topbutPanel.add(this.jbtNext);
        this.jbtReplace = this.createButton("Replace");
        topbutPanel.add(this.jbtReplace);
        this.jbtAll = this.createButton("All");
        topbutPanel.add(this.jbtAll);
        this.jbtNext.setPreferredSize(new Dimension(110, 24));
        this.jbtReplace.setPreferredSize(new Dimension(70, 24));
        this.jbtAll.setPreferredSize(new Dimension(70, 24));
        JPanel botbutPanel = new JPanel();
        botbutPanel.setLayout(new FlowLayout(0));
        this.Cancel = this.createButton("Exit");
        botbutPanel.add(this.Cancel);
        botbutPanel.add(this.jcheck);
        botbutPanel.add(this.jcheck2);
        this.jbtReplace.setToolTipText("Replace Word");
        this.jbtNext.setToolTipText("Find Next Word");
        this.jbtAll.setToolTipText("Replace All Words");
        this.Cancel.setToolTipText("Close Window");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 1));
        buttonPane.add(Box.createVerticalGlue());
        buttonPane.add(topbutPanel);
        buttonPane.add(Box.createVerticalGlue());
        buttonPane.add(botbutPanel);
        this.getContentPane().add((Component)buttonPane, "South");
        JPanel dataPane = new JPanel();
        dataPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagLayout gbLayout = new GridBagLayout();
        dataPane.setLayout(gbLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel findlabel = new JLabel("   Find..              ");
        JLabel replacelabel = new JLabel("                      ..Replace with");
        findlabel.setFont(SetEnv.guiFont);
        replacelabel.setFont(SetEnv.guiFont);
        JPanel Labels = new JPanel();
        Labels.setLayout(new FlowLayout(1));
        Labels.add(findlabel);
        Labels.add(replacelabel);
        this.getContentPane().add((Component)Labels, "North");
        JPanel txtField = new JPanel();
        this.jcb = new JComboBox();
        txtField.add(this.jcb);
        this.jcb2 = new JComboBox();
        txtField.add(this.jcb2);
        gbLayout.setConstraints(txtField, constraints);
        dataPane.add(txtField);
        this.jcb.setFont(SetEnv.guiFont);
        this.jcb2.setFont(SetEnv.guiFont);
        this.jcb.setEditable(true);
        this.jcb.setPreferredSize(new Dimension(130, 18));
        this.jtf = new JTextField();
        KeyHandler handler = new KeyHandler();
        this.jtf = (JTextField)this.jcb.getEditor().getEditorComponent();
        this.jtf.addKeyListener(handler);
        this.jcb2.setEditable(true);
        this.jcb2.setPreferredSize(new Dimension(130, 18));
        this.jtf2 = new JTextField();
        this.jtf2 = (JTextField)this.jcb2.getEditor().getEditorComponent();
        this.getContentPane().add((Component)dataPane, "Center");
        this.pack();
        this.setVisible(false);
        this.setFont(SetEnv.guiFont);
        this.ignoreCase = false;
        this.findstr = " ";
        this.findstr2 = " ";
        this.wrap = true;
        this.replaceAll = false;
    }

    void disableRep() {
        this.jbtReplace.setEnabled(false);
    }

    JButton createButton(String label) {
        JButton button = new JButton(label);
        button.setFont(SetEnv.guiFont);
        button.setPreferredSize(new Dimension(80, 18));
        button.addActionListener(this);
        return button;
    }

    public void getSelectedText() {
        String s = this.window.getSelectedText();
        if (s != null && s != "") {
            s.trim();
            int x = this.jcb.getItemCount();
            boolean match = false;
            for (int i = 0; i < x; ++i) {
                if (!this.jtf.getText().equals(s)) continue;
                match = true;
            }
            if (!match) {
                this.jcb.insertItemAt(this.makeObj(s), 0);
                this.jcb.setSelectedIndex(0);
            }
        }
    }

    private Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    public void addItemToBox() {
        int x = this.jcb.getItemCount();
        boolean match = false;
        for (int i = 0; i < x; ++i) {
            if (!this.jtf.getText().equals(this.jcb.getItemAt(i).toString())) continue;
            match = true;
        }
        if (!match) {
            this.jcb.insertItemAt(this.makeObj(this.jtf.getText()), 0);
        }
    }

    public void addItemToBox2() {
        int x = this.jcb2.getItemCount();
        boolean match = false;
        for (int i = 0; i < x; ++i) {
            if (!this.jtf2.getText().equals(this.jcb2.getItemAt(i).toString())) continue;
            match = true;
        }
        if (!match) {
            this.jcb2.insertItemAt(this.makeObj(this.jtf2.getText()), 0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.ignoreCase = this.jcheck.isSelected();
        this.wholeWord = this.jcheck2.isSelected();
        this.wrap = this.jcheck3.isSelected();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean FindNext() {
        String str;
        String s;
        int a;
        block12: {
            block11: {
                a = 0;
                s = this.window.GetText();
                if (this.jtf.getText().equals("")) break block11;
                if (this.jtf.getText() != null) break block12;
            }
            jehep.utils.Utils.userMessage("Nothing to search for", "Nothing to search for", 2);
            return false;
        }
        this.findstr = this.jtf.getText();
        this.addItemToBox();
        if (this.ignoreCase) {
            s = s.toLowerCase();
            str = this.findstr.toLowerCase();
        } else {
            str = this.findstr;
        }
        if (this.wholeWord) {
            str = " " + str + " ";
        } else {
            str.trim();
        }
        if (str != null) {
            a = str.length();
            this.pos = s.indexOf(str, this.window.getCaretPosition());
            this.lastpos = s.lastIndexOf(str);
            this.window.RequestFocus();
            if (this.pos != -1) {
                this.window.select(this.pos, this.pos + this.findstr.length());
                return true;
            }
            if (this.wrap) {
                this.pos = s.indexOf(this.findstr, 0);
                this.window.select(this.pos, this.pos + this.findstr.length());
                return true;
            }
            jehep.utils.Utils.userMessage("Not Found", this.findstr + " not found", 1);
            return false;
        }
        if (!this.replaceAll) {
            jehep.utils.Utils.userMessage("String not found", "String '" + this.findstr + "' not found", 2);
            return false;
        }
        jehep.utils.Utils.userMessage("Finished", "Search and Replace finished " + new String(Integer.toString(this.counter)) + " occurences replaced.", 2);
        this.counter = 0;
        return false;
    }

    private void Replace() {
        this.findstr2 = this.jtf2.getText().equals("") || this.jtf2.getText() == null ? " " : this.jtf2.getText();
        if (this.findstr != null) {
            this.window.RequestFocus();
            String t = this.findstr2;
            String str = this.findstr;
            if (t != null) {
                try {
                    if (this.wholeWord) {
                        this.window.replaceSelection(t);
                    } else {
                        this.window.replaceSelection(t);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error performing replace: " + ex.getMessage());
                    jehep.utils.Utils.userMessage("Error", "An error has occured, please see error log.", 1);
                    jehep.utils.Utils.writeErrorLog("Error performing replace " + ex.getMessage());
                }
            }
            if (!this.replaceAll) {
                this.FindNext();
                this.window.RequestFocus();
            }
        }
    }

    private void ReplaceAll() {
        if (this.window.getSelectedText() == null || this.window.getSelectedText().equals("")) {
            this.FindNext();
        }
        while (this.FindNext()) {
            this.Replace();
            ++this.counter;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.jbtNext) {
            this.FindNext();
        } else if (source == this.jbtReplace) {
            this.Replace();
        } else if (source == this.jbtAll) {
            this.replaceAll = true;
            this.ReplaceAll();
            this.replaceAll = false;
        } else if (source == this.Cancel) {
            this.setVisible(false);
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            switch (evt.getKeyCode()) {
                case 10: {
                    if (evt.getSource() == ReplaceDialog.this.jtf) {
                        ReplaceDialog.this.FindNext();
                    }
                }
                case 27: {
                    ReplaceDialog.this.setVisible(false);
                }
            }
        }
    }
}

