/*
 * Decompiled with CFR 0.152.
 */
package jehep.gnu.regexp;

import jehep.gnu.regexp.CharIndexed;
import jehep.gnu.regexp.REMatch;
import jehep.gnu.regexp.REToken;

final class RETokenPOSIX
extends REToken {
    int type;
    boolean insens;
    boolean negated;
    static final int ALNUM = 0;
    static final int ALPHA = 1;
    static final int BLANK = 2;
    static final int CNTRL = 3;
    static final int DIGIT = 4;
    static final int GRAPH = 5;
    static final int LOWER = 6;
    static final int PRINT = 7;
    static final int PUNCT = 8;
    static final int SPACE = 9;
    static final int UPPER = 10;
    static final int XDIGIT = 11;
    static final String[] s_nameTable = new String[]{"alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit"};

    static int intValue(String key) {
        for (int i = 0; i < s_nameTable.length; ++i) {
            if (!s_nameTable[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    RETokenPOSIX(int subIndex, int type, boolean insens, boolean negated) {
        super(subIndex);
        this.type = type;
        this.insens = insens;
        this.negated = negated;
    }

    @Override
    int getMinimumLength() {
        return 1;
    }

    @Override
    boolean match(CharIndexed input, REMatch mymatch) {
        char ch = input.charAt(mymatch.index);
        if (ch == '\uffff') {
            return false;
        }
        boolean retval = false;
        switch (this.type) {
            case 0: {
                retval = Character.isLetterOrDigit(ch) || ch == '_';
                break;
            }
            case 1: {
                retval = Character.isLetter(ch);
                break;
            }
            case 2: {
                retval = ch == ' ' || ch == '\t';
                break;
            }
            case 3: {
                retval = Character.isISOControl(ch);
                break;
            }
            case 4: {
                retval = Character.isDigit(ch);
                break;
            }
            case 5: {
                retval = !Character.isWhitespace(ch) && !Character.isISOControl(ch);
                break;
            }
            case 6: {
                retval = this.insens && Character.isLetter(ch) || Character.isLowerCase(ch);
                break;
            }
            case 7: {
                retval = !Character.isWhitespace(ch) && !Character.isISOControl(ch) || ch == ' ';
                break;
            }
            case 8: {
                retval = "`~!@#$%^&*()-_=+[]{}\\|;:'\"/?,.<>".indexOf(ch) != -1;
                break;
            }
            case 9: {
                retval = Character.isWhitespace(ch);
                break;
            }
            case 10: {
                retval = this.insens && Character.isLetter(ch) || Character.isUpperCase(ch);
                break;
            }
            case 11: {
                boolean bl = retval = Character.isDigit(ch) || "abcdefABCDEF".indexOf(ch) != -1;
            }
        }
        if (this.negated) {
            boolean bl = retval = !retval;
        }
        if (retval) {
            ++mymatch.index;
            return this.next(input, mymatch);
        }
        return false;
    }

    @Override
    void dump(StringBuffer os) {
        if (this.negated) {
            os.append('^');
        }
        os.append("[:" + s_nameTable[this.type] + ":]");
    }
}

