/*
 * Decompiled with CFR 0.152.
 */
package jehep.gnu.regexp;

import java.io.FilterInputStream;
import java.io.InputStream;
import jehep.gnu.regexp.CharIndexedInputStream;
import jehep.gnu.regexp.RE;
import jehep.gnu.regexp.REMatch;

public class REFilterInputStream
extends FilterInputStream {
    private RE expr;
    private String replace;
    private String buffer;
    private int bufpos;
    private int offset;
    private CharIndexedInputStream stream;

    public REFilterInputStream(InputStream stream, RE expr, String replace) {
        super(stream);
        this.stream = new CharIndexedInputStream(stream, 0);
        this.expr = expr;
        this.replace = replace;
    }

    @Override
    public int read() {
        char ch;
        if (this.buffer != null && this.bufpos < this.buffer.length()) {
            return this.buffer.charAt(this.bufpos++);
        }
        if (!this.stream.isValid()) {
            return -1;
        }
        REMatch mymatch = new REMatch(this.expr.getNumSubs(), this.offset, 0);
        if (this.expr.match(this.stream, mymatch)) {
            mymatch.end[0] = mymatch.index;
            mymatch.finish(this.stream);
            this.stream.move(mymatch.toString().length());
            this.offset += mymatch.toString().length();
            this.buffer = mymatch.substituteInto(this.replace);
            this.bufpos = 1;
            if (this.buffer.length() > 0) {
                return this.buffer.charAt(0);
            }
        }
        if ((ch = this.stream.charAt(0)) == '\uffff') {
            return -1;
        }
        this.stream.move(1);
        ++this.offset;
        return ch;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int ok = 0;
        while (len-- > 0) {
            int i = this.read();
            if (i == -1) {
                return ok == 0 ? -1 : ok;
            }
            b[off++] = (byte)i;
            ++ok;
        }
        return ok;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }
}

