/*
 * Decompiled with CFR 0.152.
 */
package jehep.completion;

import com.vlsolutions.swing.table.VLJTable;
import com.vlsolutions.swing.table.filters.RegExpFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import jehep.completion.DescribeDialog;
import jehep.completion.Global;
import jehep.ui.Editor;

public class JEHEPtable
extends JFrame {
    private static final long serialVersionUID = 1L;
    private VLJTable table;
    private JButton closeButton;
    private JButton filter;
    private JPanel control;
    private DescribeDialog desc = new DescribeDialog(this);
    private JPopupMenu menu;
    private static int rowIndex;
    private JFrame win;
    private int colNamesSize = 0;

    public JEHEPtable(String explanation, Vector<String> colNames, Vector fillnames) {
        this.buildTable(explanation, colNames, fillnames);
    }

    private void buildTable(String explanation, Vector<String> colNames, Vector fillnames) {
        this.setTitle("Code Assist");
        this.setDefaultCloseOperation(2);
        JPanel panel = new JPanel(new GridBagLayout());
        this.getContentPane().add(panel);
        this.colNamesSize = colNames.size();
        this.table = new VLJTable(){
            public static final long serialVersionUID = 125L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                Color colcell = new Color(240, 255, 255);
                if (rowIndex % 2 == 0 && !this.isCellSelected(rowIndex, vColIndex)) {
                    c.setBackground(colcell);
                } else {
                    c.setBackground(this.getBackground());
                }
                c.setForeground(Color.black);
                if (this.isCellSelected(rowIndex, vColIndex)) {
                    c.setBackground(Color.blue);
                    c.setForeground(Color.white);
                }
                return c;
            }
        };
        DefaultTableModel model = new DefaultTableModel(fillnames, colNames){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.table.setModel(model);
        this.table.setFilteringEnabled(true);
        this.table.setPopUpSelectorEnabled(true);
        this.table.getPopUpSelector().setCaseSensitive(false);
        for (int i = 0; i < this.colNamesSize; ++i) {
            this.table.installFilter(i, new RegExpFilter(true));
        }
        this.menu = new JPopupMenu();
        JMenuItem idescribe = new JMenuItem("describe");
        JMenuItem icopy = new JMenuItem("push");
        this.menu.add(idescribe);
        this.menu.add(icopy);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    Point p = evt.getPoint();
                    rowIndex = JEHEPtable.this.table.rowAtPoint(p);
                    Object tmp = JEHEPtable.this.table.getValueAt(rowIndex, 0);
                    String ss = tmp.toString();
                    JEHEPtable.this.insertLine(ss);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    JEHEPtable.this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    JEHEPtable.this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        icopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int rowIndex = JEHEPtable.this.table.getSelectedRow();
                Object tmp = JEHEPtable.this.table.getValueAt(rowIndex, 0);
                String ss = tmp.toString();
                JEHEPtable.this.insertLine(ss);
            }
        });
        idescribe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int rowIndex = JEHEPtable.this.table.getSelectedRow();
                if (rowIndex > -1) {
                    Object tmp = JEHEPtable.this.table.getValueAt(rowIndex, 0);
                    String ss1 = tmp.toString();
                    if (JEHEPtable.this.colNamesSize > 1) {
                        tmp = JEHEPtable.this.table.getValueAt(rowIndex, 1);
                        String ss2 = tmp.toString();
                        tmp = JEHEPtable.this.table.getValueAt(rowIndex, 2);
                        String ss3 = tmp.toString();
                        JEHEPtable.this.desc.showIt(Global.getDescription(ss1, ss3));
                    } else {
                        JEHEPtable.this.ErrorMessage("This feature is not implemented for Jython objects");
                    }
                }
            }
        });
        this.filter = new JButton(new ImageIcon(this.getClass().getResource("/com/vlsolutions/swing/table/filter16.png")));
        this.filter.setMargin(new Insets(2, 2, 2, 2));
        this.filter.setRolloverEnabled(true);
        this.filter.setToolTipText("Filter");
        this.filter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JEHEPtable.this.table.setFilterHeaderVisible(!JEHEPtable.this.table.isFilterHeaderVisible());
            }
        });
        this.closeButton = new JButton(new ImageIcon(this.getClass().getResource("/com/images/Close.png")));
        this.closeButton.setToolTipText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JEHEPtable.this.setVisible(false);
                JEHEPtable.this.dispose();
            }
        });
        this.closeButton.setMargin(new Insets(2, 2, 2, 2));
        this.closeButton.setRolloverEnabled(true);
        GridBagConstraints gc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(12, 5, 5, 5), 0, 0);
        String explanations = "<html><body><h2>" + explanation + "</h2></body></html>";
        panel.add((Component)new JLabel(explanations), gc);
        ++gc.gridy;
        gc.gridwidth = 1;
        gc.anchor = 18;
        this.control = new JPanel();
        this.control.setPreferredSize(new Dimension(24, 60));
        this.control.setMaximumSize(new Dimension(24, 60));
        this.control.setMinimumSize(new Dimension(24, 60));
        this.control.setLayout(new GridLayout(2, 0, 0, 24));
        this.control.add(this.filter);
        this.control.add(this.closeButton);
        panel.add((Component)this.control, gc);
        ++gc.gridx;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.fill = 1;
        panel.add((Component)new JScrollPane(this.table), gc);
        this.table.setFilterHeaderVisible(true);
        this.pack();
        this.setVisible(true);
    }

    private void insertLine(String s) {
        int pos = Editor.getCaretPos();
        Editor.insetText(s, pos);
    }

    private void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }
}

