/*
 * Decompiled with CFR 0.152.
 */
package jabref.groups;

import jabref.groups.GroupSelector;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;

class UndoableAddOrRemoveGroup
extends AbstractUndoableEdit {
    private Vector groups;
    private int index;
    private boolean addition;
    private String name;
    private String regexp;
    private String field;
    private GroupSelector gs;
    private boolean revalidate = true;

    public UndoableAddOrRemoveGroup(GroupSelector gs, Vector groups, int index, boolean addition, String field, String name, String regexp) {
        this.gs = gs;
        this.addition = addition;
        this.groups = groups;
        this.index = index;
        this.name = name;
        this.regexp = regexp;
        this.field = field;
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo: " + (this.addition ? "add group" : "remove group");
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo: " + (this.addition ? "add group" : "remove group");
    }

    @Override
    public void undo() {
        super.undo();
        this.doOperation(!this.addition);
    }

    @Override
    public void redo() {
        super.redo();
        this.doOperation(this.addition);
    }

    private void doOperation(boolean add) {
        if (add) {
            this.groups.add(this.index, this.regexp);
            this.groups.add(this.index, this.name);
            this.groups.add(this.index, this.field);
        } else {
            for (int i = 0; i < 3; ++i) {
                this.groups.removeElementAt(this.index);
            }
        }
        if (this.revalidate) {
            this.gs.revalidateList();
        }
    }

    public void setRevalidate(boolean val) {
        this.revalidate = val;
    }
}

