/*
 * Decompiled with CFR 0.152.
 */
package jabref.export.layout;

import jabref.export.layout.Layout;
import jabref.wsi.ra.types.StringInt;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Vector;

public class LayoutHelper {
    public static final int IS_LAYOUT_TEXT = 1;
    public static final int IS_SIMPLE_FIELD = 2;
    public static final int IS_FIELD_START = 3;
    public static final int IS_FIELD_END = 4;
    public static final int IS_OPTION_FIELD = 5;
    private PushbackReader _in;
    private Vector parsedEntries = new Vector();
    private boolean _eof = false;
    private int line = 1;

    public LayoutHelper(Reader in) {
        if (in == null) {
            throw new NullPointerException();
        }
        this._in = new PushbackReader(in);
    }

    public Layout getLayoutFromText() throws IOException {
        this.parse();
        for (int i = 0; i < this.parsedEntries.size(); ++i) {
            StringInt si = (StringInt)this.parsedEntries.get(i);
            if (si.i != 2 && si.i != 3 && si.i != 4) continue;
            si.s = si.s.trim().toLowerCase();
        }
        Layout layout = new Layout(this.parsedEntries);
        return layout;
    }

    private String getBracketedField(int _field) throws IOException {
        StringBuffer buffer = null;
        int previous = -1;
        boolean start = false;
        while (!this._eof) {
            int c = this.read();
            if (c == -1) {
                this._eof = true;
                if (buffer != null) {
                    this.parsedEntries.add(new StringInt(buffer.toString(), _field));
                }
                return null;
            }
            if (c == 123 || c == 125) {
                if (c == 125) {
                    if (buffer != null) {
                        this.parsedEntries.add(new StringInt(buffer.toString(), _field));
                        return null;
                    }
                } else {
                    start = true;
                }
            } else {
                if (buffer == null) {
                    buffer = new StringBuffer(100);
                }
                if (start && c != 125) {
                    buffer.append((char)c);
                }
            }
            previous = c;
        }
        return null;
    }

    private String getBracketedOptionField(int _field) throws IOException {
        StringBuffer buffer = null;
        int previous = -1;
        boolean start = false;
        String option = null;
        while (!this._eof) {
            int c = this.read();
            if (c == -1) {
                this._eof = true;
                if (buffer != null) {
                    String tmp = option != null ? buffer.toString() + "\n" + option : buffer.toString();
                    this.parsedEntries.add(new StringInt(tmp, 5));
                }
                return null;
            }
            if (c == 123 || c == 125 || c == 93 || c == 91) {
                if (c == 125 || c == 93) {
                    if (buffer != null) {
                        if (c == 93) {
                            option = buffer.toString();
                            buffer = null;
                            start = false;
                        }
                        if (buffer != null) {
                            String tmp = option != null ? buffer.toString() + "\n" + option : buffer.toString();
                            this.parsedEntries.add(new StringInt(tmp, 5));
                            return null;
                        }
                    }
                } else {
                    start = true;
                }
            } else {
                if (buffer == null) {
                    buffer = new StringBuffer(100);
                }
                if (start && c != 125 && c != 93 && c != 92) {
                    buffer.append((char)c);
                }
            }
            previous = c;
        }
        return null;
    }

    private Object parse() throws IOException {
        this.skipWhitespace();
        StringBuffer buffer = null;
        int previous = -1;
        while (!this._eof) {
            int c = this.read();
            if (c == -1) {
                this._eof = true;
                this.parsedEntries.add(new StringInt(buffer.toString(), 1));
                return null;
            }
            if (c == 92 && this.peek() != 92 && previous != 92) {
                if (buffer != null) {
                    this.parsedEntries.add(new StringInt(buffer.toString(), 1));
                    buffer = null;
                }
                this.parseField();
            } else {
                if (buffer == null) {
                    buffer = new StringBuffer(100);
                }
                if (c != 92 || previous != 92) {
                    buffer.append((char)c);
                }
            }
            previous = c;
        }
        return null;
    }

    private void parseField() throws IOException {
        StringBuffer buffer = null;
        while (!this._eof) {
            int c = this.read();
            if (c == -1) {
                this._eof = true;
            }
            if (!Character.isLetter((char)c)) {
                this.unread(c);
                String name = buffer.toString();
                buffer = null;
                if (name.charAt(0) == 'b') {
                    if (name.equalsIgnoreCase("begin")) {
                        this.getBracketedField(3);
                        return;
                    }
                } else if (name.charAt(0) == 'f') {
                    if (name.equalsIgnoreCase("format")) {
                        if (c == 91) {
                            this.getBracketedOptionField(5);
                            return;
                        }
                        this.getBracketedField(5);
                        return;
                    }
                } else if (name.charAt(0) == 'e' && name.equalsIgnoreCase("end")) {
                    this.getBracketedField(4);
                    return;
                }
                this.parsedEntries.add(new StringInt(name, 2));
                return;
            }
            if (buffer == null) {
                buffer = new StringBuffer(100);
            }
            buffer.append((char)c);
        }
    }

    private int peek() throws IOException {
        int c = this.read();
        this.unread(c);
        return c;
    }

    private int read() throws IOException {
        int c = this._in.read();
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    private void skipWhitespace() throws IOException {
        int c;
        do {
            if ((c = this.read()) != -1 && c != 65535) continue;
            this._eof = true;
            return;
        } while (Character.isWhitespace((char)c));
        this.unread(c);
    }

    private void unread(int c) throws IOException {
        if (c == 10) {
            --this.line;
        }
        this._in.unread(c);
    }
}

