/*
 * Decompiled with CFR 0.152.
 */
package jabref.export;

import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.BibtexString;
import jabref.CrossRefEntryComparator;
import jabref.EntryComparator;
import jabref.EntrySorter;
import jabref.GUIGlobals;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import jabref.MetaData;
import jabref.export.LatexFieldFormatter;
import jabref.export.SaveException;
import jabref.export.layout.Layout;
import jabref.export.layout.LayoutHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class FileActions {
    private static void initFile(File file2, boolean backup) throws IOException {
        String name = file2.getName();
        String path = file2.getParent();
        File temp = new File(path, name + GUIGlobals.tempExt);
        if (backup) {
            File back = new File(path, name + GUIGlobals.backupExt);
            if (back.exists()) {
                back.renameTo(temp);
            }
            if (file2.exists()) {
                file2.renameTo(back);
            }
            if (temp.exists()) {
                temp.delete();
            }
        } else if (file2.exists()) {
            file2.renameTo(temp);
        }
    }

    private static void writePreamble(Writer fw, String preamble) throws IOException {
        if (preamble != null) {
            fw.write("@PREAMBLE{");
            fw.write(preamble);
            fw.write("}\n\n");
        }
    }

    private static void writeStrings(Writer fw, BibtexDatabase database) throws IOException {
        for (int i = 0; i < database.getStringCount(); ++i) {
            BibtexString bs = database.getString(i);
            fw.write("@STRING{" + bs.getName() + " = ");
            if (!bs.getContent().equals("")) {
                fw.write(new LatexFieldFormatter().format(bs.getContent(), true));
            } else {
                fw.write("{}");
            }
            fw.write("}\n\n");
        }
    }

    public static void repairAfterError(File file2) {
        String name = file2.getName();
        String path = file2.getParent();
        File temp = new File(path, name + GUIGlobals.tempExt);
        File back = new File(path, name + GUIGlobals.backupExt);
        if (file2.exists()) {
            file2.delete();
        }
        if (temp.exists()) {
            temp.renameTo(file2);
        } else {
            back.renameTo(file2);
        }
    }

    public static void saveDatabase(BibtexDatabase database, MetaData metaData, File file2, JabRefPreferences prefs2, boolean checkSearch, boolean checkGroup) throws SaveException {
        BibtexEntry be2 = null;
        try {
            FileActions.initFile(file2, prefs2.getBoolean("backup"));
            FileWriter fw = new FileWriter(file2);
            fw.write(GUIGlobals.SIGNATURE);
            FileActions.writePreamble(fw, database.getPreamble());
            FileActions.writeStrings(fw, database);
            String pri = prefs2.get("priSort");
            String sec = prefs2.get("secSort");
            String ter = prefs2.get("terSort");
            TreeSet<BibtexEntry> sorter = new TreeSet<BibtexEntry>(new CrossRefEntryComparator(new EntryComparator(prefs2.getBoolean("priDescending"), prefs2.getBoolean("secDescending"), prefs2.getBoolean("terDescending"), pri, sec, ter)));
            Set keySet = database.getKeySet();
            if (keySet != null) {
                Iterator i = keySet.iterator();
                while (i.hasNext()) {
                    sorter.add(database.getEntryById((String)i.next()));
                }
            }
            LatexFieldFormatter ff = new LatexFieldFormatter();
            for (BibtexEntry be2 : sorter) {
                boolean write = true;
                if (checkSearch && !FileActions.nonZeroField(be2, "__search")) {
                    write = false;
                }
                if (checkGroup && !FileActions.nonZeroField(be2, "__groupsearch")) {
                    write = false;
                }
                if (!write) continue;
                be2.write(fw, ff, true);
                fw.write("\n");
            }
            if (metaData != null) {
                metaData.writeMetaData(fw);
            }
            fw.close();
        }
        catch (Throwable ex) {
            FileActions.repairAfterError(file2);
            throw new SaveException(ex.getMessage(), be2);
        }
    }

    public static void savePartOfDatabase(BibtexDatabase database, MetaData metaData, File file2, JabRefPreferences prefs2, BibtexEntry[] bes) throws SaveException {
        BibtexEntry be2 = null;
        try {
            FileActions.initFile(file2, prefs2.getBoolean("backup"));
            FileWriter fw = new FileWriter(file2);
            fw.write(GUIGlobals.SIGNATURE);
            FileActions.writePreamble(fw, database.getPreamble());
            FileActions.writeStrings(fw, database);
            String pri = prefs2.get("priSort");
            String sec = prefs2.get("secSort");
            String ter = prefs2.get("terSort");
            TreeSet<BibtexEntry> sorter = new TreeSet<BibtexEntry>(new CrossRefEntryComparator(new EntryComparator(prefs2.getBoolean("priDescending"), prefs2.getBoolean("secDescending"), prefs2.getBoolean("terDescending"), pri, sec, ter)));
            if (bes != null && bes.length > 0) {
                for (int i = 0; i < bes.length; ++i) {
                    sorter.add(bes[i]);
                }
            }
            LatexFieldFormatter ff = new LatexFieldFormatter();
            for (BibtexEntry be2 : sorter) {
                be2.write(fw, ff, true);
                fw.write("\n");
            }
            if (metaData != null) {
                metaData.writeMetaData(fw);
            }
            fw.close();
        }
        catch (Throwable ex) {
            FileActions.repairAfterError(file2);
            throw new SaveException(ex.getMessage(), be2);
        }
    }

    public static void exportDatabase(BibtexDatabase database, String lfName, File outFile, JabRefPreferences prefs2) throws IOException {
        PrintStream ps = null;
        try {
            int c;
            InputStreamReader reader;
            Object[] keys = database.getKeySet().toArray();
            ps = new PrintStream(new FileOutputStream(outFile));
            URL reso = JabRefFrame.class.getResource("/jabref/resource/layout/" + lfName + ".begin.layout");
            if (reso != null) {
                reader = new InputStreamReader(reso.openStream());
                while ((c = reader.read()) != -1) {
                    ps.write((char)c);
                }
                reader.close();
            }
            String pri = prefs2.get("priSort");
            String sec = prefs2.get("secSort");
            String ter = prefs2.get("terSort");
            EntrySorter sorter = database.getSorter(new EntryComparator(prefs2.getBoolean("priDescending"), prefs2.getBoolean("secDescending"), prefs2.getBoolean("terDescending"), pri, sec, ter));
            reso = JabRefFrame.class.getResource("/jabref/resource/layout/" + lfName + ".layout");
            reader = new InputStreamReader(reso.openStream());
            LayoutHelper layoutHelper = new LayoutHelper(reader);
            Layout defLayout = layoutHelper.getLayoutFromText();
            HashMap<String, Layout> layouts = new HashMap<String, Layout>();
            for (int i = 0; i < sorter.getEntryCount(); ++i) {
                Layout layout;
                String key = sorter.getIdAt(i);
                BibtexEntry entry = database.getEntryById(key);
                String type = entry.getType().getName().toLowerCase();
                if (layouts.containsKey(type)) {
                    layout = (Layout)layouts.get(type);
                } else {
                    reso = JabRefFrame.class.getResource("/jabref/resource/layout/" + lfName + "." + type + ".layout");
                    if (reso != null) {
                        reader = new InputStreamReader(reso.openStream());
                        layoutHelper = new LayoutHelper(reader);
                        layout = layoutHelper.getLayoutFromText();
                        layouts.put(type, layout);
                    } else {
                        layout = defLayout;
                    }
                }
                ps.println(layout.doLayout(entry));
            }
            reso = JabRefFrame.class.getResource("/jabref/resource/layout/" + lfName + ".end.layout");
            if (reso != null) {
                reader = new InputStreamReader(reso.openStream());
                while ((c = reader.read()) != -1) {
                    ps.write((char)c);
                }
                reader.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static boolean nonZeroField(BibtexEntry be, String field) {
        String o = (String)be.getField(field);
        return o != null && !o.equals("0");
    }
}

