/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.BibtexEntryType;
import jabref.JabRefPreferences;
import jabref.imports.ImportFormatReader;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JDialog;

public class Util {
    public static Color fieldsCol = new Color(180, 180, 200);
    static final int TYPE_MISMATCH = -1;
    static final int NOT_EQUAL = 0;
    static final int EQUAL = 1;
    static final int EMPTY_IN_ONE = 2;
    static final int EMPTY_IN_TWO = 3;
    private static int idCounter = 0;

    public static void bool(boolean b) {
        if (b) {
            System.out.println("true");
        } else {
            System.out.println("false");
        }
    }

    public static void pr(String s) {
        System.out.println(s);
    }

    public static void pr_(String s) {
        System.out.print(s);
    }

    public static String nCase(String s) {
        if (s.length() > 1) {
            return s.substring(0, 1).toUpperCase() + s.substring(1, s.length()).toLowerCase();
        }
        return s.toUpperCase();
    }

    public static String checkName(String s) {
        String extension = s.substring(s.length() - 4);
        if (!extension.equalsIgnoreCase(".bib")) {
            return s + ".bib";
        }
        return s;
    }

    public static String createId(BibtexEntryType type, BibtexDatabase database) {
        String s;
        while (database.getEntryById(s = type.getName() + new Integer((int)(Math.random() * 10000.0)).toString()) != null) {
        }
        return s;
    }

    public static String createNeutralId() {
        return "" + idCounter++;
    }

    public static void placeDialog(JDialog diag, Container win) {
        Dimension ds = diag.getSize();
        Dimension df = win.getSize();
        Point pf = win.getLocation();
        diag.setLocation(new Point(Math.max(0, pf.x + (df.width - ds.width) / 2), Math.max(0, pf.y + (df.height - ds.height) / 2)));
    }

    public static String parseField(String content) {
        if (content.length() == 0) {
            return "";
        }
        String toSet = "";
        int hash = content.indexOf(35);
        int wr1 = content.indexOf(34);
        int wr2 = content.indexOf(123);
        int end2 = content.length();
        if (hash == -1) {
            hash = end2;
        }
        if (wr1 == -1) {
            wr1 = end2;
        }
        if (wr2 == -1) {
            wr2 = end2;
        }
        boolean string = wr1 == end2 && wr2 == end2 || hash < Math.min(wr1, wr2);
        StringTokenizer tok = new StringTokenizer(content, "#", true);
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (str.equals("#")) {
                string = !string;
                continue;
            }
            if (string) {
                String s = Util.shaveString(str);
                try {
                    Integer.parseInt(s);
                    toSet = toSet + s;
                }
                catch (NumberFormatException ex) {
                    toSet = toSet + "#" + Util.shaveString(str) + "#";
                }
                continue;
            }
            toSet = toSet + Util.shaveString(str);
        }
        return toSet;
    }

    public static String shaveString(String s) {
        if (s == null) {
            return null;
        }
        char ch = '\u0000';
        char ch2 = '\u0000';
        int beg = 0;
        int end2 = s.length();
        boolean begok = false;
        boolean endok = false;
        boolean braok = false;
        while (!begok) {
            if (beg < s.length()) {
                ch = s.charAt(beg);
                if (Character.isWhitespace(ch)) {
                    ++beg;
                    continue;
                }
                begok = true;
                continue;
            }
            begok = true;
        }
        while (!endok) {
            if (end2 > beg + 1) {
                ch = s.charAt(end2 - 1);
                if (Character.isWhitespace(ch)) {
                    --end2;
                    continue;
                }
                endok = true;
                continue;
            }
            endok = true;
        }
        if (end2 > beg + 1) {
            ch = s.charAt(beg);
            ch2 = s.charAt(end2 - 1);
            if (ch == '{' && ch2 == '}' || ch == '\"' && ch2 == '\"') {
                ++beg;
                --end2;
            }
        }
        s = s.substring(beg, end2);
        return s;
    }

    public static String checkLegalKey(String key) {
        if (key == null) {
            return null;
        }
        StringBuffer newKey = new StringBuffer();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isWhitespace(c) || c == '#' || c == '{' || c == '}' || c == '~' || c == ',' || c == '^') continue;
            newKey.append(c);
        }
        return newKey.toString();
    }

    public static String wrap2(String in, int wrapAmount) {
        StringBuffer out = new StringBuffer(in.replaceAll("[ \\t\\n\\r]+", " "));
        int p = in.length() - wrapAmount;
        while (p > 0 && (p = out.lastIndexOf(" ", p)) > 0 && p > 20) {
            out.insert(p, "\n\t");
            p -= wrapAmount;
        }
        return out.toString();
    }

    public static HashSet findAllWordsInField(BibtexDatabase db, String field, String remove) {
        HashSet<String> res = new HashSet<String>();
        Iterator i = db.getKeySet().iterator();
        while (i.hasNext()) {
            BibtexEntry be = db.getEntryById(i.next().toString());
            Object o = be.getField(field);
            if (o == null) continue;
            StringTokenizer tok = new StringTokenizer(o.toString(), remove, false);
            while (tok.hasMoreTokens()) {
                res.add(tok.nextToken());
            }
        }
        return res;
    }

    public static String stringArrayToDelimited(String[] strs, String delimiter) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        if (strs.length == 1) {
            return strs[0];
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strs.length - 1; ++i) {
            sb.append(strs[i]);
            sb.append(delimiter);
        }
        sb.append(strs[strs.length - 1]);
        return sb.toString();
    }

    public static String[] delimToStringArray(String names, String delimiter) {
        if (names == null) {
            return null;
        }
        return names.split(delimiter);
    }

    public static void openExternalViewer(String link, String fieldName, JabRefPreferences prefs2) throws IOException {
        String[] cmdArray = new String[2];
        if (fieldName.equals("doi")) {
            cmdArray[0] = prefs2.get("htmlviewer");
            cmdArray[1] = "http://dx.doi.org/" + link;
            Process process = Runtime.getRuntime().exec(cmdArray);
        } else if (fieldName.equals("url")) {
            try {
                System.err.println("Starting HTML browser: " + prefs2.get("htmlviewer") + " " + link);
                cmdArray[0] = prefs2.get("htmlviewer");
                cmdArray[1] = link;
                Process process = Runtime.getRuntime().exec(cmdArray);
            }
            catch (IOException e) {
                System.err.println("An error occured on the command: " + prefs2.get("htmlviewer") + " " + link);
            }
        } else if (fieldName.equals("ps")) {
            try {
                System.err.println("Starting external viewer: " + prefs2.get("psviewer") + " " + link);
                cmdArray[0] = prefs2.get("psviewer");
                cmdArray[1] = link;
                Process e = Runtime.getRuntime().exec(cmdArray);
            }
            catch (IOException e) {
                System.err.println("An error occured on the command: " + prefs2.get("psviewer") + " " + link);
            }
        } else if (fieldName.equals("pdf")) {
            try {
                File f = new File(link);
                String dir2 = prefs2.get("pdfDirectory");
                if (!f.exists() && dir2 != null) {
                    link = dir2.endsWith(System.getProperty("file.separator")) ? dir2 + link : dir2 + System.getProperty("file.separator") + link;
                }
                System.err.println("Starting external viewer: " + prefs2.get("pdfviewer") + " " + link);
                cmdArray[0] = prefs2.get("pdfviewer");
                cmdArray[1] = link;
                Process process = Runtime.getRuntime().exec(cmdArray);
            }
            catch (IOException e) {
                System.err.println("An error occured on the command: " + prefs2.get("pdfviewer") + " " + link);
            }
        } else {
            System.err.println("Message: currently only PDF, PS and HTML files can be opened by double clicking");
        }
    }

    public static String findPdf(String key, String pdfDir) {
        String found;
        String filename = key + ".pdf";
        if (!pdfDir.endsWith(System.getProperty("file.separator"))) {
            pdfDir = pdfDir + System.getProperty("file.separator");
        }
        if ((found = Util.findInDir(filename, pdfDir)) != null) {
            return found.substring(pdfDir.length());
        }
        return null;
    }

    private static String findInDir(String file2, String dir2) {
        File f = new File(dir2, file2);
        if (f.exists()) {
            return f.getPath();
        }
        f = new File(dir2);
        File[] all = f.listFiles();
        if (all == null) {
            return null;
        }
        String found = null;
        for (int i = 0; i < all.length && found == null; ++i) {
            if (!all[i].isDirectory()) continue;
            found = Util.findInDir(file2, all[i].getPath());
        }
        return found;
    }

    public static boolean isDuplicate(BibtexEntry one, BibtexEntry two, float threshold) {
        float opt;
        if (one.getType() != two.getType()) {
            return false;
        }
        String[] fields = one.getType().getRequiredFields();
        float req = Util.compareFieldSet(fields, one, two);
        return (2.0f * req + (opt = Util.compareFieldSet(fields = one.getType().getOptionalFields(), one, two))) / 3.0f >= threshold;
    }

    private static float compareFieldSet(String[] fields, BibtexEntry one, BibtexEntry two) {
        int res = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (Util.compareSingleField(fields[i], one, two) != 1) continue;
            ++res;
        }
        return (float)res / (float)fields.length;
    }

    private static int compareSingleField(String field, BibtexEntry one, BibtexEntry two) {
        String s1 = (String)one.getField(field);
        String s2 = (String)two.getField(field);
        if (s1 == null) {
            if (s2 == null) {
                return 1;
            }
            return 2;
        }
        if (s2 == null) {
            return 3;
        }
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        if (field.equals("author") || field.equals("editor")) {
            String[] aus1 = ImportFormatReader.fixAuthor_lastnameFirst(s1).split(" and ");
            String[] aus2 = ImportFormatReader.fixAuthor_lastnameFirst(s2).split(" and ");
            String[] au1 = aus1[0].split(",");
            String[] au2 = aus2[0].split(",");
            if (aus1.length > 0 && aus1.length == aus2.length && au1[0].trim().equals(au2[0].trim())) {
                return 1;
            }
            return 0;
        }
        if (s1.trim().equals(s2.trim())) {
            return 1;
        }
        return 0;
    }

    public static void setDefaultOwner(ArrayList bibs, String defaultOwner) {
        for (int i = 0; i < bibs.size(); ++i) {
            BibtexEntry curEntry = (BibtexEntry)bibs.get(i);
            if (curEntry.getField("owner") != null && ((String)curEntry.getField("owner")).length() != 0) continue;
            curEntry.setField("owner", defaultOwner);
        }
    }
}

