/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntryType;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.HelpAction;
import jabref.HelpDialog;
import jabref.JabRefPreferences;
import jabref.PrefsTab;
import jabref.Util;
import jabref.labelPattern.LabelPattern;
import jabref.labelPattern.LabelPatternUtil;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class TabLabelPattern
extends JPanel
implements PrefsTab {
    private String def = Globals.lang("Default");
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints con = new GridBagConstraints();
    private HashMap textFields = new HashMap();
    private JabRefPreferences _prefs;
    private LabelPattern _keypatterns;
    private JLabel lblEntryType;
    private JLabel lblKeyPattern;
    private JLabel lblArticle;
    private JLabel lblBook;
    private JLabel lblBooklet;
    private JLabel lblConference;
    private JLabel lblInbook;
    private JLabel lblIncollection;
    private JLabel lblInproceedings;
    private JLabel lblManual;
    private JLabel lblMastersthesis;
    private JLabel lblMisc;
    private JLabel lblPhdthesis;
    private JLabel lblProceedings;
    private JLabel lblTechreport;
    private JLabel lblUnpublished;
    private JTextField txtArticle;
    private JTextField txtBook;
    private JTextField txtBooklet;
    private JTextField txtConference;
    private JTextField txtInbook;
    private JTextField txtIncollection;
    private JTextField txtInproceedings;
    private JTextField txtManual;
    private JTextField txtMastersthesis;
    private JTextField txtMisc;
    private JTextField txtPhdthesis;
    private JTextField txtProceedings;
    private JTextField txtTechreport;
    private JTextField txtUnpublished;
    private JButton btnArticleDefault;
    private JButton btnBookDefault;
    private JButton btnBookletDefault;
    private JButton btnConferenceDefault;
    private JButton btnInbookDefault;
    private JButton btnIncollectionDefault;
    private JButton btnInproceedingsDefault;
    private JButton btnManualDefault;
    private JButton btnMastersthesisDefault;
    private JButton btnMiscDefault;
    private JButton btnPhdthesisDefault;
    private JButton btnProceedingsDefault;
    private JButton btnTechreportDefault;
    private JButton btnUnpublishedDefault;
    private JButton btnDefaultAll;
    private HelpAction help;

    public TabLabelPattern(JabRefPreferences prefs2, HelpDialog helpDiag) {
        this._prefs = prefs2;
        this._keypatterns = this._prefs.getKeyPattern();
        this.help = new HelpAction(helpDiag, GUIGlobals.labelPatternHelp, "Help on key patterns");
        this.buildGUI();
    }

    @Override
    public void storeSettings() {
        LabelPattern defKeyPattern = this._keypatterns.getParent();
        this._keypatterns = new LabelPattern(defKeyPattern);
        Iterator i = this.textFields.keySet().iterator();
        String defa = (String)LabelPatternUtil.DEFAULT_LABELPATTERN.get(0);
        while (i.hasNext()) {
            String s = (String)i.next();
            String text = ((JTextField)this.textFields.get(s)).getText();
            if (defa.equals(text)) continue;
            this._keypatterns.addLabelPattern(s, text);
        }
        this._prefs.putKeyPattern(this._keypatterns);
    }

    private JTextField addEntryType(Container c, String name, int y) {
        JLabel lab = new JLabel(Util.nCase(name));
        name = name.toLowerCase();
        this.con.gridx = 0;
        this.con.gridy = y;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 17;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(lab, this.con);
        c.add(lab);
        JTextField tf = new JTextField(this._keypatterns.getValue(name).get(0).toString());
        tf.setColumns(15);
        this.con.gridx = 1;
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(tf, this.con);
        c.add(tf);
        JButton but = new JButton(this.def);
        this.con.gridx = 2;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(but, this.con);
        but.setActionCommand(name);
        but.addActionListener(new buttonHandler());
        c.add(but);
        return tf;
    }

    private void buildGUI() {
        JPanel pan = new JPanel();
        JScrollPane sp = new JScrollPane(pan);
        pan.setLayout(this.gbl);
        this.setLayout(this.gbl);
        this.lblEntryType = new JLabel(Globals.lang("Entry type"));
        Font f = new Font("plain", 1, 12);
        this.lblEntryType.setFont(f);
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.fill = 3;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 0);
        this.gbl.setConstraints(this.lblEntryType, this.con);
        pan.add(this.lblEntryType);
        this.lblKeyPattern = new JLabel(Globals.lang("Key pattern"));
        this.lblKeyPattern.setFont(f);
        this.con.gridx = 1;
        this.con.gridy = 0;
        this.con.gridheight = 1;
        this.con.fill = 1;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 0);
        this.gbl.setConstraints(this.lblKeyPattern, this.con);
        pan.add(this.lblKeyPattern);
        int y = 1;
        for (String s : BibtexEntryType.ALL_TYPES.keySet()) {
            this.textFields.put(s, this.addEntryType(pan, s, y));
            ++y;
        }
        this.con.fill = 1;
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.gridwidth = 3;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.gbl.setConstraints(sp, this.con);
        this.add(sp);
        this.con.gridwidth = 1;
        this.con.gridx = 1;
        this.con.gridy = 2;
        this.con.fill = 2;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(0, 5, 0, 5);
        JButton hlb = new JButton(new ImageIcon(GUIGlobals.helpSmallIconFile));
        hlb.setToolTipText(Globals.lang("Help on key patterns"));
        this.gbl.setConstraints(hlb, this.con);
        this.add(hlb);
        hlb.addActionListener(this.help);
        this.btnDefaultAll = new JButton(Globals.lang("Reset all"));
        this.con.gridx = 2;
        this.con.gridy = 2;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(20, 5, 0, 5);
        this.gbl.setConstraints(this.btnDefaultAll, this.con);
        this.btnDefaultAll.addActionListener(new buttonHandler());
        this.add(this.btnDefaultAll);
    }

    private void fillTextfields() {
        this.txtArticle.setText(this._keypatterns.getValue("article").get(0).toString());
        this.txtBook.setText(this._keypatterns.getValue("book").get(0).toString());
        this.txtBooklet.setText(this._keypatterns.getValue("booklet").get(0).toString());
        this.txtConference.setText(this._keypatterns.getValue("conference").get(0).toString());
        this.txtInbook.setText(this._keypatterns.getValue("inbook").get(0).toString());
        this.txtIncollection.setText(this._keypatterns.getValue("incollection").get(0).toString());
        this.txtInproceedings.setText(this._keypatterns.getValue("inproceedings").get(0).toString());
        this.txtManual.setText(this._keypatterns.getValue("manual").get(0).toString());
        this.txtMastersthesis.setText(this._keypatterns.getValue("mastersthesis").get(0).toString());
        this.txtMisc.setText(this._keypatterns.getValue("misc").get(0).toString());
        this.txtPhdthesis.setText(this._keypatterns.getValue("phdthesis").get(0).toString());
        this.txtProceedings.setText(this._keypatterns.getValue("proceedings").get(0).toString());
        this.txtTechreport.setText(this._keypatterns.getValue("techreport").get(0).toString());
        this.txtUnpublished.setText(this._keypatterns.getValue("unpublished").get(0).toString());
    }

    class buttonHandler
    implements ActionListener {
        buttonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == TabLabelPattern.this.btnDefaultAll) {
                for (String s : TabLabelPattern.this.textFields.keySet()) {
                    JTextField tf = (JTextField)TabLabelPattern.this.textFields.get(s);
                    tf.setText(TabLabelPattern.this._keypatterns.getParent().getValue(s).get(0).toString());
                }
                return;
            }
            JTextField tf = (JTextField)TabLabelPattern.this.textFields.get(evt.getActionCommand());
            tf.setText(TabLabelPattern.this._keypatterns.getParent().getValue(evt.getActionCommand()).get(0).toString());
        }
    }
}

