/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.BibtexDatabase;
import jabref.BibtexString;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.HelpAction;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import jabref.KeyCollisionException;
import jabref.undo.UndoableInsertString;
import jabref.undo.UndoableMoveString;
import jabref.undo.UndoableRemoveString;
import jabref.undo.UndoableStringChange;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.CompoundEdit;

public class StringDialog
extends JDialog {
    BibtexDatabase base;
    JabRefFrame frame;
    BasePanel panel;
    JabRefPreferences prefs;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JLabel lab;
    Container conPane = this.getContentPane();
    JToolBar tlb = new JToolBar();
    JPanel pan = new JPanel();
    StringTable table;
    HelpAction helpAction;
    CloseAction closeAction = new CloseAction(this);
    NewStringAction newStringAction = new NewStringAction(this);
    StoreContentAction storeContentAction = new StoreContentAction(this);
    RemoveStringAction removeStringAction = new RemoveStringAction(this);
    StringUpAction stringUpAction = new StringUpAction();
    StringDownAction stringDownAction = new StringDownAction();
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();

    public StringDialog(JabRefFrame frame, BasePanel panel, BibtexDatabase base, JabRefPreferences prefs2) {
        super(frame);
        this.frame = frame;
        this.panel = panel;
        this.base = base;
        this.prefs = prefs2;
        this.helpAction = new HelpAction(frame.helpDiag, GUIGlobals.stringEditorHelp, "Help");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StringDialog.this.closeAction.actionPerformed(null);
            }
        });
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component c) {
                return super.accept(c) && c instanceof StringTable;
            }
        });
        this.setLocation(prefs2.getInt("stringsPosX"), prefs2.getInt("stringsPosY"));
        this.setSize(prefs2.getInt("stringsSizeX"), prefs2.getInt("stringsSizeY"));
        this.pan.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.weighty = 1.0;
        this.con.weightx = 1.0;
        StringTableModel stm = new StringTableModel(this, base);
        this.table = new StringTable(stm);
        if (base.getStringCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.gbl.setConstraints(this.table.getPane(), this.con);
        this.pan.add(this.table.getPane());
        InputMap im = this.tlb.getInputMap(2);
        ActionMap am = this.tlb.getActionMap();
        im.put(KeyStroke.getKeyStroke(GUIGlobals.addKey), "add");
        am.put("add", this.newStringAction);
        im.put(KeyStroke.getKeyStroke(GUIGlobals.removeKey), "remove");
        am.put("remove", this.removeStringAction);
        im.put(KeyStroke.getKeyStroke(GUIGlobals.upKey), "up");
        am.put("up", this.stringUpAction);
        im.put(KeyStroke.getKeyStroke(GUIGlobals.downKey), "down");
        am.put("down", this.stringDownAction);
        im.put(GUIGlobals.exitDialog, "close");
        am.put("close", this.closeAction);
        im.put(GUIGlobals.helpKeyStroke, "help");
        am.put("help", this.helpAction);
        im.put(GUIGlobals.undoStroke, "undo");
        am.put("undo", this.undoAction);
        im.put(GUIGlobals.redoStroke, "redo");
        am.put("redo", this.redoAction);
        this.tlb.add(this.newStringAction);
        this.tlb.add(this.removeStringAction);
        this.tlb.addSeparator();
        this.tlb.add(this.stringUpAction);
        this.tlb.add(this.stringDownAction);
        this.tlb.addSeparator();
        this.tlb.add(this.helpAction);
        this.conPane.add((Component)this.tlb, "North");
        this.conPane.add((Component)this.pan, "Center");
        if (panel.file != null) {
            this.setTitle(Globals.lang(GUIGlobals.stringsTitle) + ": " + panel.file.getName());
        } else {
            this.setTitle(Globals.lang(GUIGlobals.stringsTitle) + ": " + Globals.lang(GUIGlobals.untitledTitle));
        }
    }

    public void refreshTable() {
        this.table.revalidate();
        this.table.clearSelection();
        this.table.repaint();
    }

    protected boolean isNumber(String name) {
        try {
            Integer.parseInt(name);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    protected void assureNotEditing() {
        if (this.table.isEditing()) {
            int col = this.table.getEditingColumn();
            int row = this.table.getEditingRow();
            this.table.getCellEditor(row, col).stopCellEditing();
        }
    }

    class CloseAction
    extends AbstractAction {
        StringDialog parent;

        public CloseAction(StringDialog parent) {
            super("Close window");
            this.putValue("ShortDescription", Globals.lang("Close dialog"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringDialog.this.panel.stringsClosing();
            StringDialog.this.dispose();
            Point p = StringDialog.this.getLocation();
            Dimension d = StringDialog.this.getSize();
            StringDialog.this.prefs.putInt("stringsPosX", p.x);
            StringDialog.this.prefs.putInt("stringsPosY", p.y);
            StringDialog.this.prefs.putInt("stringsSizeX", d.width);
            StringDialog.this.prefs.putInt("stringsSizeY", d.height);
        }
    }

    class NewStringAction
    extends AbstractAction {
        StringDialog parent;

        public NewStringAction(StringDialog parent) {
            super("New string", new ImageIcon(GUIGlobals.addIconFile));
            this.putValue("ShortDescription", Globals.lang("New string"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = JOptionPane.showInputDialog(this.parent, (Object)Globals.lang("Please enter the string's label"));
            if (name == null) {
                return;
            }
            if (StringDialog.this.isNumber(name)) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not be a number."), Globals.lang("Label"), 0);
                return;
            }
            try {
                BibtexString bs = new BibtexString(name, "");
                StringDialog.this.panel.undoManager.addEdit(new UndoableInsertString(StringDialog.this.panel, StringDialog.this.panel.database, bs, StringDialog.this.base.getStringCount()));
                StringDialog.this.base.addString(bs, StringDialog.this.base.getStringCount());
                StringDialog.this.table.revalidate();
                StringDialog.this.panel.markBaseChanged();
            }
            catch (KeyCollisionException ex) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("A string with that label already exists"), Globals.lang("Label"), 0);
            }
        }
    }

    class StoreContentAction
    extends AbstractAction {
        StringDialog parent;

        public StoreContentAction(StringDialog parent) {
            super("Store string", new ImageIcon(GUIGlobals.addIconFile));
            this.putValue("ShortDescription", Globals.lang("Store string"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class RemoveStringAction
    extends AbstractAction {
        StringDialog parent;

        public RemoveStringAction(StringDialog parent) {
            super("Remove selected strings", new ImageIcon(GUIGlobals.removeIconFile));
            this.putValue("ShortDescription", Globals.lang("Remove selected strings"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] sel = StringDialog.this.table.getSelectedRows();
            if (sel.length > 0) {
                StringDialog.this.assureNotEditing();
                String msg = Globals.lang("Really delete the selected") + " " + (sel.length > 1 ? sel.length + " " + Globals.lang("entries") : Globals.lang("entry")) + "?";
                int answer = JOptionPane.showConfirmDialog(this.parent, msg, Globals.lang("Delete strings"), 0, 3);
                if (answer == 0) {
                    CompoundEdit ce = new CompoundEdit();
                    for (int i = sel.length - 1; i >= 0; --i) {
                        ce.addEdit(new UndoableRemoveString(StringDialog.this.panel, StringDialog.this.base, StringDialog.this.base.getString(sel[i]), sel[i]));
                        StringDialog.this.base.removeString(sel[i]);
                    }
                    ce.end();
                    StringDialog.this.panel.undoManager.addEdit(ce);
                    StringDialog.this.table.revalidate();
                    if (StringDialog.this.base.getStringCount() > 0) {
                        StringDialog.this.table.setRowSelectionInterval(0, 0);
                    }
                    StringDialog.this.table.repaint();
                    StringDialog.this.panel.markBaseChanged();
                }
            }
        }
    }

    class StringUpAction
    extends AbstractAction {
        public StringUpAction() {
            super("Move string up", new ImageIcon(GUIGlobals.upIconFile));
            this.putValue("ShortDescription", Globals.lang("Move string up"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] sel = StringDialog.this.table.getSelectedRows();
            if (sel.length == 1 && sel[0] > 0) {
                StringDialog.this.assureNotEditing();
                StringDialog.this.panel.undoManager.addEdit(new UndoableMoveString(StringDialog.this.panel, StringDialog.this.base, sel[0], true));
                BibtexString bs = StringDialog.this.base.getString(sel[0]);
                StringDialog.this.base.removeString(sel[0]);
                try {
                    StringDialog.this.base.addString(bs, sel[0] - 1);
                }
                catch (KeyCollisionException keyCollisionException) {
                    // empty catch block
                }
                StringDialog.this.table.revalidate();
                StringDialog.this.table.setRowSelectionInterval(sel[0] - 1, sel[0] - 1);
                StringDialog.this.table.repaint();
                StringDialog.this.panel.markBaseChanged();
            }
        }
    }

    class StringDownAction
    extends AbstractAction {
        public StringDownAction() {
            super("Move string down", new ImageIcon(GUIGlobals.downIconFile));
            this.putValue("ShortDescription", Globals.lang("Move string down"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] sel = StringDialog.this.table.getSelectedRows();
            if (sel.length == 1 && sel[0] + 1 < StringDialog.this.base.getStringCount()) {
                StringDialog.this.assureNotEditing();
                StringDialog.this.panel.undoManager.addEdit(new UndoableMoveString(StringDialog.this.panel, StringDialog.this.base, sel[0], false));
                BibtexString bs = StringDialog.this.base.getString(sel[0]);
                StringDialog.this.base.removeString(sel[0]);
                try {
                    StringDialog.this.base.addString(bs, sel[0] + 1);
                }
                catch (KeyCollisionException keyCollisionException) {
                    // empty catch block
                }
                StringDialog.this.table.revalidate();
                StringDialog.this.table.setRowSelectionInterval(sel[0] + 1, sel[0] + 1);
                StringDialog.this.table.repaint();
                StringDialog.this.panel.markBaseChanged();
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", new ImageIcon(GUIGlobals.undoIconFile));
            this.putValue("ShortDescription", Globals.lang("Undo"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                StringDialog.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Undo", new ImageIcon(GUIGlobals.redoIconFile));
            this.putValue("ShortDescription", Globals.lang("Redo"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                StringDialog.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class StringTableModel
    extends AbstractTableModel {
        BibtexDatabase base;
        StringDialog parent;

        public StringTableModel(StringDialog parent, BibtexDatabase base) {
            this.parent = parent;
            this.base = base;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return col == 0 ? this.base.getString(row).getName() : this.base.getString(row).getContent();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                if (!((String)value).equals(this.base.getString(row).getName())) {
                    if (this.base.hasStringLabel((String)value)) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("A string with that label already exists"), Globals.lang("Label"), 0);
                    } else if (value != null && StringDialog.this.isNumber((String)value)) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not be a number."), Globals.lang("Label"), 0);
                    } else {
                        StringDialog.this.panel.undoManager.addEdit(new UndoableStringChange(StringDialog.this.panel, this.base.getString(row), true, this.base.getString(row).getName(), (String)value));
                        this.base.getString(row).setName((String)value);
                        StringDialog.this.panel.markBaseChanged();
                    }
                }
            } else if (!((String)value).equals(this.base.getString(row).getContent())) {
                StringDialog.this.panel.undoManager.addEdit(new UndoableStringChange(StringDialog.this.panel, this.base.getString(row), false, this.base.getString(row).getContent(), (String)value));
                this.base.getString(row).setContent((String)value);
                StringDialog.this.panel.markBaseChanged();
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.base.getStringCount();
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? Globals.lang("Name") : Globals.lang("Content");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }

    class StringTable
    extends JTable {
        JScrollPane sp;

        public StringTable(StringTableModel stm) {
            super(stm);
            this.sp = new JScrollPane(this);
            this.setShowVerticalLines(true);
            this.setShowHorizontalLines(true);
            this.setColumnSelectionAllowed(true);
            DefaultCellEditor dce = new DefaultCellEditor(new JTextField());
            dce.setClickCountToStart(2);
            this.setDefaultEditor(String.class, dce);
            TableColumnModel cm = this.getColumnModel();
            cm.getColumn(0).setPreferredWidth(800);
            cm.getColumn(1).setPreferredWidth(2000);
            this.sp.getViewport().setBackground(GUIGlobals.tableBackground);
            this.getInputMap().put(GUIGlobals.exitDialog, "close");
            this.getActionMap().put("close", StringDialog.this.closeAction);
            this.getInputMap().put(GUIGlobals.helpKeyStroke, "help");
            this.getActionMap().put("help", StringDialog.this.helpAction);
        }

        public JComponent getPane() {
            return this.sp;
        }
    }
}

