/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.JabRef;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import jehep.ui.SetEnv;
import jehep.utils.XMLformater;

public class SetPref {
    public static Preferences prefs;
    public static final String keyjGroup = "group";
    public static final String keyjTitle = "title";
    public static final String keyjShortDescription = "short-description";
    public static final String keyjAuthor = "authors";
    public static final String keyjContact = "contact";
    public static final String keyjLastModified = "last-modified";
    public static final String keyjDescription = "description";
    public static final String keyProject = "project";
    public static final String keyTime = "time";
    public static String FileName;
    public static String shortName;

    public static void init() {
        shortName = "user-comment.xml";
        String path = SetEnv.INIDIR;
        FileName = path + File.separator + "jabref.pref";
        prefs = Preferences.userNodeForPackage(JabRef.class);
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yy");
        prefs.put(keyTime, new String(formatter.format((Object)date)));
    }

    public static void Read() {
        File f = new File(FileName);
        if (f.exists() && f.length() > 1L) {
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(f));
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found!");
            }
            try {
                Preferences.importPreferences(is);
                String textjGroup = prefs.get(keyjGroup, "");
                String string = textjGroup.trim();
            }
            catch (InvalidPreferencesFormatException textjGroup) {
            }
            catch (IOException e) {
                System.out.println("Error in importing preferences!");
            }
        } else {
            System.out.println("Preferences set to zero");
        }
    }

    public static void Write() {
        try {
            prefs.exportNode(new FileOutputStream(FileName));
        }
        catch (IOException iOException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        XMLformater.format(FileName, "/>", "/>\n");
    }
}

