/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntry;
import jabref.JabRefPreferences;
import jabref.SearchRule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Pattern;

public class RegExpRule
implements SearchRule {
    JabRefPreferences prefs;

    public RegExpRule(JabRefPreferences prefs2) {
        this.prefs = prefs2;
    }

    @Override
    public int applyRule(Hashtable searchStrings, BibtexEntry bibtexEntry) {
        int score = 0;
        Enumeration e = searchStrings.elements();
        String searchString = (String)e.nextElement();
        if (!searchString.matches("\\.\\*")) {
            searchString = ".*" + searchString + ".*";
        }
        Object tempString = null;
        int flags = 0;
        if (!this.prefs.getBoolean("caseSensitiveSearch")) {
            flags = 2;
        }
        Pattern pattern = Pattern.compile(searchString, flags);
        if (this.prefs.getBoolean("searchAll")) {
            Object[] fields = bibtexEntry.getAllFields();
            score += this.searchFields(fields, bibtexEntry, pattern);
        } else {
            if (this.prefs.getBoolean("searchReq")) {
                Object[] requiredField = bibtexEntry.getRequiredFields();
                score += this.searchFields(requiredField, bibtexEntry, pattern);
            }
            if (this.prefs.getBoolean("searchOpt")) {
                Object[] optionalField = bibtexEntry.getOptionalFields();
                score += this.searchFields(optionalField, bibtexEntry, pattern);
            }
            if (this.prefs.getBoolean("searchGen")) {
                Object[] generalField = bibtexEntry.getGeneralFields();
                score += this.searchFields(generalField, bibtexEntry, pattern);
            }
        }
        return score;
    }

    protected int searchFields(Object[] fields, BibtexEntry bibtexEntry, Pattern pattern) {
        int score = 0;
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                try {
                    if (!pattern.matcher(String.valueOf(bibtexEntry.getField(fields[i].toString()))).matches()) continue;
                    ++score;
                    continue;
                }
                catch (Throwable t) {
                    System.err.println("Searching error: " + t);
                }
            }
        }
        return score;
    }
}

