/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntry;
import jabref.JabRefFrame;
import jabref.export.layout.Layout;
import jabref.export.layout.LayoutHelper;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JEditorPane;

public class PreviewPanel
extends JEditorPane {
    public String CONTENT_TYPE = "text/html";
    public String LAYOUT_FILE = "simplehtml";
    BibtexEntry entry;
    Layout layout;
    String prefix = "";
    String postfix = "";
    Dimension DIM = new Dimension(650, 110);
    HashMap layouts = new HashMap();

    public PreviewPanel(BibtexEntry be) {
        this.entry = be;
        this.setEditable(false);
        this.setContentType(this.CONTENT_TYPE);
        try {
            this.readLayout();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.update();
    }

    public void readLayout() throws IOException {
        int c;
        InputStreamReader reader;
        String entryType = this.entry.getType().getName().toLowerCase();
        if (this.layouts.get(entryType) != null) {
            this.layout = (Layout)this.layouts.get(entryType);
            return;
        }
        LayoutHelper layoutHelper = null;
        URL reso = JabRefFrame.class.getResource("/jabref/resource/layout/" + this.LAYOUT_FILE + "." + entryType + ".layout");
        try {
            if (reso == null) {
                reso = JabRefFrame.class.getResource("/jabref/resource/layout/" + this.LAYOUT_FILE + ".layout");
            }
            layoutHelper = new LayoutHelper(new InputStreamReader(reso.openStream()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.layout = layoutHelper.getLayoutFromText();
        this.layouts.put(entryType, this.layout);
        reso = JabRefFrame.class.getResource("/jabref/resource/layout/" + this.LAYOUT_FILE + ".begin.layout");
        StringWriter stw = new StringWriter();
        if (reso != null) {
            reader = new InputStreamReader(reso.openStream());
            while ((c = reader.read()) != -1) {
                stw.write((char)c);
            }
            reader.close();
        }
        this.prefix = stw.toString();
        reso = JabRefFrame.class.getResource("/jabref/resource/layout/" + this.LAYOUT_FILE + ".end.layout");
        stw = new StringWriter();
        if (reso != null) {
            reader = new InputStreamReader(reso.openStream());
            while ((c = reader.read()) != -1) {
                stw.write((char)c);
            }
            reader.close();
        }
        this.postfix = stw.toString();
    }

    public void setEntry(BibtexEntry newEntry) {
        this.entry = newEntry;
        try {
            this.readLayout();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.update();
    }

    public void update() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.layout.doLayout(this.entry));
        this.setText(sb.toString());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.DIM;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.DIM;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paintComponent(g2);
    }
}

