/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.GUIGlobals;
import jabref.Globals;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class PrefsDialog
extends JDialog {
    private String[] _choices;
    private Boolean[] _sel;
    private JabRefPreferences _prefs;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints con = new GridBagConstraints();
    private JCheckBox colorCodes;
    private JCheckBox autoResizeMode;
    private JCheckBox autoOpenForm;
    private JCheckBox backup;
    private JCheckBox openLast;
    private JCheckBox secDesc;
    private JCheckBox terDesc;
    private JCheckBox defSource;
    private JCheckBox defSort;
    private JCheckBox editSource;
    private JCheckBox autoComplete;
    private JCheckBox groupsVisible;
    private JTextField groupsField;
    private JPopupMenu complFields = new JPopupMenu();
    private JCheckBoxMenuItem[] sel_ac = new JCheckBoxMenuItem[GUIGlobals.ALL_FIELDS.length];
    private JButton openAutoComp = new JButton(Globals.lang("Choose fields"));
    private JabRefFrame parent;
    private String[] sizes = new String[]{Globals.lang("Small"), Globals.lang("Medium"), Globals.lang("Large")};
    private JComboBox formWidth = new JComboBox<String>(this.sizes);
    private JComboBox formHeight = new JComboBox<String>(this.sizes);
    private JComboBox secSort = new JComboBox<String>(GUIGlobals.ALL_FIELDS);
    private JComboBox terSort = new JComboBox<String>(GUIGlobals.ALL_FIELDS);

    public static void showPrefsDialog(JabRefFrame parent, JabRefPreferences prefs2) {
        PrefsDialog cd = new PrefsDialog(parent, prefs2);
        Dimension ds = cd.getSize();
        Dimension df = parent.getSize();
        Point pf = parent.getLocation();
        cd.setLocation(new Point(pf.x + (df.width - ds.width) / 2, pf.y + (df.height - ds.height) / 2));
        cd.setVisible(true);
    }

    public PrefsDialog(JabRefFrame parent, JabRefPreferences prefs2) {
        super(parent, Globals.lang("JabRef preferences"), true);
        int i;
        this.parent = parent;
        this._prefs = prefs2;
        this.colorCodes = new JCheckBox("Use color codes for required and optional fields", this._prefs.getBoolean("tableColorCodesOn"));
        this.autoResizeMode = new JCheckBox("Always resize table horizontally to fit on screen", this._prefs.getInt("autoResizeMode") == 4);
        this.autoOpenForm = new JCheckBox("Automatically open editor when creating a new entry", this._prefs.getBoolean("autoOpenForm"));
        this.backup = new JCheckBox("Backup old file when saving", this._prefs.getBoolean("backup"));
        this.openLast = new JCheckBox("As default, open latest edited database on startup", this._prefs.getBoolean("openLastEdited"));
        this.secDesc = new JCheckBox("Descending", this._prefs.getBoolean("secDescending"));
        this.terDesc = new JCheckBox("Descending", this._prefs.getBoolean("terDescending"));
        this.defSource = new JCheckBox("Show source by default", this._prefs.getBoolean("defaultShowSource"));
        this.defSort = new JCheckBox("Automatically sort by default", this._prefs.getBoolean("defaultAutoSort"));
        this.editSource = new JCheckBox("Enable source editing", this._prefs.getBoolean("enableSourceEditing"));
        this.autoComplete = new JCheckBox("Enable autocompletion", this._prefs.getBoolean("autoComplete"));
        this.groupsVisible = new JCheckBox("Show groups interface if database has groups defined", this._prefs.getBoolean("groupSelectorVisible"));
        this.groupsField = new JTextField(this._prefs.get("groupsDefaultField"));
        this.colorCodes.getInputMap(2).put(GUIGlobals.exitDialog, "close");
        this.colorCodes.getActionMap().put("close", new CancelAction());
        this.formWidth.setEditable(false);
        Boolean[] sel = new Boolean[GUIGlobals.ALL_FIELDS.length];
        this._choices = GUIGlobals.ALL_FIELDS;
        this._sel = sel;
        byte[] autoCompFields = prefs2.getByteArray("autoCompFields");
        String[] columns = prefs2.getStringArray("columnNames");
        for (i = 0; i < this._choices.length; ++i) {
            int j;
            boolean found = false;
            boolean found_ac = false;
            for (j = 0; j < columns.length; ++j) {
                if (!columns[j].equals(this._choices[i])) continue;
                found = true;
            }
            for (j = 0; j < autoCompFields.length; ++j) {
                if (!GUIGlobals.ALL_FIELDS[autoCompFields[j]].equals(this._choices[i])) continue;
                found_ac = true;
            }
            sel[i] = found ? new Boolean(true) : new Boolean(false);
            this.sel_ac[i] = found_ac ? new JCheckBoxMenuItem(GUIGlobals.ALL_FIELDS[i], true) : new JCheckBoxMenuItem(GUIGlobals.ALL_FIELDS[i], false);
        }
        for (i = 0; i < this._choices.length; ++i) {
            String text = this.sel_ac[i].getText();
            if (text.equals("bibtexkey") || text.equals("search")) continue;
            this.complFields.add(this.sel_ac[i]);
        }
        this.openAutoComp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton src = (JButton)e.getSource();
                PrefsDialog.this.complFields.show(src, 0, 0);
            }
        });
        String sec = prefs2.get("secSort");
        String ter = prefs2.get("terSort");
        for (int i2 = 0; i2 < GUIGlobals.ALL_FIELDS.length; ++i2) {
            if (sec.equals(GUIGlobals.ALL_FIELDS[i2])) {
                this.secSort.setSelectedIndex(i2);
            }
            if (!ter.equals(GUIGlobals.ALL_FIELDS[i2])) continue;
            this.terSort.setSelectedIndex(i2);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                new CancelAction().actionPerformed(null);
            }
        });
        AbstractTableModel tm = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return PrefsDialog.this._choices.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (column == 0) {
                    return PrefsDialog.this._choices[row];
                }
                return PrefsDialog.this._sel[row];
            }

            public Class getColumnClass(int column) {
                if (column == 0) {
                    return String.class;
                }
                return Boolean.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col > 0;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex == 1) {
                    ((PrefsDialog)PrefsDialog.this)._sel[rowIndex] = (Boolean)aValue;
                }
            }
        };
        JTable table = new JTable(tm);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.getInputMap().put(GUIGlobals.exitDialog, "close");
        table.getActionMap().put("close", new CancelAction());
        TableColumnModel cm = table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(90);
        cm.getColumn(1).setPreferredWidth(25);
        JPanel upper = new JPanel();
        JPanel lower = new JPanel();
        JPanel right = new JPanel();
        JPanel general = new JPanel();
        JPanel rightlow = new JPanel();
        JPanel tablePanel = new JPanel();
        JPanel innerTablePanel = new JPanel();
        JPanel sort = new JPanel();
        JPanel source = new JPanel();
        JPanel autoComp = new JPanel();
        JPanel groups = new JPanel();
        table.setShowVerticalLines(false);
        innerTablePanel.setBorder(BorderFactory.createEtchedBorder());
        tablePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Visible fields"));
        right.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Table appearance"));
        general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General options"));
        sort.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sort options"));
        source.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Edit/view bibtex source"));
        autoComp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Autocomplete options"));
        groups.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Groups options"));
        this.formHeight.setSelectedIndex(prefs2.getInt("entryTypeFormHeightFactor"));
        this.formWidth.setSelectedIndex(prefs2.getInt("entryTypeFormWidth"));
        innerTablePanel.setLayout(new GridLayout(1, 1));
        innerTablePanel.add(table);
        tablePanel.add(innerTablePanel);
        upper.setLayout(this.gbl);
        right.setLayout(this.gbl);
        general.setLayout(this.gbl);
        sort.setLayout(this.gbl);
        source.setLayout(this.gbl);
        autoComp.setLayout(this.gbl);
        groups.setLayout(this.gbl);
        this.con.gridheight = 0;
        this.con.fill = 1;
        this.gbl.setConstraints(tablePanel, this.con);
        upper.add(tablePanel);
        this.con.gridheight = 1;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(right, this.con);
        upper.add(right);
        this.gbl.setConstraints(general, this.con);
        upper.add(general);
        this.gbl.setConstraints(sort, this.con);
        upper.add(sort);
        this.gbl.setConstraints(source, this.con);
        upper.add(source);
        this.gbl.setConstraints(autoComp, this.con);
        upper.add(autoComp);
        this.gbl.setConstraints(groups, this.con);
        upper.add(groups);
        this.con.fill = 0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.colorCodes, this.con);
        right.add(this.colorCodes);
        this.gbl.setConstraints(this.autoResizeMode, this.con);
        right.add(this.autoResizeMode);
        this.gbl.setConstraints(this.autoOpenForm, this.con);
        general.add(this.autoOpenForm);
        this.con.gridwidth = 1;
        this.con.anchor = 17;
        this.con.weightx = 0.0;
        this.gbl.setConstraints(this.formWidth, this.con);
        general.add(this.formWidth);
        JLabel lab = new JLabel("Secondary sort criterion");
        this.gbl.setConstraints(lab, this.con);
        sort.add(lab);
        this.con.weightx = 1.0;
        this.con.insets = new Insets(0, 5, 0, 0);
        this.gbl.setConstraints(this.secSort, this.con);
        sort.add(this.secSort);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.secDesc, this.con);
        sort.add(this.secDesc);
        lab = new JLabel("Default width of entry editor");
        this.gbl.setConstraints(lab, this.con);
        general.add(lab);
        this.con.gridwidth = 1;
        this.con.anchor = 17;
        this.con.weightx = 0.0;
        this.con.insets = new Insets(0, 0, 0, 0);
        this.gbl.setConstraints(this.formHeight, this.con);
        general.add(this.formHeight);
        this.con.weightx = 1.0;
        lab = new JLabel("Tertiary sort criterion");
        this.gbl.setConstraints(lab, this.con);
        sort.add(lab);
        this.con.weightx = 0.0;
        this.con.insets = new Insets(0, 5, 0, 0);
        this.gbl.setConstraints(this.terSort, this.con);
        sort.add(this.terSort);
        this.con.weightx = 1.0;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.terDesc, this.con);
        sort.add(this.terDesc);
        lab = new JLabel("Default height of entry editor");
        this.gbl.setConstraints(lab, this.con);
        general.add(lab);
        this.con.insets = new Insets(0, 0, 0, 0);
        this.con.fill = 0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.backup, this.con);
        general.add(this.backup);
        this.gbl.setConstraints(this.openLast, this.con);
        general.add(this.openLast);
        lab = new JLabel("Primary sort criterion is set by clicking on column headers.");
        this.gbl.setConstraints(lab, this.con);
        sort.add(lab);
        this.con.insets = new Insets(0, 0, 0, 0);
        this.con.fill = 0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.defSource, this.con);
        source.add(this.defSource);
        this.gbl.setConstraints(this.editSource, this.con);
        source.add(this.editSource);
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.autoComplete, this.con);
        autoComp.add(this.autoComplete);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.openAutoComp, this.con);
        autoComp.add(this.openAutoComp);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.groupsVisible, this.con);
        groups.add(this.groupsVisible);
        lab = new JLabel("Default search field for new group:");
        this.con.gridwidth = 1;
        this.con.fill = 2;
        this.con.anchor = 17;
        this.gbl.setConstraints(lab, this.con);
        groups.add(lab);
        this.gbl.setConstraints(this.groupsField, this.con);
        groups.add(this.groupsField);
        this.con.fill = 1;
        this.gbl.setConstraints(rightlow, this.con);
        upper.add(rightlow);
        JButton ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        ok.addActionListener(new OkAction());
        cancel.addActionListener(new CancelAction());
        lower.add(ok);
        lower.add(cancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)upper, "Center");
        this.getContentPane().add((Component)lower, "South");
        this.pack();
        this.setResizable(false);
    }

    public String[] getChoices() {
        int count = 0;
        for (int i = 0; i < this._sel.length; ++i) {
            if (!this._sel[i].booleanValue()) continue;
            ++count;
        }
        String[] choices = new String[count];
        count = 0;
        for (int i = 0; i < this._sel.length; ++i) {
            if (!this._sel[i].booleanValue()) continue;
            choices[count] = GUIGlobals.ALL_FIELDS[i];
            ++count;
        }
        return choices;
    }

    public byte[] getAcChoices() {
        int count = 0;
        for (int i = 0; i < this.sel_ac.length; ++i) {
            if (!this.sel_ac[i].isSelected()) continue;
            ++count;
        }
        byte[] choices = new byte[count];
        count = 0;
        for (int i = 0; i < this.sel_ac.length; ++i) {
            if (!this.sel_ac[i].isSelected()) continue;
            choices[count] = (byte)i;
            ++count;
        }
        return choices;
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrefsDialog.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Ok");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrefsDialog.this._prefs.putStringArray("columnNames", PrefsDialog.this.getChoices());
            PrefsDialog.this._prefs.putBoolean("tableColorCodesOn", PrefsDialog.this.colorCodes.isSelected());
            PrefsDialog.this._prefs.putBoolean("autoOpenForm", PrefsDialog.this.autoOpenForm.isSelected());
            PrefsDialog.this._prefs.putInt("autoResizeMode", PrefsDialog.this.autoResizeMode.isSelected() ? 4 : 0);
            PrefsDialog.this._prefs.putInt("entryTypeFormHeightFactor", PrefsDialog.this.formHeight.getSelectedIndex());
            PrefsDialog.this._prefs.putInt("entryTypeFormWidth", PrefsDialog.this.formWidth.getSelectedIndex());
            PrefsDialog.this._prefs.putBoolean("backup", PrefsDialog.this.backup.isSelected());
            PrefsDialog.this._prefs.putBoolean("openLastEdited", PrefsDialog.this.openLast.isSelected());
            PrefsDialog.this._prefs.putBoolean("secDescending", PrefsDialog.this.secDesc.isSelected());
            PrefsDialog.this._prefs.putBoolean("terDescending", PrefsDialog.this.terDesc.isSelected());
            PrefsDialog.this._prefs.put("secSort", GUIGlobals.ALL_FIELDS[PrefsDialog.this.secSort.getSelectedIndex()]);
            PrefsDialog.this._prefs.put("terSort", GUIGlobals.ALL_FIELDS[PrefsDialog.this.terSort.getSelectedIndex()]);
            PrefsDialog.this._prefs.putBoolean("defaultShowSource", PrefsDialog.this.defSource.isSelected());
            PrefsDialog.this._prefs.putBoolean("defaultAutoSort", PrefsDialog.this.defSort.isSelected());
            PrefsDialog.this._prefs.putBoolean("enableSourceEditing", PrefsDialog.this.editSource.isSelected());
            PrefsDialog.this._prefs.putBoolean("autoComplete", PrefsDialog.this.autoComplete.isSelected());
            PrefsDialog.this._prefs.putBoolean("groupSelectorVisible", PrefsDialog.this.groupsVisible.isSelected());
            PrefsDialog.this._prefs.put("groupsDefaultField", PrefsDialog.this.groupsField.getText());
            PrefsDialog.this.parent.output("Preferences recorded.");
            PrefsDialog.this.dispose();
        }
    }
}

