/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

class KeyBindingsDialog
extends JDialog {
    KeystrokeTable table;
    KeystrokeTableModel tableModel;
    JTextField keyTF = new JTextField();
    JButton ok;
    JButton cancel;
    JButton grabB;
    JButton defB;
    HashMap bindHM;
    HashMap defBinds;
    boolean clickedSave = false;
    int selectedRow = -1;

    boolean getAction() {
        return this.clickedSave;
    }

    HashMap getNewKeyBindings() {
        return this.bindHM;
    }

    public KeyBindingsDialog(HashMap name2binding, HashMap defBinds) {
        this.defBinds = defBinds;
        this.setTitle(Globals.lang("Key bindings"));
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.bindHM = name2binding;
        this.setList();
        JScrollPane listScroller = new JScrollPane(this.table);
        listScroller.setPreferredSize(new Dimension(250, 400));
        this.getContentPane().add((Component)listScroller, "Center");
        Box buttonBox = new Box(0);
        this.ok = new JButton(Globals.lang("Ok"));
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.grabB = new JButton(Globals.lang("Grab"));
        this.defB = new JButton(Globals.lang("Default"));
        this.grabB.addKeyListener(new JBM_CustomKeyBindingsListener());
        buttonBox.add(this.grabB);
        buttonBox.add(this.defB);
        buttonBox.add(this.ok);
        buttonBox.add(this.cancel);
        this.getContentPane().add((Component)buttonBox, "South");
        this.setButtons();
        this.keyTF.setEditable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                KeyBindingsDialog.this.clickedSave = false;
                KeyBindingsDialog.this.dispose();
            }
        });
    }

    void setTop() {
        Box topBox = new Box(0);
        topBox.add(new JLabel(Globals.lang("Binding") + ":", 4));
        topBox.add(this.keyTF);
        this.getContentPane().add((Component)topBox, "North");
    }

    void setList() {
        DefaultListModel listModel = new DefaultListModel();
        Iterator it = this.bindHM.keySet().iterator();
        String[][] tableData = new String[this.bindHM.size()][3];
        int i = 0;
        while (it.hasNext()) {
            String s;
            tableData[i][2] = s = (String)it.next();
            tableData[i][1] = (String)this.bindHM.get(s);
            tableData[i][0] = Globals.lang(s);
            ++i;
        }
        TreeMap<String, String[]> sorted = new TreeMap<String, String[]>();
        for (i = 0; i < tableData.length; ++i) {
            sorted.put(tableData[i][0], tableData[i]);
        }
        this.tableModel = new KeystrokeTableModel(sorted);
        this.table = new KeystrokeTable(this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(200);
        cm.getColumn(1).setPreferredWidth(80);
        this.table.setRowSelectionInterval(0, 0);
    }

    void setButtons() {
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyBindingsDialog.this.dispose();
                KeyBindingsDialog.this.clickedSave = true;
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyBindingsDialog.this.dispose();
                KeyBindingsDialog.this.clickedSave = false;
            }
        });
        this.defB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    String setToDefault(String name) {
        String defKey = (String)this.defBinds.get(name);
        this.bindHM.put(name, defKey);
        return defKey;
    }

    class KeystrokeTable
    extends JTable {
        public KeystrokeTable(KeystrokeTableModel model) {
            super(model);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public String getOriginalName(int row) {
            return ((KeystrokeTableModel)this.getModel()).data[row][2];
        }
    }

    public class JBM_CustomKeyBindingsListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent evt) {
            int kc;
            int selRow = KeyBindingsDialog.this.table.getSelectedRow();
            if (selRow < 0) {
                return;
            }
            String code = KeyEvent.getKeyText(evt.getKeyCode());
            String mod = KeyEvent.getKeyModifiersText(evt.getModifiers());
            if (mod.equals("") && (kc = evt.getKeyCode()) < 112 && kc > 123 && kc != 27 && kc != 127) {
                return;
            }
            if (code.equals("Tab") || code.equals("Backspace") || code.equals("Enter") || code.equals("Space") || code.equals("Ctrl") || code.equals("Shift") || code.equals("Alt")) {
                return;
            }
            String newKey = !mod.equals("") ? mod.toLowerCase().replaceAll("\\+", " ") + " " + code : code;
            KeyBindingsDialog.this.keyTF.setText(newKey);
            String selectedFunction = KeyBindingsDialog.this.table.getOriginalName(selRow);
            KeyBindingsDialog.this.table.setValueAt(newKey, selRow, 1);
            KeyBindingsDialog.this.table.revalidate();
            KeyBindingsDialog.this.table.repaint();
            KeyBindingsDialog.this.bindHM.put(selectedFunction, newKey);
        }
    }

    class KeystrokeTableModel
    extends AbstractTableModel {
        String[][] data;

        public KeystrokeTableModel(TreeMap sorted) {
            this.data = new String[sorted.size()][3];
            Iterator i = sorted.keySet().iterator();
            int row = 0;
            while (i.hasNext()) {
                this.data[row++] = (String[])sorted.get(i.next());
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? Globals.lang("Action") : Globals.lang("Shortcut");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            this.data[row][col] = (String)o;
        }
    }

    class MyListDataListener
    implements ListDataListener {
        MyListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent evt) {
            DefaultListModel model = (DefaultListModel)evt.getSource();
            int start = evt.getIndex0();
            int end2 = evt.getIndex1();
            int count = end2 - start + 1;
            for (int i = start; i <= end2; ++i) {
                Object e = model.getElementAt(i);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent evt) {
            int start = evt.getIndex0();
            int end2 = evt.getIndex1();
            int count = end2 - start + 1;
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            DefaultListModel model = (DefaultListModel)evt.getSource();
            int start = evt.getIndex0();
            int end2 = evt.getIndex1();
            int count = end2 - start + 1;
            for (int i = start; i <= end2; ++i) {
                Object e = model.getElementAt(i);
            }
        }
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (!evt.getValueIsAdjusting()) {
                JList list = (JList)evt.getSource();
                Object[] selected = list.getSelectedValues();
                for (int i = 0; i < selected.length; ++i) {
                    Object sel = selected[i];
                    KeyBindingsDialog.this.keyTF.setText((String)KeyBindingsDialog.this.bindHM.get(sel));
                }
            }
        }
    }
}

