/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.CustomEntryType;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.JabRef;
import jabref.Util;
import jabref.labelPattern.DefaultLabelPatterns;
import jabref.labelPattern.LabelPattern;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;

public class JabRefPreferences {
    final String CUSTOM_TYPE_NAME = "customTypeName_";
    final String CUSTOM_TYPE_REQ = "customTypeReq_";
    final String CUSTOM_TYPE_OPT = "customTypeOpt_";
    Preferences prefs;
    HashMap defaults = new HashMap();
    HashMap keyBinds = new HashMap();
    HashMap defKeyBinds = new HashMap();
    private static final LabelPattern KEY_PATTERN = new DefaultLabelPatterns();
    private static LabelPattern keyPattern;

    public JabRefPreferences() {
        this.prefs = Preferences.userNodeForPackage(JabRef.class);
        if (Globals.osName.equals("Mac OS X")) {
            this.defaults.put("pdfviewer", "open /Applications/Preview.app");
            this.defaults.put("psviewer", "open /Applications/Preview.app");
            this.defaults.put("htmlviewer", "open /Applications/Safari.app");
        } else if (Globals.osName.toLowerCase().startsWith("windows")) {
            this.defaults.put("pdfviewer", "cmd.exe /c start /b");
            this.defaults.put("psviewer", "cmd.exe /c start /b");
            this.defaults.put("htmlviewer", "cmd.exe /c start /b");
        } else {
            this.defaults.put("pdfviewer", "acroread");
            this.defaults.put("psviewer", "gv");
            this.defaults.put("htmlviewer", "mozilla");
        }
        this.defaults.put("posX", new Integer(0));
        this.defaults.put("posY", new Integer(0));
        this.defaults.put("sizeX", new Integer(840));
        this.defaults.put("sizeY", new Integer(680));
        this.defaults.put("autoResizeMode", new Integer(0));
        this.defaults.put("tableColorCodesOn", new Boolean(true));
        this.defaults.put("namesAsIs", new Boolean(false));
        this.defaults.put("namesFf", new Boolean(false));
        this.defaults.put("language", "en");
        this.defaults.put("priSort", "author");
        this.defaults.put("priDescending", new Boolean(false));
        this.defaults.put("secSort", "year");
        this.defaults.put("secDescending", new Boolean(true));
        this.defaults.put("terSort", "author");
        this.defaults.put("terDescending", new Boolean(false));
        this.defaults.put("columnNames", "entrytype;author;title;year;journal;owner;bibtexkey");
        this.defaults.put("columnWidths", "75;280;400;60;100;100;100");
        this.defaults.put("numberColWidth", new Integer(GUIGlobals.NUMBER_COL_LENGTH));
        this.defaults.put("workingDirectory", System.getProperty("user.home"));
        this.defaults.put("autoOpenForm", new Boolean(true));
        this.defaults.put("entryTypeFormHeightFactor", new Integer(1));
        this.defaults.put("entryTypeFormWidth", new Integer(1));
        this.defaults.put("backup", new Boolean(true));
        this.defaults.put("openLastEdited", new Boolean(false));
        this.defaults.put("lastEdited", null);
        this.defaults.put("stringsPosX", new Integer(0));
        this.defaults.put("stringsPosY", new Integer(0));
        this.defaults.put("stringsSizeX", new Integer(600));
        this.defaults.put("stringsSizeY", new Integer(400));
        this.defaults.put("defaultShowSource", new Boolean(false));
        this.defaults.put("defaultAutoSort", new Boolean(false));
        this.defaults.put("enableSourceEditing", new Boolean(true));
        this.defaults.put("caseSensitiveSearch", new Boolean(false));
        this.defaults.put("searchReq", new Boolean(true));
        this.defaults.put("searchOpt", new Boolean(true));
        this.defaults.put("searchGen", new Boolean(true));
        this.defaults.put("searchAll", new Boolean(false));
        this.defaults.put("incrementS", new Boolean(true));
        this.defaults.put("selectS", new Boolean(false));
        this.defaults.put("regExpSearch", new Boolean(true));
        this.defaults.put("searchPanePosX", new Integer(0));
        this.defaults.put("searchPanePosY", new Integer(0));
        this.defaults.put("autoComplete", new Boolean(true));
        this.defaults.put("autoCompFields", new byte[]{0, 1, 28});
        this.defaults.put("groupSelectorVisible", new Boolean(true));
        this.defaults.put("groupsDefaultField", "keywords");
        this.defaults.put("defaultOwner", System.getProperty("user.name"));
        this.defaults.put("generalFields", "crossref;keywords;doi;url;pdf;abstract;comment;owner");
        this.defaults.put("historySize", new Integer(5));
        this.defaults.put("fontFamily", "Times");
        this.defaults.put("fontStyle", new Integer(0));
        this.defaults.put("fontSize", new Integer(12));
        this.defaults.put("antialias", new Boolean(true));
        this.defaults.put("ctrlClick", new Boolean(false));
        this.defaults.put("disableOnMultipleSelection", new Boolean(false));
        this.defaults.put("pdfColumn", new Boolean(true));
        this.defaults.put("urlColumn", new Boolean(true));
        this.defaults.put("useOwner", new Boolean(true));
        this.restoreKeyBindings();
    }

    public String get(String key) {
        return this.prefs.get(key, (String)this.defaults.get(key));
    }

    public String get(String key, String def) {
        return this.prefs.get(key, def);
    }

    public boolean getBoolean(String key) {
        return this.prefs.getBoolean(key, (Boolean)this.defaults.get(key));
    }

    public double getDouble(String key) {
        return this.prefs.getDouble(key, (Double)this.defaults.get(key));
    }

    public int getInt(String key) {
        return this.prefs.getInt(key, (Integer)this.defaults.get(key));
    }

    public byte[] getByteArray(String key) {
        return this.prefs.getByteArray(key, (byte[])this.defaults.get(key));
    }

    public void put(String key, String value) {
        this.prefs.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.prefs.putBoolean(key, value);
    }

    public void putDouble(String key, double value) {
        this.prefs.putDouble(key, value);
    }

    public void putInt(String key, int value) {
        this.prefs.putInt(key, value);
    }

    public void putByteArray(String key, byte[] value) {
        this.prefs.putByteArray(key, value);
    }

    public void remove(String key) {
        this.prefs.remove(key);
    }

    public void putStringArray(String key, String[] value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        if (value.length > 0) {
            StringBuffer linked = new StringBuffer();
            for (int i = 0; i < value.length - 1; ++i) {
                linked.append(this.makeEscape(value[i]));
                linked.append(";");
            }
            linked.append(this.makeEscape(value[value.length - 1]));
            this.put(key, linked.toString());
        } else {
            this.put(key, "");
        }
    }

    public String[] getStringArray(String key) {
        String names = this.get(key);
        if (names == null) {
            return null;
        }
        StringReader rd = new StringReader(names);
        Vector<String> arr = new Vector<String>();
        try {
            String rs;
            while ((rs = this.getNextUnit(rd)) != null) {
                arr.add(rs);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] res = new String[arr.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)arr.elementAt(i);
        }
        return res;
    }

    public KeyStroke getKey(String bindName) {
        String s = (String)this.keyBinds.get(bindName);
        if (s == null) {
            s = (String)this.defKeyBinds.get(bindName);
            this.keyBinds.put(bindName, s);
        }
        if (s == null) {
            Globals.logger("Could not get key binding for \"" + bindName + "\"");
        }
        if (Globals.ON_MAC) {
            return this.getKeyForMac(KeyStroke.getKeyStroke(s));
        }
        return KeyStroke.getKeyStroke(s);
    }

    private KeyStroke getKeyForMac(KeyStroke ks) {
        if (ks == null) {
            return null;
        }
        int keyCode = ks.getKeyCode();
        if ((ks.getModifiers() & 2) == 0) {
            return ks;
        }
        if ((ks.getModifiers() & 1) != 0) {
            return KeyStroke.getKeyStroke(keyCode, Globals.SHORTCUT_MASK + 1);
        }
        return KeyStroke.getKeyStroke(keyCode, Globals.SHORTCUT_MASK);
    }

    public HashMap getKeyBindings() {
        return this.keyBinds;
    }

    public HashMap getDefaultKeys() {
        return this.defKeyBinds;
    }

    public void setNewKeyBindings(HashMap newBindings) {
        if (!newBindings.equals(this.keyBinds)) {
            String[] bindNames = new String[newBindings.size()];
            String[] bindings = new String[newBindings.size()];
            int index = 0;
            for (String nm : newBindings.keySet()) {
                String bnd = (String)newBindings.get(nm);
                bindNames[index] = nm;
                bindings[index] = bnd;
                ++index;
            }
            this.putStringArray("bindNames", bindNames);
            this.putStringArray("bindings", bindings);
            this.keyBinds = newBindings;
        }
    }

    public LabelPattern getKeyPattern() {
        if (keyPattern != null) {
            return keyPattern;
        }
        keyPattern = new LabelPattern(KEY_PATTERN);
        Preferences pre = Preferences.userNodeForPackage(LabelPattern.class);
        try {
            String[] keys = pre.keys();
            if (keys.length > 0) {
                for (int i = 0; i < keys.length; ++i) {
                    keyPattern.addLabelPattern(keys[i], pre.get(keys[i], null));
                }
            }
        }
        catch (BackingStoreException ex) {
            Globals.logger("BackingStoreException in JabRefPreferences.getKeyPattern");
        }
        return keyPattern;
    }

    public void putKeyPattern(LabelPattern pattern) {
        keyPattern = pattern;
        LabelPattern parent = pattern.getParent();
        if (parent == null) {
            return;
        }
        Preferences pre = Preferences.userNodeForPackage(LabelPattern.class);
        try {
            pre.clear();
        }
        catch (BackingStoreException ex) {
            Globals.logger("BackingStoreException in JabRefPreferences.putKeyPattern");
        }
        for (String s : pattern.keySet()) {
            if (pattern.get(s).equals(parent.get(s))) continue;
            pre.put(s, pattern.getValue(s).get(0).toString());
        }
    }

    private void restoreKeyBindings() {
        this.defineDefaultKeyBindings();
        String[] bindNames = this.getStringArray("bindNames");
        String[] bindings = this.getStringArray("bindings");
        if (bindNames == null || bindings == null || bindNames.length != bindings.length) {
            this.setDefaultKeyBindings();
            return;
        }
        for (int i = 0; i < bindNames.length; ++i) {
            this.keyBinds.put(bindNames[i], bindings[i]);
        }
    }

    private void setDefaultKeyBindings() {
        this.keyBinds = this.defKeyBinds;
    }

    private void defineDefaultKeyBindings() {
        this.defKeyBinds.put("Push to jeHEP", "ctrl L");
        this.defKeyBinds.put("Quit JabRef", "ctrl Q");
        this.defKeyBinds.put("Open database", "ctrl O");
        this.defKeyBinds.put("Save database", "ctrl S");
        this.defKeyBinds.put("Save database as ...", "ctrl shift S");
        this.defKeyBinds.put("Close database", "ctrl W");
        this.defKeyBinds.put("New entry", "ctrl N");
        this.defKeyBinds.put("Cut", "ctrl X");
        this.defKeyBinds.put("Copy", "ctrl C");
        this.defKeyBinds.put("Paste", "ctrl V");
        this.defKeyBinds.put("Undo", "ctrl Z");
        this.defKeyBinds.put("Redo", "ctrl Y");
        this.defKeyBinds.put("Help", "F1");
        this.defKeyBinds.put("New article", "ctrl shift A");
        this.defKeyBinds.put("New book", "ctrl shift B");
        this.defKeyBinds.put("New phdthesis", "ctrl shift T");
        this.defKeyBinds.put("New inbook", "ctrl shift I");
        this.defKeyBinds.put("New mastersthesis", "ctrl shift M");
        this.defKeyBinds.put("New proceedings", "ctrl shift P");
        this.defKeyBinds.put("New unpublished", "ctrl shift U");
        this.defKeyBinds.put("Edit strings", "ctrl shift S");
        this.defKeyBinds.put("Edit preamble", "ctrl P");
        this.defKeyBinds.put("Select all", "ctrl A");
        this.defKeyBinds.put("Toggle groups interface", "ctrl shift G");
        this.defKeyBinds.put("Autogenerate BibTeX keys", "ctrl G");
        this.defKeyBinds.put("Search", "ctrl F");
        this.defKeyBinds.put("Incremental search", "ctrl shift F");
        this.defKeyBinds.put("Repeat incremental search", "ctrl shift F");
        this.defKeyBinds.put("Close entry editor", "ESCAPE");
        this.defKeyBinds.put("Close preamble editor", "ESCAPE");
        this.defKeyBinds.put("Preamble editor, store changes", "alt S");
        this.defKeyBinds.put("Clear search", "ESCAPE");
        this.defKeyBinds.put("Entry editor, next panel", "ctrl TAB");
        this.defKeyBinds.put("Entry editor, previous panel", "ctrl shift TAB");
        this.defKeyBinds.put("Entry editor, next entry", "ctrl shift Down");
        this.defKeyBinds.put("Entry editor, previous entry", "ctrl shift Up");
        this.defKeyBinds.put("Entry editor, store field", "alt S");
        this.defKeyBinds.put("Save session", "F11");
        this.defKeyBinds.put("Load session", "F12");
        this.defKeyBinds.put("Copy \\cite{BibTeX key}", "ctrl K");
        this.defKeyBinds.put("Next tabclose", "ctrl RIGHT");
        this.defKeyBinds.put("Previous tabclose", "ctrl LEFT");
        this.defKeyBinds.put("Replace string", "ctrl R");
        this.defKeyBinds.put("Delete", "DELETE");
        this.defKeyBinds.put("Open PDF or PS", "F4");
        this.defKeyBinds.put("Open URL or DOI", "F3");
        this.defKeyBinds.put("Toggle entry preview", "F9");
        this.defKeyBinds.put("Edit entry", "ctrl E");
        this.defKeyBinds.put("Mark entries", "ctrl M");
        this.defKeyBinds.put("Unmark entries", "ctrl shift M");
        this.defKeyBinds.put("Fetch Medline", "F5");
    }

    private String getNextUnit(Reader data) throws IOException {
        int c;
        boolean escape = false;
        boolean done = false;
        StringBuffer res = new StringBuffer();
        while (!done && (c = data.read()) != -1) {
            if (c == 92) {
                if (!escape) {
                    escape = true;
                    continue;
                }
                escape = false;
                res.append('\\');
                continue;
            }
            if (c == 59) {
                if (!escape) {
                    done = true;
                } else {
                    res.append(';');
                }
            } else {
                res.append((char)c);
            }
            escape = false;
        }
        if (res.length() > 0) {
            return res.toString();
        }
        return null;
    }

    private String makeEscape(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == ';') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void storeCustomEntryType(CustomEntryType tp, int number) {
        String nr = "" + number;
        this.put("customTypeName_" + nr, tp.getName());
        this.putStringArray("customTypeReq_" + nr, tp.getRequiredFields());
        this.putStringArray("customTypeOpt_" + nr, tp.getOptionalFields());
    }

    public CustomEntryType getCustomEntryType(int number) {
        String nr = "" + number;
        String name = this.get("customTypeName_" + nr);
        String[] req = this.getStringArray("customTypeReq_" + nr);
        String[] opt = this.getStringArray("customTypeOpt_" + nr);
        if (name == null) {
            return null;
        }
        return new CustomEntryType(Util.nCase(name), req, opt);
    }

    public void purgeCustomEntryTypes(int number) {
        while (this.get("customTypeName_" + number) != null) {
            this.remove("customTypeName_" + number);
            this.remove("customTypeReq_" + number);
            this.remove("customTypeOpt_" + number);
            ++number;
        }
    }
}

