/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class GUIGlobals {
    static int teller = 0;
    static String frameTitle = "JabRef";
    static String version = "1.3.1";
    static String stringsTitle = "Strings for database";
    static String untitledTitle = "untitled";
    static String helpTitle = "JabRef help";
    static String TYPE_HEADER = "entrytype";
    static String NUMBER_COL = "#";
    public static Font CURRENTFONT;
    public static Font typeNameFont;
    public static Font jabRefFont;
    public static final String SIGNATURE;
    static Dimension helpSize;
    static Dimension aboutSize;
    static Dimension searchPaneSize;
    static Dimension searchFieldSize;
    public static final int SPLIT_PANE_DIVIDER_SIZE = 2;
    public static final int SPLIT_PANE_DIVIDER_LOCATION = 145;
    public static final int GROUPS_VISIBLE_ROWS = 10;
    public static final int TABLE_ROW_PADDING = 4;
    public static final int KEYBIND_COL_0 = 200;
    public static final int KEYBIND_COL_1 = 80;
    public static final int PREVIEW_HEIGHT = 115;
    public static final double VERTICAL_DIVIDER_LOCATION = 0.4;
    public static String backupExt;
    public static String tempExt;
    public static String defaultDir;
    public static String imageSize;
    public static String extension;
    public static String ex;
    public static String pre;
    public static String helpPre;
    static HashMap tableIcons;
    public static URL openIconFile;
    public static URL editIconFile;
    public static URL saveIconFile;
    public static URL saveAsIconFile;
    public static URL prefsIconFile;
    public static URL newIconFile;
    public static URL undoIconFile;
    public static URL redoIconFile;
    public static URL preambleIconFile;
    public static URL addIconFile;
    public static URL delRowIconFile;
    public static URL showReqIconFile;
    public static URL showOptIconFile;
    public static URL showGenIconFile;
    public static URL sourceIconFile;
    public static URL copyIconFile;
    public static URL cutIconFile;
    public static URL copyKeyIconFile;
    public static URL genKeyIconFile;
    public static URL lyxIconFile;
    public static URL backIconFile;
    public static URL forwardIconFile;
    public static URL contentsIconFile;
    public static URL removeIconFile;
    public static URL upIconFile;
    public static URL downIconFile;
    public static URL stringsIconFile;
    public static URL groupsIconFile;
    public static URL closeIconFile;
    public static URL refreshSmallIconFile;
    public static URL helpSmallIconFile;
    public static URL helpIconFile;
    public static URL aboutIcon;
    public static URL helpContentsIconFile;
    public static URL newSmallIconFile;
    public static URL pasteIconFile;
    public static URL editEntryIconFile;
    public static URL searchIconFile;
    public static URL autoGroupIcon;
    public static URL wwwIcon;
    public static URL fetchMedlineIcon;
    public static URL pdfIcon;
    public static URL pdfSmallIcon;
    public static URL sheetIcon;
    public static URL doiIcon;
    public static URL doiSmallIcon;
    public static URL psIcon;
    public static URL jabreflogo;
    public static String baseFrameHelp;
    public static String entryEditorHelp;
    public static String stringEditorHelp;
    public static String helpContents;
    public static String searchHelp;
    public static String groupsHelp;
    public static String customEntriesHelp;
    public static String contentSelectorHelp;
    public static String labelPatternHelp;
    public static String ownerHelp;
    public static String pdfHelp;
    public static String aboutPage;
    public static String openKey;
    public static String closeKey;
    public static String storeFieldKey;
    public static String copyKeyKey;
    public static String showReqKey;
    public static String showOptKey;
    public static String showGenKey;
    public static String addKey;
    public static String removeKey;
    public static String upKey;
    public static String downKey;
    public static Integer openKeyCode;
    public static Integer saveKeyCode;
    public static Integer copyKeyCode;
    public static Integer closeKeyCode;
    public static Integer showReqKeyCode;
    public static Integer showOptKeyCode;
    public static Integer showGenKeyCode;
    public static Integer newEntryKeyCode;
    public static Integer newBookKeyCode;
    public static Integer newArticleKeyCode;
    public static Integer newPhdthesisKeyCode;
    public static Integer newInBookKeyCode;
    public static Integer newMasterKeyCode;
    public static Integer newProcKeyCode;
    public static KeyStroke generateKeyStroke;
    public static KeyStroke exitDialog;
    public static KeyStroke copyStroke;
    public static KeyStroke pasteStroke;
    public static KeyStroke undoStroke;
    public static KeyStroke redoStroke;
    public static KeyStroke selectAllKeyStroke;
    public static KeyStroke editEntryKeyStroke;
    public static KeyStroke helpKeyStroke;
    public static KeyStroke editPreambleKeyStroke;
    public static KeyStroke editStringsKeyStroke;
    public static KeyStroke simpleSearchKeyStroke;
    public static KeyStroke autoCompKeyStroke;
    public static KeyStroke showGroupsKeyStroke;
    public static KeyStroke saveKeyStroke;
    public static KeyStroke openKeyStroke;
    public static KeyStroke closeKeyStroke;
    public static KeyStroke newEntryKeyStroke;
    public static KeyStroke removeEntryKeyStroke;
    public static KeyStroke newBookKeyStroke;
    public static KeyStroke newArticleKeyStroke;
    public static KeyStroke newPhdthesisKeyStroke;
    public static KeyStroke newInBookKeyStroke;
    public static KeyStroke newMasterKeyStroke;
    public static KeyStroke newProcKeyStroke;
    public static KeyStroke newUnpublKeyStroke;
    public static KeyStroke switchPanelLeft;
    public static KeyStroke switchPanelRight;
    public static Color gridColor;
    public static Color lightGray;
    public static Color nullFieldColor;
    public static Color validFieldColor;
    public static Color invalidFieldColor;
    public static Color validFieldBackground;
    public static Color invalidFieldBackground;
    public static Color tableBackground;
    public static Color tableReqFieldBackground;
    public static Color tableOptFieldBackground;
    public static Color tableIncompleteEntryBackground;
    public static Color maybeIncompleteEntryBackground;
    public static Color markedEntryBackground;
    public static Color grayedOutBackground;
    public static Color grayedOutText;
    public static Color veryGrayedOutBackground;
    public static Color veryGrayedOutText;
    public static String META_FLAG;
    public static String META_FLAG_OLD;
    public static String KEY_FIELD;
    public static String[] ALL_FIELDS;
    public static String[] BIBTEX_STANDARD_FIELDS;
    public static String[] NON_WRITABLE_FIELDS;
    public static String[] NON_DISPLAYABLE_FIELDS;
    public static double DEFAULT_FIELD_WEIGHT;
    public static Double SMALL_W;
    public static Double MEDIUM_W;
    public static Double LARGE_W;
    public static final double PE_HEIGHT = 2.0;
    public static int[] FORM_WIDTH;
    public static int[] FORM_HEIGHT;
    public static final int INDENT = 4;
    public static final int LINE_LENGTH = 65;
    public static int DEFAULT_FIELD_LENGTH;
    public static int NUMBER_COL_LENGTH;
    public static int WIDTH_ICON_COL;
    public static final Map FIELD_WEIGHT;
    public static final Map FIELD_EXTRAS;
    public static final Map LANGUAGES;
    public static Map fieldLength;

    public static ImageIcon getTableIcon(String fieldType) {
        Object o = tableIcons.get(fieldType);
        if (o == null) {
            Globals.logger("Error: no table icon defined for type '" + fieldType + "'.");
            return null;
        }
        return (ImageIcon)o;
    }

    public static boolean isWriteableField(String field) {
        for (int i = 0; i < NON_WRITABLE_FIELDS.length; ++i) {
            if (!NON_WRITABLE_FIELDS[i].equals(field)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDisplayableField(String field) {
        for (int i = 0; i < NON_DISPLAYABLE_FIELDS.length; ++i) {
            if (!NON_DISPLAYABLE_FIELDS[i].equals(field)) continue;
            return false;
        }
        return true;
    }

    public static boolean isStandardField(String field) {
        for (int i = 0; i < BIBTEX_STANDARD_FIELDS.length; ++i) {
            if (!BIBTEX_STANDARD_FIELDS[i].equals(field)) continue;
            return true;
        }
        return false;
    }

    public static double getFieldWeight(String name) {
        double l = DEFAULT_FIELD_WEIGHT;
        Object o = FIELD_WEIGHT.get(name.toLowerCase());
        if (o != null) {
            l = (Double)o;
        }
        return l;
    }

    static {
        typeNameFont = new Font("arial", 3, 24);
        jabRefFont = new Font("arial", 2, 20);
        SIGNATURE = "This file was created with JabRef " + version + ".\n\n";
        helpSize = new Dimension(700, 600);
        aboutSize = new Dimension(600, 265);
        searchPaneSize = new Dimension(430, 70);
        searchFieldSize = new Dimension(215, 25);
        backupExt = ".bak";
        tempExt = ".tmp";
        defaultDir = ".";
        imageSize = "24";
        extension = ".gif";
        ex = imageSize + extension;
        pre = "/resources/images/";
        helpPre = "/jabref/help/";
        tableIcons = new HashMap();
        openIconFile = GUIGlobals.class.getResource(pre + "Open.png");
        editIconFile = GUIGlobals.class.getResource(pre + "pencil.png");
        saveIconFile = GUIGlobals.class.getResource(pre + "Save.png");
        saveAsIconFile = GUIGlobals.class.getResource(pre + "SaveAs.png");
        prefsIconFile = GUIGlobals.class.getResource(pre + "configure2.png");
        newIconFile = GUIGlobals.class.getResource(pre + "New.png");
        undoIconFile = GUIGlobals.class.getResource(pre + "Undo.png");
        redoIconFile = GUIGlobals.class.getResource(pre + "Redo.png");
        preambleIconFile = GUIGlobals.class.getResource(pre + "preamble.png");
        addIconFile = GUIGlobals.class.getResource(pre + "news_subscribe.png");
        delRowIconFile = GUIGlobals.class.getResource(pre + "news_unsubscribe.png");
        showReqIconFile = GUIGlobals.class.getResource(pre + "r_icon.gif");
        showOptIconFile = GUIGlobals.class.getResource(pre + "o_icon.gif");
        showGenIconFile = GUIGlobals.class.getResource(pre + "g_icon.gif");
        sourceIconFile = GUIGlobals.class.getResource(pre + "viewsource.gif");
        copyIconFile = GUIGlobals.class.getResource(pre + "Copy.png");
        cutIconFile = GUIGlobals.class.getResource(pre + "Cut.png");
        copyKeyIconFile = GUIGlobals.class.getResource(pre + "Copy.png");
        genKeyIconFile = GUIGlobals.class.getResource(pre + "wizard.png");
        lyxIconFile = GUIGlobals.class.getResource(pre + "push_jehep.gif");
        backIconFile = GUIGlobals.class.getResource(pre + "back.png");
        forwardIconFile = GUIGlobals.class.getResource(pre + "forward.png");
        contentsIconFile = GUIGlobals.class.getResource(pre + "contents2.png");
        removeIconFile = GUIGlobals.class.getResource(pre + "Delete.png");
        upIconFile = GUIGlobals.class.getResource(pre + "up.png");
        downIconFile = GUIGlobals.class.getResource(pre + "down.png");
        stringsIconFile = GUIGlobals.class.getResource(pre + "strings.png");
        groupsIconFile = GUIGlobals.class.getResource(pre + "queue.png");
        closeIconFile = GUIGlobals.class.getResource(pre + "Close.png");
        refreshSmallIconFile = GUIGlobals.class.getResource(pre + "Reload.png");
        helpSmallIconFile = GUIGlobals.class.getResource(pre + "help.png");
        helpIconFile = GUIGlobals.class.getResource(pre + "help.png");
        aboutIcon = GUIGlobals.class.getResource(pre + "hwinfo.png");
        helpContentsIconFile = GUIGlobals.class.getResource(pre + "contents2.png");
        newSmallIconFile = GUIGlobals.class.getResource(pre + "New.png");
        pasteIconFile = GUIGlobals.class.getResource(pre + "Paste.png");
        editEntryIconFile = GUIGlobals.class.getResource(pre + "DocumentDraw.gif");
        searchIconFile = GUIGlobals.class.getResource(pre + "Find.png");
        autoGroupIcon = GUIGlobals.class.getResource(pre + "Run.png");
        wwwIcon = GUIGlobals.class.getResource(pre + "www.png");
        fetchMedlineIcon = GUIGlobals.class.getResource(pre + "goto.png");
        pdfIcon = GUIGlobals.class.getResource(pre + "pdf.png");
        pdfSmallIcon = GUIGlobals.class.getResource(pre + "pdf_small.gif");
        sheetIcon = GUIGlobals.class.getResource(pre + "window_nofullscreen.png");
        doiIcon = GUIGlobals.class.getResource(pre + "doi.png");
        doiSmallIcon = GUIGlobals.class.getResource(pre + "doismall.png");
        psIcon = GUIGlobals.class.getResource(pre + "postscript.png");
        jabreflogo = GUIGlobals.class.getResource(pre + "JabRef-Logo.gif");
        baseFrameHelp = "BaseFrameHelp.html";
        entryEditorHelp = "EntryEditorHelp.html";
        stringEditorHelp = "StringEditorHelp.html";
        helpContents = "Contents.html";
        searchHelp = "SearchHelp.html";
        groupsHelp = "GroupsHelp.html";
        customEntriesHelp = "CustomEntriesHelp.html";
        contentSelectorHelp = "ContentSelectorHelp.html";
        labelPatternHelp = "LabelPatterns.html";
        ownerHelp = "OwnerHelp.html";
        pdfHelp = "ExternalFiles.html";
        aboutPage = "About.html";
        openKey = "control O";
        closeKey = "control Q";
        storeFieldKey = "control S";
        copyKeyKey = "control K";
        showReqKey = "control R";
        showOptKey = "control O";
        showGenKey = "control G";
        addKey = "control N";
        removeKey = "shift DELETE";
        upKey = "control UP";
        downKey = "control DOWN";
        openKeyCode = new Integer(79);
        saveKeyCode = new Integer(83);
        copyKeyCode = new Integer(75);
        closeKeyCode = new Integer(81);
        showReqKeyCode = new Integer(82);
        showOptKeyCode = new Integer(79);
        showGenKeyCode = new Integer(71);
        newEntryKeyCode = new Integer(78);
        newBookKeyCode = new Integer(66);
        newArticleKeyCode = new Integer(65);
        newPhdthesisKeyCode = new Integer(84);
        newInBookKeyCode = new Integer(73);
        newMasterKeyCode = new Integer(77);
        newProcKeyCode = new Integer(80);
        generateKeyStroke = KeyStroke.getKeyStroke("control G");
        exitDialog = KeyStroke.getKeyStroke("ESCAPE");
        copyStroke = KeyStroke.getKeyStroke("control C");
        pasteStroke = KeyStroke.getKeyStroke("control V");
        undoStroke = KeyStroke.getKeyStroke("control Z");
        redoStroke = KeyStroke.getKeyStroke("control Y");
        selectAllKeyStroke = KeyStroke.getKeyStroke("control A");
        editEntryKeyStroke = KeyStroke.getKeyStroke("control D");
        helpKeyStroke = KeyStroke.getKeyStroke("F1");
        editPreambleKeyStroke = KeyStroke.getKeyStroke("control P");
        editStringsKeyStroke = KeyStroke.getKeyStroke("control shift S");
        simpleSearchKeyStroke = KeyStroke.getKeyStroke("control F");
        autoCompKeyStroke = KeyStroke.getKeyStroke("control W");
        showGroupsKeyStroke = KeyStroke.getKeyStroke("control shift G");
        saveKeyStroke = KeyStroke.getKeyStroke(saveKeyCode, 2);
        openKeyStroke = KeyStroke.getKeyStroke(openKeyCode, 2);
        closeKeyStroke = KeyStroke.getKeyStroke(closeKeyCode, 2);
        newEntryKeyStroke = KeyStroke.getKeyStroke(newEntryKeyCode, 2);
        removeEntryKeyStroke = KeyStroke.getKeyStroke(127, 1);
        newBookKeyStroke = KeyStroke.getKeyStroke(newBookKeyCode, 3);
        newArticleKeyStroke = KeyStroke.getKeyStroke(newArticleKeyCode, 3);
        newPhdthesisKeyStroke = KeyStroke.getKeyStroke(newPhdthesisKeyCode, 3);
        newInBookKeyStroke = KeyStroke.getKeyStroke(newInBookKeyCode, 3);
        newMasterKeyStroke = KeyStroke.getKeyStroke(newMasterKeyCode, 3);
        newProcKeyStroke = KeyStroke.getKeyStroke(newProcKeyCode, 3);
        newUnpublKeyStroke = KeyStroke.getKeyStroke("control shift U");
        switchPanelLeft = KeyStroke.getKeyStroke("control shift LEFT");
        switchPanelRight = KeyStroke.getKeyStroke("control shift RIGHT");
        gridColor = new Color(210, 210, 210);
        lightGray = new Color(230, 230, 230);
        nullFieldColor = new Color(100, 100, 150);
        validFieldColor = new Color(75, 130, 75);
        invalidFieldColor = new Color(141, 0, 61);
        validFieldBackground = Color.white;
        invalidFieldBackground = new Color(141, 0, 61);
        tableBackground = Color.white;
        tableReqFieldBackground = new Color(235, 235, 255);
        tableOptFieldBackground = new Color(230, 255, 230);
        tableIncompleteEntryBackground = new Color(250, 175, 175);
        maybeIncompleteEntryBackground = new Color(255, 255, 200);
        markedEntryBackground = new Color(255, 255, 180);
        grayedOutBackground = new Color(225, 210, 210);
        grayedOutText = new Color(40, 40, 40);
        veryGrayedOutBackground = new Color(205, 180, 180);
        veryGrayedOutText = new Color(40, 40, 40);
        META_FLAG = "jabref-meta: ";
        META_FLAG_OLD = "bibkeeper-meta: ";
        KEY_FIELD = "bibtexkey";
        ALL_FIELDS = new String[]{"author", "editor", "title", "year", "pages", "month", "note", "publisher", "journal", "volume", "edition", "number", "chapter", "series", "type", "address", "annote", "booktitle", "crossref", "howpublished", "institution", "key", "organization", "school", "abstract", "url", "pdf", "comment", "bibtexkey", "keywords", "doi", "eid", "search"};
        BIBTEX_STANDARD_FIELDS = new String[]{"author", "editor", "title", "year", "pages", "month", "note", "publisher", "journal", "volume", "edition", "number", "chapter", "series", "type", "address", "annote", "booktitle", "crossref", "howpublished", "institution", "key", "organization", "school", "bibtexkey", "doi", "eid"};
        NON_WRITABLE_FIELDS = new String[]{"__search", "__groupsearch"};
        NON_DISPLAYABLE_FIELDS = new String[]{"__markedentry", "__search", "__groupsearch"};
        DEFAULT_FIELD_WEIGHT = 1.0;
        SMALL_W = new Double(0.3);
        MEDIUM_W = new Double(0.5);
        LARGE_W = new Double(1.5);
        FORM_WIDTH = new int[]{500, 650, 820};
        FORM_HEIGHT = new int[]{90, 110, 130};
        DEFAULT_FIELD_LENGTH = 100;
        NUMBER_COL_LENGTH = 32;
        WIDTH_ICON_COL = 19;
        fieldLength = new HashMap();
        LANGUAGES = new HashMap();
        LANGUAGES.put("English", "en");
        LANGUAGES.put("Deutsch", "de");
        LANGUAGES.put("Fran\ufffdais", "fr");
        LANGUAGES.put("Norsk", "no");
        FIELD_EXTRAS = new HashMap();
        FIELD_EXTRAS.put("pdf", "browsePdf");
        FIELD_EXTRAS.put("ps", "browse");
        FIELD_EXTRAS.put("url", "external");
        FIELD_EXTRAS.put("doi", "external");
        tableIcons.put("pdf", new ImageIcon(pdfIcon));
        tableIcons.put("url", new ImageIcon(wwwIcon));
        tableIcons.put("doi", new ImageIcon(doiSmallIcon));
        tableIcons.put("ps", new ImageIcon(psIcon));
        fieldLength.put("author", new Integer(280));
        fieldLength.put("editor", new Integer(280));
        fieldLength.put("title", new Integer(400));
        fieldLength.put("abstract", new Integer(400));
        fieldLength.put("booktitle", new Integer(175));
        fieldLength.put("year", new Integer(60));
        fieldLength.put("volume", new Integer(60));
        fieldLength.put("number", new Integer(60));
        fieldLength.put("entrytype", new Integer(75));
        fieldLength.put("search", new Integer(75));
        fieldLength.put(NUMBER_COL, new Integer(32));
        HashMap<String, Double> fieldWeight = new HashMap<String, Double>();
        fieldWeight.put("author", MEDIUM_W);
        fieldWeight.put("year", SMALL_W);
        fieldWeight.put("pages", SMALL_W);
        fieldWeight.put("month", SMALL_W);
        fieldWeight.put("url", SMALL_W);
        fieldWeight.put("crossref", SMALL_W);
        fieldWeight.put("note", MEDIUM_W);
        fieldWeight.put("publisher", MEDIUM_W);
        fieldWeight.put("journal", SMALL_W);
        fieldWeight.put("volume", SMALL_W);
        fieldWeight.put("edition", SMALL_W);
        fieldWeight.put("keywords", SMALL_W);
        fieldWeight.put("doi", SMALL_W);
        fieldWeight.put("eid", SMALL_W);
        fieldWeight.put("pdf", SMALL_W);
        fieldWeight.put("number", SMALL_W);
        fieldWeight.put("chapter", SMALL_W);
        fieldWeight.put("editor", MEDIUM_W);
        fieldWeight.put("series", SMALL_W);
        fieldWeight.put("type", SMALL_W);
        fieldWeight.put("address", SMALL_W);
        fieldWeight.put("howpublished", MEDIUM_W);
        fieldWeight.put("institution", MEDIUM_W);
        fieldWeight.put("organization", MEDIUM_W);
        fieldWeight.put("school", MEDIUM_W);
        fieldWeight.put("comment", MEDIUM_W);
        fieldWeight.put("abstract", LARGE_W);
        FIELD_WEIGHT = Collections.unmodifiableMap(fieldWeight);
    }
}

