/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.Globals;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class FileHistory
extends JMenu
implements ActionListener {
    private static final long serialVersionUID = 1L;
    int bound = 5;
    JabRefPreferences prefs;
    LinkedList history = new LinkedList();
    JabRefFrame frame;

    public FileHistory(JabRefPreferences prefs2, JabRefFrame frame) {
        super(Globals.lang("Recent files"));
        this.prefs = prefs2;
        this.frame = frame;
        String[] old = prefs2.getStringArray("recentFiles");
        if (old != null && old.length > 0) {
            for (int i = 0; i < old.length; ++i) {
                JMenuItem item = new JMenuItem(old[i]);
                item.addActionListener(this);
                this.add(item);
                this.history.addFirst(item);
            }
        } else {
            this.setEnabled(false);
        }
    }

    public void newFile(String filename) {
        JMenuItem item = new JMenuItem(filename);
        item.addActionListener(this);
        for (int i = 0; i < this.history.size(); ++i) {
            if (!((JMenuItem)this.history.get(i)).getText().equals(filename)) continue;
            this.history.remove(i--);
        }
        this.history.addFirst(item);
        while (this.history.size() > this.prefs.getInt("historySize")) {
            this.history.removeLast();
        }
        this.setItems();
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
    }

    private void setItems() {
        this.removeAll();
        Iterator i = this.history.iterator();
        while (i.hasNext()) {
            this.add((JMenuItem)i.next());
        }
    }

    public void storeHistory() {
        if (this.history.size() > 0) {
            String[] names = new String[this.history.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = ((JMenuItem)this.history.get(i)).getText();
            }
            this.prefs.putStringArray("recentFiles", names);
        }
    }

    public void setFileHistory() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name = ((JMenuItem)e.getSource()).getText();
        this.frame.fileToOpen = new File(name);
        new Thread(){

            @Override
            public void run() {
                FileHistory.this.frame.openDatabaseAction.openIt(true);
            }
        }.start();
    }
}

