/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.FieldContentSelector;
import jabref.FieldEditor;
import jabref.FieldTextArea;
import jabref.FieldTextField;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.HelpAction;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import jabref.Util;
import jabref.export.LatexFieldFormatter;
import jabref.imports.BibtexParser;
import jabref.labelPattern.LabelPatternUtil;
import jabref.undo.NamedCompound;
import jabref.undo.UndoableFieldChange;
import jabref.undo.UndoableKeyChange;
import jabref.undo.UndoableRemoveEntry;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class EntryEditor
extends JPanel
implements VetoableChangeListener {
    BibtexEntry entry;
    CloseAction closeAction;
    DeleteAction deleteAction = new DeleteAction();
    CopyKeyAction copyKeyAction;
    AbstractAction nextEntryAction = new NextEntryAction();
    AbstractAction prevEntryAction = new PrevEntryAction();
    StoreFieldAction storeFieldAction;
    SwitchLeftAction switchLeftAction = new SwitchLeftAction();
    SwitchRightAction switchRightAction = new SwitchRightAction();
    GenerateKeyAction generateKeyAction;
    SaveDatabaseAction saveDatabaseAction = new SaveDatabaseAction();
    JPanel mainPanel = new JPanel();
    JPanel srcPanel = new JPanel();
    FieldPanel reqPanel = new FieldPanel();
    FieldPanel optPanel = new FieldPanel();
    FieldPanel genPanel = new FieldPanel();
    JTextField bibtexKey;
    FieldTextField tf;
    JTextArea source;
    JToolBar tlb;
    JTabbedPane tabbed = new JTabbedPane();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JLabel lab;
    JPanel typeLabel;
    JabRefFrame frame;
    BasePanel panel;
    EntryEditor ths = this;
    boolean updateSource = true;
    boolean lastSourceAccepted = true;
    String lastSourceStringAccepted = null;
    double optW = 0.0;
    double reqW = 1.0;
    double genW = 0.0;
    private int sourceIndex = -1;
    private final String KEY_PROPERTY = "bibtexkey";
    JabRefPreferences prefs;
    HelpAction helpAction;
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();

    public EntryEditor(JabRefFrame frame_, BasePanel panel_, BibtexEntry entry_, JabRefPreferences prefs_) {
        this.frame = frame_;
        this.panel = panel_;
        this.entry = entry_;
        this.prefs = prefs_;
        this.setBackground(GUIGlobals.lightGray);
        this.entry.addPropertyChangeListener(this);
        this.helpAction = new HelpAction(this.frame.helpDiag, GUIGlobals.entryEditorHelp, "Help");
        this.closeAction = new CloseAction();
        this.copyKeyAction = new CopyKeyAction();
        this.generateKeyAction = new GenerateKeyAction(this.frame);
        this.storeFieldAction = new StoreFieldAction();
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        this.setupToolBar();
        this.setupFieldPanels(this.reqPanel, this.optPanel, this.genPanel);
        this.setupSourcePanel();
        this.tabbed.addTab(Globals.lang("Required fields"), new ImageIcon(GUIGlobals.showReqIconFile), this.reqPanel.getPane(), Globals.lang("Show required fields"));
        if (this.entry.getOptionalFields() != null && this.entry.getOptionalFields().length >= 1) {
            this.tabbed.addTab(Globals.lang("Optional fields"), new ImageIcon(GUIGlobals.showOptIconFile), this.optPanel.getPane(), Globals.lang("Show optional fields"));
        }
        if (this.entry.getGeneralFields() != null && this.entry.getGeneralFields().length >= 1) {
            this.tabbed.addTab(Globals.lang("General fields"), new ImageIcon(GUIGlobals.showGenIconFile), this.genPanel.getPane(), Globals.lang("Show general fields"));
        }
        this.tabbed.addTab(Globals.lang("BibTeX source"), new ImageIcon(GUIGlobals.sourceIconFile), this.srcPanel, Globals.lang("Show/edit BibTeX source"));
        this.sourceIndex = this.tabbed.getTabCount() - 1;
        this.tabbed.addChangeListener(new TabListener());
        this.add((Component)this.tabbed, "Center");
        int prefHeight = (int)(Math.max(this.genW, Math.max(this.optW, this.reqW)) * (double)GUIGlobals.FORM_HEIGHT[this.prefs.getInt("entryTypeFormHeightFactor")]);
        this.setSize(GUIGlobals.FORM_WIDTH[this.prefs.getInt("entryTypeFormWidth")], prefHeight);
        if (this.prefs.getBoolean("defaultShowSource")) {
            this.tabbed.setSelectedIndex(this.sourceIndex);
        }
    }

    private void setupToolBar() {
        this.tlb = new JToolBar(1);
        this.tlb.setMargin(new Insets(0, 0, 0, 2));
        ActionMap am = this.tlb.getActionMap();
        InputMap im = this.tlb.getInputMap(2);
        im.put(GUIGlobals.exitDialog, "close");
        am.put("close", this.closeAction);
        im.put(this.prefs.getKey("Entry editor, store field"), "store");
        am.put("store", this.storeFieldAction);
        im.put(GUIGlobals.generateKeyStroke, "generateKey");
        am.put("generateKey", this.generateKeyAction);
        im.put(this.prefs.getKey("Entry editor, previous panel"), "left");
        am.put("left", this.switchLeftAction);
        im.put(this.prefs.getKey("Entry editor, next panel"), "right");
        am.put("right", this.switchRightAction);
        im.put(this.prefs.getKey("Entry editor, previous entry"), "prev");
        am.put("prev", this.prevEntryAction);
        im.put(this.prefs.getKey("Entry editor, next entry"), "next");
        am.put("next", this.nextEntryAction);
        im.put(GUIGlobals.undoStroke, "undo");
        am.put("undo", this.undoAction);
        im.put(GUIGlobals.redoStroke, "redo");
        am.put("redo", this.redoAction);
        im.put(GUIGlobals.helpKeyStroke, "help");
        am.put("help", this.helpAction);
        this.tlb.setFloatable(false);
        this.tlb.add(this.closeAction);
        this.setLabel();
        this.tlb.add(this.typeLabel);
        this.tlb.addSeparator();
        this.tlb.add(this.generateKeyAction);
        this.tlb.addSeparator();
        this.tlb.add(this.deleteAction);
        this.tlb.add(this.prevEntryAction);
        this.tlb.add(this.nextEntryAction);
        this.tlb.addSeparator();
        this.tlb.add(this.helpAction);
        Component[] comps = this.tlb.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ((JComponent)comps[i]).setOpaque(false);
        }
        this.add((Component)this.tlb, "West");
    }

    private void setLabel() {
        this.typeLabel = new TypeLabel(this.entry.getType().getName());
    }

    private void setupFieldPanels(FieldPanel req, FieldPanel opt, FieldPanel gen) {
        String[] reqFields = this.entry.getRequiredFields();
        String[] optFields = this.entry.getOptionalFields();
        String[] genFields = this.prefs.getStringArray("generalFields");
        if (reqFields == null) {
            reqFields = new String[]{};
        }
        if (optFields == null) {
            optFields = new String[]{};
        }
        if (genFields == null) {
            genFields = new String[]{};
        }
        int rmax = reqFields.length;
        int omax = optFields.length;
        int gmax = genFields.length;
        int iter = Math.max(rmax, Math.max(omax, gmax));
        FieldTextArea ta1 = null;
        FieldTextArea ta2 = null;
        FieldTextArea ta3 = null;
        FieldTextArea firstR = null;
        FieldTextArea firstO = null;
        JComponent ex1 = null;
        JComponent ex2 = null;
        JComponent ex3 = null;
        req.setLayout(this.gbl);
        opt.setLayout(this.gbl);
        gen.setLayout(this.gbl);
        this.con.insets = new Insets(5, 5, 0, 0);
        this.con.anchor = 17;
        this.con.fill = 1;
        for (int i = 0; i < iter; ++i) {
            String stringContent;
            Object content;
            this.con.gridwidth = 1;
            this.con.weightx = 0.0;
            this.con.weighty = 0.0;
            if (i < rmax) {
                content = this.entry.getField(reqFields[i]);
                stringContent = content != null ? content.toString() : null;
                ta1 = new FieldTextArea(reqFields[i], stringContent);
                ex1 = this.getExtra(reqFields[i], ta1);
                this.setupJTextComponent(ta1);
                if (i == 0) {
                    firstR = ta1;
                    req.setActive(ta1);
                }
            }
            if (i < omax) {
                content = this.entry.getField(optFields[i]);
                stringContent = content != null ? content.toString() : null;
                ta2 = new FieldTextArea(optFields[i], stringContent);
                ex2 = this.getExtra(optFields[i], ta2);
                this.setupJTextComponent(ta2);
                if (i == 0) {
                    firstO = ta2;
                    opt.setActive(ta2);
                }
            }
            if (i < gmax) {
                content = this.entry.getField(genFields[i]);
                stringContent = content != null ? content.toString() : null;
                ta3 = new FieldTextArea(genFields[i], stringContent);
                ex3 = this.getExtra(genFields[i], ta3);
                this.setupJTextComponent(ta3);
                if (i == 0) {
                    firstO = ta3;
                    gen.setActive(ta3);
                }
            }
            if (i < rmax) {
                this.gbl.setConstraints(ta1.getLabel(), this.con);
                req.add(ta1.getLabel());
            }
            if (i < omax) {
                this.gbl.setConstraints(ta2.getLabel(), this.con);
                opt.add(ta2.getLabel());
            }
            if (i < gmax) {
                this.gbl.setConstraints(ta3.getLabel(), this.con);
                gen.add(ta3.getLabel());
            }
            this.con.gridwidth = 0;
            this.con.weightx = 1.0;
            if (i < rmax) {
                this.con.gridwidth = ex1 != null ? 1 : 0;
                this.con.weighty = GUIGlobals.getFieldWeight(reqFields[i]);
                this.reqW += this.con.weighty;
                this.gbl.setConstraints(ta1.getPane(), this.con);
                req.add(ta1.getPane());
                if (ex1 != null) {
                    this.con.gridwidth = 0;
                    this.con.weightx = 0.0;
                    this.gbl.setConstraints(ex1, this.con);
                    req.add(ex1);
                }
            }
            if (i < omax) {
                this.con.gridwidth = ex2 != null ? 1 : 0;
                this.con.weighty = GUIGlobals.getFieldWeight(optFields[i]);
                this.optW += this.con.weighty;
                this.gbl.setConstraints(ta2.getPane(), this.con);
                opt.add(ta2.getPane());
                if (ex2 != null) {
                    this.con.gridwidth = 0;
                    this.con.weightx = 0.0;
                    this.gbl.setConstraints(ex2, this.con);
                    opt.add(ex2);
                }
            }
            if (i >= gmax) continue;
            this.con.gridwidth = ex3 != null ? 1 : 0;
            this.con.weighty = GUIGlobals.getFieldWeight(genFields[i]);
            this.genW += this.con.weighty;
            this.gbl.setConstraints(ta3.getPane(), this.con);
            gen.add(ta3.getPane());
            if (ex3 == null) continue;
            this.con.gridwidth = 0;
            this.con.weightx = 0.0;
            this.con.fill = 2;
            this.con.anchor = 17;
            this.gbl.setConstraints(ex3, this.con);
            this.con.fill = 1;
            gen.add(ex3);
            this.con.anchor = 10;
        }
        this.con.insets.top += 25;
        this.con.insets.bottom = 10;
        this.con.gridwidth = 1;
        this.con.weighty = 0.0;
        this.con.weightx = 0.0;
        this.con.anchor = 16;
        this.con.fill = 0;
        this.tf = new FieldTextField("bibtexkey", (String)this.entry.getField("bibtexkey"));
        this.gbl.setConstraints(this.tf.getLabel(), this.con);
        req.add(this.tf.getLabel());
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.fill = 2;
        this.setupJTextComponent(this.tf);
        this.gbl.setConstraints(this.tf, this.con);
        req.add(this.tf);
    }

    private JComponent getExtra(String string, FieldEditor editor) {
        final FieldEditor ed = editor;
        Object o = GUIGlobals.FIELD_EXTRAS.get(string);
        final String fieldName = editor.getFieldName();
        String s = (String)o;
        if (s != null && s.equals("external")) {
            ((JComponent)((Object)editor)).addMouseListener(new ExternalViewerListener());
            return null;
        }
        if (this.panel.metaData.getData("selector_" + editor.getFieldName()) != null) {
            FieldContentSelector ws = new FieldContentSelector(this, editor, this.panel.metaData);
            return ws;
        }
        if (s != null && s.equals("browse")) {
            JButton but = new JButton(Globals.lang("Browse"));
            ((JComponent)((Object)editor)).addMouseListener(new ExternalViewerListener());
            but.setBackground(GUIGlobals.lightGray);
            but.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String chosenFile;
                    String dir2 = ed.getText();
                    if (dir2.equals("")) {
                        dir2 = EntryEditor.this.prefs.get(fieldName + "_dir", "");
                    }
                    if ((chosenFile = Globals.getNewFile(EntryEditor.this.frame, EntryEditor.this.prefs, new File(dir2), "." + fieldName, 0, false)) != null) {
                        File newFile = new File(chosenFile);
                        ed.setText(newFile.getPath());
                        EntryEditor.this.prefs.put(fieldName + "_dir", newFile.getPath());
                        EntryEditor.this.storeFieldAction.actionPerformed(new ActionEvent(ed, 0, ""));
                    }
                }
            });
            return but;
        }
        if (s != null && s.equals("browsePdf")) {
            JPanel pan = new JPanel();
            pan.setLayout(new GridLayout(2, 1));
            JButton but = new JButton(Globals.lang("Browse"));
            JButton auto = new JButton(Globals.lang("Auto"));
            ((JComponent)((Object)editor)).addMouseListener(new ExternalViewerListener());
            but.setBackground(GUIGlobals.lightGray);
            but.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String chosenFile;
                    String pdfDir = EntryEditor.this.prefs.get("pdfDirectory");
                    String dir2 = ed.getText();
                    if (dir2.equals("") || !new File(dir2).isAbsolute()) {
                        dir2 = pdfDir != null ? pdfDir : EntryEditor.this.prefs.get(fieldName + "_dir", "");
                    }
                    if ((chosenFile = Globals.getNewFile(EntryEditor.this.frame, EntryEditor.this.prefs, new File(dir2), ".pdf", 0, false)) != null) {
                        File newFile = new File(chosenFile);
                        String position = newFile.getParent();
                        if (pdfDir != null && position.startsWith(pdfDir)) {
                            String relPath = position.substring(pdfDir.length(), position.length()) + File.separator + newFile.getName();
                            if (relPath.startsWith(File.separator)) {
                                relPath = relPath.substring(File.separator.length(), relPath.length());
                            }
                            ed.setText(relPath);
                        } else {
                            ed.setText(newFile.getPath());
                        }
                        EntryEditor.this.prefs.put(fieldName + "_dir", newFile.getPath());
                        EntryEditor.this.storeFieldAction.actionPerformed(new ActionEvent(ed, 0, ""));
                    }
                }
            });
            auto.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = EntryEditor.this.entry.getField("bibtexkey");
                    if (o == null || EntryEditor.this.prefs.get("pdfDirectory") == null) {
                        EntryEditor.this.frame.output(Globals.lang("You must set both bibtex key and PDF directory") + ".");
                        return;
                    }
                    EntryEditor.this.panel.output(Globals.lang("Searching for PDF file") + " '" + o + ".pdf'...");
                    new Thread(){

                        @Override
                        public void run() {
                            Object o = EntryEditor.this.entry.getField("bibtexkey");
                            String found = Util.findPdf((String)o, EntryEditor.this.prefs.get("pdfDirectory"));
                            if (found != null) {
                                ed.setText(found);
                                EntryEditor.this.storeFieldAction.actionPerformed(new ActionEvent(ed, 0, ""));
                                EntryEditor.this.panel.output(Globals.lang("PDF field set") + ".");
                            } else {
                                EntryEditor.this.panel.output(Globals.lang("No PDF found") + ".");
                            }
                        }
                    }.start();
                }
            });
            pan.add(but);
            pan.add(auto);
            return pan;
        }
        return null;
    }

    private void setupSourcePanel() {
        this.source = new JTextArea(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                super.paintComponent(g2);
            }
        };
        this.con = new GridBagConstraints();
        this.con.insets = new Insets(10, 10, 10, 10);
        this.con.fill = 1;
        this.con.gridwidth = 0;
        this.con.gridheight = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.srcPanel.setLayout(this.gbl);
        this.source.setEditable(true);
        this.source.setLineWrap(true);
        this.source.setTabSize(4);
        this.source.addFocusListener(Globals.focusListener);
        this.setupJTextComponent(this.source);
        this.updateSource();
        JScrollPane sp = new JScrollPane(this.source, 20, 31);
        this.gbl.setConstraints(sp, this.con);
        this.srcPanel.add(sp);
    }

    private void updateSource() {
        if (this.updateSource) {
            StringWriter sw = new StringWriter(200);
            try {
                this.entry.write(sw, new LatexFieldFormatter(), false);
                String srcString = sw.getBuffer().toString();
                this.source.setText(srcString);
                this.lastSourceStringAccepted = srcString;
            }
            catch (IOException ex) {
                this.source.setText("Error: " + ex.getMessage() + "\n\nCorrect the entry, and reopen editor to display/edit source.");
                this.source.setEditable(false);
            }
        }
    }

    private void setupJTextComponent(JTextComponent ta) {
        InputMap im = ta.getInputMap(0);
        ActionMap am = ta.getActionMap();
        im.put(this.prefs.getKey("Entry editor, store field"), "store");
        am.put("store", this.storeFieldAction);
        im.put(this.prefs.getKey("Entry editor, next panel"), "right");
        am.put("left", this.switchLeftAction);
        im.put(this.prefs.getKey("Entry editor, previous panel"), "left");
        am.put("right", this.switchRightAction);
        im.put(this.prefs.getKey("Help"), "help");
        am.put("help", this.helpAction);
        im.put(this.prefs.getKey("Save database"), "save");
        am.put("save", this.saveDatabaseAction);
        try {
            HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(ta.getFocusTraversalKeys(0));
            keys.clear();
            keys.add(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
            ta.setFocusTraversalKeys(0, keys);
            keys = new HashSet<AWTKeyStroke>(ta.getFocusTraversalKeys(1));
            keys.clear();
            keys.add(KeyStroke.getKeyStroke("shift pressed TAB"));
            ta.setFocusTraversalKeys(1, keys);
        }
        catch (Throwable t) {
            System.err.println(t);
        }
        ta.addFocusListener(new FieldListener());
    }

    @Override
    public void requestFocus() {
        if (this.tabbed.getSelectedComponent() instanceof FieldPanel) {
            ((FieldPanel)this.tabbed.getSelectedComponent()).activate();
        } else {
            this.source.requestFocus();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        FieldPanel[] panels = new FieldPanel[]{this.reqPanel, this.optPanel, this.genPanel};
        for (int i = 0; i < panels.length; ++i) {
            Vector fields = panels[i].getFields();
            for (int j = 0; j < fields.size(); ++j) {
                ((Component)fields.elementAt(j)).setEnabled(enabled);
            }
        }
        this.source.setEnabled(enabled);
        Component[] comps = this.tlb.getComponents();
        for (int i = 1; i < comps.length; ++i) {
            comps[i].setEnabled(enabled);
        }
    }

    private void scrollTo(int row) {
        this.panel.entryTable.setRowSelectionInterval(row, row);
        this.panel.entryTable.ensureVisible(row);
    }

    private void switchTo(String id) {
        Component comp = this.tabbed.getSelectedComponent();
        if (comp instanceof FieldPanel && ((FieldPanel)comp).activeField != null) {
            this.storeFieldAction.actionPerformed(new ActionEvent(((FieldPanel)comp).activeField, 0, ""));
        }
        BibtexEntry be = this.panel.database.getEntryById(id);
        if (this.entry.getType() == be.getType()) {
            this.switchTo(be);
        } else {
            this.panel.showEntry(be);
        }
    }

    public int getVisiblePanel() {
        return this.tabbed.getSelectedIndex();
    }

    public void setVisiblePanel(int i) {
        if (i < this.tabbed.getTabCount()) {
            this.tabbed.setSelectedIndex(i);
        } else {
            while (i >= this.tabbed.getTabCount()) {
                --i;
            }
            this.tabbed.setSelectedIndex(i);
        }
    }

    public void switchTo(BibtexEntry be) {
        this.entry = be;
        this.updateAllFields();
        this.updateSource();
        this.panel.showing = be;
        if (this.tabbed.getSelectedComponent() instanceof FieldPanel) {
            ((FieldPanel)this.tabbed.getSelectedComponent()).activate();
        } else {
            ((JComponent)this.tabbed.getSelectedComponent()).requestFocus();
        }
    }

    public boolean setField(String fieldName, String newFieldData) {
        try {
            if (this.setFieldInPanel(this.reqPanel, fieldName, newFieldData)) {
                return true;
            }
            if (this.setFieldInPanel(this.optPanel, fieldName, newFieldData)) {
                return true;
            }
            if (this.setFieldInPanel(this.genPanel, fieldName, newFieldData)) {
                return true;
            }
        }
        catch (ClassCastException cce) {
            System.err.println("caught in setField: " + cce);
            return false;
        }
        return false;
    }

    private boolean setFieldInPanel(FieldPanel pan, String fieldName, String newFieldData) throws ClassCastException {
        Vector fields = pan.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (!((FieldEditor)fields.elementAt(i)).getFieldName().equals(fieldName)) continue;
            FieldEditor ed = (FieldEditor)fields.elementAt(i);
            ed.setText(newFieldData);
            ed.setLabelColor(newFieldData == null || newFieldData.equals("") ? GUIGlobals.nullFieldColor : GUIGlobals.validFieldColor);
            return true;
        }
        return false;
    }

    private void updateAllFields() {
        FieldPanel[] panels = new FieldPanel[]{this.reqPanel, this.optPanel, this.genPanel};
        for (int i = 0; i < panels.length; ++i) {
            Vector fields = panels[i].getFields();
            for (int j = 0; j < fields.size(); ++j) {
                FieldEditor ed;
                Object content = this.entry.getField((ed = (FieldEditor)fields.elementAt(j)).getFieldName());
                ed.setText(content == null ? "" : content.toString());
                ed.setLabelColor(content == null ? GUIGlobals.nullFieldColor : GUIGlobals.validFieldColor);
            }
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        this.setField(e.getPropertyName(), (String)e.getNewValue());
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(Globals.lang("Delete"), new ImageIcon(GUIGlobals.removeIconFile));
            this.putValue("ShortDescription", Globals.lang("Delete entry"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryEditor.this.panel.hideEntryEditor();
            EntryEditor.this.panel.database.removeEntry(EntryEditor.this.entry.getId());
            EntryEditor.this.panel.markBaseChanged();
            EntryEditor.this.panel.refreshTable();
            EntryEditor.this.panel.undoManager.addEdit(new UndoableRemoveEntry(EntryEditor.this.panel.database, EntryEditor.this.entry, EntryEditor.this.panel));
            EntryEditor.this.panel.output(Globals.lang("Deleted") + " " + Globals.lang("entry"));
        }
    }

    class NextEntryAction
    extends AbstractAction {
        public NextEntryAction() {
            super(Globals.lang("Next entry"), new ImageIcon(GUIGlobals.downIconFile));
            this.putValue("ShortDescription", Globals.lang("Next entry"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int thisRow = EntryEditor.this.panel.tableModel.getNumberFromName(EntryEditor.this.entry.getId());
            String id = null;
            int newRow = -1;
            if (thisRow + 1 < EntryEditor.this.panel.database.getEntryCount()) {
                newRow = thisRow + 1;
            } else if (thisRow > 0) {
                newRow = 0;
            } else {
                return;
            }
            id = EntryEditor.this.panel.tableModel.getNameFromNumber(newRow);
            EntryEditor.this.switchTo(id);
            final int nr = newRow;
            new Thread(){

                @Override
                public void run() {
                    EntryEditor.this.scrollTo(nr);
                }
            }.start();
        }
    }

    class PrevEntryAction
    extends AbstractAction {
        public PrevEntryAction() {
            super(Globals.lang("Previous entry"), new ImageIcon(GUIGlobals.upIconFile));
            this.putValue("ShortDescription", Globals.lang("Previous entry"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int thisRow = EntryEditor.this.panel.tableModel.getNumberFromName(EntryEditor.this.entry.getId());
            String id = null;
            int newRow = -1;
            if (thisRow - 1 >= 0) {
                newRow = thisRow - 1;
            } else if (thisRow != EntryEditor.this.panel.database.getEntryCount() - 1) {
                newRow = EntryEditor.this.panel.database.getEntryCount() - 1;
            } else {
                return;
            }
            id = EntryEditor.this.panel.tableModel.getNameFromNumber(newRow);
            EntryEditor.this.switchTo(id);
            final int nr = newRow;
            new Thread(){

                @Override
                public void run() {
                    EntryEditor.this.scrollTo(nr);
                }
            }.start();
        }
    }

    class SwitchLeftAction
    extends AbstractAction {
        public SwitchLeftAction() {
            super("Switch to the panel to the left");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = EntryEditor.this.tabbed.getSelectedIndex();
            EntryEditor.this.tabbed.setSelectedIndex(i > 0 ? i - 1 : EntryEditor.this.tabbed.getTabCount() - 1);
            if (EntryEditor.this.tabbed.getSelectedComponent() instanceof FieldPanel) {
                ((FieldPanel)EntryEditor.this.tabbed.getSelectedComponent()).activate();
            }
        }
    }

    class SwitchRightAction
    extends AbstractAction {
        public SwitchRightAction() {
            super("Switch to the panel to the right");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = EntryEditor.this.tabbed.getSelectedIndex();
            EntryEditor.this.tabbed.setSelectedIndex(i < EntryEditor.this.tabbed.getTabCount() - 1 ? i + 1 : 0);
            if (EntryEditor.this.tabbed.getSelectedComponent() instanceof FieldPanel) {
                ((FieldPanel)EntryEditor.this.tabbed.getSelectedComponent()).activate();
            }
        }
    }

    class SaveDatabaseAction
    extends AbstractAction {
        public SaveDatabaseAction() {
            super("Save database");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component comp = EntryEditor.this.tabbed.getSelectedComponent();
            if (comp instanceof FieldPanel) {
                FieldPanel fp = (FieldPanel)comp;
                EntryEditor.this.storeFieldAction.actionPerformed(new ActionEvent(fp.activeField, 0, ""));
            } else {
                EntryEditor.this.storeFieldAction.actionPerformed(new ActionEvent(comp, 0, ""));
            }
            try {
                EntryEditor.this.panel.runCommand("save");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class FieldPanel
    extends JPanel {
        FieldEditor activeField = null;
        JScrollPane sp;

        public JComponent getPane() {
            return this;
        }

        public void setActive(FieldEditor c) {
            this.activeField = c;
        }

        public Vector getFields() {
            Vector<Component> textFields = new Vector<Component>();
            Component[] components = this.getComponents();
            try {
                for (int i = 0; i < components.length; ++i) {
                    if (components[i] instanceof FieldEditor) {
                        textFields.add(components[i]);
                        continue;
                    }
                    if (!(components[i] instanceof JScrollPane)) continue;
                    textFields.add(((JScrollPane)components[i]).getViewport().getComponent(0));
                }
                return textFields;
            }
            catch (ClassCastException cce) {
                System.err.println("caught in getFields: " + cce);
                return null;
            }
        }

        public void activate() {
            if (this.activeField != null) {
                this.activeField.requestFocus();
            } else {
                EntryEditor.this.tf.requestFocus();
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", new ImageIcon(GUIGlobals.undoIconFile));
            this.putValue("ShortDescription", "Undo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                EntryEditor.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Undo", new ImageIcon(GUIGlobals.redoIconFile));
            this.putValue("ShortDescription", "Redo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                EntryEditor.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close window"), new ImageIcon(GUIGlobals.closeIconFile));
            this.putValue("ShortDescription", Globals.lang("Close window"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntryEditor.this.tabbed.getSelectedComponent() == EntryEditor.this.srcPanel) {
                EntryEditor.this.storeFieldAction.actionPerformed(new ActionEvent(EntryEditor.this.source, 0, ""));
                if (EntryEditor.this.lastSourceAccepted) {
                    EntryEditor.this.panel.entryTypeFormClosing(EntryEditor.this.entry.getId());
                    EntryEditor.this.panel.hideEntryEditor();
                }
            } else {
                EntryEditor.this.panel.entryTypeFormClosing(EntryEditor.this.entry.getId());
                EntryEditor.this.panel.hideEntryEditor();
            }
        }
    }

    class CopyKeyAction
    extends AbstractAction {
        public CopyKeyAction() {
            super("Copy BibTeX key to clipboard", new ImageIcon(GUIGlobals.copyKeyIconFile));
            this.putValue("ShortDescription", "Copy BibTeX key to clipboard (Ctrl-K)");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = (String)EntryEditor.this.entry.getField("bibtexkey");
            StringSelection ss = new StringSelection(s);
            if (s != null) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
            }
        }
    }

    class GenerateKeyAction
    extends AbstractAction {
        JabRefFrame parent;
        BibtexEntry selectedEntry;

        public GenerateKeyAction(JabRefFrame parentFrame) {
            super(Globals.lang("Generate BibTeX key"), new ImageIcon(GUIGlobals.genKeyIconFile));
            this.parent = parentFrame;
            this.putValue("ShortDescription", Globals.lang("Generate BibTeX key"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object oldValue = EntryEditor.this.entry.getField(GUIGlobals.KEY_FIELD);
                EntryEditor.this.entry = LabelPatternUtil.makeLabel(EntryEditor.this.prefs.getKeyPattern(), EntryEditor.this.panel.database, EntryEditor.this.entry);
                EntryEditor.this.panel.undoManager.addEdit(new UndoableKeyChange(EntryEditor.this.panel.database, EntryEditor.this.entry.getId(), (String)oldValue, (String)EntryEditor.this.entry.getField(GUIGlobals.KEY_FIELD)));
                String bibtexKeyData = (String)EntryEditor.this.entry.getField("bibtexkey");
                EntryEditor.this.setField("bibtexkey", bibtexKeyData);
                EntryEditor.this.panel.markBaseChanged();
                EntryEditor.this.panel.refreshTable();
            }
            catch (Throwable t) {
                System.err.println("error setting key: " + t);
            }
        }
    }

    class StoreFieldAction
    extends AbstractAction {
        public StoreFieldAction() {
            super("Store field value");
            this.putValue("ShortDescription", "Store field value");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block28: {
                if (e.getSource() instanceof FieldTextArea) {
                    String toSet = null;
                    FieldEditor fe = (FieldEditor)e.getSource();
                    if (fe.getText().length() > 0) {
                        toSet = fe.getText();
                    }
                    boolean set = toSet == null ? EntryEditor.this.entry.getField(fe.getFieldName()) != null : EntryEditor.this.entry.getField(fe.getFieldName()) == null || !toSet.equals(EntryEditor.this.entry.getField(fe.getFieldName()).toString());
                    if (set) {
                        try {
                            if (toSet != null) {
                                new LatexFieldFormatter().format(toSet, GUIGlobals.isStandardField(fe.getFieldName()));
                            }
                            Object oldValue = EntryEditor.this.entry.getField(fe.getFieldName());
                            EntryEditor.this.entry.setField(fe.getFieldName(), toSet);
                            if (toSet != null && toSet.length() > 0) {
                                fe.setLabelColor(GUIGlobals.validFieldColor);
                                fe.setBackground(GUIGlobals.validFieldBackground);
                            } else {
                                fe.setLabelColor(GUIGlobals.nullFieldColor);
                                fe.setBackground(GUIGlobals.validFieldBackground);
                            }
                            EntryEditor.this.panel.undoManager.addEdit(new UndoableFieldChange(EntryEditor.this.entry, fe.getFieldName(), oldValue, toSet));
                            EntryEditor.this.updateSource();
                            EntryEditor.this.panel.refreshTable();
                            EntryEditor.this.panel.markBaseChanged();
                        }
                        catch (IllegalArgumentException ex) {
                            JOptionPane.showMessageDialog(EntryEditor.this.frame, "Error: " + ex.getMessage(), Globals.lang("Error setting field"), 0);
                            fe.setLabelColor(GUIGlobals.invalidFieldColor);
                            fe.setBackground(GUIGlobals.invalidFieldBackground);
                        }
                    } else {
                        fe.setBackground(GUIGlobals.validFieldBackground);
                        fe.setLabelColor(toSet == null ? GUIGlobals.nullFieldColor : GUIGlobals.validFieldColor);
                    }
                } else if (e.getSource() instanceof FieldTextField) {
                    FieldTextField fe = (FieldTextField)e.getSource();
                    String oldValue = EntryEditor.this.entry.getCiteKey();
                    String newValue = fe.getText();
                    if (oldValue == null && newValue == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
                        return;
                    }
                    boolean isDuplicate = EntryEditor.this.panel.database.setCiteKeyForEntry(EntryEditor.this.entry.getId(), newValue);
                    if (isDuplicate) {
                        EntryEditor.this.panel.output(Globals.lang("Warning") + ": " + Globals.lang("duplicate bibtex key."));
                    } else {
                        EntryEditor.this.panel.output(Globals.lang("Bibtex key is unique."));
                    }
                    EntryEditor.this.panel.undoManager.addEdit(new UndoableKeyChange(EntryEditor.this.panel.database, EntryEditor.this.entry.getId(), oldValue, newValue));
                    if (newValue != null && newValue.length() > 0) {
                        fe.setLabelColor(GUIGlobals.validFieldColor);
                        fe.setBackground(GUIGlobals.validFieldBackground);
                    } else {
                        fe.setLabelColor(GUIGlobals.nullFieldColor);
                        fe.setBackground(GUIGlobals.validFieldBackground);
                    }
                    EntryEditor.this.panel.refreshTable();
                    EntryEditor.this.panel.markBaseChanged();
                } else if (EntryEditor.this.source.isEditable() && !EntryEditor.this.source.getText().equals(EntryEditor.this.lastSourceStringAccepted)) {
                    BibtexParser bp = new BibtexParser(new StringReader(EntryEditor.this.source.getText()));
                    try {
                        int i;
                        BibtexDatabase db = bp.parse().getDatabase();
                        if (db.getEntryCount() > 1) {
                            throw new Exception("More than one entry found.");
                        }
                        if (db.getEntryCount() < 1) {
                            throw new Exception("No entries found.");
                        }
                        NamedCompound compound = new NamedCompound("source edit");
                        BibtexEntry nu = db.getEntryById((String)db.getKeySet().iterator().next());
                        String id = EntryEditor.this.entry.getId();
                        String newKey = nu.getCiteKey();
                        boolean anyChanged = false;
                        boolean duplicateWarning = false;
                        if (EntryEditor.this.panel.database.setCiteKeyForEntry(id, newKey)) {
                            duplicateWarning = true;
                        }
                        Object[] fields = EntryEditor.this.entry.getAllFields();
                        for (i = 0; i < fields.length; ++i) {
                            if (!GUIGlobals.isWriteableField(fields[i].toString()) || nu.getField(fields[i].toString()) != null) continue;
                            compound.addEdit(new UndoableFieldChange(EntryEditor.this.entry, fields[i].toString(), EntryEditor.this.entry.getField(fields[i].toString()), null));
                            EntryEditor.this.entry.setField(fields[i].toString(), null);
                            anyChanged = true;
                        }
                        fields = nu.getAllFields();
                        for (i = 0; i < fields.length; ++i) {
                            if (EntryEditor.this.entry.getField(fields[i].toString()) == nu.getField(fields[i].toString())) continue;
                            String toSet = (String)nu.getField(fields[i].toString());
                            new LatexFieldFormatter().format(toSet, GUIGlobals.isStandardField(fields[i].toString()));
                            compound.addEdit(new UndoableFieldChange(EntryEditor.this.entry, fields[i].toString(), EntryEditor.this.entry.getField(fields[i].toString()), toSet));
                            EntryEditor.this.entry.setField(fields[i].toString(), toSet);
                            anyChanged = true;
                        }
                        compound.end();
                        if (!anyChanged) {
                            return;
                        }
                        EntryEditor.this.panel.undoManager.addEdit(compound);
                        if (duplicateWarning) {
                            EntryEditor.this.panel.output(Globals.lang("Warning: duplicate bibtex key."));
                        } else {
                            EntryEditor.this.panel.output(Globals.lang("Stored entry") + ".");
                        }
                        EntryEditor.this.lastSourceStringAccepted = EntryEditor.this.source.getText();
                        EntryEditor.this.updateAllFields();
                        EntryEditor.this.lastSourceAccepted = true;
                        EntryEditor.this.updateSource = true;
                        EntryEditor.this.panel.refreshTable();
                        EntryEditor.this.panel.markBaseChanged();
                    }
                    catch (Throwable ex) {
                        EntryEditor.this.updateSource = false;
                        EntryEditor.this.lastSourceAccepted = false;
                        EntryEditor.this.tabbed.setSelectedComponent(EntryEditor.this.srcPanel);
                        Object[] options = new Object[]{"Edit", "Revert to original source"};
                        int answer = JOptionPane.showOptionDialog(EntryEditor.this.frame, "Error: " + ex.getMessage(), "Problem with parsing entry", 0, 0, null, options, options[0]);
                        if (answer == 0) break block28;
                        EntryEditor.this.updateSource = true;
                        EntryEditor.this.updateSource();
                    }
                }
            }
        }
    }

    class TabListener
    implements ChangeListener {
        TabListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (((JTabbedPane)e.getSource()).getSelectedIndex() != EntryEditor.this.sourceIndex) {
                FieldPanel fp = (FieldPanel)((JTabbedPane)e.getSource()).getSelectedComponent();
                fp.activate();
            } else {
                EntryEditor.this.source.requestFocus();
            }
        }
    }

    private class TypeLabel
    extends JPanel {
        private String label;

        public TypeLabel(String type) {
            this.label = type;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(GUIGlobals.nullFieldColor);
            g2.setFont(GUIGlobals.typeNameFont);
            FontMetrics fm = g2.getFontMetrics();
            int width = fm.stringWidth(this.label);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.rotate(-1.5707963267948966, 0.0, 0.0);
            g2.drawString(this.label, -width - 7, 28);
        }
    }

    class ExternalViewerListener
    extends MouseAdapter {
        ExternalViewerListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                FieldTextArea tf = (FieldTextArea)evt.getSource();
                if (tf.getText().equals("")) {
                    return;
                }
                tf.selectAll();
                String link = tf.getText();
                try {
                    Util.openExternalViewer(link, tf.getFieldName(), EntryEditor.this.prefs);
                }
                catch (IOException ex) {
                    System.err.println("Error opening file.");
                }
            }
        }
    }

    class FieldListener
    extends FocusAdapter {
        FieldListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof FieldEditor) {
                FieldEditor ta = (FieldEditor)e.getSource();
                Container parent = ta.getParent();
                while (!(parent instanceof FieldPanel)) {
                    parent = parent.getParent();
                }
                ((FieldPanel)parent).setActive(ta);
            } else if (EntryEditor.this.panel.baseChanged) {
                EntryEditor.this.updateSource();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                EntryEditor.this.storeFieldAction.actionPerformed(new ActionEvent(e.getSource(), 0, ""));
            }
        }
    }
}

