/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntry;
import jabref.GUIGlobals;
import jabref.imports.ImportFormatReader;
import java.util.Comparator;

public class EntryComparator
implements Comparator {
    String key;
    String sortField;
    boolean descending;
    EntryComparator next;

    public EntryComparator(boolean priDesc, boolean secDesc, boolean terDesc, boolean fourthDesc, String pri, String sec, String ter, String fourth) {
        this.next = new EntryComparator(secDesc, terDesc, fourthDesc, sec, ter, fourth);
        this.descending = priDesc;
        this.sortField = pri;
    }

    public EntryComparator(boolean priDesc, boolean secDesc, boolean terDesc, String pri, String sec, String ter) {
        this.next = new EntryComparator(secDesc, terDesc, sec, ter);
        this.descending = priDesc;
        this.sortField = pri;
    }

    public EntryComparator(boolean priDesc, boolean secDesc, String pri, String sec) {
        this.next = new EntryComparator(secDesc, sec);
        this.descending = priDesc;
        this.sortField = pri;
    }

    public EntryComparator(boolean priDesc, String pri) {
        this.descending = priDesc;
        this.sortField = pri;
    }

    public int compare(Object o1, Object o2) throws ClassCastException {
        String theirs;
        if (!(o1 instanceof BibtexEntry) || !(o2 instanceof BibtexEntry)) {
            throw new ClassCastException("Trouble comparing objects: " + o1.toString() + "\n\n" + o2.toString());
        }
        BibtexEntry e1 = (BibtexEntry)o1;
        BibtexEntry e2 = (BibtexEntry)o2;
        Object f1 = e1.getField(this.sortField);
        Object f2 = e2.getField(this.sortField);
        if (this.sortField.equals("author") || this.sortField.equals("editor")) {
            if (f1 != null) {
                f1 = ImportFormatReader.fixAuthor_lastnameFirst((String)f1);
            }
            if (f2 != null) {
                f2 = ImportFormatReader.fixAuthor_lastnameFirst((String)f2);
            }
        } else if (this.sortField.equals(GUIGlobals.TYPE_HEADER)) {
            f1 = e1.getType().getName();
            f2 = e2.getType().getName();
        }
        if (f1 == null && f2 == null) {
            return this.next != null ? this.next.compare(o1, o2) : this.idCompare(e1, e2);
        }
        if (f1 != null && f2 == null) {
            return -1;
        }
        if (f1 == null && f2 != null) {
            return 1;
        }
        int result = 0;
        String ours = ((String)f1).toLowerCase();
        int comp = ours.compareTo(theirs = ((String)f2).toLowerCase());
        result = -comp;
        if (result != 0) {
            return this.descending ? result : -result;
        }
        if (this.next != null) {
            return this.next.compare(o1, o2);
        }
        return this.idCompare(e1, e2);
    }

    private int idCompare(BibtexEntry b1, BibtexEntry b2) {
        return b1.getId().compareTo(b2.getId());
    }
}

