/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntry;
import jabref.BibtexEntryType;

public class CustomEntryType
extends BibtexEntryType {
    private String name;
    private String[] req;
    private String[] opt;

    public CustomEntryType(String name_, String[] req_, String[] opt_) {
        this.name = name_;
        this.req = req_;
        this.opt = opt_;
    }

    public CustomEntryType(String name_, String reqStr, String optStr) {
        this.name = name_;
        this.req = reqStr.length() == 0 ? new String[0] : reqStr.split(";");
        this.opt = optStr.length() == 0 ? new String[0] : optStr.split(";");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getOptionalFields() {
        return this.opt;
    }

    @Override
    public String[] getRequiredFields() {
        return this.req;
    }

    @Override
    public String describeRequiredFields() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.req.length; ++i) {
            sb.append(this.req[i]);
            sb.append(i <= this.req.length - 1 && this.req.length > 1 ? ", " : "");
        }
        return sb.toString();
    }

    public String describeOptionalFields() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.opt.length; ++i) {
            sb.append(this.opt[i]);
            sb.append(i <= this.opt.length - 1 && this.opt.length > 1 ? ", " : "");
        }
        return sb.toString();
    }

    @Override
    public boolean hasAllRequiredFields(BibtexEntry entry) {
        for (int i = 0; i < this.req.length; ++i) {
            if (entry.getField(this.req[i]) != null) continue;
            return false;
        }
        return true;
    }
}

