/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntry;
import jabref.CustomEntryType;
import jabref.JabRefPreferences;
import java.util.Iterator;
import java.util.TreeMap;

public abstract class BibtexEntryType
implements Comparable {
    public static final BibtexEntryType OTHER = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Other";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[0];
        }

        @Override
        public String[] getRequiredFields() {
            return new String[0];
        }

        @Override
        public String describeRequiredFields() {
            return "";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return true;
        }
    };
    public static final BibtexEntryType ARTICLE = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Article";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"volume", "number", "pages", "month", "eid", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "journal", "year"};
        }

        @Override
        public String describeRequiredFields() {
            return "AUTHOR, TITLE, JOURNAL and YEAR";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"author", "title", "journal", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType BOOKLET = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Booklet";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"author", "howpublished", "address", "month", "year", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"title"};
        }

        @Override
        public String describeRequiredFields() {
            return "TITLE";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"title", "bibtexkey"});
        }
    };
    public static final BibtexEntryType INBOOK = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Inbook";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"volume", "number", "series", "type", "address", "edition", "month", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"chapter", "pages", "title", "publisher", "year", "editor", "author"};
        }

        @Override
        public String describeRequiredFields() {
            return "TITLE, CHAPTER and/or PAGES, PUBLISHER, YEAR, and an EDITOR and/or AUTHOR";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return !(!entry.allFieldsPresent(new String[]{"title", "publisher", "year", "bibtexkey"}) || entry.getField("author") == null && entry.getField("editor") == null || entry.getField("chapter") == null && entry.getField("pages") == null);
        }
    };
    public static final BibtexEntryType BOOK = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Book";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"volume", "number", "series", "address", "edition", "month", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"title", "publisher", "year", "editor", "author"};
        }

        @Override
        public String describeRequiredFields() {
            return "TITLE, PUBLISHER, YEAR, and an EDITOR and/or AUTHOR";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"title", "publisher", "year", "bibtexkey"}) && (entry.getField("author") != null || entry.getField("editor") != null);
        }
    };
    public static final BibtexEntryType INCOLLECTION = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Incollection";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"editor", "volume", "number", "series", "type", "chapter", "pages", "address", "edition", "month", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "booktitle", "publisher", "year"};
        }

        @Override
        public String describeRequiredFields() {
            return "AUTHOR, TITLE, BOOKTITLE, PUBLISHER and YEAR";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"author", "title", "booktitle", "publisher", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType INPROCEEDINGS = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Inproceedings";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"editor", "volume", "number", "series", "pages", "address", "month", "organization", "publisher", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "booktitle", "year"};
        }

        @Override
        public String describeRequiredFields() {
            return "AUTHOR, TITLE, BOOKTITLE and YEAR";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"author", "title", "booktitle", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType PROCEEDINGS = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Proceedings";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"editor", "volume", "number", "series", "address", "publisher", "note", "month", "organization"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"title", "year"};
        }

        @Override
        public String describeRequiredFields() {
            return "TITLE and YEAR";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"title", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType MANUAL = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Manual";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"author", "organization", "address", "edition", "month", "year", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"title"};
        }

        @Override
        public String describeRequiredFields() {
            return "TITLE";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"title", "bibtexkey"});
        }
    };
    public static final BibtexEntryType TECHREPORT = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Techreport";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"type", "number", "address", "month", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "institution", "year"};
        }

        @Override
        public String describeRequiredFields() {
            return "AUTHOR, TITLE, INSTITUTION and YEAR";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"author", "title", "institution", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType MASTERSTHESIS = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Mastersthesis";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"type", "address", "month", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "school", "year"};
        }

        @Override
        public String describeRequiredFields() {
            return "AUTHOR, TITLE, SCHOOL and YEAR";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"author", "title", "school", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType PHDTHESIS = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Phdthesis";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"type", "address", "month", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "school", "year"};
        }

        @Override
        public String describeRequiredFields() {
            return "AUTHOR, TITLE, SCHOOL and YEAR";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"author", "title", "school", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType UNPUBLISHED = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Unpublished";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"month", "year"};
        }

        @Override
        public String[] getRequiredFields() {
            return new String[]{"author", "title", "note"};
        }

        @Override
        public String describeRequiredFields() {
            return "AUTHOR, TITLE and NOTE";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"author", "title", "note", "bibtexkey"});
        }
    };
    public static final BibtexEntryType MISC = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Misc";
        }

        @Override
        public String[] getOptionalFields() {
            return new String[]{"author", "title", "howpublished", "month", "year", "note"};
        }

        @Override
        public String[] getRequiredFields() {
            return null;
        }

        @Override
        public String describeRequiredFields() {
            return "None";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return entry.allFieldsPresent(new String[]{"bibtexkey"});
        }
    };
    public static final BibtexEntryType TYPELESS = new BibtexEntryType(){

        @Override
        public String getName() {
            return "Typeless";
        }

        @Override
        public String[] getOptionalFields() {
            return null;
        }

        @Override
        public String[] getRequiredFields() {
            return null;
        }

        @Override
        public String describeRequiredFields() {
            return "None";
        }

        @Override
        public boolean hasAllRequiredFields(BibtexEntry entry) {
            return false;
        }
    };
    public static TreeMap ALL_TYPES = new TreeMap();
    public static TreeMap STANDARD_TYPES = new TreeMap();

    public abstract String getName();

    public int compareTo(Object o) {
        return this.getName().compareTo(((BibtexEntryType)o).getName());
    }

    public abstract String[] getOptionalFields();

    public abstract String[] getRequiredFields();

    public String[] getGeneralFields() {
        return new String[]{"crossref", "keywords", "doi", "url", "pdf", "abstract", "comment"};
    }

    public abstract String describeRequiredFields();

    public abstract boolean hasAllRequiredFields(BibtexEntry var1);

    public String[] getUtilityFields() {
        return new String[]{"search"};
    }

    public boolean isRequired(String field) {
        String[] req = this.getRequiredFields();
        if (req == null) {
            return false;
        }
        for (int i = 0; i < req.length; ++i) {
            if (!req[i].equals(field)) continue;
            return true;
        }
        return false;
    }

    public boolean isOptional(String field) {
        String[] opt = this.getOptionalFields();
        if (opt == null) {
            return false;
        }
        for (int i = 0; i < opt.length; ++i) {
            if (!opt[i].equals(field)) continue;
            return true;
        }
        return false;
    }

    public static BibtexEntryType getType(String name) {
        Object o = ALL_TYPES.get(name.toLowerCase());
        if (o == null) {
            return null;
        }
        return (BibtexEntryType)o;
    }

    public static BibtexEntryType getStandardType(String name) {
        Object o = STANDARD_TYPES.get(name.toLowerCase());
        if (o == null) {
            return null;
        }
        return (BibtexEntryType)o;
    }

    public static void removeType(String name) {
        String nm = name.toLowerCase();
        ALL_TYPES.remove(nm);
        if (STANDARD_TYPES.get(nm) != null) {
            ALL_TYPES.put(nm, STANDARD_TYPES.get(nm));
        }
    }

    public static void loadCustomEntryTypes(JabRefPreferences prefs2) {
        CustomEntryType type;
        int number = 0;
        while ((type = prefs2.getCustomEntryType(number)) != null) {
            ALL_TYPES.put(type.getName().toLowerCase(), type);
            ++number;
        }
    }

    public static void saveCustomEntryTypes(JabRefPreferences prefs2) {
        Iterator i = ALL_TYPES.keySet().iterator();
        int number = 0;
        while (i.hasNext()) {
            Object o = ALL_TYPES.get(i.next());
            if (!(o instanceof CustomEntryType)) continue;
            prefs2.storeCustomEntryType((CustomEntryType)o, number);
            ++number;
        }
        prefs2.purgeCustomEntryTypes(number);
    }

    static {
        ALL_TYPES.put("article", ARTICLE);
        ALL_TYPES.put("inbook", INBOOK);
        ALL_TYPES.put("book", BOOK);
        ALL_TYPES.put("booklet", BOOKLET);
        ALL_TYPES.put("incollection", INCOLLECTION);
        ALL_TYPES.put("inproceedings", INPROCEEDINGS);
        ALL_TYPES.put("proceedings", PROCEEDINGS);
        ALL_TYPES.put("manual", MANUAL);
        ALL_TYPES.put("mastersthesis", MASTERSTHESIS);
        ALL_TYPES.put("phdthesis", PHDTHESIS);
        ALL_TYPES.put("techreport", TECHREPORT);
        ALL_TYPES.put("unpublished", UNPUBLISHED);
        ALL_TYPES.put("misc", MISC);
        ALL_TYPES.put("other", OTHER);
        STANDARD_TYPES = (TreeMap)ALL_TYPES.clone();
    }
}

