/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.BibtexEntryType;
import jabref.BibtexString;
import jabref.DuplicateResolverDialog;
import jabref.EntryEditor;
import jabref.EntryTable;
import jabref.EntryTableModel;
import jabref.EntryTypeDialog;
import jabref.FocusRequester;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import jabref.KeyCollisionException;
import jabref.MergeDialog;
import jabref.MetaData;
import jabref.PreambleEditor;
import jabref.PreviewPanel;
import jabref.ReplaceStringDialog;
import jabref.RightClickMenu;
import jabref.SearchManager2;
import jabref.SidePaneManager;
import jabref.StringDialog;
import jabref.TransferableBibtexEntry;
import jabref.Util;
import jabref.export.FileActions;
import jabref.export.SaveException;
import jabref.groups.GroupSelector;
import jabref.groups.QuickSearchRule;
import jabref.imports.BibtexParser;
import jabref.imports.MedlineAuthorFetcher;
import jabref.imports.MedlineFetcher;
import jabref.imports.ParserResult;
import jabref.labelPattern.LabelPatternUtil;
import jabref.undo.CountingUndoManager;
import jabref.undo.NamedCompound;
import jabref.undo.UndoableChangeType;
import jabref.undo.UndoableFieldChange;
import jabref.undo.UndoableInsertEntry;
import jabref.undo.UndoableInsertString;
import jabref.undo.UndoableKeyChange;
import jabref.undo.UndoableRemoveEntry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import jehep.ui.Editor;

public class BasePanel
extends JSplitPane
implements ClipboardOwner {
    private static final long serialVersionUID = 1L;
    BasePanel ths = this;
    JSplitPane splitPane;
    PreviewPanel previewPanel = null;
    JabRefFrame frame;
    BibtexDatabase database;
    JabRefPreferences prefs;
    File file = null;
    File fileToOpen = null;
    public CountingUndoManager undoManager = new CountingUndoManager();
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    boolean baseChanged = false;
    boolean nonUndoableChange = false;
    EntryTableModel tableModel = null;
    EntryTable entryTable = null;
    SidePaneManager sidePaneManager;
    SearchManager2 searchManager;
    MedlineFetcher medlineFetcher;
    MedlineAuthorFetcher medlineAuthorFetcher;
    RightClickMenu rcm;
    BibtexEntry showing = null;
    HashMap entryEditors = new HashMap();
    PreambleEditor preambleEditor = null;
    StringDialog stringDialog = null;
    GroupSelector groupSelector;
    boolean showingSearchResults = false;
    boolean showingGroup = false;
    boolean previewEnabled = true;
    MetaData metaData;
    HashMap fieldExtras = new HashMap();
    private boolean suppressOutput = false;
    private HashMap actions = new HashMap();

    public BasePanel(JabRefFrame frame, JabRefPreferences prefs2) {
        this.database = new BibtexDatabase();
        this.metaData = new MetaData();
        this.frame = frame;
        this.prefs = prefs2;
        this.setupActions();
        this.setupMainPanel();
    }

    public BasePanel(JabRefFrame frame, BibtexDatabase db, File file2, HashMap meta, JabRefPreferences prefs2) {
        super(1, true);
        this.frame = frame;
        this.database = db;
        this.prefs = prefs2;
        this.parseMetaData(meta);
        this.setupActions();
        this.setupMainPanel();
        this.file = file2;
    }

    public BibtexDatabase database() {
        return this.database;
    }

    public JabRefFrame frame() {
        return this.frame;
    }

    public JabRefPreferences prefs() {
        return this.prefs;
    }

    public void output(String s) {
        if (!this.suppressOutput) {
            this.frame.output(s);
        }
    }

    private void setupActions() {
        this.actions.put("undo", this.undoAction);
        this.actions.put("redo", this.redoAction);
        this.actions.put("edit", new BaseAction(){

            @Override
            public void action() {
                int clickedOn = -1;
                if (BasePanel.this.entryTable.getSelectedRowCount() == 1) {
                    clickedOn = BasePanel.this.entryTable.getSelectedRow();
                }
                if (clickedOn >= 0) {
                    String id = BasePanel.this.tableModel.getNameFromNumber(clickedOn);
                    BibtexEntry be = BasePanel.this.database.getEntryById(id);
                    BasePanel.this.showEntry(be);
                }
            }
        });
        this.actions.put("save", new BaseAction(){

            @Override
            public void action() throws Throwable {
                if (BasePanel.this.file == null) {
                    BasePanel.this.runCommand("saveAs");
                } else {
                    BasePanel.this.saveDatabase(BasePanel.this.file, false);
                    BasePanel.this.undoManager.markUnchanged();
                    BasePanel.this.nonUndoableChange = false;
                    BasePanel.this.baseChanged = false;
                    BasePanel.this.frame.setTabTitle(BasePanel.this.ths, BasePanel.this.file.getName());
                    BasePanel.this.frame.output(Globals.lang("Saved database") + " '" + BasePanel.this.file.getPath() + "'.");
                }
            }
        });
        this.actions.put("saveAs", new BaseAction(){

            @Override
            public void action() throws Throwable {
                String chosenFile = Globals.getNewFile(BasePanel.this.frame, BasePanel.this.prefs, new File(BasePanel.this.prefs.get("workingDirectory")), ".bib", 1, false);
                if (chosenFile != null) {
                    BasePanel.this.file = new File(chosenFile);
                    if (!BasePanel.this.file.exists() || JOptionPane.showConfirmDialog(BasePanel.this.frame, "'" + BasePanel.this.file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Save database"), 2) == 0) {
                        BasePanel.this.runCommand("save");
                        BasePanel.this.prefs.put("workingDirectory", BasePanel.this.file.getParent());
                        BasePanel.this.frame.fileHistory.newFile(BasePanel.this.file.getPath());
                    } else {
                        BasePanel.this.file = null;
                    }
                }
            }
        });
        this.actions.put("saveSelectedAs", new BaseAction(){

            @Override
            public void action() throws Throwable {
                File expFile;
                String chosenFile = Globals.getNewFile(BasePanel.this.frame, BasePanel.this.prefs, new File(BasePanel.this.prefs.get("workingDirectory")), ".bib", 1, false);
                if (!(chosenFile == null || (expFile = new File(chosenFile)).exists() && JOptionPane.showConfirmDialog(BasePanel.this.frame, "'" + expFile.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Save database"), 2) != 0)) {
                    BasePanel.this.saveDatabase(expFile, true);
                    BasePanel.this.frame.fileHistory.newFile(expFile.getPath());
                    BasePanel.this.frame.output(Globals.lang("Saved selected to") + " '" + expFile.getPath() + "'.");
                }
            }
        });
        this.actions.put("copy", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                if (bes != null && bes.length > 0) {
                    TransferableBibtexEntry trbe = new TransferableBibtexEntry(bes);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trbe, BasePanel.this.ths);
                    BasePanel.this.output(Globals.lang("Copied") + " " + (bes.length > 1 ? bes.length + " " + Globals.lang("entries") : "1 " + Globals.lang("entry") + "."));
                } else {
                    Object o;
                    int[] rows = BasePanel.this.entryTable.getSelectedRows();
                    int[] cols = BasePanel.this.entryTable.getSelectedColumns();
                    if (cols.length == 1 && rows.length == 1 && (o = BasePanel.this.tableModel.getValueAt(rows[0], cols[0])) != null) {
                        StringSelection ss = new StringSelection(o.toString());
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, BasePanel.this.ths);
                        BasePanel.this.output(Globals.lang("Copied cell contents") + ".");
                    }
                }
            }
        });
        this.actions.put("cut", new BaseAction(){

            @Override
            public void action() throws Throwable {
                BasePanel.this.runCommand("copy");
                BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                if (bes != null && bes.length > 0) {
                    NamedCompound ce = new NamedCompound(bes.length > 1 ? "cut entries" : "cut entry");
                    for (int i = 0; i < bes.length; ++i) {
                        BasePanel.this.database.removeEntry(bes[i].getId());
                        BasePanel.this.ensureNotShowing(bes[i]);
                        ce.addEdit(new UndoableRemoveEntry(BasePanel.this.database, bes[i], BasePanel.this.ths));
                    }
                    BasePanel.this.entryTable.clearSelection();
                    BasePanel.this.frame.output(Globals.lang("Cut_pr") + " " + (bes.length > 1 ? bes.length + " " + Globals.lang("entries") : Globals.lang("entry")) + ".");
                    ce.end();
                    BasePanel.this.undoManager.addEdit(ce);
                    BasePanel.this.refreshTable();
                    BasePanel.this.markBaseChanged();
                }
            }
        });
        this.actions.put("delete", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                if (bes.length > 0) {
                    NamedCompound ce = new NamedCompound(bes.length > 1 ? Globals.lang("delete entries") : Globals.lang("delete entry"));
                    for (int i = 0; i < bes.length; ++i) {
                        BasePanel.this.database.removeEntry(bes[i].getId());
                        BasePanel.this.ensureNotShowing(bes[i]);
                        ce.addEdit(new UndoableRemoveEntry(BasePanel.this.database, bes[i], BasePanel.this.ths));
                    }
                    BasePanel.this.entryTable.clearSelection();
                    BasePanel.this.frame.output(Globals.lang("Deleted") + " " + (bes.length > 1 ? bes.length + " " + Globals.lang("entries") : Globals.lang("entry")) + ".");
                    ce.end();
                    BasePanel.this.undoManager.addEdit(ce);
                    BasePanel.this.refreshTable();
                    BasePanel.this.markBaseChanged();
                }
            }
        });
        this.actions.put("paste", new BaseAction(){

            @Override
            public void action() {
                Transferable content = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (content != null) {
                    BibtexEntry[] bes = null;
                    if (content.isDataFlavorSupported(TransferableBibtexEntry.entryFlavor)) {
                        try {
                            bes = (BibtexEntry[])content.getTransferData(TransferableBibtexEntry.entryFlavor);
                        }
                        catch (UnsupportedFlavorException ex) {
                            ex.printStackTrace();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    } else if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        int[] rows = BasePanel.this.entryTable.getSelectedRows();
                        int[] cols = BasePanel.this.entryTable.getSelectedColumns();
                        Util.pr(rows.length + " x " + cols.length);
                        if (cols != null && cols.length == 1 && cols[0] != 0 && rows != null && rows.length == 1) {
                            try {
                                BasePanel.this.tableModel.setValueAt((String)content.getTransferData(DataFlavor.stringFlavor), rows[0], cols[0]);
                                BasePanel.this.refreshTable();
                                BasePanel.this.markBaseChanged();
                                BasePanel.this.output("Pasted cell contents");
                            }
                            catch (UnsupportedFlavorException ex) {
                                ex.printStackTrace();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                            catch (IllegalArgumentException ex) {
                                BasePanel.this.output("Can't paste.");
                            }
                        } else {
                            try {
                                BibtexParser bp = new BibtexParser(new StringReader((String)content.getTransferData(DataFlavor.stringFlavor)));
                                BibtexDatabase db = bp.parse().getDatabase();
                                Util.pr("Parsed " + db.getEntryCount() + " entries from clipboard text");
                                if (db.getEntryCount() > 0) {
                                    Set keySet = db.getKeySet();
                                    if (keySet != null) {
                                        bes = new BibtexEntry[db.getEntryCount()];
                                        Iterator it = keySet.iterator();
                                        int i = 0;
                                        while (it.hasNext()) {
                                            bes[i] = db.getEntryById((String)it.next());
                                            ++i;
                                        }
                                    }
                                } else {
                                    BasePanel.this.output(Globals.lang("Unable to parse clipboard text as Bibtex entries."));
                                }
                            }
                            catch (UnsupportedFlavorException ex) {
                                ex.printStackTrace();
                            }
                            catch (Throwable ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    if (bes != null && bes.length > 0) {
                        NamedCompound ce = new NamedCompound(bes.length > 1 ? "paste entries" : "paste entry");
                        for (int i = 0; i < bes.length; ++i) {
                            try {
                                BibtexEntry be = (BibtexEntry)bes[i].clone();
                                be.setId(Util.createId(be.getType(), BasePanel.this.database));
                                BasePanel.this.database.insertEntry(be);
                                ce.addEdit(new UndoableInsertEntry(BasePanel.this.database, be, BasePanel.this.ths));
                                continue;
                            }
                            catch (KeyCollisionException ex) {
                                Util.pr("KeyCollisionException... this shouldn't happen.");
                            }
                        }
                        ce.end();
                        BasePanel.this.undoManager.addEdit(ce);
                        BasePanel.this.tableModel.remap();
                        BasePanel.this.entryTable.clearSelection();
                        BasePanel.this.entryTable.revalidate();
                        BasePanel.this.output(Globals.lang("Pasted") + " " + (bes.length > 1 ? bes.length + " " + Globals.lang("entries") : "1 " + Globals.lang("entry")) + ".");
                        BasePanel.this.refreshTable();
                        BasePanel.this.markBaseChanged();
                    }
                }
            }
        });
        this.actions.put("selectAll", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.entryTable.selectAll();
            }
        });
        this.actions.put("editPreamble", new BaseAction(){

            @Override
            public void action() {
                if (BasePanel.this.preambleEditor == null) {
                    PreambleEditor form = new PreambleEditor(BasePanel.this.frame, BasePanel.this.ths, BasePanel.this.database, BasePanel.this.prefs);
                    Util.placeDialog(form, BasePanel.this.frame);
                    form.setVisible(true);
                    BasePanel.this.preambleEditor = form;
                } else {
                    BasePanel.this.preambleEditor.setVisible(true);
                }
            }
        });
        this.actions.put("editStrings", new BaseAction(){

            @Override
            public void action() {
                if (BasePanel.this.stringDialog == null) {
                    StringDialog form = new StringDialog(BasePanel.this.frame, BasePanel.this.ths, BasePanel.this.database, BasePanel.this.prefs);
                    Util.placeDialog(form, BasePanel.this.frame);
                    form.setVisible(true);
                    BasePanel.this.stringDialog = form;
                } else {
                    BasePanel.this.stringDialog.setVisible(true);
                }
            }
        });
        this.actions.put("toggleGroups", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.sidePaneManager.togglePanel("groups");
            }
        });
        this.actions.put("pushToLyX", new BaseAction(){

            @Override
            public void action() {
                int[] rows = BasePanel.this.entryTable.getSelectedRows();
                int numSelected = rows.length;
                BibtexEntry bes = null;
                if (numSelected > 0) {
                    String citeStr = "";
                    String citeKey = "";
                    String message = "";
                    for (int i = 0; i < numSelected; ++i) {
                        bes = BasePanel.this.database.getEntryById(BasePanel.this.tableModel.getNameFromNumber(rows[i]));
                        citeKey = (String)bes.getField(GUIGlobals.KEY_FIELD);
                        if (citeKey == null || citeKey.equals("")) continue;
                        citeStr = citeStr.equals("") ? citeKey : citeStr + "," + citeKey;
                        message = message + ", " + rows[i];
                    }
                    if (citeStr.equals("")) {
                        BasePanel.this.output("Please define citekey first");
                    } else {
                        citeStr = "\\cite{" + citeStr + "}";
                        int pos = Editor.getCaretPosition();
                        Editor.insetText(citeStr, pos);
                        BasePanel.this.output("Pushed the citation " + citeStr + " for jeHep rows: " + message);
                    }
                }
            }
        });
        this.actions.put("makeKey", new BaseAction(){

            @Override
            public void action() {
                int[] rows = BasePanel.this.entryTable.getSelectedRows();
                int numSelected = rows.length;
                BibtexEntry bes = null;
                if (numSelected == 0) {
                    JOptionPane.showMessageDialog(BasePanel.this.frame, Globals.lang("First select the entries you want keys to be generated for."), Globals.lang("Autogenerate BibTeX key"), 1);
                    return;
                }
                BasePanel.this.output(Globals.lang("Generating BibTeX key for") + " " + numSelected + " " + (numSelected > 1 ? Globals.lang("entries") : Globals.lang("entry")));
                NamedCompound ce = new NamedCompound("autogenerate keys");
                for (int i = 0; i < numSelected; ++i) {
                    bes = BasePanel.this.database.getEntryById(BasePanel.this.tableModel.getNameFromNumber(rows[i]));
                    Object oldValue = bes.getField(GUIGlobals.KEY_FIELD);
                    bes = LabelPatternUtil.makeLabel(BasePanel.this.prefs.getKeyPattern(), BasePanel.this.database, bes);
                    ce.addEdit(new UndoableKeyChange(BasePanel.this.database, bes.getId(), (String)oldValue, (String)bes.getField(GUIGlobals.KEY_FIELD)));
                }
                ce.end();
                BasePanel.this.undoManager.addEdit(ce);
                BasePanel.this.markBaseChanged();
                BasePanel.this.refreshTable();
                BasePanel.this.output(Globals.lang("Generated BibTeX key for") + " " + numSelected + " " + (numSelected > 1 ? Globals.lang("entries") : Globals.lang("entry")));
            }
        });
        this.actions.put("search", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.sidePaneManager.ensureVisible("search");
                BasePanel.this.searchManager.startSearch();
            }
        });
        this.actions.put("incSearch", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.sidePaneManager.ensureVisible("search");
                BasePanel.this.searchManager.startIncrementalSearch();
            }
        });
        this.actions.put("copyKey", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                if (bes != null && bes.length > 0) {
                    Vector<Object> keys = new Vector<Object>();
                    for (int i = 0; i < bes.length; ++i) {
                        if (bes[i].getField("bibtexkey") == null) continue;
                        keys.add(bes[i].getField("bibtexkey"));
                    }
                    if (keys.size() == 0) {
                        BasePanel.this.output("None of the selected entries have BibTeX keys.");
                        return;
                    }
                    StringBuffer sb = new StringBuffer((String)keys.elementAt(0));
                    for (int i = 1; i < keys.size(); ++i) {
                        sb.append(',');
                        sb.append((String)keys.elementAt(i));
                    }
                    StringSelection ss = new StringSelection(sb.toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, BasePanel.this.ths);
                    if (keys.size() == bes.length) {
                        BasePanel.this.output(Globals.lang(bes.length > 1 ? "Copied keys" : "Copied key") + ".");
                    } else {
                        BasePanel.this.output(Globals.lang("Warning") + ": " + (bes.length - keys.size()) + " " + Globals.lang("out of") + " " + bes.length + " " + Globals.lang("entries have undefined BibTeX key") + ".");
                    }
                }
            }
        });
        this.actions.put("copyCiteKey", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                if (bes != null && bes.length > 0) {
                    Vector<Object> keys = new Vector<Object>();
                    for (int i = 0; i < bes.length; ++i) {
                        if (bes[i].getField("bibtexkey") == null) continue;
                        keys.add(bes[i].getField("bibtexkey"));
                    }
                    if (keys.size() == 0) {
                        BasePanel.this.output("None of the selected entries have BibTeX keys.");
                        return;
                    }
                    StringBuffer sb = new StringBuffer((String)keys.elementAt(0));
                    for (int i = 1; i < keys.size(); ++i) {
                        sb.append(',');
                        sb.append((String)keys.elementAt(i));
                    }
                    StringSelection ss = new StringSelection("\\cite{" + sb.toString() + "}");
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, BasePanel.this.ths);
                    if (keys.size() == bes.length) {
                        BasePanel.this.output(Globals.lang(bes.length > 1 ? "Copied keys" : "Copied key") + ".");
                    } else {
                        BasePanel.this.output(Globals.lang("Warning") + ": " + (bes.length - keys.size()) + " " + Globals.lang("out of") + " " + bes.length + " " + Globals.lang("entries have undefined BibTeX key") + ".");
                    }
                }
            }
        });
        this.actions.put("mergeDatabase", new BaseAction(){

            @Override
            public void action() {
                final MergeDialog md = new MergeDialog(BasePanel.this.frame, Globals.lang("Append database"), true);
                Util.placeDialog(md, BasePanel.this.ths);
                md.setVisible(true);
                if (md.okPressed) {
                    String chosenFile = Globals.getNewFile(BasePanel.this.frame, BasePanel.this.prefs, new File(BasePanel.this.prefs.get("workingDirectory")), null, 0, false);
                    if (chosenFile == null) {
                        return;
                    }
                    BasePanel.this.fileToOpen = new File(chosenFile);
                    if (BasePanel.this.fileToOpen != null) {
                        new Thread(){

                            @Override
                            public void run() {
                                this.openIt(md.importEntries(), md.importStrings(), md.importGroups(), md.importSelectorWords());
                            }
                        }.start();
                        BasePanel.this.frame.fileHistory.newFile(BasePanel.this.fileToOpen.getPath());
                    }
                }
            }

            void openIt(boolean importEntries, boolean importStrings, boolean importGroups, boolean importSelectorWords) {
                if (BasePanel.this.fileToOpen != null && BasePanel.this.fileToOpen.exists()) {
                    try {
                        Vector newGroups;
                        Iterator i;
                        BasePanel.this.prefs.put("workingDirectory", BasePanel.this.fileToOpen.getPath());
                        ParserResult pr = BasePanel.this.frame.loadDatabase(BasePanel.this.fileToOpen);
                        BibtexDatabase db = pr.getDatabase();
                        MetaData meta = new MetaData(pr.getMetaData());
                        NamedCompound ce = new NamedCompound("Append database");
                        if (importEntries) {
                            i = db.getKeySet().iterator();
                            while (i.hasNext()) {
                                BibtexEntry be = (BibtexEntry)db.getEntryById((String)i.next()).clone();
                                be.setId(Util.createNeutralId());
                                BasePanel.this.database.insertEntry(be);
                                ce.addEdit(new UndoableInsertEntry(BasePanel.this.database, be, BasePanel.this.ths));
                            }
                        }
                        if (importStrings) {
                            int pos = 0;
                            for (int i2 = 0; i2 < db.getStringCount(); ++i2) {
                                BibtexString bs = (BibtexString)db.getString(i2).clone();
                                if (BasePanel.this.database.hasStringLabel(bs.getName())) continue;
                                pos = BasePanel.this.database.getStringCount();
                                BasePanel.this.database.addString(bs, pos);
                                ce.addEdit(new UndoableInsertString(BasePanel.this.ths, BasePanel.this.database, bs, pos));
                            }
                        }
                        if (importGroups && (newGroups = meta.getData("groups")) != null) {
                            if (BasePanel.this.groupSelector == null) {
                                BasePanel.this.groupSelector = new GroupSelector(BasePanel.this.frame, BasePanel.this.ths, new Vector(), BasePanel.this.sidePaneManager, BasePanel.this.prefs);
                                BasePanel.this.sidePaneManager.register("groups", BasePanel.this.groupSelector);
                            }
                            BasePanel.this.groupSelector.addGroups(newGroups, ce);
                            BasePanel.this.groupSelector.revalidateList();
                        }
                        if (importSelectorWords) {
                            i = meta.iterator();
                            while (i.hasNext()) {
                                String s = (String)i.next();
                                if (!s.startsWith("selector_")) continue;
                                BasePanel.this.metaData.putData(s, meta.getData(s));
                            }
                        }
                        ce.end();
                        BasePanel.this.undoManager.addEdit(ce);
                        BasePanel.this.markBaseChanged();
                        BasePanel.this.refreshTable();
                        BasePanel.this.output("Imported from database '" + BasePanel.this.fileToOpen.getPath() + "':");
                        BasePanel.this.fileToOpen = null;
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(BasePanel.this.ths, ex.getMessage(), "Open database", 0);
                    }
                }
            }
        });
        this.actions.put("openFile", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                String field = "ps";
                if (bes != null && bes.length == 1) {
                    Object link = bes[0].getField("ps");
                    if (bes[0].getField("pdf") != null) {
                        link = bes[0].getField("pdf");
                        field = "pdf";
                    }
                    String filepath = null;
                    if (link != null) {
                        filepath = link.toString();
                    } else {
                        Object key = bes[0].getField("bibtexkey");
                        if (key != null) {
                            String basefile = key.toString();
                            String dir2 = BasePanel.this.prefs.get("pdfDirectory");
                            basefile = dir2.endsWith(System.getProperty("file.separator")) ? dir2 + basefile : dir2 + System.getProperty("file.separator") + basefile;
                            String[] typesToTry = new String[]{"html", "ps", "pdf"};
                            for (int i = 0; i < typesToTry.length; ++i) {
                                File f = new File(basefile + "." + typesToTry[i]);
                                Util.pr("Checking for " + f);
                                if (!f.exists()) continue;
                                field = typesToTry[i];
                                filepath = f.getPath();
                                break;
                            }
                        }
                    }
                    if (filepath != null) {
                        try {
                            Util.pr("Opening external " + field + " file '" + filepath + "'.");
                            Util.openExternalViewer(filepath, field, BasePanel.this.prefs);
                            BasePanel.this.output(Globals.lang("External viewer called") + ".");
                        }
                        catch (IOException ex) {
                            BasePanel.this.output(Globals.lang("Error: check your External viewer settings in Preferences") + ".");
                        }
                    } else {
                        BasePanel.this.output(Globals.lang("No pdf or ps defined, and no file matching Bibtex key found") + ".");
                    }
                } else {
                    BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                }
            }
        });
        this.actions.put("openUrl", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                String field = "doi";
                if (bes != null && bes.length == 1) {
                    Object link = bes[0].getField("doi");
                    if (bes[0].getField("url") != null) {
                        link = bes[0].getField("url");
                        field = "url";
                    }
                    if (link != null) {
                        try {
                            Util.openExternalViewer(link.toString(), field, BasePanel.this.prefs);
                            BasePanel.this.output(Globals.lang("External viewer called") + ".");
                        }
                        catch (IOException ex) {
                            BasePanel.this.output(Globals.lang("Error: check your External viewer settings in Preferences") + ".");
                        }
                    } else {
                        BasePanel.this.output(Globals.lang("No url defined") + ".");
                    }
                } else {
                    BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                }
            }
        });
        this.actions.put("replaceAll", new BaseAction(){

            @Override
            public void action() {
                ReplaceStringDialog rsd = new ReplaceStringDialog(BasePanel.this.frame);
                rsd.setVisible(true);
                if (!rsd.okPressed()) {
                    return;
                }
                int counter = 0;
                NamedCompound ce = new NamedCompound("Replace string");
                if (!rsd.selOnly()) {
                    Iterator i = BasePanel.this.database.getKeySet().iterator();
                    while (i.hasNext()) {
                        counter += rsd.replace(BasePanel.this.database.getEntryById((String)i.next()), ce);
                    }
                } else {
                    BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                    for (int i = 0; i < bes.length; ++i) {
                        counter += rsd.replace(bes[i], ce);
                    }
                }
                BasePanel.this.output(Globals.lang("Replaced") + " " + counter + " " + Globals.lang(counter == 1 ? "occurence" : "occurences") + ".");
                if (counter > 0) {
                    ce.end();
                    BasePanel.this.undoManager.addEdit(ce);
                    BasePanel.this.markBaseChanged();
                    BasePanel.this.refreshTable();
                }
            }
        });
        this.actions.put("dupliCheck", new BaseAction(){

            @Override
            public void action() {
                CompoundEdit ce = null;
                int dupl = 0;
                BasePanel.this.output(Globals.lang("Searching for duplicates..."));
                Object[] keys = BasePanel.this.database.getKeySet().toArray();
                if (keys == null || keys.length < 2) {
                    return;
                }
                BibtexEntry[] bes = new BibtexEntry[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    bes[i] = BasePanel.this.database.getEntryById((String)keys[i]);
                }
                Window drd = null;
                for (int i = 0; i < bes.length - 1; ++i) {
                    for (int j = i + 1; j < bes.length; ++j) {
                        boolean eq = Util.isDuplicate(bes[i], bes[j], Globals.duplicateThreshold);
                        if (!eq || BasePanel.this.database.getEntryById(bes[i].getId()) == null || BasePanel.this.database.getEntryById(bes[j].getId()) == null) continue;
                        if (drd == null) {
                            drd = new DuplicateResolverDialog(BasePanel.this.frame, bes[i], bes[j]);
                        } else {
                            ((DuplicateResolverDialog)drd).setEntries(bes[i], bes[j]);
                        }
                        ((Dialog)drd).setVisible(true);
                        int answer = ((DuplicateResolverDialog)drd).getSelected();
                        if (answer == 1) {
                            if (ce == null) {
                                ce = new NamedCompound("duplicate removal");
                            }
                            BasePanel.this.database.removeEntry(bes[j].getId());
                            BasePanel.this.refreshTable();
                            BasePanel.this.markBaseChanged();
                            ce.addEdit(new UndoableRemoveEntry(BasePanel.this.database, bes[j], BasePanel.this.ths));
                        } else if (answer == 2) {
                            if (ce == null) {
                                ce = new NamedCompound("duplicate removal");
                            }
                            BasePanel.this.database.removeEntry(bes[i].getId());
                            BasePanel.this.refreshTable();
                            BasePanel.this.markBaseChanged();
                            ce.addEdit(new UndoableRemoveEntry(BasePanel.this.database, bes[i], BasePanel.this.ths));
                        }
                        ++dupl;
                    }
                }
                if (drd != null) {
                    drd.dispose();
                }
                BasePanel.this.output(Globals.lang("Duplicate pairs found") + ": " + dupl);
                if (ce != null) {
                    ce.end();
                    BasePanel.this.undoManager.addEdit(ce);
                }
            }
        });
        this.actions.put("markEntries", new BaseAction(){

            @Override
            public void action() {
                NamedCompound ce = new NamedCompound("Mark entries");
                BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                for (int i = 0; i < bes.length; ++i) {
                    ce.addEdit(new UndoableFieldChange(bes[i], "__markedentry", bes[i].getField("__markedentry"), "0"));
                    bes[i].setField("__markedentry", "0");
                }
                ce.end();
                BasePanel.this.undoManager.addEdit(ce);
                BasePanel.this.markBaseChanged();
                BasePanel.this.refreshTable();
            }
        });
        this.actions.put("unmarkEntries", new BaseAction(){

            @Override
            public void action() {
                NamedCompound ce = new NamedCompound("Unmark entries");
                BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                for (int i = 0; i < bes.length; ++i) {
                    ce.addEdit(new UndoableFieldChange(bes[i], "__markedentry", bes[i].getField("__markedentry"), null));
                    bes[i].setField("__markedentry", null);
                }
                ce.end();
                BasePanel.this.undoManager.addEdit(ce);
                BasePanel.this.markBaseChanged();
                BasePanel.this.refreshTable();
            }
        });
        this.actions.put("unmarkAll", new BaseAction(){

            @Override
            public void action() {
                NamedCompound ce = new NamedCompound("Unmark all");
                Set keySet = BasePanel.this.database.getKeySet();
                Iterator i = keySet.iterator();
                while (i.hasNext()) {
                    BibtexEntry be = BasePanel.this.database.getEntryById((String)i.next());
                    ce.addEdit(new UndoableFieldChange(be, "__markedentry", be.getField("__markedentry"), null));
                    be.setField("__markedentry", null);
                }
                ce.end();
                BasePanel.this.undoManager.addEdit(ce);
                BasePanel.this.markBaseChanged();
                BasePanel.this.refreshTable();
            }
        });
        this.actions.put("togglePreview", new BaseAction(){

            @Override
            public void action() {
                boolean bl = BasePanel.this.previewEnabled = !BasePanel.this.previewEnabled;
                if (!BasePanel.this.previewEnabled) {
                    BasePanel.this.hidePreview();
                } else {
                    BibtexEntry[] bes = BasePanel.this.entryTable.getSelectedEntries();
                    if (bes != null && bes.length > 0) {
                        BasePanel.this.updateWiewToSelected(bes[0]);
                    }
                }
            }
        });
    }

    public void runCommand(String command) throws Throwable {
        if (this.actions.get(command) == null) {
            Util.pr("No action defined for'" + command + "'");
        } else {
            ((BaseAction)this.actions.get(command)).action();
        }
    }

    private void saveDatabase(File file2, boolean selectedOnly) throws SaveException {
        try {
            if (!selectedOnly) {
                FileActions.saveDatabase(this.database, this.metaData, file2, this.prefs, false, false);
            } else {
                FileActions.savePartOfDatabase(this.database, this.metaData, file2, this.prefs, this.entryTable.getSelectedEntries());
            }
        }
        catch (SaveException ex) {
            if (ex.specificEntry()) {
                int row = this.tableModel.getNumberFromName(ex.getEntry().getId());
                int topShow = Math.max(0, row - 3);
                this.entryTable.setRowSelectionInterval(row, row);
                this.entryTable.setColumnSelectionInterval(0, this.entryTable.getColumnCount() - 1);
                this.entryTable.scrollTo(topShow);
                this.showEntry(ex.getEntry());
            } else {
                ex.printStackTrace();
            }
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file") + ".\n" + ex.getMessage(), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
    }

    public void newEntry(BibtexEntryType type) {
        if (type == null) {
            EntryTypeDialog etd = new EntryTypeDialog(this.frame);
            Util.placeDialog(etd, this.frame);
            etd.setVisible(true);
            type = etd.getChoice();
        }
        if (type != null) {
            String id = Util.createId(type, this.database);
            BibtexEntry be = new BibtexEntry(id, type);
            try {
                this.database.insertEntry(be);
                if (this.prefs.getBoolean("useOwner")) {
                    be.setField("owner", this.prefs.get("defaultOwner"));
                }
                this.undoManager.addEdit(new UndoableInsertEntry(this.database, be, this.ths));
                this.output(Globals.lang("Added new") + " '" + type.getName().toLowerCase() + "' " + Globals.lang("entry") + ".");
                this.refreshTable();
                int row = this.tableModel.getNumberFromName(id);
                this.entryTable.clearSelection();
                this.entryTable.scrollTo(row);
                this.markBaseChanged();
                if (this.prefs.getBoolean("autoOpenForm")) {
                    this.showEntry(be);
                }
            }
            catch (KeyCollisionException ex) {
                Util.pr(ex.getMessage());
            }
        }
    }

    public void validateMainPanel() {
    }

    public void setupTable() {
        this.tableModel = new EntryTableModel(this.frame, this, this.database);
        this.entryTable = new EntryTable(this.tableModel, this.ths, this.frame.prefs);
        this.entryTable.getActionMap().put("cut", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("cut");
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.entryTable.getActionMap().put("copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("copy");
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.entryTable.getActionMap().put("paste", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("paste");
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.entryTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BasePanel.this.runCommand("edit");
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                } else if (e.getKeyCode() == 127) {
                    try {
                        BasePanel.this.runCommand("delete");
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.entryTable.setRightClickMenu(this.rcm);
        int pos = this.splitPane.getDividerLocation();
        this.splitPane.setTopComponent(this.entryTable.getPane());
        this.splitPane.setDividerLocation(pos);
    }

    public void setupMainPanel() {
        this.splitPane = new JSplitPane(0);
        this.splitPane.setDividerSize(2);
        this.setupTable();
        if (this.showing == null) {
            this.splitPane.setBottomComponent(this.previewPanel);
            if (this.previewPanel != null) {
                this.splitPane.setDividerLocation(this.splitPane.getHeight() - 115);
            }
        } else {
            this.showEntry(this.showing);
        }
        this.setRightComponent(this.splitPane);
        this.sidePaneManager = new SidePaneManager(this.frame, this, this.prefs, this.metaData);
        this.medlineFetcher = new MedlineFetcher(this, this.sidePaneManager);
        this.sidePaneManager.register("fetchMedline", this.medlineFetcher);
        this.medlineAuthorFetcher = new MedlineAuthorFetcher(this, this.sidePaneManager);
        this.sidePaneManager.register("fetchAuthorMedline", this.medlineAuthorFetcher);
        this.searchManager = new SearchManager2(this.frame, this.prefs, this.sidePaneManager);
        this.sidePaneManager.add("search", this.searchManager);
        this.sidePaneManager.populatePanel();
        this.setDividerSize(2);
        this.setResizeWeight(0.0);
        this.revalidate();
    }

    public void parseMetaData(HashMap meta) {
        this.metaData = new MetaData(meta);
    }

    public void refreshTable() {
        this.tableModel.remap();
        this.entryTable.revalidate();
        this.entryTable.repaint();
    }

    public void updatePreamble() {
        if (this.preambleEditor != null) {
            this.preambleEditor.updatePreamble();
        }
    }

    public void assureStringDialogNotEditing() {
        if (this.stringDialog != null) {
            this.stringDialog.assureNotEditing();
        }
    }

    public void updateStringDialog() {
        if (this.stringDialog != null) {
            this.stringDialog.refreshTable();
        }
    }

    public void updateWiewToSelected(BibtexEntry be) {
        if (this.showing != null) {
            BibtexEntry[] bes = this.entryTable.getSelectedEntries();
            if (bes != null && bes.length > 0) {
                this.showEntry(bes[0]);
            }
            return;
        }
        if (!this.previewEnabled) {
            this.splitPane.setBottomComponent(null);
            return;
        }
        if (this.previewPanel == null) {
            this.previewPanel = new PreviewPanel(be);
        } else {
            this.previewPanel.setEntry(be);
        }
        this.splitPane.setBottomComponent(this.previewPanel);
        this.splitPane.setDividerLocation(this.splitPane.getHeight() - 115);
        this.previewPanel.repaint();
    }

    public void hidePreview() {
        this.previewPanel = null;
        Component c = this.splitPane.getBottomComponent();
        if (c != null && c instanceof PreviewPanel) {
            this.splitPane.setBottomComponent(null);
        }
    }

    public boolean isShowingEditor() {
        return this.splitPane.getBottomComponent() != null && this.splitPane.getBottomComponent() instanceof EntryEditor;
    }

    public void showEntry(BibtexEntry be) {
        EntryEditor form;
        if (this.showing == be) {
            if (this.splitPane.getBottomComponent() == null) {
                this.showing = null;
                this.showEntry(be);
            }
            return;
        }
        int divLoc = -1;
        int visPan = -1;
        if (this.showing != null) {
            visPan = ((EntryEditor)this.splitPane.getBottomComponent()).getVisiblePanel();
        }
        if (this.showing != null) {
            divLoc = this.splitPane.getDividerLocation();
        }
        if (this.entryEditors.containsKey(be.getType().getName())) {
            form = (EntryEditor)this.entryEditors.get(be.getType().getName());
            form.switchTo(be);
            if (visPan >= 0) {
                form.setVisiblePanel(visPan);
            }
            this.splitPane.setBottomComponent(form);
        } else {
            form = new EntryEditor(this.frame, this.ths, be, this.prefs);
            if (visPan >= 0) {
                form.setVisiblePanel(visPan);
            }
            this.splitPane.setBottomComponent(form);
            this.entryEditors.put(be.getType().getName(), form);
        }
        if (divLoc > 0) {
            this.splitPane.setDividerLocation(divLoc);
        } else {
            this.splitPane.setDividerLocation(0.4);
        }
        new FocusRequester(form);
        this.showing = be;
        this.setEntryEditorEnabled(true);
    }

    public void hideEntryEditor() {
        BibtexEntry be = this.showing;
        this.showing = null;
        if (be != null) {
            this.updateWiewToSelected(be);
        }
        new FocusRequester(this.entryTable);
    }

    public void ensureNotShowing(BibtexEntry be) {
        if (this.showing == be) {
            this.hideEntryEditor();
            this.showing = null;
        }
    }

    public void markBaseChanged() {
        this.baseChanged = true;
        String oldTitle = this.frame.getTabTitle(this);
        if (!oldTitle.endsWith("*")) {
            this.frame.setTabTitle(this, oldTitle + "*");
        }
        if (this.frame.statusLine.getText().startsWith("Saved database")) {
            this.frame.output(" ");
        }
    }

    public void markNonUndoableBaseChanged() {
        this.nonUndoableChange = true;
        this.markBaseChanged();
    }

    public synchronized void markChangedOrUnChanged() {
        if (this.undoManager.hasChanged()) {
            if (!this.baseChanged) {
                this.markBaseChanged();
            }
        } else if (this.baseChanged && !this.nonUndoableChange) {
            this.baseChanged = false;
            if (this.file != null) {
                this.frame.setTabTitle(this.ths, this.file.getName());
            } else {
                this.frame.setTabTitle(this.ths, Globals.lang("untitled"));
            }
        }
    }

    public void showSearchResults(String searchValueField) {
        if (searchValueField == "__search") {
            this.showingSearchResults = true;
        } else if (searchValueField == "__groupsearch") {
            this.showingGroup = true;
        }
        this.entryTable.setShowingSearchResults(this.showingSearchResults, this.showingGroup);
        this.entryTable.clearSelection();
        this.entryTable.scrollTo(0);
        this.refreshTable();
    }

    public void selectSearchResults() {
        this.entryTable.clearSelection();
        for (int i = 0; i < this.entryTable.getRowCount(); ++i) {
            String value = (String)this.database.getEntryById(this.tableModel.getNameFromNumber(i)).getField("__search");
            if (value == null || value.equals("0")) continue;
            this.entryTable.addRowSelectionInterval(i, i);
        }
    }

    public void selectSingleEntry(int pos) {
        this.entryTable.clearSelection();
        this.entryTable.addRowSelectionInterval(pos, pos);
        this.entryTable.scrollToCenter(pos, 0);
    }

    public void stopShowingSearchResults() {
        this.showingSearchResults = false;
        this.entryTable.setShowingSearchResults(this.showingSearchResults, this.showingGroup);
        this.refreshTable();
        this.entryTable.requestFocus();
    }

    public void stopShowingGroup() {
        this.showingGroup = false;
        this.entryTable.setShowingSearchResults(this.showingSearchResults, this.showingGroup);
        this.refreshTable();
    }

    protected EntryTableModel getTableModel() {
        return this.tableModel;
    }

    public BibtexDatabase getDatabase() {
        return this.database;
    }

    public void entryTypeFormClosing(String id) {
    }

    public void preambleEditorClosing() {
        this.preambleEditor = null;
    }

    public void stringsClosing() {
        this.stringDialog = null;
    }

    public void addToGroup(String groupName, String regexp, String field) {
        String message;
        int choice;
        boolean giveWarning = false;
        for (int i = 0; i < GUIGlobals.ALL_FIELDS.length; ++i) {
            if (!field.equals(GUIGlobals.ALL_FIELDS[i]) || field.equals("keywords")) continue;
            giveWarning = true;
            break;
        }
        if (giveWarning && (choice = JOptionPane.showConfirmDialog(this, message = "This action will modify the '" + field + "' field of your entries.\nThis could cause undesired changes to your entries, so it\nis recommended that you change the field in your group\ndefinition to 'keywords' or a non-standard name.\n\nDo you still want to continue?", "Warning", 0, 2)) == 1) {
            return;
        }
        BibtexEntry[] bes = this.entryTable.getSelectedEntries();
        if (bes != null && bes.length > 0) {
            QuickSearchRule qsr = new QuickSearchRule(field, regexp);
            NamedCompound ce = new NamedCompound("add to group");
            boolean hasEdits = false;
            for (int i = 0; i < bes.length; ++i) {
                if (qsr.applyRule(null, bes[i]) != 0) continue;
                String oldContent = (String)bes[i].getField(field);
                String pre = " ";
                String post = "";
                String newContent = (oldContent == null ? "" : oldContent + pre) + regexp + post;
                bes[i].setField(field, newContent);
                ce.addEdit(new UndoableFieldChange(bes[i], field, oldContent, newContent));
                hasEdits = true;
            }
            if (hasEdits) {
                ce.end();
                this.undoManager.addEdit(ce);
                this.refreshTable();
                this.markBaseChanged();
            }
            this.output("Appended '" + regexp + "' to the '" + field + "' field of " + bes.length + " entr" + (bes.length > 1 ? "ies." : "y."));
        }
    }

    public void removeFromGroup(String groupName, String regexp, String field) {
        String message;
        int choice;
        boolean giveWarning = false;
        for (int i = 0; i < GUIGlobals.ALL_FIELDS.length; ++i) {
            if (!field.equals(GUIGlobals.ALL_FIELDS[i]) || field.equals("keywords")) continue;
            giveWarning = true;
            break;
        }
        if (giveWarning && (choice = JOptionPane.showConfirmDialog(this, message = "This action will modify the '" + field + "' field of your entries.\nThis could cause undesired changes to your entries, so it\nis recommended that you change the field in your group\ndefinition to 'keywords' or a non-standard name.\n\nDo you still want to continue?", "Warning", 0, 2)) == 1) {
            return;
        }
        BibtexEntry[] bes = this.entryTable.getSelectedEntries();
        if (bes != null && bes.length > 0) {
            QuickSearchRule qsr = new QuickSearchRule(field, regexp);
            NamedCompound ce = new NamedCompound("remove from group");
            boolean hasEdits = false;
            for (int i = 0; i < bes.length; ++i) {
                if (qsr.applyRule(null, bes[i]) <= 0) continue;
                String oldContent = (String)bes[i].getField(field);
                qsr.removeMatches(bes[i]);
                ce.addEdit(new UndoableFieldChange(bes[i], field, oldContent, bes[i].getField(field)));
                hasEdits = true;
            }
            if (hasEdits) {
                ce.end();
                this.undoManager.addEdit(ce);
                this.refreshTable();
                this.markBaseChanged();
            }
            this.output("Removed '" + regexp + "' from the '" + field + "' field of " + bes.length + " entr" + (bes.length > 1 ? "ies." : "y."));
        }
    }

    public void changeType(BibtexEntryType type) {
        int choice;
        BibtexEntry[] bes = this.entryTable.getSelectedEntries();
        if (bes == null || bes.length == 0) {
            this.output("First select the entries you wish to change type for.");
            return;
        }
        if (bes.length > 1 && (choice = JOptionPane.showConfirmDialog(this, "Multiple entries selected. Do you want to change\nthe type of all these to '" + type.getName() + "'?", "Change type", 0, 2)) == 1) {
            return;
        }
        NamedCompound ce = new NamedCompound("change type");
        for (int i = 0; i < bes.length; ++i) {
            ce.addEdit(new UndoableChangeType(bes[i], bes[i].getType(), type));
            bes[i].setType(type);
        }
        this.output(Globals.lang("Changed type to") + " '" + type.getName() + "' " + Globals.lang("for") + " " + bes.length + " " + Globals.lang("entries") + ".");
        ce.end();
        this.undoManager.addEdit(ce);
        this.refreshTable();
        this.markBaseChanged();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public boolean previewEnabled() {
        return this.previewEnabled;
    }

    public void setEntryEditorEnabled(boolean enabled) {
        EntryEditor ed;
        if (this.showing != null && this.splitPane.getBottomComponent() instanceof EntryEditor && (ed = (EntryEditor)this.splitPane.getBottomComponent()).isEnabled() != enabled) {
            ed.setEnabled(enabled);
        }
    }

    class UndoAction
    extends BaseAction {
        UndoAction() {
        }

        @Override
        public void action() {
            try {
                String name = BasePanel.this.undoManager.getUndoPresentationName();
                BasePanel.this.undoManager.undo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.refreshTable();
                BasePanel.this.frame.output(name);
            }
            catch (CannotUndoException ex) {
                BasePanel.this.frame.output(Globals.lang("Nothing to undo") + ".");
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }

    class RedoAction
    extends BaseAction {
        RedoAction() {
        }

        @Override
        public void action() {
            try {
                String name = BasePanel.this.undoManager.getRedoPresentationName();
                BasePanel.this.undoManager.redo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.refreshTable();
                BasePanel.this.frame.output(name);
            }
            catch (CannotRedoException ex) {
                BasePanel.this.frame.output(Globals.lang("Nothing to redo") + ".");
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }

    abstract class BaseAction {
        BaseAction() {
        }

        abstract void action() throws Throwable;
    }
}

