/*
 * Decompiled with CFR 0.152.
 */
package dragmath;

import dragmath.InputComponent;
import dragmath.tree.BinaryOperator;
import dragmath.tree.Function;
import dragmath.tree.Grouping;
import dragmath.tree.MathObject;
import dragmath.tree.Matrix;
import dragmath.tree.NaryFunction;
import dragmath.tree.NaryOperator;
import dragmath.tree.RealNumber;
import dragmath.tree.Text;
import dragmath.tree.Variable;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeDisplay
extends JFrame {
    private DefaultMutableTreeNode root;
    private InputComponent[] inputComponents;
    private JPanel jPanel1;

    public TreeDisplay(MathObject start, InputComponent[] inputComponents) {
        this.initComponents();
        this.inputComponents = inputComponents;
        this.root = new DefaultMutableTreeNode("Expression");
        if (start != null) {
            this.traverse(start, this.root);
        }
        JScrollPane jScrollPane1 = new JScrollPane();
        JTree jTree1 = new JTree(this.root);
        jScrollPane1.setViewportView(jTree1);
        this.jPanel1.add((Component)jScrollPane1, "Center");
        for (int i = 0; i < jTree1.getRowCount(); ++i) {
            jTree1.expandRow(i);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("DragMath");
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel1.setMaximumSize(new Dimension(1000, 1000));
        this.jPanel1.setMinimumSize(new Dimension(100, 100));
        this.jPanel1.setPreferredSize(new Dimension(300, 300));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    public void traverse(MathObject start, DefaultMutableTreeNode currentNode) throws NullPointerException {
        int i;
        DefaultMutableTreeNode nary;
        if (start.getClass().getName().equals("dragmath.tree.Text")) {
            Text textObj = (Text)start;
            DefaultMutableTreeNode text = new DefaultMutableTreeNode(textObj.getText());
            currentNode.add(text);
        }
        if (start.getClass().getName().equals("dragmath.tree.Variable")) {
            Variable variableObj = (Variable)start;
            DefaultMutableTreeNode var = new DefaultMutableTreeNode(String.valueOf(variableObj.getVarName()));
            currentNode.add(var);
        }
        if (start.getClass().getName().equals("dragmath.tree.RealNumber")) {
            RealNumber numberObj = (RealNumber)start;
            DefaultMutableTreeNode number = new DefaultMutableTreeNode(numberObj.getNumber(true));
            currentNode.add(number);
        }
        if (start.getClass().getName().equals("dragmath.tree.BinaryOperator")) {
            BinaryOperator binaryObj = (BinaryOperator)start;
            DefaultMutableTreeNode binary = new DefaultMutableTreeNode(this.inputComponents[binaryObj.getID()].getDisplayText());
            currentNode.add(binary);
            this.traverse(binaryObj.getRightChild(), binary);
            this.traverse(binaryObj.getLeftChild(), binary);
        }
        if (start.getClass().getName().equals("dragmath.tree.Function")) {
            Function functionObj = (Function)start;
            DefaultMutableTreeNode function = new DefaultMutableTreeNode(this.inputComponents[functionObj.getID()].getDisplayText());
            currentNode.add(function);
            this.traverse(functionObj.getChild(), function);
        }
        if (start.getClass().getName().equals("dragmath.tree.NaryFunction")) {
            NaryFunction naryFunctionObj = (NaryFunction)start;
            nary = new DefaultMutableTreeNode(this.inputComponents[naryFunctionObj.getID()].getDisplayText());
            currentNode.add(nary);
            for (i = 0; i < naryFunctionObj.getSize(); ++i) {
                this.traverse(naryFunctionObj.getChild(i), nary);
            }
        }
        if (start.getClass().getName().equals("dragmath.tree.Matrix")) {
            Matrix matrixObj = (Matrix)start;
            DefaultMutableTreeNode matrix = new DefaultMutableTreeNode(this.inputComponents[matrixObj.getID()].getDisplayText());
            currentNode.add(matrix);
        }
        if (start.getClass().getName().equals("dragmath.tree.Grouping")) {
            Grouping groupingObj = (Grouping)start;
            DefaultMutableTreeNode grouping = new DefaultMutableTreeNode(this.inputComponents[groupingObj.getID()].getDisplayText());
            currentNode.add(grouping);
            this.traverse(groupingObj.getChild(), grouping);
        }
        if (start.getClass().getName().equals("dragmath.tree.NaryOperator")) {
            NaryOperator naryObj = (NaryOperator)start;
            nary = new DefaultMutableTreeNode(this.inputComponents[naryObj.getID()].getDisplayText());
            currentNode.add(nary);
            for (i = 0; i < naryObj.getSize(); ++i) {
                this.traverse(naryObj.getChild(i), nary);
            }
        }
    }
}

