/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.table.filters;

import com.vlsolutions.swing.table.VLJTableFilter;

public class ContainsFilter
implements VLJTableFilter {
    String filter;
    String lowerCaseFilter;
    boolean ignoreCase = false;

    public ContainsFilter() {
    }

    public ContainsFilter(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public ContainsFilter(boolean ignoreCase, String filter) {
        this.ignoreCase = ignoreCase;
        this.setFilter(filter);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean accept(Object filterPattern) {
        if (this.filter == null) {
            return true;
        }
        if (this.ignoreCase) {
            return ((String)filterPattern).toLowerCase().indexOf(this.lowerCaseFilter) >= 0;
        }
        return ((String)filterPattern).indexOf(this.filter) >= 0;
    }

    @Override
    public void compile() {
        if (this.ignoreCase && this.filter != null) {
            this.lowerCaseFilter = this.filter.toLowerCase();
        }
    }

    @Override
    public void setFilter(Object value) {
        this.setFilter((String)value);
    }

    @Override
    public boolean isFiltering() {
        return this.filter != null && !this.filter.equals("");
    }
}

