/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.table;

import com.vlsolutions.swing.table.VLJTable;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class VLTableCellRenderer
extends DefaultTableCellRenderer {
    protected VLJTable table;
    protected int col;

    public VLTableCellRenderer() {
    }

    VLTableCellRenderer(VLJTable table, int col) {
        this.col = col;
        this.table = table;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
            this.setHorizontalAlignment(0);
        }
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int sort = this.table.getSortMode(this.col);
        if (sort != 0) {
            g.setColor(this.getBackground().darker());
            if (sort == 1) {
                g.drawImage(this.table.getAscendingSortImage(), this.getWidth() - 16, this.getHeight() / 2 - 8, null);
            } else {
                g.drawImage(this.table.getDescendingSortImage(), this.getWidth() - 16, this.getHeight() / 2 - 8, null);
            }
        }
    }
}

