/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.util;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class ListComboBoxModel<T>
extends AbstractListModel
implements ComboBoxModel {
    private static final long serialVersionUID = 1L;
    private List<T> data;
    private T selectedObject;

    public ListComboBoxModel(List<T> data) {
        this.data = data;
        if (data.size() > 0) {
            this.selectedObject = data.get(0);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedObject = anItem;
    }

    @Override
    public Object getElementAt(int index) {
        return this.data.get(index);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    public void addItem(T item) {
        if (item == null) {
            return;
        }
        this.data.add(item);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void removeItem(T item) {
        this.data.remove(item);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void update() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public List<T> getDataList() {
        return this.data;
    }

    public void clear() {
        this.data.clear();
        this.update();
    }
}

