/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.logger;

import com.artenum.tk.ui.xmlgui.GUILoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class GUILogger
extends JPanel
implements ActionListener,
ComponentListener,
ChangeListener {
    private static final long serialVersionUID = -1367411009432805437L;
    public static final String STYLE_NORMAL = "regular";
    public static final String STYLE_ERROR = "error";
    public static final String STYLE_WARNING = "warning";
    public static final String STYLE_DEBUG = "debug";
    public static final String STYLE_INFO_ICON = "regularIcon";
    public static final String STYLE_ERROR_ICON = "errorIcon";
    public static final String STYLE_WARNING_ICON = "warningIcon";
    public static final String STYLE_DEBUG_ICON = "debugIcon";
    public static final String STYLE_SYSTEM = "system";
    public static final String STYLE_LARGE = "large";
    public static final String STYLE_SMALL = "small";
    public static final String STYLE_BOLD = "bold";
    private StyledDocument document = new DefaultStyledDocument();
    private JTextPane log = new JTextPane(this.document);
    private JButton clear;
    private JScrollPane scroll;
    private JCheckBox autoScroll;
    private int logSize = 50000;
    private JSlider slider;
    private ImageIcon errorIcon;
    private Icon warningIcon;
    private Icon debugIcon;
    private ImageIcon infoIcon;

    public GUILogger() {
        super(new BorderLayout());
        this.log.setEditable(false);
        this.slider = new JSlider(1, 5);
        Hashtable<Integer, JLabel> tabLabel = new Hashtable<Integer, JLabel>();
        tabLabel.put(new Integer(5), new JLabel("Inf"));
        tabLabel.put(new Integer(1), new JLabel("Min"));
        this.slider.setLabelTable(tabLabel);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(this);
        this.slider.setValue(5);
        this.scroll = new JScrollPane(this.log);
        this.clear = new JButton("Clear");
        this.clear.setActionCommand("CLEAR");
        this.clear.addActionListener(this);
        this.autoScroll = new JCheckBox("Auto scroll", true);
        JPanel cmdLine = new JPanel();
        cmdLine.setLayout(new BoxLayout(cmdLine, 2));
        cmdLine.add(this.autoScroll);
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(this.slider);
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(this.clear);
        this.add((Component)this.scroll, "Center");
        this.add((Component)cmdLine, "South");
        this.log.addComponentListener(this);
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = this.document.addStyle(STYLE_NORMAL, def);
        StyleConstants.setFontFamily(def, "SansSerif");
        Style s = this.document.addStyle(STYLE_BOLD, regular);
        StyleConstants.setBold(s, true);
        s = this.document.addStyle(STYLE_SMALL, regular);
        StyleConstants.setFontSize(s, 10);
        s = this.document.addStyle(STYLE_LARGE, regular);
        StyleConstants.setFontSize(s, 16);
        s = this.document.addStyle(STYLE_ERROR, regular);
        StyleConstants.setForeground(s, Color.RED);
        s = this.document.addStyle(STYLE_WARNING, regular);
        StyleConstants.setForeground(s, new Color(255, 82, 0));
        s = this.document.addStyle(STYLE_SYSTEM, regular);
        StyleConstants.setForeground(s, Color.BLUE);
        s = this.document.addStyle(STYLE_DEBUG, regular);
        StyleConstants.setForeground(s, new Color(240, 0, 240));
        this.debugIcon = this.getImageIconFromClassPath("/debug_icon.png");
        s = this.document.addStyle(STYLE_DEBUG_ICON, regular);
        StyleConstants.setIcon(s, this.debugIcon);
        this.infoIcon = this.getImageIconFromClassPath("/normal_icon.png");
        s = this.document.addStyle(STYLE_INFO_ICON, regular);
        StyleConstants.setIcon(s, this.infoIcon);
        this.warningIcon = this.getImageIconFromClassPath("/warning_icon.png");
        s = this.document.addStyle(STYLE_WARNING_ICON, regular);
        StyleConstants.setIcon(s, this.warningIcon);
        this.errorIcon = this.getImageIconFromClassPath("/error_icon.png");
        s = this.document.addStyle(STYLE_ERROR_ICON, regular);
        StyleConstants.setIcon(s, this.errorIcon);
    }

    public ImageIcon getImageIconFromClassPath(String iconPath) {
        ImageIcon icon = null;
        if (iconPath != null) {
            URL imgURL = GUILoader.class.getResource(iconPath);
            if (imgURL != null) {
                icon = new ImageIcon(imgURL);
            } else {
                System.err.println("Couldn't find file: " + iconPath);
            }
        }
        return icon;
    }

    StyledDocument getDocument() {
        return this.document;
    }

    public void setBufferSize(int nbCharMax) {
        this.logSize = nbCharMax;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("CLEAR")) {
            try {
                this.document.remove(0, this.document.getLength());
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    public StyledDocument getStyledDocument() {
        return this.document;
    }

    public PrintStream getStreamedLogged(String styleName) {
        return new PrintStream(new LoggerOutputStream(styleName));
    }

    public void updateScrollPosition() {
        this.scroll.getViewport().setViewPosition(new Point(0, this.log.getHeight()));
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.autoScroll.isSelected()) {
            this.updateScrollPosition();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        switch (this.slider.getValue()) {
            case 1: {
                this.setBufferSize(5000);
                break;
            }
            case 2: {
                this.setBufferSize(10000);
                break;
            }
            case 3: {
                this.setBufferSize(50000);
                break;
            }
            case 4: {
                this.setBufferSize(100000);
                break;
            }
            case 5: {
                this.setBufferSize(-1);
            }
        }
    }

    public class LoggerOutputStream
    extends OutputStream {
        private String styleName;

        public LoggerOutputStream(String styleName) {
            this.styleName = styleName;
        }

        public void setStyle(String style) {
            this.styleName = style;
        }

        public void checkBufferSize() {
            if (GUILogger.this.logSize > 0 && GUILogger.this.document.getLength() - GUILogger.this.logSize > 0) {
                try {
                    GUILogger.this.document.remove(0, GUILogger.this.document.getLength() - GUILogger.this.logSize);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                GUILogger.this.document.insertString(GUILogger.this.document.getLength(), String.valueOf((char)b), GUILogger.this.document.getStyle(this.styleName));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.checkBufferSize();
        }

        @Override
        public void write(byte[] b) throws IOException {
            try {
                GUILogger.this.document.insertString(GUILogger.this.document.getLength(), new String(b), GUILogger.this.document.getStyle(this.styleName));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.checkBufferSize();
        }

        public void write(byte[] b, String style) throws IOException {
            this.styleName = style;
            this.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                GUILogger.this.document.insertString(GUILogger.this.document.getLength(), new String(b, off, len), GUILogger.this.document.getStyle(this.styleName));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.checkBufferSize();
        }
    }
}

