/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.panel;

import com.artenum.tk.panel.PanelType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class GridBagPanel
extends JPanel {
    private static final long serialVersionUID = 4701719869705620555L;
    private GridBagConstraints constraints;
    private GridBagConstraints defaultConstraints;
    private PanelType type;
    private int currentGridX;
    private int currentGridY;
    private boolean positionSet = false;

    private GridBagPanel(Builder builder) {
        this.setLayout(new GridBagLayout());
        if (builder.containerName != null) {
            this.setBorder(BorderFactory.createTitledBorder(builder.containerName));
        }
        this.defaultConstraints = builder.defaultConstraints;
        this.constraints = new GridBagConstraints();
        this.type = builder.type;
        this.currentGridX = 0;
        this.currentGridY = 0;
        this.resetConstraints();
    }

    public GridBagPanel addComponent(Component component) {
        switch (this.type) {
            case GRID: {
                if (this.positionSet) break;
                this.constraints.gridx = this.currentGridX;
                this.constraints.gridy = this.currentGridY;
                this.currentGridX += this.constraints.gridwidth;
                break;
            }
            case HBOX: {
                this.constraints.gridx = this.currentGridX;
                this.constraints.gridy = 0;
                this.currentGridX += this.constraints.gridwidth;
                break;
            }
            case VBOX: {
                this.constraints.gridx = 0;
                this.constraints.gridy = this.currentGridY++;
                break;
            }
        }
        this.add(component, this.constraints);
        this.resetConstraints();
        return this;
    }

    public GridBagPanel newLine() {
        this.currentGridX = 0;
        ++this.currentGridY;
        return this;
    }

    public GridBagPanel nextGridX() {
        ++this.currentGridX;
        return this;
    }

    public GridBagPanel nextGridY() {
        ++this.currentGridY;
        return this;
    }

    public GridBagPanel anchor(int anchor) {
        this.constraints.anchor = anchor;
        return this;
    }

    public GridBagPanel fill(int fill) {
        this.constraints.fill = fill;
        return this;
    }

    public GridBagPanel gridheight(int gridheight) {
        this.constraints.gridheight = gridheight;
        return this;
    }

    public GridBagPanel gridwidth(int gridwidth) {
        this.constraints.gridwidth = gridwidth;
        return this;
    }

    public GridBagPanel span(int gridwidth, int gridheight) {
        this.constraints.gridwidth = gridwidth;
        this.constraints.gridheight = gridheight;
        return this;
    }

    public GridBagPanel gridx(int gridx) {
        this.constraints.gridx = gridx;
        this.positionSet = true;
        return this;
    }

    public GridBagPanel gridy(int gridy) {
        this.constraints.gridy = gridy;
        this.positionSet = true;
        return this;
    }

    public GridBagPanel position(int gridx, int gridy) {
        this.constraints.gridx = gridx;
        this.constraints.gridy = gridy;
        this.positionSet = true;
        return this;
    }

    public GridBagPanel insets(Insets someInsets) {
        this.constraints.insets = someInsets;
        return this;
    }

    public GridBagPanel insets(int top, int left, int bottom, int right) {
        this.constraints.insets = new Insets(top, left, bottom, right);
        return this;
    }

    public GridBagPanel ipadx(int ipadx) {
        this.constraints.ipadx = ipadx;
        return this;
    }

    public GridBagPanel ipady(int ipady) {
        this.constraints.ipady = ipady;
        return this;
    }

    public GridBagPanel padding(int ipadx, int ipady) {
        this.constraints.ipadx = ipadx;
        this.constraints.ipady = ipady;
        return this;
    }

    public GridBagPanel weightx(double weightx) {
        this.constraints.weightx = weightx;
        return this;
    }

    public GridBagPanel weighty(double weighty) {
        this.constraints.weighty = weighty;
        return this;
    }

    public GridBagPanel weight(double weightx, double weighty) {
        this.constraints.weightx = weightx;
        this.constraints.weighty = weighty;
        return this;
    }

    public int getCurrentGridX() {
        return this.currentGridX;
    }

    public int getCurrentGridY() {
        return this.currentGridY;
    }

    private void resetConstraints() {
        this.constraints = (GridBagConstraints)this.defaultConstraints.clone();
        this.positionSet = false;
    }

    public static class Builder {
        private GridBagConstraints defaultConstraints;
        private PanelType type;
        private String containerName = null;

        public Builder() {
            this.initDefaultConstraints();
        }

        public Builder(String aName) {
            this.containerName = aName;
            this.initDefaultConstraints();
        }

        private void initDefaultConstraints() {
            this.defaultConstraints = new GridBagConstraints();
            this.defaultConstraints.anchor = 10;
            this.defaultConstraints.fill = 2;
            this.defaultConstraints.gridheight = 1;
            this.defaultConstraints.gridwidth = 1;
            this.defaultConstraints.insets = new Insets(5, 5, 5, 5);
            this.defaultConstraints.ipadx = 0;
            this.defaultConstraints.ipady = 0;
            this.defaultConstraints.weightx = 1.0;
            this.defaultConstraints.weighty = 1.0;
        }

        public Builder anchor(int anchor) {
            this.defaultConstraints.anchor = anchor;
            return this;
        }

        public Builder fill(int fill) {
            this.defaultConstraints.fill = fill;
            return this;
        }

        public Builder insets(Insets someInsets) {
            this.defaultConstraints.insets = someInsets;
            return this;
        }

        public Builder insets(int top, int left, int bottom, int right) {
            this.defaultConstraints.insets = new Insets(top, left, bottom, right);
            return this;
        }

        public Builder ipadx(int ipadx) {
            this.defaultConstraints.ipadx = ipadx;
            return this;
        }

        public Builder ipady(int ipady) {
            this.defaultConstraints.ipady = ipady;
            return this;
        }

        public Builder padding(int ipadx, int ipady) {
            this.defaultConstraints.ipadx = ipadx;
            this.defaultConstraints.ipady = ipady;
            return this;
        }

        public GridBagPanel build(PanelType aType) {
            this.type = aType;
            return new GridBagPanel(this);
        }
    }
}

