/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxGraphicsCanvas2D;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.shape.mxStencilRegistry;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxStencil
implements mxIShape {
    protected Element desc;
    protected String aspect = null;
    protected double w0 = 100.0;
    protected double h0 = 100.0;
    protected Element bgNode = null;
    protected Element fgNode = null;
    protected String strokewidth = null;
    protected double lastMoveX = 0.0;
    protected double lastMoveY = 0.0;

    public mxStencil(Element description) {
        this.setDescription(description);
    }

    public Element getDescription() {
        return this.desc;
    }

    public void setDescription(Element value) {
        this.desc = value;
        this.parseDescription();
    }

    protected mxGraphicsCanvas2D createCanvas(mxGraphics2DCanvas gc) {
        return new mxGraphicsCanvas2D(gc.getGraphics());
    }

    @Override
    public void paintShape(mxGraphics2DCanvas gc, mxCellState state) {
        String strokeColor;
        String fillColor;
        Map<String, Object> style = state.getStyle();
        mxGraphicsCanvas2D canvas = this.createCanvas(gc);
        double rotation = mxUtils.getDouble(style, mxConstants.STYLE_ROTATION, 0.0);
        String direction = mxUtils.getString(style, mxConstants.STYLE_DIRECTION, null);
        if (direction != null) {
            if (direction.equals("north")) {
                rotation += 270.0;
            } else if (direction.equals("west")) {
                rotation += 180.0;
            } else if (direction.equals("south")) {
                rotation += 90.0;
            }
        }
        boolean flipH = mxUtils.isTrue(style, mxConstants.STYLE_STENCIL_FLIPH, false);
        boolean flipV = mxUtils.isTrue(style, mxConstants.STYLE_STENCIL_FLIPV, false);
        if (flipH && flipV) {
            rotation += 180.0;
            flipH = false;
            flipV = false;
        }
        canvas.save();
        if ((rotation %= 360.0) != 0.0 || flipH || flipV) {
            canvas.rotate(rotation, flipH, flipV, state.getCenterX(), state.getCenterY());
        }
        mxRectangle aspect = this.computeAspect(state, state, direction);
        double minScale = Math.min(aspect.getWidth(), aspect.getHeight());
        double sw = this.strokewidth.equals("inherit") ? mxUtils.getDouble(state.getStyle(), mxConstants.STYLE_STROKEWIDTH, 1.0) * state.getView().getScale() : Double.parseDouble(this.strokewidth) * minScale;
        canvas.setStrokeWidth(sw);
        double alpha = mxUtils.getDouble(style, mxConstants.STYLE_OPACITY, 100.0) / 100.0;
        String gradientColor = mxUtils.getString(style, mxConstants.STYLE_GRADIENTCOLOR, null);
        if (gradientColor != null && gradientColor.equals(mxConstants.NONE)) {
            gradientColor = null;
        }
        if ((fillColor = mxUtils.getString(style, mxConstants.STYLE_FILLCOLOR, null)) != null && fillColor.equals(mxConstants.NONE)) {
            fillColor = null;
        }
        if ((strokeColor = mxUtils.getString(style, mxConstants.STYLE_STROKECOLOR, null)) != null && strokeColor.equals(mxConstants.NONE)) {
            strokeColor = null;
        }
        if (mxUtils.isTrue(style, mxConstants.STYLE_SHADOW, false)) {
            this.drawShadow(canvas, state, rotation, flipH, flipV, state, alpha, fillColor != null, aspect);
        }
        canvas.setAlpha(alpha);
        if (mxUtils.isTrue(style, mxConstants.STYLE_DASHED, false)) {
            canvas.setDashed(true);
        }
        if (strokeColor != null || fillColor != null) {
            if (strokeColor != null) {
                canvas.setStrokeColor(strokeColor);
            }
            if (fillColor != null) {
                if (gradientColor != null && !gradientColor.equals("transparent")) {
                    canvas.setGradient(fillColor, gradientColor, state.getX(), state.getY(), state.getWidth(), state.getHeight(), direction, 1.0, 1.0);
                } else {
                    canvas.setFillColor(fillColor);
                }
            }
            this.drawShape(canvas, state, state, aspect, true);
            this.drawShape(canvas, state, state, aspect, false);
        }
    }

    protected void drawShadow(mxGraphicsCanvas2D canvas, mxCellState state, double rotation, boolean flipH, boolean flipV, mxRectangle bounds, double alpha, boolean filled, mxRectangle aspect) {
        double rad = rotation * Math.PI / 180.0;
        double cos = Math.cos(-rad);
        double sin = Math.sin(-rad);
        mxPoint offset = mxUtils.getRotatedPoint(new mxPoint(mxConstants.SHADOW_OFFSETX, mxConstants.SHADOW_OFFSETY), cos, sin);
        if (flipH) {
            offset.setX(offset.getX() * -1.0);
        }
        if (flipV) {
            offset.setY(offset.getY() * -1.0);
        }
        canvas.translate(offset.getX(), offset.getY());
        if (this.drawShape(canvas, state, bounds, aspect, true)) {
            canvas.setAlpha((double)mxConstants.STENCIL_SHADOW_OPACITY * alpha);
        }
        canvas.translate(-offset.getX(), -offset.getY());
    }

    public boolean drawShape(mxGraphicsCanvas2D canvas, mxCellState state, mxRectangle bounds, mxRectangle aspect, boolean background) {
        Element elt;
        Element element = elt = background ? this.bgNode : this.fgNode;
        if (elt != null) {
            this.lastMoveX = 0.0;
            this.lastMoveY = 0.0;
            for (Node tmp = elt.getFirstChild(); tmp != null; tmp = tmp.getNextSibling()) {
                if (tmp.getNodeType() != 1) continue;
                this.drawElement(canvas, state, (Element)tmp, aspect);
            }
            return true;
        }
        return false;
    }

    protected mxRectangle computeAspect(mxCellState state, mxRectangle bounds, String direction) {
        boolean inverse;
        double x0 = bounds.getX();
        double y0 = bounds.getY();
        double sx = bounds.getWidth() / this.w0;
        double sy = bounds.getHeight() / this.h0;
        boolean bl = inverse = direction != null && (direction.equals("north") || direction.equals("south"));
        if (inverse) {
            sy = bounds.getWidth() / this.h0;
            sx = bounds.getHeight() / this.w0;
            double delta = (bounds.getWidth() - bounds.getHeight()) / 2.0;
            x0 += delta;
            y0 -= delta;
        }
        if (this.aspect.equals("fixed")) {
            sx = sy = Math.min(sx, sy);
            if (inverse) {
                x0 += (bounds.getHeight() - this.w0 * sx) / 2.0;
                y0 += (bounds.getWidth() - this.h0 * sy) / 2.0;
            } else {
                x0 += (bounds.getWidth() - this.w0 * sx) / 2.0;
                y0 += (bounds.getHeight() - this.h0 * sy) / 2.0;
            }
        }
        return new mxRectangle(x0, y0, sx, sy);
    }

    protected void drawElement(mxGraphicsCanvas2D canvas, mxCellState state, Element node, mxRectangle aspect) {
        String name = node.getNodeName();
        double x0 = aspect.getX();
        double y0 = aspect.getY();
        double sx = aspect.getWidth();
        double sy = aspect.getHeight();
        double minScale = Math.min(sx, sy);
        if (name.equals("save")) {
            canvas.save();
        } else if (name.equals("restore")) {
            canvas.restore();
        } else if (name.equals("path")) {
            canvas.begin();
            for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                if (childNode.getNodeType() != 1) continue;
                this.drawElement(canvas, state, (Element)childNode, aspect);
            }
        } else if (name.equals("close")) {
            canvas.close();
        } else if (name.equals("move")) {
            this.lastMoveX = x0 + this.getDouble(node, "x") * sx;
            this.lastMoveY = y0 + this.getDouble(node, "y") * sy;
            canvas.moveTo(this.lastMoveX, this.lastMoveY);
        } else if (name.equals("line")) {
            this.lastMoveX = x0 + this.getDouble(node, "x") * sx;
            this.lastMoveY = y0 + this.getDouble(node, "y") * sy;
            canvas.lineTo(this.lastMoveX, this.lastMoveY);
        } else if (name.equals("quad")) {
            this.lastMoveX = x0 + this.getDouble(node, "x2") * sx;
            this.lastMoveY = y0 + this.getDouble(node, "y2") * sy;
            canvas.quadTo(x0 + this.getDouble(node, "x1") * sx, y0 + this.getDouble(node, "y1") * sy, this.lastMoveX, this.lastMoveY);
        } else if (name.equals("curve")) {
            this.lastMoveX = x0 + this.getDouble(node, "x3") * sx;
            this.lastMoveY = y0 + this.getDouble(node, "y3") * sy;
            canvas.curveTo(x0 + this.getDouble(node, "x1") * sx, y0 + this.getDouble(node, "y1") * sy, x0 + this.getDouble(node, "x2") * sx, y0 + this.getDouble(node, "y2") * sy, this.lastMoveX, this.lastMoveY);
        } else if (name.equals("arc")) {
            double r1 = this.getDouble(node, "rx") * sx;
            double r2 = this.getDouble(node, "ry") * sy;
            double angle = this.getDouble(node, "x-axis-rotation");
            double largeArcFlag = this.getDouble(node, "large-arc-flag");
            double sweepFlag = this.getDouble(node, "sweep-flag");
            double x = x0 + this.getDouble(node, "x") * sx;
            double y = y0 + this.getDouble(node, "y") * sy;
            double[] curves = mxUtils.arcToCurves(this.lastMoveX, this.lastMoveY, r1, r2, angle, largeArcFlag, sweepFlag, x, y);
            for (int i = 0; i < curves.length; i += 6) {
                canvas.curveTo(curves[i], curves[i + 1], curves[i + 2], curves[i + 3], curves[i + 4], curves[i + 5]);
                this.lastMoveX = curves[i + 4];
                this.lastMoveY = curves[i + 5];
            }
        } else if (name.equals("rect")) {
            canvas.rect(x0 + this.getDouble(node, "x") * sx, y0 + this.getDouble(node, "y") * sy, this.getDouble(node, "w") * sx, this.getDouble(node, "h") * sy);
        } else if (name.equals("roundrect")) {
            double arcsize = this.getDouble(node, "arcsize");
            if (arcsize == 0.0) {
                arcsize = mxConstants.RECTANGLE_ROUNDING_FACTOR * 100.0;
            }
            double w = this.getDouble(node, "w") * sx;
            double h = this.getDouble(node, "h") * sy;
            double factor = arcsize / 100.0;
            double r = Math.min(w * factor, h * factor);
            canvas.roundrect(x0 + this.getDouble(node, "x") * sx, y0 + this.getDouble(node, "y") * sy, this.getDouble(node, "w") * sx, this.getDouble(node, "h") * sy, r, r);
        } else if (name.equals("ellipse")) {
            canvas.ellipse(x0 + this.getDouble(node, "x") * sx, y0 + this.getDouble(node, "y") * sy, this.getDouble(node, "w") * sx, this.getDouble(node, "h") * sy);
        } else if (name.equals("image")) {
            String src = this.evaluateAttribute(node, "src", state);
            canvas.image(x0 + this.getDouble(node, "x") * sx, y0 + this.getDouble(node, "y") * sy, this.getDouble(node, "w") * sx, this.getDouble(node, "h") * sy, src, false, this.getString(node, "flipH", "0").equals("1"), this.getString(node, "flipV", "0").equals("1"));
        } else if (name.equals("text")) {
            String str = this.evaluateAttribute(node, "str", state);
            double rotation = this.getString(node, "vertical", "0").equals("1") ? -90.0 : 0.0;
            canvas.text(x0 + this.getDouble(node, "x") * sx, y0 + this.getDouble(node, "y") * sy, 0.0, 0.0, str, node.getAttribute("align"), node.getAttribute("valign"), false, "", null, false, rotation, null);
        } else if (name.equals("include-shape")) {
            mxStencil stencil = mxStencilRegistry.getStencil(node.getAttribute("name"));
            if (stencil != null) {
                double x = x0 + this.getDouble(node, "x") * sx;
                double y = y0 + this.getDouble(node, "y") * sy;
                double w = this.getDouble(node, "w") * sx;
                double h = this.getDouble(node, "h") * sy;
                mxRectangle tmp = new mxRectangle(x, y, w, h);
                stencil.drawShape(canvas, state, tmp, aspect, true);
                stencil.drawShape(canvas, state, tmp, aspect, false);
            }
        } else if (name.equals("fillstroke")) {
            canvas.fillAndStroke();
        } else if (name.equals("fill")) {
            canvas.fill();
        } else if (name.equals("stroke")) {
            canvas.stroke();
        } else if (name.equals("strokewidth")) {
            double s = this.getInt(node, "fixed", 0) == 1 ? 1.0 : minScale;
            canvas.setStrokeWidth(this.getDouble(node, "width") * s);
        } else if (name.equals("dashed")) {
            String dashed = node.getAttribute("dashed");
            if (dashed != null) {
                canvas.setDashed(dashed.equals("1"));
            }
        } else if (name.equals("dashpattern")) {
            String value = node.getAttribute("pattern");
            if (value != null) {
                String[] tmp = value.split(" ");
                StringBuffer pat = new StringBuffer();
                for (int i = 0; i < tmp.length; ++i) {
                    if (tmp[i].length() <= 0) continue;
                    pat.append(Double.parseDouble(tmp[i]) * minScale);
                    pat.append(" ");
                }
                value = pat.toString();
            }
            canvas.setDashPattern(value);
        } else if (name.equals("strokecolor")) {
            canvas.setStrokeColor(node.getAttribute("color"));
        } else if (name.equals("linecap")) {
            canvas.setLineCap(node.getAttribute("cap"));
        } else if (name.equals("linejoin")) {
            canvas.setLineJoin(node.getAttribute("join"));
        } else if (name.equals("miterlimit")) {
            canvas.setMiterLimit(this.getDouble(node, "limit"));
        } else if (name.equals("fillcolor")) {
            canvas.setFillColor(node.getAttribute("color"));
        } else if (name.equals("fontcolor")) {
            canvas.setFontColor(node.getAttribute("color"));
        } else if (name.equals("fontstyle")) {
            canvas.setFontStyle(this.getInt(node, "style", 0));
        } else if (name.equals("fontfamily")) {
            canvas.setFontFamily(node.getAttribute("family"));
        } else if (name.equals("fontsize")) {
            canvas.setFontSize(this.getDouble(node, "size") * minScale);
        }
    }

    protected int getInt(Element elt, String attribute, int defaultValue) {
        String value = elt.getAttribute(attribute);
        if (value != null && value.length() > 0) {
            try {
                defaultValue = (int)Math.floor(Float.parseFloat(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected double getDouble(Element elt, String attribute) {
        return this.getDouble(elt, attribute, 0.0);
    }

    protected double getDouble(Element elt, String attribute, double defaultValue) {
        String value = elt.getAttribute(attribute);
        if (value != null && value.length() > 0) {
            try {
                defaultValue = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected String getString(Element elt, String attribute, String defaultValue) {
        String value = elt.getAttribute(attribute);
        if (value != null && value.length() > 0) {
            defaultValue = value;
        }
        return defaultValue;
    }

    protected void parseDescription() {
        this.fgNode = (Element)this.desc.getElementsByTagName("foreground").item(0);
        this.bgNode = (Element)this.desc.getElementsByTagName("background").item(0);
        this.w0 = this.getDouble(this.desc, "w", this.w0);
        this.h0 = this.getDouble(this.desc, "h", this.h0);
        this.aspect = this.getString(this.desc, "aspect", "variable");
        this.strokewidth = this.getString(this.desc, "strokewidth", "1");
    }

    public String evaluateAttribute(Element elt, String attribute, mxCellState state) {
        String result = elt.getAttribute(attribute);
        if (result == null) {
            // empty if block
        }
        return result;
    }
}

