/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing.editor;

import com.mxgraph.examples.swing.editor.BasicGraphEditor;
import com.mxgraph.examples.swing.editor.EditorActions;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraphView;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;

public class SchemaEditorToolBar
extends JToolBar {
    private static final long serialVersionUID = -3979320704834605323L;
    private boolean ignoreZoomChange = false;

    public SchemaEditorToolBar(final BasicGraphEditor editor, int orientation) {
        super(orientation);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), this.getBorder()));
        this.setFloatable(false);
        this.add(editor.bind("New", new EditorActions.NewAction(), "/com/mxgraph/examples/swing/images/new.gif"));
        this.add(editor.bind("Open", new EditorActions.OpenAction(), "/com/mxgraph/examples/swing/images/open.gif"));
        this.add(editor.bind("Save", new EditorActions.SaveAction(false), "/com/mxgraph/examples/swing/images/save.gif"));
        this.addSeparator();
        this.add(editor.bind("Print", new EditorActions.PrintAction(), "/com/mxgraph/examples/swing/images/print.gif"));
        this.addSeparator();
        this.add(editor.bind("Cut", TransferHandler.getCutAction(), "/com/mxgraph/examples/swing/images/cut.gif"));
        this.add(editor.bind("Copy", TransferHandler.getCopyAction(), "/com/mxgraph/examples/swing/images/copy.gif"));
        this.add(editor.bind("Paste", TransferHandler.getPasteAction(), "/com/mxgraph/examples/swing/images/paste.gif"));
        this.addSeparator();
        this.add(editor.bind("Delete", mxGraphActions.getDeleteAction(), "/com/mxgraph/examples/swing/images/delete.gif"));
        this.addSeparator();
        this.add(editor.bind("Undo", new EditorActions.HistoryAction(true), "/com/mxgraph/examples/swing/images/undo.gif"));
        this.add(editor.bind("Redo", new EditorActions.HistoryAction(false), "/com/mxgraph/examples/swing/images/redo.gif"));
        this.addSeparator();
        final mxGraphView view = editor.getGraphComponent().getGraph().getView();
        final JComboBox<Object> zoomCombo = new JComboBox<Object>(new Object[]{"400%", "200%", "150%", "100%", "75%", "50%", mxResources.get("page"), mxResources.get("width"), mxResources.get("actualSize")});
        zoomCombo.setEditable(true);
        zoomCombo.setMinimumSize(new Dimension(75, 0));
        zoomCombo.setPreferredSize(new Dimension(75, 0));
        zoomCombo.setMaximumSize(new Dimension(75, 100));
        zoomCombo.setMaximumRowCount(9);
        this.add(zoomCombo);
        mxEventSource.mxIEventListener scaleTracker = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object sender, mxEventObject evt) {
                SchemaEditorToolBar.this.ignoreZoomChange = true;
                try {
                    zoomCombo.setSelectedItem((int)Math.round(100.0 * view.getScale()) + "%");
                }
                finally {
                    SchemaEditorToolBar.this.ignoreZoomChange = false;
                }
            }
        };
        view.getGraph().getView().addListener("scale", scaleTracker);
        view.getGraph().getView().addListener("scaleAndTranslate", scaleTracker);
        scaleTracker.invoke(null, null);
        zoomCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mxGraphComponent graphComponent = editor.getGraphComponent();
                if (!SchemaEditorToolBar.this.ignoreZoomChange) {
                    String zoom = zoomCombo.getSelectedItem().toString();
                    if (zoom.equals(mxResources.get("page"))) {
                        graphComponent.setPageVisible(true);
                        graphComponent.setZoomPolicy(1);
                    } else if (zoom.equals(mxResources.get("width"))) {
                        graphComponent.setPageVisible(true);
                        graphComponent.setZoomPolicy(2);
                    } else if (zoom.equals(mxResources.get("actualSize"))) {
                        graphComponent.zoomActual();
                    } else {
                        try {
                            zoom = zoom.replace("%", "");
                            double scale = Math.min(16.0, Math.max(0.01, Double.parseDouble(zoom) / 100.0));
                            graphComponent.zoomTo(scale, graphComponent.isCenterZoom());
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(editor, ex.getMessage());
                        }
                    }
                }
            }
        });
    }
}

