/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing.editor;

import com.mxgraph.examples.swing.editor.BasicGraphEditor;
import com.mxgraph.examples.swing.editor.EditorActions;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

public class SchemaEditorMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 6776304509649205465L;

    public SchemaEditorMenuBar(final BasicGraphEditor editor) {
        final mxGraphComponent graphComponent = editor.getGraphComponent();
        mxGraph graph = graphComponent.getGraph();
        JMenu menu = null;
        JMenu submenu = null;
        menu = this.add(new JMenu(mxResources.get("file")));
        menu.add(editor.bind(mxResources.get("new"), new EditorActions.NewAction(), "/com/mxgraph/examples/swing/images/new.gif"));
        menu.add(editor.bind(mxResources.get("openFile"), new EditorActions.OpenAction(), "/com/mxgraph/examples/swing/images/open.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get("save"), new EditorActions.SaveAction(false), "/com/mxgraph/examples/swing/images/save.gif"));
        menu.add(editor.bind(mxResources.get("saveAs"), new EditorActions.SaveAction(true), "/com/mxgraph/examples/swing/images/saveas.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get("pageSetup"), new EditorActions.PageSetupAction(), "/com/mxgraph/examples/swing/images/pagesetup.gif"));
        menu.add(editor.bind(mxResources.get("print"), new EditorActions.PrintAction(), "/com/mxgraph/examples/swing/images/print.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get("exit"), new EditorActions.ExitAction()));
        menu = this.add(new JMenu(mxResources.get("edit")));
        menu.add(editor.bind(mxResources.get("undo"), new EditorActions.HistoryAction(true), "/com/mxgraph/examples/swing/images/undo.gif"));
        menu.add(editor.bind(mxResources.get("redo"), new EditorActions.HistoryAction(false), "/com/mxgraph/examples/swing/images/redo.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get("cut"), TransferHandler.getCutAction(), "/com/mxgraph/examples/swing/images/cut.gif"));
        menu.add(editor.bind(mxResources.get("copy"), TransferHandler.getCopyAction(), "/com/mxgraph/examples/swing/images/copy.gif"));
        menu.add(editor.bind(mxResources.get("paste"), TransferHandler.getPasteAction(), "/com/mxgraph/examples/swing/images/paste.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get("delete"), mxGraphActions.getDeleteAction(), "/com/mxgraph/examples/swing/images/delete.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get("selectAll"), mxGraphActions.getSelectAllAction()));
        menu.add(editor.bind(mxResources.get("selectNone"), mxGraphActions.getSelectNoneAction()));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get("warning"), new EditorActions.WarningAction()));
        menu.add(editor.bind(mxResources.get("edit"), mxGraphActions.getEditAction()));
        menu = this.add(new JMenu(mxResources.get("view")));
        JMenuItem item = menu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get("pageLayout"), "PageVisible", true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (graphComponent.isPageVisible() && graphComponent.isCenterPage()) {
                    graphComponent.zoomAndCenter();
                }
            }
        }));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof EditorActions.TogglePropertyItem) {
                    final mxGraphComponent graphComponent = editor.getGraphComponent();
                    EditorActions.TogglePropertyItem toggleItem = (EditorActions.TogglePropertyItem)e.getSource();
                    if (toggleItem.isSelected()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                graphComponent.scrollToCenter(true);
                                graphComponent.scrollToCenter(false);
                            }
                        });
                    } else {
                        mxPoint tr = graphComponent.getGraph().getView().getTranslate();
                        if (tr.getX() != 0.0 || tr.getY() != 0.0) {
                            graphComponent.getGraph().getView().setTranslate(new mxPoint());
                        }
                    }
                }
            }
        });
        menu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get("antialias"), "AntiAlias", true));
        menu.addSeparator();
        menu.add(new EditorActions.ToggleGridItem(editor, mxResources.get("grid")));
        menu.add(new EditorActions.ToggleRulersItem(editor, mxResources.get("rulers")));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get("zoom")));
        submenu.add(editor.bind("400%", new EditorActions.ScaleAction(4.0)));
        submenu.add(editor.bind("200%", new EditorActions.ScaleAction(2.0)));
        submenu.add(editor.bind("150%", new EditorActions.ScaleAction(1.5)));
        submenu.add(editor.bind("100%", new EditorActions.ScaleAction(1.0)));
        submenu.add(editor.bind("75%", new EditorActions.ScaleAction(0.75)));
        submenu.add(editor.bind("50%", new EditorActions.ScaleAction(0.5)));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get("custom"), new EditorActions.ScaleAction(0.0)));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get("zoomIn"), mxGraphActions.getZoomInAction()));
        menu.add(editor.bind(mxResources.get("zoomOut"), mxGraphActions.getZoomOutAction()));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get("page"), new EditorActions.ZoomPolicyAction(1)));
        menu.add(editor.bind(mxResources.get("width"), new EditorActions.ZoomPolicyAction(2)));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get("actualSize"), mxGraphActions.getZoomActualAction()));
        menu = this.add(new JMenu(mxResources.get("diagram")));
        menu.add(new EditorActions.ToggleOutlineItem(editor, mxResources.get("outline")));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get("background")));
        submenu.add(editor.bind(mxResources.get("backgroundColor"), new EditorActions.BackgroundAction()));
        submenu.add(editor.bind(mxResources.get("backgroundImage"), new EditorActions.BackgroundImageAction()));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get("pageBackground"), new EditorActions.PageBackgroundAction()));
        submenu = (JMenu)menu.add(new JMenu(mxResources.get("grid")));
        submenu.add(editor.bind(mxResources.get("gridSize"), new EditorActions.PromptPropertyAction(graph, "Grid Size", "GridSize")));
        submenu.add(editor.bind(mxResources.get("gridColor"), new EditorActions.GridColorAction()));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get("dashed"), new EditorActions.GridStyleAction(3)));
        submenu.add(editor.bind(mxResources.get("dot"), new EditorActions.GridStyleAction(0)));
        submenu.add(editor.bind(mxResources.get("line"), new EditorActions.GridStyleAction(2)));
        submenu.add(editor.bind(mxResources.get("cross"), new EditorActions.GridStyleAction(1)));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get("layout")));
        submenu.add(editor.graphLayout("verticalHierarchical", true));
        submenu.add(editor.graphLayout("horizontalHierarchical", true));
        submenu.addSeparator();
        submenu.add(editor.graphLayout("verticalPartition", false));
        submenu.add(editor.graphLayout("horizontalPartition", false));
        submenu.addSeparator();
        submenu.add(editor.graphLayout("verticalStack", false));
        submenu.add(editor.graphLayout("horizontalStack", false));
        submenu.addSeparator();
        submenu.add(editor.graphLayout("verticalTree", true));
        submenu.add(editor.graphLayout("horizontalTree", true));
        submenu.addSeparator();
        submenu.add(editor.graphLayout("parallelEdges", false));
        submenu.addSeparator();
        submenu.add(editor.graphLayout("organicLayout", true));
        submenu = (JMenu)menu.add(new JMenu(mxResources.get("selection")));
        submenu.add(editor.bind(mxResources.get("selectPath"), new EditorActions.SelectShortestPathAction(false)));
        submenu.add(editor.bind(mxResources.get("selectDirectedPath"), new EditorActions.SelectShortestPathAction(true)));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get("selectTree"), new EditorActions.SelectSpanningTreeAction(false)));
        submenu.add(editor.bind(mxResources.get("selectDirectedTree"), new EditorActions.SelectSpanningTreeAction(true)));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get("stylesheet")));
        submenu.add(editor.bind(mxResources.get("basicStyle"), new EditorActions.StylesheetAction("/com/mxgraph/examples/swing/resources/basic-style.xml")));
        submenu.add(editor.bind(mxResources.get("defaultStyle"), new EditorActions.StylesheetAction("/com/mxgraph/examples/swing/resources/default-style.xml")));
        menu = this.add(new JMenu(mxResources.get("options")));
        submenu = (JMenu)menu.add(new JMenu(mxResources.get("display")));
        submenu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get("buffering"), "TripleBuffered", true));
        submenu.add(editor.bind(mxResources.get("dirty"), new EditorActions.ToggleDirtyAction()));
        submenu.addSeparator();
        item = submenu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get("centerPage"), "CenterPage", true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (graphComponent.isPageVisible() && graphComponent.isCenterPage()) {
                    graphComponent.zoomAndCenter();
                }
            }
        }));
        submenu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get("centerZoom"), "CenterZoom", true));
        submenu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get("zoomToSelection"), "KeepSelectionVisibleOnZoom", true));
        submenu.addSeparator();
        submenu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get("preferPagesize"), "PreferPageSize", true));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get("tolerance"), new EditorActions.PromptPropertyAction(graph, "Tolerance")));
        menu = this.add(new JMenu(mxResources.get("window")));
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafs.length; ++i) {
            final String clazz = lafs[i].getClassName();
            menu.add(new AbstractAction(lafs[i].getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    editor.setLookAndFeel(clazz);
                }
            });
        }
        menu = this.add(new JMenu(mxResources.get("help")));
        item = menu.add(new JMenuItem(mxResources.get("aboutGraphEditor")));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editor.about();
            }
        });
    }
}

