/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing.editor;

import com.mxgraph.examples.swing.editor.EditorAboutFrame;
import com.mxgraph.examples.swing.editor.EditorKeyboardHandler;
import com.mxgraph.examples.swing.editor.EditorPalette;
import com.mxgraph.examples.swing.editor.EditorPopupMenu;
import com.mxgraph.examples.swing.editor.EditorToolBar;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.layout.mxCompactTreeLayout;
import com.mxgraph.layout.mxEdgeLabelLayout;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.layout.mxIGraphLayout;
import com.mxgraph.layout.mxOrganicLayout;
import com.mxgraph.layout.mxParallelEdgeLayout;
import com.mxgraph.layout.mxPartitionLayout;
import com.mxgraph.layout.mxStackLayout;
import com.mxgraph.swing.handler.mxKeyboardHandler;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.mxGraphOutline;
import com.mxgraph.swing.util.mxMorphing;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUndoManager;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.view.mxGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class BasicGraphEditor
extends JPanel {
    private static final long serialVersionUID = -6561623072112577140L;
    protected mxGraphComponent graphComponent;
    protected mxGraphOutline graphOutline;
    protected JTabbedPane libraryPane;
    protected mxUndoManager undoManager;
    protected String appTitle;
    protected JLabel statusBar;
    protected File currentFile;
    protected boolean modified = false;
    protected mxRubberband rubberband;
    protected mxKeyboardHandler keyboardHandler;
    protected mxEventSource.mxIEventListener undoHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object source, mxEventObject evt) {
            BasicGraphEditor.this.undoManager.undoableEditHappened((mxUndoableEdit)evt.getProperty("edit"));
        }
    };
    protected mxEventSource.mxIEventListener changeTracker = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object source, mxEventObject evt) {
            BasicGraphEditor.this.setModified(true);
        }
    };

    public BasicGraphEditor(String appTitle, mxGraphComponent component) {
        this.appTitle = appTitle;
        this.graphComponent = component;
        final mxGraph graph = this.graphComponent.getGraph();
        this.undoManager = this.createUndoManager();
        graph.setResetViewOnRootChange(false);
        graph.getModel().addListener("change", this.changeTracker);
        graph.getModel().addListener("undo", this.undoHandler);
        graph.getView().addListener("undo", this.undoHandler);
        mxEventSource.mxIEventListener undoHandler = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object source, mxEventObject evt) {
                List<mxUndoableEdit.mxUndoableChange> changes = ((mxUndoableEdit)evt.getProperty("edit")).getChanges();
                graph.setSelectionCells(graph.getSelectionCellsForChanges(changes));
            }
        };
        this.undoManager.addListener("undo", undoHandler);
        this.undoManager.addListener("redo", undoHandler);
        this.graphOutline = new mxGraphOutline(this.graphComponent);
        this.libraryPane = new JTabbedPane();
        JSplitPane inner = new JSplitPane(0, this.libraryPane, this.graphOutline);
        inner.setDividerLocation(320);
        inner.setResizeWeight(1.0);
        inner.setDividerSize(6);
        inner.setBorder(null);
        JSplitPane outer = new JSplitPane(1, inner, this.graphComponent);
        outer.setOneTouchExpandable(true);
        outer.setDividerLocation(200);
        outer.setDividerSize(6);
        outer.setBorder(null);
        this.statusBar = this.createStatusBar();
        this.installRepaintListener();
        this.setLayout(new BorderLayout());
        this.add((Component)outer, "Center");
        this.add((Component)this.statusBar, "South");
        this.installToolBar();
        this.installHandlers();
        this.installListeners();
        this.updateTitle();
    }

    protected mxUndoManager createUndoManager() {
        return new mxUndoManager();
    }

    protected void installHandlers() {
        this.rubberband = new mxRubberband(this.graphComponent);
        this.keyboardHandler = new EditorKeyboardHandler(this.graphComponent);
    }

    protected void installToolBar() {
        this.add((Component)new EditorToolBar(this, 0), "North");
    }

    protected JLabel createStatusBar() {
        JLabel statusBar = new JLabel(mxResources.get("ready"));
        statusBar.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        return statusBar;
    }

    protected void installRepaintListener() {
        this.graphComponent.getGraph().addListener("repaint", new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object source, mxEventObject evt) {
                String buffer = BasicGraphEditor.this.graphComponent.getTripleBuffer() != null ? "" : " (unbuffered)";
                mxRectangle dirty = (mxRectangle)evt.getProperty("region");
                if (dirty == null) {
                    BasicGraphEditor.this.status("Repaint all" + buffer);
                } else {
                    BasicGraphEditor.this.status("Repaint: x=" + (int)dirty.getX() + " y=" + (int)dirty.getY() + " w=" + (int)dirty.getWidth() + " h=" + (int)dirty.getHeight() + buffer);
                }
            }
        });
    }

    public EditorPalette insertPalette(String title) {
        final EditorPalette palette = new EditorPalette();
        final JScrollPane scrollPane = new JScrollPane(palette);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.libraryPane.add(title, scrollPane);
        this.libraryPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = scrollPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
                palette.setPreferredWidth(w);
            }
        });
        return palette;
    }

    protected void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.graphComponent.zoomIn();
        } else {
            this.graphComponent.zoomOut();
        }
        this.status(mxResources.get("scale") + ": " + (int)(100.0 * this.graphComponent.getGraph().getView().getScale()) + "%");
    }

    protected void showOutlinePopupMenu(MouseEvent e) {
        Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.graphComponent);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(mxResources.get("magnifyPage"));
        item.setSelected(this.graphOutline.isFitPage());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicGraphEditor.this.graphOutline.setFitPage(!BasicGraphEditor.this.graphOutline.isFitPage());
                BasicGraphEditor.this.graphOutline.repaint();
            }
        });
        JCheckBoxMenuItem item2 = new JCheckBoxMenuItem(mxResources.get("showLabels"));
        item2.setSelected(this.graphOutline.isDrawLabels());
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicGraphEditor.this.graphOutline.setDrawLabels(!BasicGraphEditor.this.graphOutline.isDrawLabels());
                BasicGraphEditor.this.graphOutline.repaint();
            }
        });
        JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(mxResources.get("buffering"));
        item3.setSelected(this.graphOutline.isTripleBuffered());
        item3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicGraphEditor.this.graphOutline.setTripleBuffered(!BasicGraphEditor.this.graphOutline.isTripleBuffered());
                BasicGraphEditor.this.graphOutline.repaint();
            }
        });
        JPopupMenu menu = new JPopupMenu();
        menu.add(item);
        menu.add(item2);
        menu.add(item3);
        menu.show(this.graphComponent, pt.x, pt.y);
        e.consume();
    }

    protected void showGraphPopupMenu(MouseEvent e) {
        Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.graphComponent);
        EditorPopupMenu menu = new EditorPopupMenu(this);
        menu.show(this.graphComponent, pt.x, pt.y);
        e.consume();
    }

    protected void mouseLocationChanged(MouseEvent e) {
        this.status(e.getX() + ", " + e.getY());
    }

    protected void installListeners() {
        MouseWheelListener wheelTracker = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getSource() instanceof mxGraphOutline || e.isControlDown()) {
                    BasicGraphEditor.this.mouseWheelMoved(e);
                }
            }
        };
        this.graphOutline.addMouseWheelListener(wheelTracker);
        this.graphComponent.addMouseWheelListener(wheelTracker);
        this.graphOutline.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseReleased(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BasicGraphEditor.this.showOutlinePopupMenu(e);
                }
            }
        });
        this.graphComponent.getGraphControl().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseReleased(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BasicGraphEditor.this.showGraphPopupMenu(e);
                }
            }
        });
        this.graphComponent.getGraphControl().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                BasicGraphEditor.this.mouseLocationChanged(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.mouseDragged(e);
            }
        });
    }

    public void setCurrentFile(File file) {
        File oldValue = this.currentFile;
        this.currentFile = file;
        this.firePropertyChange("currentFile", oldValue, file);
        if (oldValue != file) {
            this.updateTitle();
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setModified(boolean modified) {
        boolean oldValue = this.modified;
        this.modified = modified;
        this.firePropertyChange("modified", oldValue, modified);
        if (oldValue != modified) {
            this.updateTitle();
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public mxGraphOutline getGraphOutline() {
        return this.graphOutline;
    }

    public JTabbedPane getLibraryPane() {
        return this.libraryPane;
    }

    public mxUndoManager getUndoManager() {
        return this.undoManager;
    }

    public Action bind(String name, Action action) {
        return this.bind(name, action, null);
    }

    public Action bind(String name, final Action action, String iconUrl) {
        AbstractAction newAction = new AbstractAction(name, iconUrl != null ? new ImageIcon(BasicGraphEditor.class.getResource(iconUrl)) : null){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.actionPerformed(new ActionEvent(BasicGraphEditor.this.getGraphComponent(), e.getID(), e.getActionCommand()));
            }
        };
        newAction.putValue("ShortDescription", action.getValue("ShortDescription"));
        return newAction;
    }

    public void status(String msg) {
        this.statusBar.setText(msg);
    }

    public void updateTitle() {
        JFrame frame = (JFrame)SwingUtilities.windowForComponent(this);
        if (frame != null) {
            String title;
            String string = title = this.currentFile != null ? this.currentFile.getAbsolutePath() : mxResources.get("newDiagram");
            if (this.modified) {
                title = title + "*";
            }
            frame.setTitle(title + " - " + this.appTitle);
        }
    }

    public void about() {
        JFrame frame = (JFrame)SwingUtilities.windowForComponent(this);
        if (frame != null) {
            EditorAboutFrame about = new EditorAboutFrame(frame);
            about.setModal(true);
            int x = frame.getX() + (frame.getWidth() - about.getWidth()) / 2;
            int y = frame.getY() + (frame.getHeight() - about.getHeight()) / 2;
            about.setLocation(x, y);
            about.setVisible(true);
        }
    }

    public void exit() {
        JFrame frame = (JFrame)SwingUtilities.windowForComponent(this);
        if (frame != null) {
            frame.dispose();
        }
    }

    public void setLookAndFeel(String clazz) {
        JFrame frame = (JFrame)SwingUtilities.windowForComponent(this);
        if (frame != null) {
            try {
                UIManager.setLookAndFeel(clazz);
                SwingUtilities.updateComponentTreeUI(frame);
                this.keyboardHandler = new EditorKeyboardHandler(this.graphComponent);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public JFrame createFrame(JMenuBar menuBar) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(this);
        frame.setDefaultCloseOperation(2);
        frame.setJMenuBar(menuBar);
        frame.setSize(870, 640);
        this.updateTitle();
        return frame;
    }

    public Action graphLayout(String key, boolean animate) {
        final mxIGraphLayout layout = this.createLayout(key, animate);
        if (layout != null) {
            return new AbstractAction(mxResources.get(key)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    mxMorphing morph;
                    mxGraph graph = BasicGraphEditor.this.graphComponent.getGraph();
                    Object cell = graph.getSelectionCell();
                    if (cell == null || graph.getModel().getChildCount(cell) == 0) {
                        cell = graph.getDefaultParent();
                    }
                    graph.getModel().beginUpdate();
                    try {
                        long t0 = System.currentTimeMillis();
                        layout.execute(cell);
                        BasicGraphEditor.this.status("Layout: " + (System.currentTimeMillis() - t0) + " ms");
                        morph = new mxMorphing(BasicGraphEditor.this.graphComponent, 20, 1.2, 20);
                    }
                    catch (Throwable throwable) {
                        mxMorphing morph2 = new mxMorphing(BasicGraphEditor.this.graphComponent, 20, 1.2, 20);
                        morph2.addListener("done", new mxEventSource.mxIEventListener(graph){
                            final /* synthetic */ mxGraph val$graph;
                            {
                                this.val$graph = mxGraph2;
                            }

                            @Override
                            public void invoke(Object sender, mxEventObject evt) {
                                this.val$graph.getModel().endUpdate();
                            }
                        });
                        morph2.startAnimation();
                        throw throwable;
                    }
                    morph.addListener("done", new /* invalid duplicate definition of identical inner class */);
                    morph.startAnimation();
                }
            };
        }
        return new AbstractAction(mxResources.get(key)){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(BasicGraphEditor.this.graphComponent, mxResources.get("noLayout"));
            }
        };
    }

    protected mxIGraphLayout createLayout(String ident, boolean animate) {
        mxGraphLayout layout = null;
        if (ident != null) {
            mxGraph graph = this.graphComponent.getGraph();
            if (ident.equals("verticalHierarchical")) {
                layout = new mxHierarchicalLayout(graph);
            } else if (ident.equals("horizontalHierarchical")) {
                layout = new mxHierarchicalLayout(graph, 7);
            } else if (ident.equals("verticalTree")) {
                layout = new mxCompactTreeLayout(graph, false);
            } else if (ident.equals("horizontalTree")) {
                layout = new mxCompactTreeLayout(graph, true);
            } else if (ident.equals("parallelEdges")) {
                layout = new mxParallelEdgeLayout(graph);
            } else if (ident.equals("placeEdgeLabels")) {
                layout = new mxEdgeLabelLayout(graph);
            } else if (ident.equals("organicLayout")) {
                layout = new mxOrganicLayout(graph);
            }
            if (ident.equals("verticalPartition")) {
                layout = new mxPartitionLayout(graph, false){

                    @Override
                    public mxRectangle getContainerSize() {
                        return BasicGraphEditor.this.graphComponent.getLayoutAreaSize();
                    }
                };
            } else if (ident.equals("horizontalPartition")) {
                layout = new mxPartitionLayout(graph, true){

                    @Override
                    public mxRectangle getContainerSize() {
                        return BasicGraphEditor.this.graphComponent.getLayoutAreaSize();
                    }
                };
            } else if (ident.equals("verticalStack")) {
                layout = new mxStackLayout(graph, false){

                    @Override
                    public mxRectangle getContainerSize() {
                        return BasicGraphEditor.this.graphComponent.getLayoutAreaSize();
                    }
                };
            } else if (ident.equals("horizontalStack")) {
                layout = new mxStackLayout(graph, true){

                    @Override
                    public mxRectangle getContainerSize() {
                        return BasicGraphEditor.this.graphComponent.getLayoutAreaSize();
                    }
                };
            } else if (ident.equals("circleLayout")) {
                layout = new mxCircleLayout(graph);
            }
        }
        return layout;
    }

    static {
        try {
            mxResources.add("com/mxgraph/examples/swing/resources/editor");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

